/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.BuiltinTestFunctions;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogTypes;
import net.minecraft.server.dialog.action.Action;
import net.minecraft.server.dialog.action.ActionTypes;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.body.DialogBodyTypes;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.InputControlTypes;
import net.minecraft.server.jsonrpc.IncomingRpcMethod;
import net.minecraft.server.jsonrpc.IncomingRpcMethods;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.OutgoingRpcMethods;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnConditions;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplays;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplays;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.EnchantmentProviderTypes;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.bukkit.Registry;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger aN = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> aO = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> aP = new RegistryMaterials(ResourceKey.a(Registries.a), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> a = BuiltInRegistries.a(Registries.K, "step", GameEvent::a);
    public static final IRegistry<SoundEffect> b = BuiltInRegistries.a(Registries.at, (IRegistry<T> registry) -> SoundEffects.pk);
    public static final RegistryBlocks<FluidType> c = BuiltInRegistries.b(Registries.I, "empty", registry -> FluidTypes.a);
    public static final IRegistry<MobEffectList> d = BuiltInRegistries.a(Registries.aa, MobEffects::a);
    public static final RegistryBlocks<Block> e = BuiltInRegistries.b(Registries.i, "air", registry -> Blocks.a);
    public static final IRegistry<DebugSubscription<?>> f = BuiltInRegistries.a(Registries.s, DebugSubscriptions::a);
    public static final RegistryBlocks<EntityTypes<?>> g = BuiltInRegistries.b(Registries.E, "pig", registry -> EntityTypes.aV);
    public static final RegistryBlocks<Item> h = BuiltInRegistries.b(Registries.O, "air", registry -> Items.a);
    public static final IRegistry<PotionRegistry> i = BuiltInRegistries.a(Registries.ai, Potions::a);
    public static final IRegistry<Particle<?>> j = BuiltInRegistries.a(Registries.ac, (IRegistry<T> registry) -> Particles.b);
    public static final IRegistry<TileEntityTypes<?>> k = BuiltInRegistries.b(Registries.e, registry -> TileEntityTypes.a);
    public static final IRegistry<MinecraftKey> l = BuiltInRegistries.a(Registries.p, (IRegistry<T> registry) -> StatisticList.F);
    public static final RegistryBlocks<ChunkStatus> m = BuiltInRegistries.a(Registries.l, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> n = BuiltInRegistries.a(Registries.ap, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<RuleBlockEntityModifierType<?>> o = BuiltInRegistries.a(Registries.ao, (IRegistry<T> registry) -> RuleBlockEntityModifierType.b);
    public static final IRegistry<PosRuleTestType<?>> p = BuiltInRegistries.a(Registries.ah, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> q = BuiltInRegistries.a(Registries.Z, (IRegistry<T> registry) -> Containers.i);
    public static final IRegistry<Recipes<?>> r = BuiltInRegistries.a(Registries.am, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> s = BuiltInRegistries.a(Registries.al, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> t = BuiltInRegistries.a(Registries.c, GenericAttributes::a);
    public static final IRegistry<PositionSourceType<?>> u = BuiltInRegistries.a(Registries.ag, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> v = BuiltInRegistries.a(Registries.m, ArgumentTypeInfos::a);
    public static final IRegistry<StatisticWrapper<?>> w = BuiltInRegistries.a(Registries.av, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> x = BuiltInRegistries.a(Registries.aJ, "plains", VillagerType::a);
    public static final RegistryBlocks<VillagerProfession> y = BuiltInRegistries.a(Registries.aI, "none", VillagerProfession::a);
    public static final IRegistry<VillagePlaceType> z = BuiltInRegistries.a(Registries.ae, PoiTypes::a);
    public static final RegistryBlocks<MemoryModuleType<?>> A = BuiltInRegistries.a(Registries.Y, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> B = BuiltInRegistries.a(Registries.ar, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> C = BuiltInRegistries.a(Registries.aq, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> D = BuiltInRegistries.a(Registries.b, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> E = BuiltInRegistries.a(Registries.T, (IRegistry<T> registry) -> LootEntries.b);
    public static final IRegistry<LootItemFunctionType<?>> F = BuiltInRegistries.a(Registries.Q, (IRegistry<T> registry) -> LootItemFunctions.e);
    public static final IRegistry<LootItemConditionType> G = BuiltInRegistries.a(Registries.P, (IRegistry<T> registry) -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> H = BuiltInRegistries.a(Registries.S, (IRegistry<T> registry) -> NumberProviders.b);
    public static final IRegistry<LootNbtProviderType> I = BuiltInRegistries.a(Registries.R, (IRegistry<T> registry) -> NbtProviders.c);
    public static final IRegistry<LootScoreProviderType> J = BuiltInRegistries.a(Registries.U, (IRegistry<T> registry) -> ScoreboardNameProviders.c);
    public static final IRegistry<FloatProviderType<?>> K = BuiltInRegistries.a(Registries.H, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final IRegistry<IntProviderType<?>> L = BuiltInRegistries.a(Registries.N, (IRegistry<T> registry) -> IntProviderType.a);
    public static final IRegistry<HeightProviderType<?>> M = BuiltInRegistries.a(Registries.L, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final IRegistry<BlockPredicateType<?>> N = BuiltInRegistries.a(Registries.f, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final IRegistry<WorldGenCarverAbstract<?>> O = BuiltInRegistries.a(Registries.j, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final IRegistry<WorldGenerator<?>> P = BuiltInRegistries.a(Registries.G, (IRegistry<T> registry) -> WorldGenerator.J);
    public static final IRegistry<StructurePlacementType<?>> Q = BuiltInRegistries.a(Registries.ax, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final IRegistry<WorldGenFeatureStructurePieceType> R = BuiltInRegistries.a(Registries.aw, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final IRegistry<StructureType<?>> S = BuiltInRegistries.a(Registries.aA, (IRegistry<T> registry) -> StructureType.f);
    public static final IRegistry<PlacementModifierType<?>> T = BuiltInRegistries.a(Registries.ad, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> U = BuiltInRegistries.a(Registries.g, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> V = BuiltInRegistries.a(Registries.J, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> W = BuiltInRegistries.a(Registries.aH, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<RootPlacerType<?>> X = BuiltInRegistries.a(Registries.an, (IRegistry<T> registry) -> RootPlacerType.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> Y = BuiltInRegistries.a(Registries.aG, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> Z = BuiltInRegistries.a(Registries.F, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<MapCodec<? extends WorldChunkManager>> aa = BuiltInRegistries.a(Registries.d, BiomeSources::a);
    public static final IRegistry<MapCodec<? extends ChunkGenerator>> ab = BuiltInRegistries.a(Registries.k, ChunkGenerators::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.f>> ac = BuiltInRegistries.a(Registries.W, SurfaceRules.f::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.o>> ad = BuiltInRegistries.a(Registries.X, SurfaceRules.o::a);
    public static final IRegistry<MapCodec<? extends DensityFunction>> ae = BuiltInRegistries.a(Registries.u, DensityFunctions::a);
    public static final IRegistry<MapCodec<? extends Block>> af = BuiltInRegistries.a(Registries.h, BlockTypes::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> ag = BuiltInRegistries.a(Registries.az, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.e);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> ah = BuiltInRegistries.a(Registries.ay, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    public static final IRegistry<MapCodec<? extends PoolAliasBinding>> ai = BuiltInRegistries.a(Registries.af, PoolAliasBindings::a);
    public static final IRegistry<DecoratedPotPattern> aj = BuiltInRegistries.a(Registries.t, DecoratedPotPatterns::a);
    public static final IRegistry<CreativeModeTab> ak = BuiltInRegistries.a(Registries.o, CreativeModeTabs::a);
    public static final IRegistry<CriterionTrigger<?>> al = BuiltInRegistries.a(Registries.br, CriterionTriggers::a);
    public static final IRegistry<NumberFormatType<?>> am = BuiltInRegistries.a(Registries.ab, NumberFormatTypes::a);
    public static final IRegistry<DataComponentType<?>> an = BuiltInRegistries.a(Registries.r, DataComponents::a);
    public static final IRegistry<MapCodec<? extends EntitySubPredicate>> ao = BuiltInRegistries.a(Registries.D, EntitySubPredicates::a);
    public static final IRegistry<DataComponentPredicate.b<?>> ap = BuiltInRegistries.a(Registries.q, DataComponentPredicates::a);
    public static final IRegistry<MapDecorationType> aq = BuiltInRegistries.a(Registries.V, MapDecorationTypes::a);
    public static final IRegistry<DataComponentType<?>> ar = BuiltInRegistries.a(Registries.x, EnchantmentEffectComponents::a);
    public static final IRegistry<MapCodec<? extends LevelBasedValue>> as = BuiltInRegistries.a(Registries.z, LevelBasedValue::a);
    public static final IRegistry<MapCodec<? extends EnchantmentEntityEffect>> at = BuiltInRegistries.a(Registries.y, EnchantmentEntityEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentLocationBasedEffect>> au = BuiltInRegistries.a(Registries.A, EnchantmentLocationBasedEffect::b);
    public static final IRegistry<MapCodec<? extends EnchantmentValueEffect>> av = BuiltInRegistries.a(Registries.C, EnchantmentValueEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentProvider>> aw = BuiltInRegistries.a(Registries.B, EnchantmentProviderTypes::a);
    public static final IRegistry<ConsumeEffect.a<?>> ax = BuiltInRegistries.a(Registries.n, (IRegistry<T> registry) -> ConsumeEffect.a.a);
    public static final IRegistry<RecipeDisplay.a<?>> ay = BuiltInRegistries.a(Registries.ak, RecipeDisplays::a);
    public static final IRegistry<SlotDisplay.i<?>> az = BuiltInRegistries.a(Registries.as, SlotDisplays::a);
    public static final IRegistry<RecipeBookCategory> aA = BuiltInRegistries.a(Registries.aj, RecipeBookCategories::a);
    public static final IRegistry<TicketType> aB = BuiltInRegistries.a(Registries.aF, (IRegistry<T> registry) -> TicketType.o);
    public static final IRegistry<IncomingRpcMethod> aC = BuiltInRegistries.a(Registries.aK, IncomingRpcMethods::a);
    public static final IRegistry<OutgoingRpcMethod<?, ?>> aD = BuiltInRegistries.a(Registries.aL, (IRegistry<T> registry) -> OutgoingRpcMethods.a);
    public static final IRegistry<MapCodec<? extends TestEnvironmentDefinition>> aE = BuiltInRegistries.a(Registries.aC, TestEnvironmentDefinition::a);
    public static final IRegistry<MapCodec<? extends GameTestInstance>> aF = BuiltInRegistries.a(Registries.aE, GameTestInstance::a);
    public static final IRegistry<MapCodec<? extends SpawnCondition>> aG = BuiltInRegistries.a(Registries.au, SpawnConditions::a);
    public static final IRegistry<MapCodec<? extends Dialog>> aH = BuiltInRegistries.a(Registries.w, DialogTypes::a);
    public static final IRegistry<MapCodec<? extends Action>> aI = BuiltInRegistries.a(Registries.aB, ActionTypes::a);
    public static final IRegistry<MapCodec<? extends InputControl>> aJ = BuiltInRegistries.a(Registries.M, InputControlTypes::a);
    public static final IRegistry<MapCodec<? extends DialogBody>> aK = BuiltInRegistries.a(Registries.v, DialogBodyTypes::a);
    public static final IRegistry<Consumer<GameTestHarnessHelper>> aL = BuiltInRegistries.a(Registries.aD, BuiltinTestFunctions::a);
    public static final IRegistry<? extends IRegistry<?>> aM = aP;
    public static final Conversions STATIC_ACCESS_CONVERSIONS = new Conversions(new RegistryOps.a(RegistryLayer.f));

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> registryKey, a<T> bootstrap) {
        return BuiltInRegistries.a(registryKey, new RegistryMaterials(registryKey, Lifecycle.stable(), false), bootstrap);
    }

    private static <T> IRegistry<T> b(ResourceKey<? extends IRegistry<T>> registryKey, a<T> bootstrap) {
        return BuiltInRegistries.a(registryKey, new RegistryMaterials(registryKey, Lifecycle.stable(), true), bootstrap);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> registryKey, String defaultKey, a<T> bootstrap) {
        return BuiltInRegistries.a(registryKey, new DefaultedMappedRegistry(defaultKey, registryKey, Lifecycle.stable(), false), bootstrap);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> registryKey, String defaultKey, a<T> bootstrap) {
        return BuiltInRegistries.a(registryKey, new DefaultedMappedRegistry(defaultKey, registryKey, Lifecycle.stable(), true), bootstrap);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> registryKey, R registry, a<T> bootstrap) {
        DispenserRegistry.a(() -> "registry " + String.valueOf(registryKey.a()));
        PaperRegistryAccess.instance().registerRegistry(registry);
        MinecraftKey resourceLocation = registryKey.a();
        aO.put(resourceLocation, () -> bootstrap.run(registry));
        aP.a(registryKey, registry, RegistrationInfo.a);
        return registry;
    }

    public static void a() {
        BuiltInRegistries.bootStrap(() -> {});
    }

    public static void bootStrap(Runnable runnable) {
        aM.n();
        BuiltInRegistries.b();
        runnable.run();
        BuiltInRegistries.c();
        BuiltInRegistries.b(aM);
    }

    private static void b() {
        try {
            Class.forName(Registry.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        aO.forEach((resourceLocation, supplier) -> {
            if (supplier.get() == null) {
                aN.error("Unable to bootstrap registry '{}'", resourceLocation);
            }
            PaperRegistryAccess.instance().lockReferenceHolders(ResourceKey.a(resourceLocation));
        });
    }

    private static void c() {
        aM.n();
        for (IRegistry iRegistry : aM) {
            BuiltInRegistries.c(iRegistry);
            PaperRegistryListenerManager.INSTANCE.runFreezeListeners(iRegistry.g(), STATIC_ACCESS_CONVERSIONS);
            iRegistry.n();
        }
    }

    private static <T extends IRegistry<?>> void b(IRegistry<T> registry) {
        registry.forEach(registry1 -> {
            if (registry1.i().isEmpty()) {
                SystemUtils.b("Registry '" + String.valueOf(registry.b(registry1)) + "' was empty after loading");
            }
            if (registry1 instanceof RegistryBlocks) {
                MinecraftKey defaultKey = ((RegistryBlocks)registry1).b();
                Objects.requireNonNull(registry1.a(defaultKey), "Missing default of DefaultedMappedRegistry: " + String.valueOf(defaultKey));
            }
        });
    }

    public static <T> HolderGetter<T> a(IRegistry<T> registry) {
        return ((IRegistryWritable)registry).p();
    }

    private static void c(IRegistry<?> registry) {
        ((RegistryMaterials)registry).o();
    }

    @FunctionalInterface
    static interface a<T> {
        public Object run(IRegistry<T> var1);
    }
}

