/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger a = LogUtils.getLogger();
    private static final String b = "// ";
    private final Path c;
    private final Path d;
    private final String e;
    private final Map<String, b> f;
    private final Set<String> g = new HashSet<String>();
    final Set<Path> h = new HashSet<Path>();
    private final int i;
    private int j;

    private Path b(String provider) {
        return this.d.resolve(Hashing.sha1().hashString((CharSequence)provider, StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path rootDir, Collection<String> providers, WorldVersion version) throws IOException {
        this.e = version.b();
        this.c = rootDir;
        this.d = rootDir.resolve(".cache");
        Files.createDirectories(this.d, new FileAttribute[0]);
        HashMap<String, b> map = new HashMap<String, b>();
        int i2 = 0;
        for (String string : providers) {
            Path providerCachePath = this.b(string);
            this.h.add(providerCachePath);
            b cache = HashCache.a(rootDir, providerCachePath);
            map.put(string, cache);
            i2 += cache.a();
        }
        this.f = map;
        this.i = i2;
    }

    private static b a(Path rootDir, Path cachePath) {
        if (Files.isReadable(cachePath)) {
            try {
                return net.minecraft.data.HashCache$b.a(rootDir, cachePath);
            }
            catch (Exception var3) {
                a.warn("Failed to parse cache {}, discarding", (Object)cachePath, (Object)var3);
            }
        }
        return new b("unknown", (ImmutableMap<Path, HashCode>)ImmutableMap.of());
    }

    public boolean a(String provider) {
        b providerCache = this.f.get(provider);
        return providerCache == null || !providerCache.a.equals(this.e);
    }

    public CompletableFuture<e> a(String provider, UpdateFunction updateFunction) {
        b providerCache = this.f.get(provider);
        if (providerCache == null) {
            throw new IllegalStateException("Provider not registered: " + provider);
        }
        a cacheUpdater = new a(provider, this.e, providerCache);
        return updateFunction.update(cacheUpdater).thenApply(object -> cacheUpdater.a());
    }

    public void a(e updateResult) {
        this.f.put(updateResult.a(), updateResult.b());
        this.g.add(updateResult.a());
        this.j += updateResult.c();
    }

    public void a() throws IOException {
        final HashSet<Path> set = new HashSet<Path>();
        this.f.forEach((cacheName, providerCache) -> {
            if (this.g.contains(cacheName)) {
                Path providerCachePath = this.b((String)cacheName);
                providerCache.a(this.c, providerCachePath, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + cacheName);
            }
            set.addAll((Collection<Path>)providerCache.c().keySet());
        });
        set.add(this.c.resolve("version.json"));
        final MutableInt mutableInt = new MutableInt();
        final MutableInt mutableInt1 = new MutableInt();
        Files.walkFileTree(this.c, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) {
                if (HashCache.this.h.contains(path)) {
                    return FileVisitResult.CONTINUE;
                }
                mutableInt.increment();
                if (set.contains(path)) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    Files.delete(path);
                }
                catch (IOException var4) {
                    a.warn("Failed to delete file {}", (Object)path, (Object)var4);
                }
                mutableInt1.increment();
                return FileVisitResult.CONTINUE;
            }
        });
        a.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{mutableInt, this.i, set.size(), mutableInt1, this.j});
    }

    record b(String a, ImmutableMap<Path, HashCode> b) {
        private final String a;
        private final ImmutableMap<Path, HashCode> b;

        @Nullable
        public HashCode a(Path path) {
            return (HashCode)this.b.get((Object)path);
        }

        public int a() {
            return this.b.size();
        }

        public static b a(Path rootDir, Path cachePath) throws IOException {
            b var7;
            try (BufferedReader bufferedReader = Files.newBufferedReader(cachePath, StandardCharsets.UTF_8);){
                String line = bufferedReader.readLine();
                if (!line.startsWith(HashCache.b)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] parts = line.substring(HashCache.b.length()).split("\t", 2);
                String string = parts[0];
                ImmutableMap.Builder builder = ImmutableMap.builder();
                bufferedReader.lines().forEach(line1 -> {
                    int index = line1.indexOf(32);
                    builder.put((Object)rootDir.resolve(line1.substring(index + 1)), (Object)HashCode.fromString((String)line1.substring(0, index)));
                });
                var7 = new b(string, (ImmutableMap<Path, HashCode>)builder.build());
            }
            return var7;
        }

        public void a(Path rootDir, Path cachePath, String date) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(cachePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(HashCache.b);
                bufferedWriter.write(this.a);
                bufferedWriter.write(9);
                bufferedWriter.write(date);
                bufferedWriter.newLine();
                for (Map.Entry entry : this.b.entrySet()) {
                    bufferedWriter.write(((HashCode)entry.getValue()).toString());
                    bufferedWriter.write(32);
                    bufferedWriter.write(rootDir.relativize((Path)entry.getKey()).toString());
                    bufferedWriter.newLine();
                }
            }
            catch (IOException var9) {
                a.warn("Unable write cachefile {}: {}", (Object)cachePath, (Object)var9);
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "version;data", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "version;data", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "version;data", "a", "b"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public ImmutableMap<Path, HashCode> c() {
            return this.b;
        }
    }

    static class a
    implements CachedOutput {
        private final String b;
        private final b c;
        private final c d;
        private final AtomicInteger e = new AtomicInteger();
        private volatile boolean f;

        a(String provider, String version, b oldCache) {
            this.b = provider;
            this.c = oldCache;
            this.d = new c(version);
        }

        private boolean a(Path key, HashCode value) {
            return !Objects.equals(this.c.a(key), value) || !Files.exists(key, new LinkOption[0]);
        }

        @Override
        public void writeIfNeeded(Path filePath, byte[] data, HashCode hashCode) throws IOException {
            if (this.f) {
                throw new IllegalStateException("Cannot write to cache as it has already been closed");
            }
            if (this.a(filePath, hashCode)) {
                this.e.incrementAndGet();
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, data, new OpenOption[0]);
            }
            this.d.a(filePath, hashCode);
        }

        public e a() {
            this.f = true;
            return new e(this.b, this.d.a(), this.e.get());
        }
    }

    @FunctionalInterface
    public static interface UpdateFunction {
        public CompletableFuture<?> update(CachedOutput var1);
    }

    public record e(String a, b b, int c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "providerId;cache;writes", "a", "b", "c"}, this, o2);
        }
    }

    record c(String a, ConcurrentMap<Path, HashCode> b) {
        private final String a;
        private final ConcurrentMap<Path, HashCode> b;

        c(String version) {
            this(version, new ConcurrentHashMap<Path, HashCode>());
        }

        public void a(Path key, HashCode value) {
            this.b.put(key, value);
        }

        public b a() {
            return new b(this.a, (ImmutableMap<Path, HashCode>)ImmutableMap.copyOf(this.b));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "version;data", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "version;data", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "version;data", "a", "b"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public ConcurrentMap<Path, HashCode> c() {
            return this.b;
        }
    }
}

