/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.a a;
    private final FeatureFlagSet b;
    private final FeatureFlagSet c;
    private final Map<EntityTypes<?>, Map<ResourceKey<LootTable>, LootTable.a>> d = Maps.newHashMap();

    protected final AnyOfCondition.a a() {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.aZ);
        return AnyOfCondition.a(LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, CriterionConditionEntity.a.a().a(CriterionConditionEntityFlags.a.a().b(true))), LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.c, CriterionConditionEntity.a.a().a(CriterionConditionEntityEquipment.a.a().f(CriterionConditionItem.a.a().a(DataComponentMatchers.a.a().a(DataComponentPredicates.b, EnchantmentsPredicate.a(List.of(new CriterionConditionEnchantments(registryLookup.b(EnchantmentTags.p), CriterionConditionValue.IntegerRange.c)))).b())))));
    }

    protected EntityLootSubProvider(FeatureFlagSet required, HolderLookup.a registries) {
        this(required, required, registries);
    }

    protected EntityLootSubProvider(FeatureFlagSet allowed, FeatureFlagSet required, HolderLookup.a registries) {
        this.b = allowed;
        this.c = required;
        this.a = registries;
    }

    public static LootSelector.a a(Map<EnumColor, ResourceKey<LootTable>> lootTables) {
        LootEntryAlternatives.a builder = LootEntryAlternatives.a(new LootEntryAbstract.a[0]);
        for (Map.Entry<EnumColor, ResourceKey<LootTable>> entry : lootTables.entrySet()) {
            builder = builder.a((LootEntryAbstract.a<?>)NestedLootTable.a(entry.getValue()).a(LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, CriterionConditionEntity.a.a().a(DataComponentMatchers.a.a().a(DataComponentExactPredicate.a(DataComponents.aR, entry.getKey())).b()).a(SheepPredicate.b()))));
        }
        return LootSelector.a().a(builder);
    }

    public abstract void b();

    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.a> output) {
        this.b();
        HashSet set = new HashSet();
        BuiltInRegistries.g.c().forEach(reference -> {
            EntityTypes entityType = (EntityTypes)reference.a();
            if (entityType.a(this.b)) {
                Optional<ResourceKey<LootTable>> defaultLootTable = entityType.j();
                if (defaultLootTable.isPresent()) {
                    Map<ResourceKey<LootTable>, LootTable.a> map = this.d.remove(entityType);
                    if (entityType.a(this.c) && (map == null || !map.containsKey(defaultLootTable.get()))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", defaultLootTable.get(), reference.h().a()));
                    }
                    if (map != null) {
                        map.forEach((resourceKey, builder) -> {
                            if (!set.add(resourceKey)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", resourceKey, reference.h().a()));
                            }
                            output.accept((ResourceKey<LootTable>)resourceKey, (LootTable.a)builder);
                        });
                    }
                } else {
                    Map<ResourceKey<LootTable>, LootTable.a> mapx = this.d.remove(entityType);
                    if (mapx != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", mapx.keySet().stream().map(resourceKey -> resourceKey.a().toString()).collect(Collectors.joining(",")), reference.h().a()));
                    }
                }
            }
        });
        if (!this.d.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.d.keySet()));
        }
    }

    protected LootItemCondition.a a(HolderGetter<EntityTypes<?>> entityTypeRegistry) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(entityTypeRegistry, EntityTypes.ae)));
    }

    protected LootItemCondition.a a(HolderGetter<EntityTypes<?>> entityTypeRegistry, HolderGetter<FrogVariant> variantRegistry, ResourceKey<FrogVariant> variantKey) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(entityTypeRegistry, EntityTypes.ae).a(DataComponentMatchers.a.a().a(DataComponentExactPredicate.a(DataComponents.aK, variantRegistry.b(variantKey))).b())));
    }

    protected void a(EntityTypes<?> entityType, LootTable.a builder) {
        this.a(entityType, entityType.j().orElseThrow(() -> new IllegalStateException("Entity " + String.valueOf(entityType) + " has no loot table")), builder);
    }

    protected void a(EntityTypes<?> entityType, ResourceKey<LootTable> defaultLootTable, LootTable.a builder) {
        this.d.computeIfAbsent(entityType, entityType1 -> new HashMap()).put(defaultLootTable, builder);
    }
}

