/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapedRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> b;
    private final RecipeCategory c;
    private final Item d;
    private final int e;
    private final List<String> f = Lists.newArrayList();
    private final Map<Character, RecipeItemStack> g = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> h = new LinkedHashMap();
    @Nullable
    private String i;
    private boolean j = true;

    private ShapedRecipeBuilder(HolderGetter<Item> items, RecipeCategory category, IMaterial result, int count) {
        this.b = items;
        this.c = category;
        this.d = result.h();
        this.e = count;
    }

    public static ShapedRecipeBuilder a(HolderGetter<Item> items, RecipeCategory category, IMaterial result) {
        return ShapedRecipeBuilder.a(items, category, result, 1);
    }

    public static ShapedRecipeBuilder a(HolderGetter<Item> items, RecipeCategory category, IMaterial result, int count) {
        return new ShapedRecipeBuilder(items, category, result, count);
    }

    public ShapedRecipeBuilder a(Character symbol, TagKey<Item> tag) {
        return this.a(symbol, RecipeItemStack.a(this.b.b(tag)));
    }

    public ShapedRecipeBuilder a(Character symbol, IMaterial item) {
        return this.a(symbol, RecipeItemStack.a(item));
    }

    public ShapedRecipeBuilder a(Character symbol, RecipeItemStack ingredient) {
        if (this.g.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.g.put(symbol, ingredient);
        return this;
    }

    public ShapedRecipeBuilder b(String pattern) {
        if (!this.f.isEmpty() && pattern.length() != this.f.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.f.add(pattern);
        return this;
    }

    public ShapedRecipeBuilder b(String name, Criterion<?> criterion) {
        this.h.put(name, criterion);
        return this;
    }

    public ShapedRecipeBuilder c(@Nullable String groupName) {
        this.i = groupName;
        return this;
    }

    public ShapedRecipeBuilder a(boolean showNotification) {
        this.j = showNotification;
        return this;
    }

    @Override
    public Item a() {
        return this.d;
    }

    @Override
    public void a(RecipeOutput output, ResourceKey<IRecipe<?>> resourceKey) {
        ShapedRecipePattern shapedRecipePattern = this.a(resourceKey);
        Advancement.SerializedAdvancement builder = output.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(resourceKey)).a(AdvancementRewards.a.c(resourceKey)).a(AdvancementRequirements.a.b);
        this.h.forEach(builder::a);
        ShapedRecipes shapedRecipe = new ShapedRecipes(Objects.requireNonNullElse(this.i, ""), RecipeBuilder.a(this.c), shapedRecipePattern, new ItemStack(this.d, this.e), this.j);
        output.a(resourceKey, shapedRecipe, builder.b(resourceKey.a().f("recipes/" + this.c.a() + "/")));
    }

    private ShapedRecipePattern a(ResourceKey<IRecipe<?>> recipe) {
        if (this.h.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipe.a()));
        }
        return ShapedRecipePattern.a(this.g, this.f);
    }
}

