/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final PackOutput e;
    private final Iterable<Path> f;
    private final List<Filter> g = Lists.newArrayList();

    public SnbtToNbt(PackOutput output, Iterable<Path> inputFolders) {
        this.e = output;
        this.f = inputFolders;
    }

    public SnbtToNbt a(Filter filter) {
        this.g.add(filter);
        return this;
    }

    private NBTTagCompound a(String fileName, NBTTagCompound tag) {
        NBTTagCompound compoundTag = tag;
        for (Filter filter : this.g) {
            compoundTag = filter.apply(fileName, compoundTag);
        }
        return compoundTag;
    }

    @Override
    public CompletableFuture<?> a(CachedOutput output) {
        Path outputFolder = this.e.a();
        ArrayList list = Lists.newArrayList();
        for (Path path : this.f) {
            list.add(CompletableFuture.supplyAsync(() -> {
                try {
                    CompletableFuture<Void> var5x;
                    try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                        var5x = CompletableFuture.allOf((CompletableFuture[])stream.filter(path1 -> path1.toString().endsWith(".snbt")).map(path1 -> CompletableFuture.runAsync(() -> {
                            c structure = this.a((Path)path1, this.a(path, (Path)path1));
                            this.a(output, structure, outputFolder);
                        }, SystemUtils.h().a("SnbtToNbt"))).toArray(CompletableFuture[]::new));
                    }
                    return var5x;
                }
                catch (Exception var9) {
                    throw new RuntimeException("Failed to read structure input directory, aborting", var9);
                }
            }, SystemUtils.h().a("SnbtToNbt")).thenCompose(completableFuture -> completableFuture));
        }
        return SystemUtils.e(list);
    }

    @Override
    public final String a() {
        return "SNBT -> NBT";
    }

    private String a(Path inputFolder, Path filePath) {
        String string = inputFolder.relativize(filePath).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private c a(Path filePath, String fileName) {
        try {
            c var10;
            try (BufferedReader bufferedReader = Files.newBufferedReader(filePath);){
                String string = IOUtils.toString((Reader)bufferedReader);
                NBTTagCompound compoundTag = this.a(fileName, GameProfileSerializer.a(string));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                NBTCompressedStreamTools.a(compoundTag, (OutputStream)hashingOutputStream);
                byte[] bytes = byteArrayOutputStream.toByteArray();
                HashCode hashCode = hashingOutputStream.hash();
                var10 = new c(fileName, bytes, hashCode);
            }
            return var10;
        }
        catch (Throwable var13) {
            throw new StructureConversionException(filePath, var13);
        }
    }

    private void a(CachedOutput output, c taskResult, Path directoryPath) {
        Path path = directoryPath.resolve(taskResult.a + ".nbt");
        try {
            output.writeIfNeeded(path, taskResult.b, taskResult.c);
        }
        catch (IOException var6) {
            d.error("Couldn't write structure {} at {}", new Object[]{taskResult.a, path, var6});
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    record c(String a, byte[] b, HashCode c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this, o2);
        }
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path path, Throwable cause) {
            super(path.toAbsolutePath().toString(), cause);
        }
    }
}

