/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float a = -0.51f;
    private static final float b = -0.4f;
    private static final float c = 0.1f;
    private static final float d = -0.15f;
    private static final BoundedFloatFunction<Float> e = BoundedFloatFunction.a;
    private static final BoundedFloatFunction<Float> f = BoundedFloatFunction.a(f2 -> f2 < 0.0f ? f2 : f2 * 2.0f);
    private static final BoundedFloatFunction<Float> g = BoundedFloatFunction.a(f2 -> 1.25f - 6.25f / (f2 + 5.0f));
    private static final BoundedFloatFunction<Float> h = BoundedFloatFunction.a(f2 -> f2 * 2.0f);

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I continents, I erosion, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? f : e;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(erosion, ridgesFolded, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.a(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.a(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, boundedFloatFunction);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.a(erosion, ridgesFolded, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, boundedFloatFunction);
        return CubicSpline.a(continents, boundedFloatFunction).a(-1.1f, 0.044f).a(-1.02f, -0.2222f).a(-0.51f, -0.2222f).a(-0.44f, -0.12f).a(-0.18f, -0.12f).a(-0.16f, cubicSpline).a(-0.15f, cubicSpline).a(-0.1f, cubicSpline1).a(0.25f, cubicSpline2).a(1.0f, cubicSpline3).a();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? g : e;
        return CubicSpline.a(continents, e).a(-0.19f, 3.95f).a(-0.15f, TerrainProvider.a(erosion, ridges, ridgesFolded, 6.25f, true, e)).a(-0.1f, TerrainProvider.a(erosion, ridges, ridgesFolded, 5.47f, true, boundedFloatFunction)).a(0.03f, TerrainProvider.a(erosion, ridges, ridgesFolded, 5.08f, true, boundedFloatFunction)).a(0.06f, TerrainProvider.a(erosion, ridges, ridgesFolded, 4.69f, false, boundedFloatFunction)).a();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> b(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        BoundedFloatFunction<Float> boundedFloatFunction = amplified ? h : e;
        float f2 = 0.65f;
        return CubicSpline.a(continents, boundedFloatFunction).a(-0.11f, 0.0f).a(0.03f, TerrainProvider.a(erosion, ridges, ridgesFolded, 1.0f, 0.5f, 0.0f, 0.0f, boundedFloatFunction)).a(0.65f, TerrainProvider.a(erosion, ridges, ridgesFolded, 1.0f, 1.0f, 1.0f, 0.0f, boundedFloatFunction)).a();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridges, I ridgesFolded, float highErosionHighWeirdness, float lowErosionHighWeirdness, float highErosionMidWeirdness, float lowErosionMidWeirdness, BoundedFloatFunction<Float> transform) {
        float f2 = -0.5775f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(ridges, ridgesFolded, highErosionHighWeirdness, highErosionMidWeirdness, transform);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.a(ridges, ridgesFolded, lowErosionHighWeirdness, lowErosionMidWeirdness, transform);
        return CubicSpline.a(erosion, transform).a(-1.0f, cubicSpline).a(-0.78f, cubicSpline1).a(-0.5775f, cubicSpline1).a(-0.375f, 0.0f).a();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I ridges, I ridgesFolded, float highWeirdnessMagnitude, float midWeirdnessMagnitude, BoundedFloatFunction<Float> transform) {
        float f2 = NoiseRouterData.a(0.4f);
        float f1 = NoiseRouterData.a(0.56666666f);
        float f22 = (f2 + f1) / 2.0f;
        CubicSpline.b<C, I> builder = CubicSpline.a(ridgesFolded, transform);
        builder.a(f2, 0.0f);
        if (midWeirdnessMagnitude > 0.0f) {
            builder.a(f22, TerrainProvider.a(ridges, midWeirdnessMagnitude, transform));
        } else {
            builder.a(f22, 0.0f);
        }
        if (highWeirdnessMagnitude > 0.0f) {
            builder.a(1.0f, TerrainProvider.a(ridges, highWeirdnessMagnitude, transform));
        } else {
            builder.a(1.0f, 0.0f);
        }
        return builder.a();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I ridges, float magnitude, BoundedFloatFunction<Float> transform) {
        float f2 = 0.63f * magnitude;
        float f1 = 0.3f * magnitude;
        return CubicSpline.a(ridges, transform).a(-0.01f, f2).a(0.01f, f1).a();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridges, I ridgesFolded, float value, boolean higherValues, BoundedFloatFunction<Float> transform) {
        CubicSpline cubicSpline = CubicSpline.a(ridges, transform).a(-0.2f, 6.3f).a(0.2f, value).a();
        CubicSpline.b builder = CubicSpline.a(erosion, transform).a(-0.6f, cubicSpline).a(-0.5f, CubicSpline.a(ridges, transform).a(-0.05f, 6.3f).a(0.05f, 2.67f).a()).a(-0.35f, cubicSpline).a(-0.25f, cubicSpline).a(-0.1f, CubicSpline.a(ridges, transform).a(-0.05f, 2.67f).a(0.05f, 6.3f).a()).a(0.03f, cubicSpline);
        if (higherValues) {
            CubicSpline cubicSpline1 = CubicSpline.a(ridges, transform).a(0.0f, value).a(0.1f, 0.625f).a();
            CubicSpline cubicSpline2 = CubicSpline.a(ridgesFolded, transform).a(-0.9f, value).a(-0.69f, cubicSpline1).a();
            builder.a(0.35f, value).a(0.45f, cubicSpline2).a(0.55f, cubicSpline2).a(0.62f, value);
        } else {
            CubicSpline cubicSpline1 = CubicSpline.a(ridgesFolded, transform).a(-0.7f, cubicSpline).a(-0.15f, 1.37f).a();
            CubicSpline cubicSpline2 = CubicSpline.a(ridgesFolded, transform).a(0.45f, cubicSpline).a(0.7f, 1.56f).a();
            builder.a(0.05f, cubicSpline2).a(0.4f, cubicSpline2).a(0.45f, cubicSpline1).a(0.55f, cubicSpline1).a(0.58f, value);
        }
        return builder.a();
    }

    private static float a(float y1, float y2, float x1, float x2) {
        return (y2 - y1) / (x2 - x1);
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I ridgesFolded, float magnitude, boolean useMaxSlope, BoundedFloatFunction<Float> transform) {
        CubicSpline.b builder = CubicSpline.a(ridgesFolded, transform);
        float f2 = -0.7f;
        float f1 = -1.0f;
        float f22 = TerrainProvider.a(-1.0f, magnitude, -0.7f);
        float f3 = 1.0f;
        float f4 = TerrainProvider.a(1.0f, magnitude, -0.7f);
        float f5 = TerrainProvider.a(magnitude);
        float f6 = -0.65f;
        if (-0.65f < f5 && f5 < 1.0f) {
            float f7 = TerrainProvider.a(-0.65f, magnitude, -0.7f);
            float f8 = -0.75f;
            float f9 = TerrainProvider.a(-0.75f, magnitude, -0.7f);
            float f10 = TerrainProvider.a(f22, f9, -1.0f, -0.75f);
            builder.a(-1.0f, f22, f10);
            builder.a(-0.75f, f9);
            builder.a(-0.65f, f7);
            float f11 = TerrainProvider.a(f5, magnitude, -0.7f);
            float f12 = TerrainProvider.a(f11, f4, f5, 1.0f);
            float f13 = 0.01f;
            builder.a(f5 - 0.01f, f11);
            builder.a(f5, f11, f12);
            builder.a(1.0f, f4, f12);
        } else {
            float f7 = TerrainProvider.a(f22, f4, -1.0f, 1.0f);
            if (useMaxSlope) {
                builder.a(-1.0f, Math.max(0.2f, f22));
                builder.a(0.0f, MathHelper.h(0.5f, f22, f4), f7);
            } else {
                builder.a(-1.0f, f22, f7);
            }
            builder.a(1.0f, f4, f7);
        }
        return builder.a();
    }

    private static float a(float heightFactor, float magnitude, float cutoffHeight) {
        float f2 = 1.17f;
        float f1 = 0.46082947f;
        float f22 = 1.0f - (1.0f - magnitude) * 0.5f;
        float f3 = 0.5f * (1.0f - magnitude);
        float f4 = (heightFactor + 1.17f) * 0.46082947f;
        float f5 = f4 * f22 - f3;
        return heightFactor < cutoffHeight ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float a(float input) {
        float f2 = 1.17f;
        float f1 = 0.46082947f;
        float f22 = 1.0f - (1.0f - input) * 0.5f;
        float f3 = 0.5f * (1.0f - input);
        return f3 / (0.46082947f * f22) - 1.17f;
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridgesFolded, float ridgeBaseOffset, float ridgeMidOffset, float ridgePeakOffset, float magnitude, float ridgeInnerOffset, float ridgeOuterOffset, boolean extended, boolean useMaxSlope, BoundedFloatFunction<Float> transform) {
        float f2 = 0.6f;
        float f1 = 0.5f;
        float f22 = 0.5f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(ridgesFolded, MathHelper.h(magnitude, 0.6f, 1.5f), useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline1 = TerrainProvider.a(ridgesFolded, MathHelper.h(magnitude, 0.6f, 1.0f), useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.a(ridgesFolded, magnitude, useMaxSlope, transform);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.a(ridgesFolded, ridgeBaseOffset - 0.15f, 0.5f * magnitude, MathHelper.h(0.5f, 0.5f, 0.5f) * magnitude, 0.5f * magnitude, 0.6f * magnitude, 0.5f, transform);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.a(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset * magnitude, ridgeMidOffset * magnitude, 0.5f * magnitude, 0.6f * magnitude, 0.5f, transform);
        CubicSpline<C, I> cubicSpline5 = TerrainProvider.a(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset, ridgeInnerOffset, ridgeMidOffset, ridgePeakOffset, 0.5f, transform);
        CubicSpline<C, I> cubicSpline6 = TerrainProvider.a(ridgesFolded, ridgeBaseOffset, ridgeInnerOffset, ridgeInnerOffset, ridgeMidOffset, ridgePeakOffset, 0.5f, transform);
        CubicSpline cubicSpline7 = CubicSpline.a(ridgesFolded, transform).a(-1.0f, ridgeBaseOffset).a(-0.4f, cubicSpline5).a(0.0f, ridgePeakOffset + 0.07f).a();
        CubicSpline<C, I> cubicSpline8 = TerrainProvider.a(ridgesFolded, -0.02f, ridgeOuterOffset, ridgeOuterOffset, ridgeMidOffset, ridgePeakOffset, 0.0f, transform);
        CubicSpline.b<C, I> builder = CubicSpline.a(erosion, transform).a(-0.85f, cubicSpline).a(-0.7f, cubicSpline1).a(-0.4f, cubicSpline2).a(-0.35f, cubicSpline3).a(-0.1f, cubicSpline4).a(0.2f, cubicSpline5);
        if (extended) {
            builder.a(0.4f, cubicSpline6).a(0.45f, cubicSpline7).a(0.55f, cubicSpline7).a(0.58f, cubicSpline6);
        }
        builder.a(0.7f, cubicSpline8);
        return builder.a();
    }

    private static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> a(I ridgesFolded, float y1, float y2, float y3, float y4, float y5, float minSmoothing, BoundedFloatFunction<Float> transform) {
        float max = Math.max(0.5f * (y2 - y1), minSmoothing);
        float f2 = 5.0f * (y3 - y2);
        return CubicSpline.a(ridgesFolded, transform).a(-1.0f, y1, max).a(-0.4f, y2, Math.min(max, f2)).a(0.0f, y3, f2).a(0.4f, y4, 2.0f * (y4 - y3)).a(1.0f, y5, 0.7f * (y5 - y4)).a();
    }
}

