/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo a;
    private boolean b;

    public GameTestHarnessHelper(GameTestHarnessInfo testInfo) {
        this.a = testInfo;
    }

    public GameTestHarnessAssertion a(IChatBaseComponent message) {
        return new GameTestHarnessAssertion(message, this.a.p());
    }

    public GameTestHarnessAssertion a(String messageKey, Object ... args) {
        return this.a(IChatBaseComponent.b(messageKey, args));
    }

    public GameTestHarnessAssertionPosition a(BlockPosition pos, IChatBaseComponent message) {
        return new GameTestHarnessAssertionPosition(message, this.j(pos), pos, this.a.p());
    }

    public GameTestHarnessAssertionPosition a(BlockPosition pos, String messageKey, Object ... args) {
        return this.a(pos, (IChatBaseComponent)IChatBaseComponent.b(messageKey, args));
    }

    public WorldServer a() {
        return this.a.g();
    }

    public IBlockData a(BlockPosition pos) {
        return this.a().a_(this.j(pos));
    }

    public <T extends TileEntity> T a(BlockPosition pos, Class<T> clazz) {
        TileEntity blockEntity = this.a().c_(this.j(pos));
        if (blockEntity == null) {
            throw this.a(pos, "test.error.missing_block_entity", new Object[0]);
        }
        if (clazz.isInstance(blockEntity)) {
            return (T)((TileEntity)clazz.cast(blockEntity));
        }
        throw this.a(pos, "test.error.wrong_block_entity", blockEntity.s().a().g());
    }

    public void b() {
        this.a(Entity.class);
    }

    public void a(Class<? extends Entity> entityClass) {
        AxisAlignedBB bounds = this.k();
        List<Entity> entitiesOfClass = this.a().a(entityClass, bounds.g(1.0), (? super T entity) -> !(entity instanceof EntityHuman));
        entitiesOfClass.forEach(entity -> entity.c(this.a()));
    }

    public EntityItem a(Item item, Vec3D pos) {
        WorldServer level = this.a();
        Vec3D vec3 = this.a(pos);
        EntityItem itemEntity = new EntityItem(level, vec3.g, vec3.h, vec3.i, new ItemStack(item, 1));
        itemEntity.m(0.0, 0.0, 0.0);
        level.b(itemEntity);
        return itemEntity;
    }

    public EntityItem a(Item item, float x2, float y2, float z2) {
        return this.a(item, new Vec3D(x2, y2, z2));
    }

    public EntityItem a(Item item, BlockPosition pos) {
        return this.a(item, (float)pos.u(), (float)pos.v(), (float)pos.w());
    }

    public <E extends Entity> E a(EntityTypes<E> type, BlockPosition pos) {
        return this.a(type, Vec3D.c(pos));
    }

    public <E extends Entity> List<E> a(EntityTypes<E> type, BlockPosition pos, int count) {
        return this.a(type, Vec3D.c(pos), count);
    }

    public <E extends Entity> List<E> a(EntityTypes<E> type, Vec3D pos, int count) {
        ArrayList<E> list = new ArrayList<E>();
        for (int i2 = 0; i2 < count; ++i2) {
            list.add(this.a(type, pos));
        }
        return list;
    }

    public <E extends Entity> E a(EntityTypes<E> type, Vec3D pos) {
        WorldServer level = this.a();
        E entity = type.a(level, EntitySpawnReason.d);
        if (entity == null) {
            throw this.a(BlockPosition.a(pos), "test.error.spawn_failure", type.r().g());
        }
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            mob.gq();
        }
        Vec3D vec3 = this.a(pos);
        float f2 = ((Entity)entity).a(this.h());
        ((Entity)entity).b(vec3.g, vec3.h, vec3.i, f2, ((Entity)entity).dZ());
        ((Entity)entity).s(f2);
        ((Entity)entity).r(f2);
        level.b((Entity)entity);
        return entity;
    }

    public void a(Entity entity, DamageSource damageSource, float amount) {
        entity.a(this.a(), damageSource, amount);
    }

    public void a(Entity entity) {
        entity.c(this.a());
    }

    public <E extends Entity> E a(EntityTypes<E> type) {
        return this.a(type, 0, 0, 0, 2.147483647E9);
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2, double radius) {
        List<E> list = this.b(type, x2, y2, z2, radius);
        if (list.isEmpty()) {
            throw this.a("test.error.expected_entity_around", type.h(), x2, y2, z2);
        }
        if (list.size() > 1) {
            throw this.a("test.error.too_many_entities", type.i(), x2, y2, z2, list.size());
        }
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        list.sort((first, second) -> {
            double d2 = first.dD().f(vec3);
            double d1 = second.dD().f(vec3);
            return Double.compare(d2, d1);
        });
        return (E)((Entity)list.get(0));
    }

    public <E extends Entity> List<E> b(EntityTypes<E> type, int x2, int y2, int z2, double radius) {
        return this.a(type, Vec3D.c(new BlockPosition(x2, y2, z2)), radius);
    }

    public <E extends Entity> List<E> a(EntityTypes<E> type, Vec3D pos, double radius) {
        WorldServer level = this.a();
        Vec3D vec3 = this.a(pos);
        AxisAlignedBB structureBounds = this.a.e();
        AxisAlignedBB aabb = new AxisAlignedBB(vec3.b(-radius, -radius, -radius), vec3.b(radius, radius, radius));
        return level.a(type, structureBounds, (? super T entity) -> entity.de().c(aabb) && entity.bX());
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.a(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends Entity> E a(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.a(type, new Vec3D(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, BlockPosition pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.gD();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.b(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, Vec3D pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.gD();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.b(type, new Vec3D(x2, y2, z2));
    }

    public void a(EntityInsentient mob, float x2, float y2, float z2) {
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        mob.b(vec3.g, vec3.h, vec3.i, mob.dX(), mob.dZ());
    }

    public GameTestHarnessSequence a(EntityInsentient mob, BlockPosition pos, float speed) {
        return this.g().a(2, () -> {
            PathEntity path = mob.S().a(this.j(pos), 0);
            mob.S().a(path, (double)speed);
        });
    }

    public void a(int x2, int y2, int z2) {
        this.b(new BlockPosition(x2, y2, z2));
    }

    public void b(BlockPosition pos) {
        this.a(TagsBlock.f, pos);
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockButtonAbstract buttonBlock = (BlockButtonAbstract)blockState.b();
        buttonBlock.a(blockState, (World)this.a(), blockPos, (EntityHuman)null);
    }

    public void c(BlockPosition pos) {
        this.a(pos, this.a(EnumGamemode.b));
    }

    public void a(BlockPosition pos, EntityHuman player) {
        BlockPosition blockPos = this.j(pos);
        this.a(pos, player, new MovingObjectPositionBlock(Vec3D.b(blockPos), EnumDirection.c, blockPos, true));
    }

    public void a(BlockPosition pos, EntityHuman player, MovingObjectPositionBlock result) {
        EnumHand interactionHand;
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        EnumInteractionResult interactionResult = blockState.a(player.b(interactionHand = EnumHand.a), this.a(), player, interactionHand, result);
        if (!(interactionResult.a() || interactionResult instanceof EnumInteractionResult.f && blockState.a((World)this.a(), player, result).a())) {
            ItemActionContext useOnContext = new ItemActionContext(player, interactionHand, result);
            player.b(interactionHand).a(useOnContext);
        }
    }

    public EntityLiving a(EntityLiving entity) {
        entity.j(0);
        entity.x(0.25f);
        return entity;
    }

    public EntityLiving b(EntityLiving entity) {
        entity.x(0.25f);
        return entity;
    }

    public EntityHuman a(final EnumGamemode gameType) {
        return new EntityHuman(this, this.a(), new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Nonnull
            public EnumGamemode a() {
                return gameType;
            }

            @Override
            public void setAfk(boolean afk) {
            }

            @Override
            public void J() {
            }

            @Override
            public boolean ab_() {
                return false;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public EntityPlayer c() {
        CommonListenerCookie commonListenerCookie = CommonListenerCookie.a(new GameProfile(UUID.randomUUID(), "test-mock-player"), false);
        EntityPlayer serverPlayer = new EntityPlayer(this, this.a().q(), this.a(), commonListenerCookie.a(), commonListenerCookie.c()){

            @Override
            public EnumGamemode a() {
                return EnumGamemode.b;
            }
        };
        NetworkManager connection = new NetworkManager(EnumProtocolDirection.a);
        new EmbeddedChannel(new ChannelHandler[]{connection});
        this.a().q().am().a(connection, serverPlayer, commonListenerCookie);
        return serverPlayer;
    }

    public void b(int x2, int y2, int z2) {
        this.d(new BlockPosition(x2, y2, z2));
    }

    public void d(BlockPosition pos) {
        this.a(Blocks.dX, pos);
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockLever leverBlock = (BlockLever)blockState.b();
        leverBlock.b(blockState, (World)this.a(), blockPos, null);
    }

    public void a(BlockPosition pos, long delay) {
        this.a(pos, Blocks.hR);
        this.b(delay, () -> this.a(pos, Blocks.a));
    }

    public void e(BlockPosition pos) {
        this.a().a(this.j(pos), false, null);
    }

    public void a(int x2, int y2, int z2, Block block) {
        this.a(new BlockPosition(x2, y2, z2), block);
    }

    public void a(int x2, int y2, int z2, IBlockData state) {
        this.a(new BlockPosition(x2, y2, z2), state);
    }

    public void a(BlockPosition pos, Block block) {
        this.a(pos, block.m());
    }

    public void a(BlockPosition pos, IBlockData state) {
        this.a().a(this.j(pos), state, 3);
    }

    public void a(BlockPosition pos, Block block, EnumDirection facing) {
        this.a(pos, block.m(), facing);
    }

    public void a(BlockPosition pos, IBlockData state, EnumDirection facing) {
        IBlockData blockState = state;
        if (state.b(BlockFacingHorizontal.f)) {
            blockState = (IBlockData)state.b(BlockFacingHorizontal.f, facing);
        }
        if (state.b(BlockProperties.R)) {
            blockState = (IBlockData)state.b(BlockProperties.R, facing);
        }
        this.a().a(this.j(pos), blockState, 3);
    }

    public void d() {
        this.a(13000);
    }

    public void a(int time) {
        this.a().b((long)time);
    }

    public void a(Block block, int x2, int y2, int z2) {
        this.a(block, new BlockPosition(x2, y2, z2));
    }

    public void a(Block block, BlockPosition pos) {
        IBlockData blockState = this.a(pos);
        this.a(pos, (Block actualBlock) -> blockState.a(block), (Block actualBlock) -> IChatBaseComponent.a("test.error.expected_block", block.f(), actualBlock.f()));
    }

    public void b(Block block, int x2, int y2, int z2) {
        this.b(block, new BlockPosition(x2, y2, z2));
    }

    public void b(Block block, BlockPosition pos) {
        this.a(pos, (Block actualBlock) -> !this.a(pos).a(block), (Block actualBlock) -> IChatBaseComponent.a("test.error.unexpected_block", block.f()));
    }

    public void a(TagKey<Block> tag, BlockPosition pos) {
        this.b(pos, (IBlockData state) -> state.a(tag), (IBlockData state) -> IChatBaseComponent.a("test.error.expected_block_tag", IChatBaseComponent.a(tag.b()), state.b().f()));
    }

    public void c(Block block, int x2, int y2, int z2) {
        this.c(block, new BlockPosition(x2, y2, z2));
    }

    public void c(Block block, BlockPosition pos) {
        this.b(() -> this.a(block, pos));
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, Function<Block, IChatBaseComponent> message) {
        this.b(pos, (IBlockData state) -> predicate.test(state.b()), (IBlockData state) -> (IChatBaseComponent)message.apply(state.b()));
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, T value) {
        IBlockData blockState = this.a(pos);
        boolean hasProperty = blockState.b(property);
        if (!hasProperty) {
            throw this.a(pos, "test.error.block_property_missing", property.f(), value);
        }
        if (!blockState.c(property).equals(value)) {
            throw this.a(pos, "test.error.block_property_mismatch", property.f(), value, blockState.c(property));
        }
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, Predicate<T> predicate, IChatBaseComponent message) {
        this.b(pos, (IBlockData state) -> {
            if (!state.b(property)) {
                return false;
            }
            Object value = state.c(property);
            return predicate.test(value);
        }, (IBlockData state) -> message);
    }

    public void b(BlockPosition pos, IBlockData state) {
        IBlockData blockState = this.a(pos);
        if (!blockState.equals(state)) {
            throw this.a(pos, "test.error.state_not_equal", state, blockState);
        }
    }

    public void b(BlockPosition pos, Predicate<IBlockData> predicate, Function<IBlockData, IChatBaseComponent> message) {
        IBlockData blockState = this.a(pos);
        if (!predicate.test(blockState)) {
            throw this.a(pos, message.apply(blockState));
        }
    }

    public <T extends TileEntity> void a(BlockPosition pos, Class<T> blockEntityClass, Predicate<T> predicate, Supplier<IChatBaseComponent> message) {
        T blockEntity = this.a(pos, blockEntityClass);
        if (!predicate.test(blockEntity)) {
            throw this.a(pos, message.get());
        }
    }

    public void a(BlockPosition pos, EnumDirection direction, IntPredicate signalStrengthPredicate, Supplier<IChatBaseComponent> message) {
        BlockPosition blockPos = this.j(pos);
        WorldServer level = this.a();
        IBlockData blockState = level.a_(blockPos);
        int signal = blockState.a((IBlockAccess)level, blockPos, direction);
        if (!signalStrengthPredicate.test(signal)) {
            throw this.a(pos, message.get());
        }
    }

    public void b(EntityTypes<?> type) {
        if (!this.a().b(type, this.k(), Entity::bX)) {
            throw this.a("test.error.expected_entity_in_test", type.h());
        }
    }

    public void c(EntityTypes<?> type, int x2, int y2, int z2) {
        this.c(type, new BlockPosition(x2, y2, z2));
    }

    public void c(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        if (!this.a().b(type, new AxisAlignedBB(blockPos), Entity::bX)) {
            throw this.a(pos, "test.error.expected_entity", new Object[]{type.h()});
        }
    }

    public void a(EntityTypes<?> type, AxisAlignedBB box) {
        AxisAlignedBB aabb = this.a(box);
        if (!this.a().b(type, aabb, Entity::bX)) {
            throw this.a(BlockPosition.a(box.f()), "test.error.expected_entity", new Object[]{type.h()});
        }
    }

    public void a(EntityTypes<?> entityType, int count) {
        List<Entity> entities = this.a().a(entityType, this.k(), Entity::bX);
        if (entities.size() != count) {
            throw this.a("test.error.expected_entity_count", count, entityType.h(), entities.size());
        }
    }

    public void a(EntityTypes<?> entityType, BlockPosition pos, int count, double radius) {
        BlockPosition blockPos = this.j(pos);
        List<?> entities = this.b(entityType, pos, radius);
        if (entities.size() != count) {
            throw this.a(pos, "test.error.expected_entity_count", count, entityType.h(), entities.size());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, double expansionAmount) {
        List<?> entities = this.b(type, pos, expansionAmount);
        if (entities.isEmpty()) {
            BlockPosition blockPos = this.j(pos);
            throw this.a(pos, "test.error.expected_entity", new Object[]{type.h()});
        }
    }

    public <T extends Entity> List<T> b(EntityTypes<T> entityType, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.j(pos);
        return this.a().a(entityType, new AxisAlignedBB(blockPos).g(radius), Entity::bX);
    }

    public <T extends Entity> List<T> c(EntityTypes<T> entityType) {
        return this.a().a(entityType, this.k(), Entity::bX);
    }

    public void a(Entity entity, int x2, int y2, int z2) {
        this.a(entity, new BlockPosition(x2, y2, z2));
    }

    public void a(Entity entity, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> entities = this.a().a(entity.ax(), new AxisAlignedBB(blockPos), Entity::bX);
        entities.stream().filter(currentEntity -> currentEntity == entity).findFirst().orElseThrow(() -> this.a(pos, "test.error.expected_entity", new Object[]{entity.ax().h()}));
    }

    public void a(Item item, BlockPosition pos, double expansionAmount, int count) {
        BlockPosition blockPos = this.j(pos);
        List<EntityItem> entities = this.a().a(EntityTypes.au, new AxisAlignedBB(blockPos).g(expansionAmount), Entity::bX);
        int i2 = 0;
        for (EntityItem itemEntity : entities) {
            ItemStack item1 = itemEntity.e();
            if (!item1.a(item)) continue;
            i2 += item1.M();
        }
        if (i2 != count) {
            throw this.a(pos, "test.error.expected_items_count", count, item.l(), i2);
        }
    }

    public void a(Item item, BlockPosition pos, double expansionAmount) {
        BlockPosition blockPos = this.j(pos);
        Predicate<EntityItem> predicate = itemEntity -> itemEntity.bX() && itemEntity.e().a(item);
        if (!this.a().b(EntityTypes.au, new AxisAlignedBB(blockPos).g(expansionAmount), predicate)) {
            throw this.a(pos, "test.error.expected_item", new Object[]{item.l()});
        }
    }

    public void b(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.j(pos);
        Predicate<EntityItem> predicate = itemEntity -> itemEntity.bX() && itemEntity.e().a(item);
        if (this.a().b(EntityTypes.au, new AxisAlignedBB(blockPos).g(radius), predicate)) {
            throw this.a(pos, "test.error.unexpected_item", new Object[]{item.l()});
        }
    }

    public void a(Item item) {
        Predicate<EntityItem> predicate = itemEntity -> itemEntity.bX() && itemEntity.e().a(item);
        if (!this.a().b(EntityTypes.au, this.k(), predicate)) {
            throw this.a("test.error.expected_item", item.l());
        }
    }

    public void b(Item item) {
        Predicate<EntityItem> predicate = itemEntity -> itemEntity.bX() && itemEntity.e().a(item);
        if (this.a().b(EntityTypes.au, this.k(), predicate)) {
            throw this.a("test.error.unexpected_item", item.l());
        }
    }

    public void d(EntityTypes<?> type) {
        List<Entity> entities = this.a().a(type, this.k(), Entity::bX);
        if (!entities.isEmpty()) {
            throw this.a(entities.getFirst().dF(), "test.error.unexpected_entity", new Object[]{type.h()});
        }
    }

    public void d(EntityTypes<?> type, int x2, int y2, int z2) {
        this.d(type, new BlockPosition(x2, y2, z2));
    }

    public void d(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        if (this.a().b(type, new AxisAlignedBB(blockPos), Entity::bX)) {
            throw this.a(pos, "test.error.unexpected_entity", new Object[]{type.h()});
        }
    }

    public void b(EntityTypes<?> type, AxisAlignedBB box) {
        AxisAlignedBB aabb = this.a(box);
        List<Entity> entities = this.a().a(type, aabb, Entity::bX);
        if (!entities.isEmpty()) {
            throw this.a(entities.getFirst().dF(), "test.error.unexpected_entity", new Object[]{type.h()});
        }
    }

    public void a(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec31 = this.a(vec3);
        Predicate<Entity> predicate = entity -> entity.de().a(vec31, vec31);
        if (!this.a().b(type, this.k(), predicate)) {
            throw this.a("test.error.expected_entity_touching", type.h(), vec31.a(), vec31.b(), vec31.c(), x2, y2, z2);
        }
    }

    public void b(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec31 = this.a(vec3);
        Predicate<Entity> predicate = entity -> !entity.de().a(vec31, vec31);
        if (!this.a().b(type, this.k(), predicate)) {
            throw this.a("test.error.expected_entity_not_touching", type.h(), vec31.a(), vec31.b(), vec31.c(), x2, y2, z2);
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Predicate<E> predicate) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> entities = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bX);
        if (entities.isEmpty()) {
            throw this.a(pos, "test.error.expected_entity", new Object[]{type.h()});
        }
        for (Entity entity : entities) {
            if (predicate.test(entity)) continue;
            throw this.a(entity.dF(), "test.error.expected_entity_data_predicate", new Object[]{entity.ao()});
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Function<? super E, T> entityDataGetter, @Nullable T testEntityData) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> entities = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bX);
        if (entities.isEmpty()) {
            throw this.a(pos, "test.error.expected_entity", new Object[]{type.h()});
        }
        for (Entity entity : entities) {
            T object = entityDataGetter.apply(entity);
            if (Objects.equals(object, testEntityData)) continue;
            throw this.a(pos, "test.error.expected_entity_data", testEntityData, object);
        }
    }

    public <E extends EntityLiving> void a(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.j(pos);
        List<EntityLiving> entities = this.a().a(entityType, new AxisAlignedBB(blockPos), Entity::bX);
        if (entities.isEmpty()) {
            throw this.a(pos, "test.error.expected_entity", new Object[]{entityType.h()});
        }
        for (EntityLiving livingEntity : entities) {
            if (!livingEntity.b(item)) continue;
            return;
        }
        throw this.a(pos, "test.error.expected_entity_holding", new Object[]{item.l()});
    }

    public <E extends Entity> void b(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> entities = this.a().a(entityType, new AxisAlignedBB(blockPos), (? super T entity1) -> entity1.bX());
        if (entities.isEmpty()) {
            throw this.a(pos, "test.error.expected_entity", new Object[]{entityType.h()});
        }
        for (Entity entity : entities) {
            if (!((InventoryCarrier)((Object)entity)).n().a_(stack -> stack.a(item))) continue;
            return;
        }
        throw this.a(pos, "test.error.expected_entity_having", new Object[]{item.l()});
    }

    public void f(BlockPosition pos) {
        TileEntityContainer baseContainerBlockEntity = this.a(pos, TileEntityContainer.class);
        if (!baseContainerBlockEntity.c()) {
            throw this.a(pos, "test.error.expected_empty_container", new Object[0]);
        }
    }

    public void a(BlockPosition pos, Item item) {
        TileEntityContainer baseContainerBlockEntity = this.a(pos, TileEntityContainer.class);
        if (baseContainerBlockEntity.a_(item) != 1) {
            throw this.a(pos, "test.error.expected_container_contents_single", new Object[]{item.l()});
        }
    }

    public void b(BlockPosition pos, Item item) {
        TileEntityContainer baseContainerBlockEntity = this.a(pos, TileEntityContainer.class);
        if (baseContainerBlockEntity.a_(item) == 0) {
            throw this.a(pos, "test.error.expected_container_contents", new Object[]{item.l()});
        }
    }

    public void a(StructureBoundingBox boundingBox, BlockPosition pos) {
        BlockPosition.a(boundingBox).forEach(blockPos -> {
            BlockPosition blockPos1 = pos.b(blockPos.u() - boundingBox.h(), blockPos.v() - boundingBox.i(), blockPos.w() - boundingBox.j());
            this.a((BlockPosition)blockPos, blockPos1);
        });
    }

    public void a(BlockPosition testPos, BlockPosition comparisonPos) {
        IBlockData blockState1;
        IBlockData blockState = this.a(testPos);
        if (blockState != (blockState1 = this.a(comparisonPos))) {
            throw this.a(testPos, "test.error.state_not_equal", blockState1, blockState);
        }
    }

    public void a(long tickTime, BlockPosition pos, Item item) {
        this.a(tickTime, () -> this.a(pos, item));
    }

    public void a(long tickTime, BlockPosition pos) {
        this.a(tickTime, () -> this.f(pos));
    }

    public <E extends Entity, T> void b(BlockPosition pos, EntityTypes<E> type, Function<E, T> entityDataGetter, T testEntityData) {
        this.b(() -> this.a(pos, type, entityDataGetter, testEntityData));
    }

    public void a(Entity entity, AxisAlignedBB boundingBox, IChatBaseComponent message) {
        if (!boundingBox.d(this.b(entity.dD()))) {
            throw this.a(message);
        }
    }

    public <E extends Entity> void a(E entity, Predicate<E> predicate, IChatBaseComponent message) {
        if (!predicate.test(entity)) {
            throw this.a(entity.dF(), "test.error.entity_property", entity.ao(), message);
        }
    }

    public <E extends Entity, T> void a(E entity, Function<E, T> valueGetter, T expectedValue, IChatBaseComponent message) {
        T object = valueGetter.apply(entity);
        if (!object.equals(expectedValue)) {
            throw this.a(entity.dF(), "test.error.entity_property_details", entity.ao(), message, object, expectedValue);
        }
    }

    public void a(EntityLiving entity, Holder<MobEffectList> effect, int amplifier) {
        MobEffect effect1 = entity.e(effect);
        if (effect1 == null || effect1.e() != amplifier) {
            throw this.a("test.error.expected_entity_effect", new Object[]{entity.ao(), PotionContents.a(effect, amplifier)});
        }
    }

    public void e(EntityTypes<?> type, int x2, int y2, int z2) {
        this.e(type, new BlockPosition(x2, y2, z2));
    }

    public void e(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.c(type, pos));
    }

    public void f(EntityTypes<?> type, int x2, int y2, int z2) {
        this.f(type, new BlockPosition(x2, y2, z2));
    }

    public void f(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.d(type, pos));
    }

    public void e() {
        this.a.m();
    }

    private void l() {
        if (this.b) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.b = true;
    }

    public void a(Runnable criterion) {
        this.l();
        this.a.q().a(0L, criterion).a();
    }

    public void b(Runnable criterion) {
        this.l();
        this.a.q().a(criterion).a();
    }

    public void a(int tick, Runnable criterion) {
        this.l();
        this.a.q().a((long)tick, criterion).a();
    }

    public void a(long tickTime, Runnable task) {
        this.a.a(tickTime, task);
    }

    public void b(long delay, Runnable task) {
        this.a((long)this.a.p() + delay, task);
    }

    public void g(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        WorldServer level = this.a();
        level.a_(blockPos).b(level, blockPos, level.z);
    }

    public void h(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        WorldServer level = this.a();
        level.a_(blockPos).a(level, blockPos, level.z);
    }

    public void i(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        WorldServer level = this.a();
        level.a(blockPos);
    }

    public void f() {
        AxisAlignedBB relativeBounds = this.m();
        int i2 = (int)Math.floor(relativeBounds.d);
        int i1 = (int)Math.floor(relativeBounds.f);
        int i22 = (int)Math.floor(relativeBounds.e);
        for (int i3 = (int)Math.floor(relativeBounds.a); i3 < i2; ++i3) {
            for (int i4 = (int)Math.floor(relativeBounds.c); i4 < i1; ++i4) {
                this.i(new BlockPosition(i3, i22, i4));
            }
        }
    }

    public int a(HeightMap.Type heightmapType, int x2, int z2) {
        BlockPosition blockPos = this.j(new BlockPosition(x2, 0, z2));
        return this.k(this.a().a(heightmapType, blockPos)).v();
    }

    public void a(IChatBaseComponent message, BlockPosition pos) {
        throw this.a(pos, message);
    }

    public void a(IChatBaseComponent message, Entity entity) {
        throw this.a(entity.dF(), message);
    }

    public void b(IChatBaseComponent message) {
        throw this.a(message);
    }

    public void a(String message) {
        throw this.a(IChatBaseComponent.b(message));
    }

    public void c(Runnable criterion) {
        this.a.q().a(criterion).a(() -> this.a("test.error.fail", new Object[0]));
    }

    public void d(Runnable criterion) {
        LongStream.range(this.a.p(), this.a.x()).forEach(l2 -> this.a.a(l2, criterion::run));
    }

    public GameTestHarnessSequence g() {
        return this.a.q();
    }

    public BlockPosition j(BlockPosition pos) {
        BlockPosition testOrigin = this.a.d();
        BlockPosition blockPos = testOrigin.a(pos);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, this.a.u(), testOrigin);
    }

    public BlockPosition k(BlockPosition pos) {
        BlockPosition testOrigin = this.a.d();
        EnumBlockRotation rotated = this.a.u().a(EnumBlockRotation.c);
        BlockPosition blockPos = DefinedStructure.a(pos, EnumBlockMirror.a, rotated, testOrigin);
        return blockPos.b(testOrigin);
    }

    public AxisAlignedBB a(AxisAlignedBB aabb) {
        Vec3D vec3 = this.a(aabb.h());
        Vec3D vec31 = this.a(aabb.i());
        return new AxisAlignedBB(vec3, vec31);
    }

    public AxisAlignedBB b(AxisAlignedBB aabb) {
        Vec3D vec3 = this.b(aabb.h());
        Vec3D vec31 = this.b(aabb.i());
        return new AxisAlignedBB(vec3, vec31);
    }

    public Vec3D a(Vec3D relativeVec3) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(vec3.e(relativeVec3), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public Vec3D b(Vec3D absoluteVec3) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(absoluteVec3.d(vec3), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public EnumBlockRotation h() {
        return this.a.u();
    }

    public EnumDirection i() {
        return this.a.u().a(EnumDirection.d);
    }

    public void a(boolean condition, IChatBaseComponent message) {
        if (!condition) {
            throw this.a(message);
        }
    }

    public <N> void a(N expected, N actual, IChatBaseComponent name) {
        if (!expected.equals(actual)) {
            throw this.a("test.error.value_not_equal", name, expected, actual);
        }
    }

    public void b(boolean condition, IChatBaseComponent message) {
        this.a(!condition, message);
    }

    public long j() {
        return this.a.p();
    }

    public AxisAlignedBB k() {
        return this.a.e();
    }

    private AxisAlignedBB m() {
        AxisAlignedBB structureBounds = this.a.e();
        EnumBlockRotation rotation = this.a.u();
        switch (rotation) {
            case d: 
            case b: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, structureBounds.d(), structureBounds.c(), structureBounds.b());
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, structureBounds.b(), structureBounds.c(), structureBounds.d());
    }

    public void a(Consumer<BlockPosition> consumer) {
        AxisAlignedBB aabb = this.m().a(1.0, 1.0, 1.0);
        BlockPosition.MutableBlockPosition.b(aabb).forEach(consumer);
    }

    public void e(Runnable task) {
        LongStream.range(this.a.p(), this.a.x()).forEach(l2 -> this.a.a(l2, task::run));
    }

    public void a(EntityHuman player, ItemStack stack, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = this.j(pos.a(direction));
        MovingObjectPositionBlock blockHitResult = new MovingObjectPositionBlock(Vec3D.b(blockPos), direction, blockPos, false);
        ItemActionContext useOnContext = new ItemActionContext(player, EnumHand.a, blockHitResult);
        stack.a(useOnContext);
    }

    public void a(ResourceKey<BiomeBase> biome) {
        AxisAlignedBB bounds = this.k();
        BlockPosition blockPos = BlockPosition.a(bounds.a, bounds.b, bounds.c);
        BlockPosition blockPos1 = BlockPosition.a(bounds.d, bounds.e, bounds.f);
        Either<Integer, CommandSyntaxException> either = FillBiomeCommand.a(this.a(), blockPos, blockPos1, this.a().L_().f(Registries.aN).b(biome));
        if (either.right().isPresent()) {
            throw this.a("test.error.set_biome", new Object[0]);
        }
    }
}

