/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.gametest.framework.GameTestHarnessTimeout;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.UnknownGameTestException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.event.entity.EntityRemoveEvent;

public class GameTestHarnessInfo {
    private final Holder.c<GameTestInstance> a;
    @Nullable
    private BlockPosition b;
    private final WorldServer c;
    private final Collection<GameTestHarnessListener> d = Lists.newArrayList();
    private final int e;
    private final Collection<GameTestHarnessSequence> f = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> g = new Object2LongOpenHashMap();
    private boolean h;
    private boolean i;
    private int j;
    private boolean k;
    private final RetryOptions l;
    private final Stopwatch m = Stopwatch.createUnstarted();
    private boolean n;
    private final EnumBlockRotation o;
    @Nullable
    private GameTestException p;
    @Nullable
    private TestInstanceBlockEntity q;

    public GameTestHarnessInfo(Holder.c<GameTestInstance> test, EnumBlockRotation extraRotation, WorldServer level, RetryOptions retryOptions) {
        this.a = test;
        this.c = level;
        this.l = retryOptions;
        this.e = test.a().f();
        this.o = extraRotation;
    }

    public void a(@Nullable BlockPosition testBlockPos) {
        this.b = testBlockPos;
    }

    public GameTestHarnessInfo a(int delay) {
        this.j = -(this.a.a().g() + delay + 1);
        return this;
    }

    public void a() {
        if (!this.h) {
            TestInstanceBlockEntity testInstanceBlockEntity = this.f();
            if (!testInstanceBlockEntity.C()) {
                this.a(IChatBaseComponent.a("test.error.structure.failure", new Object[]{testInstanceBlockEntity.k().getString()}));
            }
            this.h = true;
            testInstanceBlockEntity.E();
            StructureBoundingBox structureBoundingBox = testInstanceBlockEntity.d();
            this.c.o().a(structureBoundingBox);
            this.c.a(structureBoundingBox);
            this.d.forEach(listener -> listener.a(this));
        }
    }

    public void a(GameTestHarnessRunner runner) {
        block9: {
            block10: {
                if (this.k()) break block9;
                if (!this.h) {
                    this.a(IChatBaseComponent.c("test.error.ticking_without_structure"));
                }
                if (this.q == null) {
                    this.a(IChatBaseComponent.c("test.error.missing_block_entity"));
                }
                if (this.p != null) {
                    this.G();
                }
                if (this.i) break block10;
                if (!this.q.d().b().allMatch(this.c::a)) break block9;
            }
            this.i = true;
            this.E();
            if (this.k()) {
                if (this.p != null) {
                    this.d.forEach(listener -> listener.b(this, runner));
                } else {
                    this.d.forEach(listener -> listener.a(this, runner));
                }
            }
        }
    }

    private void E() {
        ++this.j;
        if (this.j >= 0) {
            if (!this.k) {
                this.F();
            }
            ObjectIterator objectIterator = this.g.object2LongEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)objectIterator.next();
                if (entry.getLongValue() > (long)this.j) continue;
                try {
                    ((Runnable)entry.getKey()).run();
                }
                catch (GameTestException var4) {
                    this.a(var4);
                }
                catch (Exception var5) {
                    this.a(new UnknownGameTestException(var5));
                }
                objectIterator.remove();
            }
            if (this.j > this.e) {
                if (this.f.isEmpty()) {
                    this.a(new GameTestHarnessTimeout(IChatBaseComponent.a("test.error.timeout.no_result", this.a.a().f())));
                } else {
                    this.f.forEach(sequence -> sequence.c(this.j));
                    if (this.p == null) {
                        this.a(new GameTestHarnessTimeout(IChatBaseComponent.a("test.error.timeout.no_sequences_finished", this.a.a().f())));
                    }
                }
            } else {
                this.f.forEach(sequence -> sequence.b(this.j));
            }
        }
    }

    private void F() {
        if (!this.k) {
            this.k = true;
            this.f().z();
            try {
                this.a.a().a(new GameTestHarnessHelper(this));
            }
            catch (GameTestException var2) {
                this.a(var2);
            }
            catch (Exception var3) {
                this.a(new UnknownGameTestException(var3));
            }
        }
    }

    public void a(long tickTime, Runnable task) {
        this.g.put((Object)task, tickTime);
    }

    public MinecraftKey b() {
        return this.a.h().a();
    }

    @Nullable
    public BlockPosition c() {
        return this.b;
    }

    public BlockPosition d() {
        return this.q.D();
    }

    public AxisAlignedBB e() {
        TestInstanceBlockEntity testInstanceBlockEntity = this.f();
        return testInstanceBlockEntity.f();
    }

    public TestInstanceBlockEntity f() {
        if (this.q == null) {
            if (this.b == null) {
                throw new IllegalStateException("This GameTestInfo has no position");
            }
            TileEntity tileEntity = this.c.c_(this.b);
            if (tileEntity instanceof TestInstanceBlockEntity) {
                TestInstanceBlockEntity testInstanceBlockEntity;
                this.q = testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity;
            }
            if (this.q == null) {
                throw new IllegalStateException("Could not find a test instance block entity at the given coordinate " + String.valueOf(this.b));
            }
        }
        return this.q;
    }

    public WorldServer g() {
        return this.c;
    }

    public boolean h() {
        return this.n && this.p == null;
    }

    public boolean i() {
        return this.p != null;
    }

    public boolean j() {
        return this.k;
    }

    public boolean k() {
        return this.n;
    }

    public long l() {
        return this.m.elapsed(TimeUnit.MILLISECONDS);
    }

    private void G() {
        if (!this.n) {
            this.n = true;
            if (this.m.isRunning()) {
                this.m.stop();
            }
        }
    }

    public void m() {
        if (this.p == null) {
            this.G();
            AxisAlignedBB structureBounds = this.e();
            List<Entity> entitiesOfClass = this.g().a(Entity.class, structureBounds.g(1.0), (? super T entity) -> !(entity instanceof EntityHuman));
            entitiesOfClass.forEach(entity -> entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD));
        }
    }

    public void a(IChatBaseComponent message) {
        this.a(new GameTestHarnessAssertion(message, this.j));
    }

    public void a(GameTestException error) {
        this.p = error;
    }

    @Nullable
    public GameTestException n() {
        return this.p;
    }

    public String toString() {
        return this.b().toString();
    }

    public void a(GameTestHarnessListener listener) {
        this.d.add(listener);
    }

    @Nullable
    public GameTestHarnessInfo o() {
        TestInstanceBlockEntity testInstanceBlockEntity = this.a(Objects.requireNonNull(this.b), this.o, this.c);
        if (testInstanceBlockEntity != null) {
            this.q = testInstanceBlockEntity;
            this.a();
            return this;
        }
        return null;
    }

    @Nullable
    private TestInstanceBlockEntity a(BlockPosition pos, EnumBlockRotation rotation, WorldServer level) {
        level.c(pos, Blocks.qb.m());
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity;
            ResourceKey<GameTestInstance> resourceKey = this.w().h();
            BaseBlockPosition vec3i = TestInstanceBlockEntity.a(level, resourceKey).orElse(new BaseBlockPosition(1, 1, 1));
            testInstanceBlockEntity.a(new TestInstanceBlockEntity.a(Optional.of(resourceKey), vec3i, rotation, false, TestInstanceBlockEntity.c.a, Optional.empty()));
            return testInstanceBlockEntity;
        }
        return null;
    }

    int p() {
        return this.j;
    }

    GameTestHarnessSequence q() {
        GameTestHarnessSequence gameTestSequence = new GameTestHarnessSequence(this);
        this.f.add(gameTestSequence);
        return gameTestSequence;
    }

    public boolean r() {
        return this.a.a().h();
    }

    public boolean s() {
        return !this.a.a().h();
    }

    public MinecraftKey t() {
        return this.a.a().e();
    }

    public EnumBlockRotation u() {
        return this.a.a().n().f().a(this.o);
    }

    public GameTestInstance v() {
        return this.a.a();
    }

    public Holder.c<GameTestInstance> w() {
        return this.a;
    }

    public int x() {
        return this.e;
    }

    public boolean y() {
        return this.a.a().j() > 1;
    }

    public int z() {
        return this.a.a().j();
    }

    public int A() {
        return this.a.a().k();
    }

    public RetryOptions B() {
        return this.l;
    }

    public Stream<GameTestHarnessListener> C() {
        return this.d.stream();
    }

    public GameTestHarnessInfo D() {
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(this.a, this.o, this.c, this.B());
        if (this.b != null) {
            gameTestInfo.a(this.b);
        }
        return gameTestInfo;
    }
}

