/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class GameTestHarnessStructures {
    public static final int a = 10;
    public static final String b = "Minecraft.Server/src/test/convertables/data";
    public static Path c = Paths.get("Minecraft.Server/src/test/convertables/data", new String[0]);

    public static EnumBlockRotation a(int rotationSteps) {
        switch (rotationSteps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + rotationSteps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(rotation));
    }

    public static TestInstanceBlockEntity a(MinecraftKey id, BlockPosition pos, BaseBlockPosition size, EnumBlockRotation rotation, WorldServer level) {
        StructureBoundingBox structureBoundingBox = GameTestHarnessStructures.b(TestInstanceBlockEntity.a(pos), size, rotation);
        GameTestHarnessStructures.a(structureBoundingBox, level);
        level.c(pos, Blocks.qb.m());
        TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)level.c_(pos);
        ResourceKey<GameTestInstance> resourceKey = ResourceKey.a(Registries.bp, id);
        testInstanceBlockEntity.a(new TestInstanceBlockEntity.a(Optional.of(resourceKey), size, rotation, false, TestInstanceBlockEntity.c.a, Optional.empty()));
        return testInstanceBlockEntity;
    }

    public static void a(StructureBoundingBox boundingBox, WorldServer level) {
        int i2 = boundingBox.i() - 1;
        BlockPosition.a(boundingBox).forEach(pos -> GameTestHarnessStructures.a(i2, pos, level));
        level.o().a(boundingBox);
        level.a(boundingBox);
        AxisAlignedBB aabb = AxisAlignedBB.a(boundingBox);
        List<Entity> entitiesOfClass = level.a(Entity.class, aabb, entity -> !(entity instanceof EntityHuman));
        entitiesOfClass.forEach(entity -> entity.discard(EntityRemoveEvent.Cause.DISCARD));
    }

    public static BlockPosition a(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(offset).b(-1, -1, -1);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
    }

    public static StructureBoundingBox b(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition transformedFarCorner = GameTestHarnessStructures.a(pos, offset, rotation);
        StructureBoundingBox boundingBox = StructureBoundingBox.a((BaseBlockPosition)pos, (BaseBlockPosition)transformedFarCorner);
        int min = Math.min(boundingBox.h(), boundingBox.k());
        int min1 = Math.min(boundingBox.j(), boundingBox.m());
        return boundingBox.a(pos.u() - min, 0, pos.w() - min1);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer level) {
        return GameTestHarnessStructures.c(pos, radius, level).filter(pos1 -> GameTestHarnessStructures.a(pos1, pos, level)).findFirst();
    }

    public static Optional<BlockPosition> b(BlockPosition pos, int radius, WorldServer level) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(pos1 -> pos1.k(pos));
        return GameTestHarnessStructures.c(pos, radius, level).min(comparator);
    }

    public static Stream<BlockPosition> c(BlockPosition pos, int radius, WorldServer level) {
        return level.D().a(holder -> holder.a(PoiTypes.u), blockPos -> true, pos, radius, VillagePlace.Occupancy.c).map(BlockPosition::j);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, Entity entity, WorldServer level) {
        int i2 = 250;
        Vec3D eyePosition = entity.bR();
        Vec3D vec3 = eyePosition.e(entity.cf().c(250.0));
        return GameTestHarnessStructures.c(pos, 250, level).map(blockPos -> level.a((BlockPosition)blockPos, TileEntityTypes.V)).flatMap(Optional::stream).filter(testInstanceBlockEntity -> testInstanceBlockEntity.f().b(eyePosition, vec3).isPresent()).map(TileEntity::aD_).sorted(Comparator.comparing(pos::j)).limit(1L);
    }

    private static void a(int structureBlockY, BlockPosition pos, WorldServer level) {
        IBlockData blockState = pos.v() < structureBlockY ? Blocks.b.m() : Blocks.a.m();
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState, Collections.emptySet(), null);
        blockInput.a(level, pos, 818);
        level.a(pos, blockState.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition posToTest, WorldServer level) {
        TestInstanceBlockEntity testInstanceBlockEntity;
        TileEntity tileEntity = level.c_(structureBlockPos);
        return tileEntity instanceof TestInstanceBlockEntity && (testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity).d().b(posToTest);
    }
}

