/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.SuppressForbidden;
import net.minecraft.SystemUtils;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.JUnitLikeTestReporter;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class GameTestMainUtil {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "gametestserver";
    private static final String c = "gametestworld";
    private static final OptionParser d = new OptionParser();
    private static final OptionSpec<String> e = d.accepts("universe", "The path to where the test server world will be created. Any existing folder will be replaced.").withRequiredArg().defaultsTo((Object)"gametestserver", (Object[])new String[0]);
    private static final OptionSpec<File> f = d.accepts("report", "Exports results in a junit-like XML report at the given path.").withRequiredArg().ofType(File.class);
    private static final OptionSpec<String> g = d.accepts("tests", "Which test(s) to run (namespaced ID selector using wildcards). Empty means run all.").withRequiredArg();
    private static final OptionSpec<Boolean> h = d.accepts("verify", "Runs the tests specified with `test` or `testNamespace` 100 times for each 90 degree rotation step").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    private static final OptionSpec<String> i = d.accepts("packs", "A folder of datapacks to include in the world").withRequiredArg();
    private static final OptionSpec<Void> j = d.accepts("help").forHelp();

    @SuppressForbidden(reason="Using System.err due to no bootstrap")
    public static void a(String[] args, Consumer<String> universeOutput) throws Exception {
        d.allowsUnrecognizedOptions();
        OptionSet optionSet = d.parse(args);
        if (optionSet.has(j)) {
            d.printHelpOn((OutputStream)System.err);
        } else {
            if (((Boolean)optionSet.valueOf(h)).booleanValue() && !optionSet.has(g)) {
                a.error("Please specify a test selection to run the verify option. For example: --verify --tests example:test_something_*");
                System.exit(-1);
            }
            a.info("Running GameTestMain with cwd '{}', universe path '{}'", (Object)System.getProperty("user.dir"), optionSet.valueOf(e));
            if (optionSet.has(f)) {
                GlobalTestReporter.a(new JUnitLikeTestReporter((File)f.value(optionSet)));
            }
            DispenserRegistry.a();
            SystemUtils.p();
            String string = (String)optionSet.valueOf(e);
            GameTestMainUtil.a(string);
            universeOutput.accept(string);
            if (optionSet.has(i)) {
                String string1 = (String)optionSet.valueOf(i);
                GameTestMainUtil.a(string, string1);
            }
            Convertable.ConversionSession levelStorageAccess = Convertable.b(Paths.get(string, new String[0])).createAccess(c, WorldDimension.b);
            ResourcePackRepository packRepository = ResourcePackSourceVanilla.a(levelStorageAccess);
            MinecraftServer.a((Thread thread) -> GameTestServer.a(thread, levelStorageAccess, packRepository, GameTestMainUtil.a(optionSet, g), optionSet.has(h)));
        }
    }

    private static Optional<String> a(OptionSet options, OptionSpec<String> option) {
        return options.has(option) ? Optional.of((String)options.valueOf(option)) : Optional.empty();
    }

    private static void a(String dir) throws IOException {
        Path path = Paths.get(dir, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)path.toFile());
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    private static void a(String universe, String packs) throws IOException {
        Path path1;
        Path path = Paths.get(universe, new String[0]).resolve(c).resolve("datapacks");
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (Files.exists(path1 = Paths.get(packs, new String[0]), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(path1);){
                for (Path path2 : stream.toList()) {
                    Path path3 = path.resolve(path2.getFileName());
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        if (!Files.isRegularFile(path2.resolve("pack.mcmeta"), new LinkOption[0])) continue;
                        FileUtils.copyDirectory((File)path2.toFile(), (File)path3.toFile());
                        a.info("Included folder pack {}", (Object)path2.getFileName());
                        continue;
                    }
                    if (!path2.toString().endsWith(".zip")) continue;
                    Files.copy(path2, path3, new CopyOption[0]);
                    a.info("Included zip pack {}", (Object)path2.getFileName());
                }
            }
        }
    }
}

