/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.brigadier.StringReader;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceSelectorArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.notifications.EmptyNotificationService;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.command.CommandSender;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger m = LogUtils.getLogger();
    private static final int n = 20;
    private static final int o = 14999992;
    private static final Services p = new Services(null, ServicesKeySet.EMPTY, null, new b(), new a());
    private static final FeatureFlagSet q = FeatureFlags.e.a().d(FeatureFlagSet.a(FeatureFlags.c, FeatureFlags.d));
    private final LocalSampleLogger r = new LocalSampleLogger(4);
    private final Optional<String> s;
    private final boolean t;
    private List<GameTestHarnessBatch> u = new ArrayList<GameTestHarnessBatch>();
    private final Stopwatch v = Stopwatch.createUnstarted();
    private static final WorldOptions w = new WorldOptions(0L, false, false);
    @Nullable
    private GameTestHarnessCollector x;

    public static GameTestServer a(Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, Optional<String> testSelection, boolean verify) {
        packRepository.a();
        ArrayList<String> list = new ArrayList<String>(packRepository.c());
        list.remove("vanilla");
        list.addFirst("vanilla");
        WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(new DataPackConfiguration(list, List.of()), q);
        WorldSettings levelSettings = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, new GameRules(q), worldDataConfiguration);
        WorldLoader.d packConfig = new WorldLoader.d(packRepository, worldDataConfiguration, false, true);
        WorldLoader.c initConfig = new WorldLoader.c(packConfig, CommandDispatcher.ServerType.b, 4);
        try {
            m.debug("Starting resource loading");
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldStem worldStem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(initConfig, (WorldLoader.a context) -> {
                IRegistry<WorldDimension> frozen = new RegistryMaterials<WorldDimension>(Registries.by, Lifecycle.stable()).n();
                WorldDimensions.b complete = context.c().e(Registries.bw).b(WorldPresets.b).a().a().a(frozen);
                return new WorldLoader.b<WorldDataServer>(new WorldDataServer(levelSettings, w, complete.d(), complete.a()), complete.b());
            }, WorldStem::new, SystemUtils.h(), executor)).get();
            stopwatch.stop();
            m.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return new GameTestServer(serverThread, storageSource, packRepository, worldStem, testSelection, verify);
        }
        catch (Exception var12) {
            m.warn("Failed to load vanilla datapack, bit oops", (Throwable)var12);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, Optional<String> testSelection, boolean verify) {
        super(null, null, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, DataConverterRegistry.a(), p, LoggingLevelLoadListener.a());
        this.s = testSelection;
        this.t = verify;
    }

    @Override
    public boolean e() {
        this.a(new PlayerList(this, this, this.bh(), this.h, new EmptyNotificationService()){

            @Override
            public void loadAndSaveFiles() {
                throw new UnsupportedOperationException("Should not be called in a GameTestServer");
            }
        });
        this.loadLevel("blah");
        this.initPostWorld();
        WorldServer serverLevel = this.O();
        this.u = this.a(serverLevel);
        m.info("Started game test server");
        return true;
    }

    private List<GameTestHarnessBatch> a(WorldServer level) {
        GameTestBatchFactory.a testDecorator;
        List<Holder.c<GameTestInstance>> collection;
        IRegistry<GameTestInstance> registry = level.L_().f(Registries.bp);
        if (this.s.isPresent()) {
            collection = GameTestServer.a(level.L_(), this.s.get()).filter(reference -> !((GameTestInstance)reference.a()).i()).toList();
            if (this.t) {
                testDecorator = GameTestServer::a;
                m.info("Verify requested. Will run each test that matches {} {} times", (Object)this.s.get(), (Object)(100 * EnumBlockRotation.values().length));
            } else {
                testDecorator = GameTestBatchFactory.a;
                m.info("Will run tests matching {} ({} tests)", (Object)this.s.get(), (Object)collection.size());
            }
        } else {
            collection = registry.c().filter(reference -> !((GameTestInstance)reference.a()).i()).toList();
            testDecorator = GameTestBatchFactory.a;
        }
        return GameTestBatchFactory.a(collection, testDecorator, level);
    }

    private static Stream<GameTestHarnessInfo> a(Holder.c<GameTestInstance> test, WorldServer level) {
        Stream.Builder<GameTestHarnessInfo> builder = Stream.builder();
        for (EnumBlockRotation rotation : EnumBlockRotation.values()) {
            for (int i2 = 0; i2 < 100; ++i2) {
                builder.add(new GameTestHarnessInfo(test, rotation, level, RetryOptions.a()));
            }
        }
        return builder.build();
    }

    public static Stream<Holder.c<GameTestInstance>> a(IRegistryCustom registries, String selection) {
        return ResourceSelectorArgument.a(new StringReader(selection), registries.f(Registries.bp)).stream();
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft) {
        super.a(hasTimeLeft);
        WorldServer serverLevel = this.O();
        if (!this.bB()) {
            this.b(serverLevel);
        }
        if (serverLevel.ag() % 20L == 0L) {
            m.info(this.x.j());
        }
        if (this.x.i()) {
            this.a(false);
            m.info(this.x.j());
            GlobalTestReporter.a();
            m.info("========= {} GAME TESTS COMPLETE IN {} ======================", (Object)this.x.h(), (Object)this.v.stop());
            if (this.x.d()) {
                m.info("{} required tests failed :(", (Object)this.x.a());
                this.x.f().forEach(GameTestServer::a);
            } else {
                m.info("All {} required tests passed :)", (Object)this.x.h());
            }
            if (this.x.e()) {
                m.info("{} optional tests failed", (Object)this.x.b());
                this.x.g().forEach(GameTestServer::a);
            }
            m.info("====================================================");
        }
    }

    private static void a(GameTestHarnessInfo info) {
        if (info.u() != EnumBlockRotation.a) {
            m.info("   - {} with rotation {}: {}", new Object[]{info.b(), info.u().c(), info.n().a().getString()});
        } else {
            m.info("   - {}: {}", (Object)info.b(), (Object)info.n().a().getString());
        }
    }

    @Override
    public SampleLogger f() {
        return this.r;
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public void x_() {
        this.bR();
    }

    @Override
    public SystemReport a(SystemReport report) {
        report.a("Type", "Game test server");
        return report;
    }

    @Override
    public void i() {
        super.i();
        m.info("Game test server shutting down");
        System.exit(this.x != null ? this.x.a() : -1);
    }

    @Override
    public void a(CrashReport report) {
        super.a(report);
        m.error("Game test server crashed\n{}", (Object)report.a(ReportType.a));
        System.exit(1);
    }

    private void b(WorldServer level) {
        BlockPosition blockPos = new BlockPosition(level.z.a(-14999992, 14999992), -59, level.z.a(-14999992, 14999992));
        level.a(WorldData.a.a(level.al(), blockPos, 0.0f, 0.0f));
        GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.a(this.u, level).a((GameTestHarnessRunner.c)new StructureGridSpawner(blockPos, 8, false)).c();
        List<GameTestHarnessInfo> testInfos = gameTestRunner.a();
        this.x = new GameTestHarnessCollector(testInfos);
        m.info("{} tests are now running at position {}!", (Object)this.x.h(), (Object)blockPos.x());
        this.v.reset();
        this.v.start();
        gameTestRunner.b();
    }

    private boolean bB() {
        return this.x != null;
    }

    @Override
    public boolean w_() {
        return false;
    }

    @Override
    public int k() {
        return 0;
    }

    @Override
    public int l() {
        return 4;
    }

    @Override
    public boolean m() {
        return false;
    }

    @Override
    public boolean n() {
        return false;
    }

    @Override
    public int o() {
        return 0;
    }

    @Override
    public boolean p() {
        return false;
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public boolean r() {
        return true;
    }

    @Override
    public boolean s() {
        return false;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean a(NameAndId nameAndId) {
        return false;
    }

    @Override
    public int t() {
        return 1;
    }

    static class b
    implements UserNameToIdResolver {
        private final Set<NameAndId> a = new HashSet<NameAndId>();

        b() {
        }

        @Override
        public void a(NameAndId nameAndId) {
            this.a.add(nameAndId);
        }

        @Override
        public Optional<NameAndId> a(String name) {
            return this.a.stream().filter(nameAndId -> nameAndId.b().equals(name)).findFirst().or(() -> Optional.of(NameAndId.a(name)));
        }

        @Override
        public Optional<NameAndId> a(UUID uuid) {
            return this.a.stream().filter(nameAndId -> nameAndId.a().equals(uuid)).findFirst();
        }

        @Override
        public void a(boolean resolveOfflineUsers) {
        }

        @Override
        public void a() {
        }

        @Override
        public void save(boolean async) {
        }

        @Override
        @Nullable
        public NameAndId getIfCached(String name) {
            return this.a(name).orElse(null);
        }
    }

    static class a
    implements ProfileResolver {
        a() {
        }

        @Override
        public Optional<GameProfile> a(String name) {
            return Optional.empty();
        }

        @Override
        public Optional<GameProfile> a(UUID id) {
            return Optional.empty();
        }
    }
}

