/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private int a = 0;
    private int b = 0;

    @Override
    public void a(GameTestHarnessInfo testInfo) {
        ++this.a;
    }

    private void a(GameTestHarnessInfo testInfo, GameTestHarnessRunner runner, boolean passed) {
        RetryOptions retryOptions = testInfo.B();
        Object string = String.format(Locale.ROOT, "[Run: %4d, Ok: %4d, Fail: %4d", this.a, this.b, this.a - this.b);
        if (!retryOptions.b()) {
            string = (String)string + String.format(Locale.ROOT, ", Left: %4d", retryOptions.d() - this.a);
        }
        string = (String)string + "]";
        String string1 = String.valueOf(testInfo.b()) + " " + (passed ? "passed" : "failed") + "! " + testInfo.l() + "ms";
        String string2 = String.format(Locale.ROOT, "%-53s%s", string, string1);
        if (passed) {
            ReportGameListener.a(testInfo, string2);
        } else {
            ReportGameListener.a(testInfo.g(), EnumChatFormat.m, string2);
        }
        if (retryOptions.a(this.a, this.b)) {
            runner.a(testInfo);
        }
    }

    @Override
    public void a(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
        ++this.b;
        if (test.B().c()) {
            this.a(test, runner, true);
        } else if (!test.y()) {
            ReportGameListener.a(test, String.valueOf(test.b()) + " passed! (" + test.l() + "ms)");
        } else if (this.b >= test.A()) {
            ReportGameListener.a(test, String.valueOf(test) + " passed " + this.b + " times of " + this.a + " attempts.");
        } else {
            ReportGameListener.a(test.g(), EnumChatFormat.k, "Flaky test " + String.valueOf(test) + " succeeded, attempt: " + this.a + " successes: " + this.b);
            runner.a(test);
        }
    }

    @Override
    public void b(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
        if (!test.y()) {
            ReportGameListener.a(test, test.n());
            if (test.B().c()) {
                this.a(test, runner, false);
            }
        } else {
            GameTestInstance test1 = test.v();
            String string = "Flaky test " + String.valueOf(test) + " failed, attempt: " + this.a + "/" + test1.j();
            if (test1.k() > 1) {
                string = string + ", successes: " + this.b + " (" + test1.k() + " required)";
            }
            ReportGameListener.a(test.g(), EnumChatFormat.o, string);
            if (test.z() - this.a + this.b >= test.A()) {
                runner.a(test);
            } else {
                ReportGameListener.a(test, new ExhaustedAttemptsException(this.a, this.b, test));
            }
        }
    }

    @Override
    public void a(GameTestHarnessInfo oldTest, GameTestHarnessInfo newTest, GameTestHarnessRunner runner) {
        newTest.a(this);
    }

    public static void a(GameTestHarnessInfo testInfo, String message) {
        ReportGameListener.b(testInfo).ifPresent(blockEntity -> blockEntity.y());
        ReportGameListener.b(testInfo, message);
    }

    private static void b(GameTestHarnessInfo testInfo, String message) {
        ReportGameListener.a(testInfo.g(), EnumChatFormat.k, message);
        GlobalTestReporter.b(testInfo);
    }

    protected static void a(GameTestHarnessInfo testInfo, Throwable error) {
        IChatBaseComponent description;
        if (error instanceof GameTestHarnessAssertion) {
            GameTestHarnessAssertion gameTestAssertException = (GameTestHarnessAssertion)error;
            description = gameTestAssertException.a();
        } else {
            description = IChatBaseComponent.b(SystemUtils.c(error));
        }
        ReportGameListener.b(testInfo).ifPresent(blockEntity -> blockEntity.a(description));
        ReportGameListener.b(testInfo, error);
    }

    protected static void b(GameTestHarnessInfo testInfo, Throwable error) {
        String string = error.getMessage() + (String)(error.getCause() == null ? "" : " cause: " + SystemUtils.c(error.getCause()));
        String string1 = (testInfo.r() ? "" : "(optional) ") + String.valueOf(testInfo.b()) + " failed! " + string;
        ReportGameListener.a(testInfo.g(), testInfo.r() ? EnumChatFormat.m : EnumChatFormat.o, string1);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)error), (Object)error);
        if (throwable instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition gameTestAssertPosException = (GameTestHarnessAssertionPosition)throwable;
            testInfo.f().a(gameTestAssertPosException.d(), gameTestAssertPosException.b());
        }
        GlobalTestReporter.a(testInfo);
    }

    private static Optional<TestInstanceBlockEntity> b(GameTestHarnessInfo testInfo) {
        WorldServer level = testInfo.g();
        Optional<BlockPosition> optional = Optional.ofNullable(testInfo.c());
        return optional.flatMap(pos -> level.a((BlockPosition)pos, TileEntityTypes.V));
    }

    protected static void a(WorldServer level, EnumChatFormat formatting, String message) {
        level.a((? super EntityPlayer player) -> true).forEach(player -> player.a(IChatBaseComponent.b(message).a(formatting)));
    }
}

