/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public interface TestEnvironmentDefinition {
    public static final Codec<TestEnvironmentDefinition> a = BuiltInRegistries.aE.q().dispatch(TestEnvironmentDefinition::a, mapCodec -> mapCodec);
    public static final Codec<Holder<TestEnvironmentDefinition>> b = RegistryFileCodec.a(Registries.bo, a);

    public static MapCodec<? extends TestEnvironmentDefinition> a(IRegistry<MapCodec<? extends TestEnvironmentDefinition>> registry) {
        IRegistry.a(registry, "all_of", net.minecraft.gametest.framework.TestEnvironmentDefinition$a.c);
        IRegistry.a(registry, "game_rules", c.c);
        IRegistry.a(registry, "time_of_day", d.c);
        IRegistry.a(registry, "weather", e.c);
        return IRegistry.a(registry, "function", net.minecraft.gametest.framework.TestEnvironmentDefinition$b.c);
    }

    public void a(WorldServer var1);

    default public void b(WorldServer level) {
    }

    public MapCodec<? extends TestEnvironmentDefinition> a();

    public static final class a
    extends Record
    implements TestEnvironmentDefinition {
        private final List<Holder<TestEnvironmentDefinition>> d;
        public static final MapCodec<a> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)b.listOf().fieldOf("definitions").forGetter(a::b)).apply((Applicative)instance, a::new));

        public a(TestEnvironmentDefinition ... definitions) {
            this(Arrays.stream(definitions).map(Holder::a).toList());
        }

        public a(List<Holder<TestEnvironmentDefinition>> definitions) {
            this.d = definitions;
        }

        @Override
        public void a(WorldServer level) {
            this.d.forEach(definition -> ((TestEnvironmentDefinition)definition.a()).a(level));
        }

        @Override
        public void b(WorldServer level) {
            this.d.forEach(definition -> ((TestEnvironmentDefinition)definition.a()).b(level));
        }

        public MapCodec<a> a() {
            return c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "definitions", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "definitions", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "definitions", "d"}, this, o2);
        }

        public List<Holder<TestEnvironmentDefinition>> b() {
            return this.d;
        }
    }

    public static final class c
    extends Record
    implements TestEnvironmentDefinition {
        private final List<a<Boolean, GameRules.GameRuleBoolean>> d;
        private final List<a<Integer, GameRules.GameRuleInt>> e;
        public static final MapCodec<c> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.a(GameRules.GameRuleBoolean.class, Codec.BOOL).listOf().fieldOf("bool_rules").forGetter(c::b), (App)a.a(GameRules.GameRuleInt.class, Codec.INT).listOf().fieldOf("int_rules").forGetter(c::c)).apply((Applicative)instance, c::new));

        public c(List<a<Boolean, GameRules.GameRuleBoolean>> boolRules, List<a<Integer, GameRules.GameRuleInt>> intRules) {
            this.d = boolRules;
            this.e = intRules;
        }

        @Override
        public void a(WorldServer level) {
            GameRules gameRules = level.S();
            MinecraftServer server = level.q();
            for (a<Boolean, GameRules.GameRuleBoolean> a2 : this.d) {
                gameRules.b(a2.a()).set(a2.b(), level);
            }
            for (a<Comparable<Boolean>, GameRules.GameRuleValue> a3 : this.e) {
                ((GameRules.GameRuleInt)gameRules.b(a3.a())).set((Integer)a3.b(), level);
            }
        }

        @Override
        public void b(WorldServer level) {
            GameRules gameRules = level.S();
            MinecraftServer server = level.q();
            for (a<Boolean, GameRules.GameRuleBoolean> a2 : this.d) {
                gameRules.b(a2.a()).setFrom(GameRules.a(a2.a()).a(), level);
            }
            for (a<Comparable<Boolean>, GameRules.GameRuleValue> a3 : this.e) {
                ((GameRules.GameRuleInt)gameRules.b(a3.a())).setFrom((GameRules.GameRuleInt)GameRules.a(a3.a()).a(), level);
            }
        }

        public MapCodec<c> a() {
            return c;
        }

        public static <S, T extends GameRules.GameRuleValue<T>> a<S, T> a(GameRules.GameRuleKey<T> key, S value) {
            return new a<S, T>(key, value);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "boolRules;intRules", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "boolRules;intRules", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "boolRules;intRules", "d", "e"}, this, o2);
        }

        public List<a<Boolean, GameRules.GameRuleBoolean>> b() {
            return this.d;
        }

        public List<a<Integer, GameRules.GameRuleInt>> c() {
            return this.e;
        }

        public record a<S, T extends GameRules.GameRuleValue<T>>(GameRules.GameRuleKey<T> a, S b) {
            public static <S, T extends GameRules.GameRuleValue<T>> Codec<a<S, T>> a(Class<T> valueClass, Codec<S> valueCodec) {
                return RecordCodecBuilder.create(instance -> instance.group((App)GameRules.a(valueClass).fieldOf("rule").forGetter(a::a), (App)valueCodec.fieldOf("value").forGetter(a::b)).apply((Applicative)instance, a::new));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;value", "a", "b"}, this, o2);
            }
        }
    }

    public static final class d
    extends Record
    implements TestEnvironmentDefinition {
        private final int d;
        public static final MapCodec<d> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.o.fieldOf("time").forGetter(d::b)).apply((Applicative)instance, d::new));

        public d(int time) {
            this.d = time;
        }

        @Override
        public void a(WorldServer level) {
            level.b((long)this.d);
        }

        public MapCodec<d> a() {
            return c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "time", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "time", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "time", "d"}, this, o2);
        }

        public int b() {
            return this.d;
        }
    }

    public static final class e
    extends Record
    implements TestEnvironmentDefinition {
        private final a d;
        public static final MapCodec<e> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.d.fieldOf("weather").forGetter(e::b)).apply((Applicative)instance, e::new));

        public e(a weather) {
            this.d = weather;
        }

        @Override
        public void a(WorldServer level) {
            this.d.a(level);
        }

        @Override
        public void b(WorldServer level) {
            level.i();
        }

        public MapCodec<e> a() {
            return c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "weather", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "weather", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "weather", "d"}, this, o2);
        }

        public a b() {
            return this.d;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("clear", 100000, 0, false, false);
            public static final /* enum */ a b = new a("rain", 0, 100000, true, false);
            public static final /* enum */ a c = new a("thunder", 0, 100000, true, true);
            public static final Codec<a> d;
            private final String e;
            private final int f;
            private final int g;
            private final boolean h;
            private final boolean i;
            private static final /* synthetic */ a[] j;

            public static a[] values() {
                return (a[])j.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String id, int clearTime, int rainTime, boolean raining, boolean thundering) {
                this.e = id;
                this.f = clearTime;
                this.g = rainTime;
                this.h = raining;
                this.i = thundering;
            }

            void a(WorldServer level) {
                level.a(this.f, this.g, this.h, this.i);
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c};
            }

            static {
                j = net.minecraft.gametest.framework.TestEnvironmentDefinition$e$a.a();
                d = INamable.a(a::values);
            }
        }
    }

    public static final class b
    extends Record
    implements TestEnvironmentDefinition {
        private final Optional<MinecraftKey> d;
        private final Optional<MinecraftKey> e;
        private static final Logger f = LogUtils.getLogger();
        public static final MapCodec<b> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.optionalFieldOf("setup").forGetter(b::b), (App)MinecraftKey.a.optionalFieldOf("teardown").forGetter(b::c)).apply((Applicative)instance, b::new));

        public b(Optional<MinecraftKey> setupFunction, Optional<MinecraftKey> teardownFunction) {
            this.d = setupFunction;
            this.e = teardownFunction;
        }

        @Override
        public void a(WorldServer level) {
            this.d.ifPresent(function -> net.minecraft.gametest.framework.TestEnvironmentDefinition$b.a(level, function));
        }

        @Override
        public void b(WorldServer level) {
            this.e.ifPresent(function -> net.minecraft.gametest.framework.TestEnvironmentDefinition$b.a(level, function));
        }

        private static void a(WorldServer level, MinecraftKey function) {
            MinecraftServer server = level.q();
            CustomFunctionData functions = server.aG();
            Optional<CommandFunction<CommandListenerWrapper>> optional = functions.a(function);
            if (optional.isPresent()) {
                CommandListenerWrapper commandSourceStack = server.aK().a(2).a().a(level);
                functions.a(optional.get(), commandSourceStack);
            } else {
                f.error("Test Batch failed for non-existent function {}", (Object)function);
            }
        }

        public MapCodec<b> a() {
            return c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "setupFunction;teardownFunction", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "setupFunction;teardownFunction", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "setupFunction;teardownFunction", "d", "e"}, this, o2);
        }

        public Optional<MinecraftKey> b() {
            return this.d;
        }

        public Optional<MinecraftKey> c() {
            return this.e;
        }
    }
}

