/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.nbt.NbtAccounterException;

public class NBTReadLimiter {
    private static final int a = 512;
    private final long b;
    private long c;
    private final int d;
    private int e;

    public NBTReadLimiter(long quota, int maxDepth) {
        this.b = quota;
        this.d = maxDepth;
    }

    public static NBTReadLimiter a(long quota) {
        return new NBTReadLimiter(quota, 512);
    }

    public static NBTReadLimiter a() {
        return new NBTReadLimiter(Long.MAX_VALUE, 512);
    }

    public void a(long bytesPerItem, long items) {
        this.b(bytesPerItem * items);
    }

    public void b(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Tried to account NBT tag with negative size: " + bytes);
        }
        if (this.c + bytes > this.b) {
            throw new NbtAccounterException("Tried to read NBT tag that was too big; tried to allocate: " + this.c + " + " + bytes + " bytes where max allowed: " + this.b);
        }
        this.c += bytes;
    }

    public void b() {
        if (this.e >= this.d) {
            throw new NbtAccounterException("Tried to read NBT tag with too high complexity, depth > " + this.d);
        }
        ++this.e;
    }

    public void c() {
        if (this.e <= 0) {
            throw new NbtAccounterException("NBT-Accounter tried to pop stack-depth at top-level");
        }
        --this.e;
    }

    @VisibleForTesting
    public long d() {
        return this.c;
    }

    @VisibleForTesting
    public int e() {
        return this.e;
    }
}

