/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagIntArray
implements NBTList {
    private static final int b = 24;
    public static final NBTTagType<NBTTagIntArray> a = new NBTTagType.b<NBTTagIntArray>(){

        public NBTTagIntArray a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return new NBTTagIntArray(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static int[] d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(24L);
            int _int = input.readInt();
            Preconditions.checkArgument((_int < 0x1000000 ? 1 : 0) != 0);
            accounter.a(4L, _int);
            int[] ints = new int[_int];
            for (int i2 = 0; i2 < _int; ++i2) {
                ints[i2] = input.readInt();
            }
            return ints;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            input.skipBytes(input.readInt() * 4);
        }

        @Override
        public String a() {
            return "INT[]";
        }

        @Override
        public String b() {
            return "TAG_Int_Array";
        }
    };
    private int[] c;

    public NBTTagIntArray(int[] data) {
        this.c = data;
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        for (int i2 : this.c) {
            output.writeInt(i2);
        }
    }

    @Override
    public int a() {
        return 24 + 4 * this.c.length;
    }

    @Override
    public byte b() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.a(this);
        return stringTagVisitor.a();
    }

    public NBTTagIntArray e() {
        int[] ints = new int[this.c.length];
        System.arraycopy(this.c, 0, ints, 0, this.c.length);
        return new NBTTagIntArray(ints);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagIntArray && Arrays.equals(this.c, ((NBTTagIntArray)other).c);
    }

    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    public int[] g() {
        return this.c;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagInt a(int index) {
        return NBTTagInt.a(this.c[index]);
    }

    @Override
    public boolean a(int index, NBTBase tag) {
        if (tag instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)tag;
            this.c[index] = numericTag.h();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase tag) {
        if (tag instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)tag;
            this.c = ArrayUtils.add((int[])this.c, (int)index, (int)numericTag.h());
            return true;
        }
        return false;
    }

    public NBTTagInt b(int index) {
        int i2 = this.c[index];
        this.c = ArrayUtils.remove((int[])this.c, (int)index);
        return NBTTagInt.a(i2);
    }

    @Override
    public void clear() {
        this.c = new int[0];
    }

    @Override
    public Optional<int[]> s_() {
        return Optional.of(this.c);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }
}

