/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;

public class SnbtPrinterTagVisitor
implements TagVisitor {
    private static final Map<String, List<String>> a = SystemUtils.a(Maps.newHashMap(), map -> {
        map.put("{}", Lists.newArrayList((Object[])new String[]{"DataVersion", "author", "size", "data", "entities", "palette", "palettes"}));
        map.put("{}.data.[].{}", Lists.newArrayList((Object[])new String[]{"pos", "state", "nbt"}));
        map.put("{}.entities.[].{}", Lists.newArrayList((Object[])new String[]{"blockPos", "pos"}));
    });
    private static final Set<String> b = Sets.newHashSet((Object[])new String[]{"{}.size.[]", "{}.data.[].{}", "{}.palette.[].{}", "{}.entities.[].{}"});
    private static final Pattern c = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String d = String.valueOf(':');
    private static final String e = String.valueOf(',');
    private static final String f = "[";
    private static final String g = "]";
    private static final String h = ";";
    private static final String i = " ";
    private static final String j = "{";
    private static final String k = "}";
    private static final String l = "\n";
    private final String m;
    private final int n;
    private final List<String> o;
    private String p = "";

    public SnbtPrinterTagVisitor() {
        this("    ", 0, Lists.newArrayList());
    }

    public SnbtPrinterTagVisitor(String indentation, int depth, List<String> path) {
        this.m = indentation;
        this.n = depth;
        this.o = path;
    }

    public String a(NBTBase tag) {
        tag.a(this);
        return this.p;
    }

    @Override
    public void a(NBTTagString tag) {
        this.p = NBTTagString.b(tag.k());
    }

    @Override
    public void a(NBTTagByte tag) {
        this.p = tag.n() + "b";
    }

    @Override
    public void a(NBTTagShort tag) {
        this.p = tag.n() + "s";
    }

    @Override
    public void a(NBTTagInt tag) {
        this.p = String.valueOf(tag.n());
    }

    @Override
    public void a(NBTTagLong tag) {
        this.p = tag.n() + "L";
    }

    @Override
    public void a(NBTTagFloat tag) {
        this.p = tag.n() + "f";
    }

    @Override
    public void a(NBTTagDouble tag) {
        this.p = tag.n() + "d";
    }

    @Override
    public void a(NBTTagByteArray tag) {
        StringBuilder stringBuilder = new StringBuilder(f).append("B").append(h);
        byte[] asByteArray = tag.e();
        for (int i2 = 0; i2 < asByteArray.length; ++i2) {
            stringBuilder.append(i).append(asByteArray[i2]).append("B");
            if (i2 == asByteArray.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    public void a(NBTTagIntArray tag) {
        StringBuilder stringBuilder = new StringBuilder(f).append("I").append(h);
        int[] asIntArray = tag.g();
        for (int i2 = 0; i2 < asIntArray.length; ++i2) {
            stringBuilder.append(i).append(asIntArray[i2]);
            if (i2 == asIntArray.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    public void a(NBTTagLongArray tag) {
        String string = "L";
        StringBuilder stringBuilder = new StringBuilder(f).append("L").append(h);
        long[] asLongArray = tag.g();
        for (int i2 = 0; i2 < asLongArray.length; ++i2) {
            stringBuilder.append(i).append(asLongArray[i2]).append("L");
            if (i2 == asLongArray.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    public void a(NBTTagList tag) {
        if (tag.isEmpty()) {
            this.p = "[]";
        } else {
            String string;
            StringBuilder stringBuilder = new StringBuilder(f);
            this.b("[]");
            String string2 = string = b.contains(this.a()) ? "" : this.m;
            if (!string.isEmpty()) {
                stringBuilder.append(l);
            }
            for (int i2 = 0; i2 < tag.size(); ++i2) {
                stringBuilder.append(Strings.repeat((String)string, (int)(this.n + 1)));
                stringBuilder.append(new SnbtPrinterTagVisitor(string, this.n + 1, this.o).a(tag.c(i2)));
                if (i2 == tag.size() - 1) continue;
                stringBuilder.append(e).append(string.isEmpty() ? i : l);
            }
            if (!string.isEmpty()) {
                stringBuilder.append(l).append(Strings.repeat((String)string, (int)this.n));
            }
            stringBuilder.append(g);
            this.p = stringBuilder.toString();
            this.b();
        }
    }

    @Override
    public void a(NBTTagCompound tag) {
        if (tag.j()) {
            this.p = "{}";
        } else {
            String string;
            StringBuilder stringBuilder = new StringBuilder(j);
            this.b("{}");
            String string2 = string = b.contains(this.a()) ? "" : this.m;
            if (!string.isEmpty()) {
                stringBuilder.append(l);
            }
            List<String> keys = this.b(tag);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String string1 = (String)iterator.next();
                NBTBase tag1 = tag.a(string1);
                this.b(string1);
                stringBuilder.append(Strings.repeat((String)string, (int)(this.n + 1))).append(SnbtPrinterTagVisitor.a(string1)).append(d).append(i).append(new SnbtPrinterTagVisitor(string, this.n + 1, this.o).a(tag1));
                this.b();
                if (!iterator.hasNext()) continue;
                stringBuilder.append(e).append(string.isEmpty() ? i : l);
            }
            if (!string.isEmpty()) {
                stringBuilder.append(l).append(Strings.repeat((String)string, (int)this.n));
            }
            stringBuilder.append(k);
            this.p = stringBuilder.toString();
            this.b();
        }
    }

    private void b() {
        this.o.remove(this.o.size() - 1);
    }

    private void b(String key) {
        this.o.add(key);
    }

    protected List<String> b(NBTTagCompound tag) {
        HashSet set = Sets.newHashSet(tag.e());
        ArrayList list = Lists.newArrayList();
        List<String> list1 = a.get(this.a());
        if (list1 != null) {
            for (String string : list1) {
                if (!set.remove(string)) continue;
                list.add(string);
            }
            if (!set.isEmpty()) {
                set.stream().sorted().forEach(list::add);
            }
        } else {
            list.addAll(set);
            Collections.sort(list);
        }
        return list;
    }

    public String a() {
        return String.join((CharSequence)".", this.o);
    }

    protected static String a(String text) {
        return c.matcher(text).matches() ? text : NBTTagString.b(text);
    }

    @Override
    public void a(NBTTagEnd tag) {
    }
}

