/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> b a(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.a(new PacketDecoder<T>(protocolInfo));
    }

    private static b a(ChannelInboundHandler handler) {
        return ctx -> {
            ctx.pipeline().replace(ctx.name(), "decoder", (ChannelHandler)handler);
            ctx.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> d b(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.a(new PacketEncoder<T>(protocolInfo));
    }

    private static d a(ChannelOutboundHandler handler) {
        return ctx -> ctx.pipeline().replace(ctx.name(), "encoder", (ChannelHandler)handler);
    }

    @FunctionalInterface
    public static interface b {
        public void run(ChannelHandlerContext var1);

        default public b andThen(b task) {
            return ctx -> {
                this.run(ctx);
                task.run(ctx);
            };
        }
    }

    @FunctionalInterface
    public static interface d {
        public void run(ChannelHandlerContext var1);

        default public d andThen(d task) {
            return ctx -> {
                this.run(ctx);
                task.run(ctx);
            };
        }
    }

    public static class c
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(message));
            }
            if (message instanceof d) {
                d outboundConfigurationTask = (d)message;
                try {
                    outboundConfigurationTask.run(ctx);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                ctx.write(message, promise);
            }
        }
    }

    public static class a
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext ctx, Object message) {
            if (message instanceof ByteBuf || message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(message));
            }
            ctx.fireChannelRead(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof b) {
                b inboundConfigurationTask = (b)message;
                try {
                    inboundConfigurationTask.run(ctx);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                ctx.write(message, promise);
            }
        }
    }
}

