/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.VarInt;

public class Utf8String {
    public static String a(ByteBuf buffer, int maxLength) {
        int i2 = ByteBufUtil.utf8MaxBytes((int)maxLength);
        int i1 = VarInt.a(buffer);
        if (i1 > i2) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + i1 + " > " + i2 + ")");
        }
        if (i1 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        int i22 = buffer.readableBytes();
        if (i1 > i22) {
            throw new DecoderException("Not enough bytes in buffer, expected " + i1 + ", but got " + i22);
        }
        String string = buffer.toString(buffer.readerIndex(), i1, StandardCharsets.UTF_8);
        buffer.readerIndex(buffer.readerIndex() + i1);
        if (string.length() > maxLength) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + string.length() + " > " + maxLength + ")");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(ByteBuf buffer, CharSequence string, int maxLength) {
        if (string.length() > maxLength) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + maxLength + ")");
        }
        int i2 = ByteBufUtil.utf8MaxBytes((CharSequence)string);
        ByteBuf byteBuf = buffer.alloc().buffer(i2);
        try {
            int i1 = ByteBufUtil.writeUtf8((ByteBuf)byteBuf, (CharSequence)string);
            int i22 = ByteBufUtil.utf8MaxBytes((int)maxLength);
            if (i1 > i22) {
                throw new EncoderException("String too big (was " + i1 + " bytes encoded, max " + i22 + ")");
            }
            VarInt.a(buffer, i1);
            buffer.writeBytes(byteBuf);
        }
        finally {
            byteBuf.release();
        }
    }
}

