/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;

public final class ChatMessageType
extends Record {
    private final ChatDecoration l;
    private final ChatDecoration m;
    public static final Codec<ChatMessageType> a = RecordCodecBuilder.create(instance -> instance.group((App)ChatDecoration.a.fieldOf("chat").forGetter(ChatMessageType::a), (App)ChatDecoration.a.fieldOf("narration").forGetter(ChatMessageType::b)).apply((Applicative)instance, ChatMessageType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatMessageType> b = StreamCodec.a(ChatDecoration.b, ChatMessageType::a, ChatDecoration.b, ChatMessageType::b, ChatMessageType::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<ChatMessageType>> c = ByteBufCodecs.a(Registries.aP, b);
    public static final ChatDecoration d = ChatDecoration.a("chat.type.text");
    public static final ResourceKey<ChatMessageType> e = ChatMessageType.a("chat");
    public static final ResourceKey<ChatMessageType> f = ChatMessageType.a("say_command");
    public static final ResourceKey<ChatMessageType> g = ChatMessageType.a("msg_command_incoming");
    public static final ResourceKey<ChatMessageType> h = ChatMessageType.a("msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> i = ChatMessageType.a("team_msg_command_incoming");
    public static final ResourceKey<ChatMessageType> j = ChatMessageType.a("team_msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> k = ChatMessageType.a("emote_command");

    public ChatMessageType(ChatDecoration chat, ChatDecoration narration) {
        this.l = chat;
        this.m = narration;
    }

    private static ResourceKey<ChatMessageType> a(String key) {
        return ResourceKey.a(Registries.aP, MinecraftKey.b(key));
    }

    public static void a(BootstrapContext<ChatMessageType> context) {
        context.a(e, new ChatMessageType(d, ChatDecoration.a("chat.type.text.narrate")));
        context.a(f, new ChatMessageType(ChatDecoration.a("chat.type.announcement"), ChatDecoration.a("chat.type.text.narrate")));
        context.a(g, new ChatMessageType(ChatDecoration.b("commands.message.display.incoming"), ChatDecoration.a("chat.type.text.narrate")));
        context.a(h, new ChatMessageType(ChatDecoration.c("commands.message.display.outgoing"), ChatDecoration.a("chat.type.text.narrate")));
        context.a(i, new ChatMessageType(ChatDecoration.d("chat.type.team.text"), ChatDecoration.a("chat.type.text.narrate")));
        context.a(j, new ChatMessageType(ChatDecoration.d("chat.type.team.sent"), ChatDecoration.a("chat.type.text.narrate")));
        context.a(k, new ChatMessageType(ChatDecoration.a("chat.type.emote"), ChatDecoration.a("chat.type.emote")));
    }

    public static a a(ResourceKey<ChatMessageType> chatTypeKey, Entity entity) {
        return ChatMessageType.a(chatTypeKey, entity.an().L_(), entity.S_());
    }

    public static a a(ResourceKey<ChatMessageType> chatTypeKey, CommandListenerWrapper source) {
        return ChatMessageType.a(chatTypeKey, source.u(), source.b());
    }

    public static a a(ResourceKey<ChatMessageType> chatTypeKey, IRegistryCustom registryAccess, IChatBaseComponent name) {
        IRegistry<ChatMessageType> registry = registryAccess.f(Registries.aP);
        return new a(registry.b(chatTypeKey), name);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChatMessageType.class, "chat;narration", "l", "m"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChatMessageType.class, "chat;narration", "l", "m"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChatMessageType.class, "chat;narration", "l", "m"}, this, o2);
    }

    public ChatDecoration a() {
        return this.l;
    }

    public ChatDecoration b() {
        return this.m;
    }

    public static final class a
    extends Record {
        private final Holder<ChatMessageType> b;
        private final IChatBaseComponent c;
        private final Optional<IChatBaseComponent> d;
        public static final StreamCodec<RegistryFriendlyByteBuf, a> a = StreamCodec.a(c, a::a, ComponentSerialization.d, a::b, ComponentSerialization.e, a::c, a::new);

        a(Holder<ChatMessageType> chatType, IChatBaseComponent name) {
            this(chatType, name, Optional.empty());
        }

        public a(Holder<ChatMessageType> chatType, IChatBaseComponent name, Optional<IChatBaseComponent> targetName) {
            this.b = chatType;
            this.c = name;
            this.d = targetName;
        }

        public IChatBaseComponent a(IChatBaseComponent content) {
            return this.b.a().a().a(content, this);
        }

        public IChatBaseComponent b(IChatBaseComponent content) {
            return this.b.a().b().a(content, this);
        }

        public a c(IChatBaseComponent targetName) {
            return new a(this.b, this.c, Optional.of(targetName));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chatType;name;targetName", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chatType;name;targetName", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chatType;name;targetName", "b", "c", "d"}, this, o2);
        }

        public Holder<ChatMessageType> a() {
            return this.b;
        }

        public IChatBaseComponent b() {
            return this.c;
        }

        public Optional<IChatBaseComponent> c() {
            return this.d;
        }
    }
}

