/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public final class ChatModifier {
    public static final ChatModifier a = new ChatModifier(null, null, null, null, null, null, null, null, null, null, null);
    @Nullable
    final ChatHexColor b;
    @Nullable
    final Integer c;
    @Nullable
    final Boolean d;
    @Nullable
    final Boolean e;
    @Nullable
    final Boolean f;
    @Nullable
    final Boolean g;
    @Nullable
    final Boolean h;
    @Nullable
    final ChatClickable i;
    @Nullable
    final ChatHoverable j;
    @Nullable
    final String k;
    @Nullable
    final FontDescription l;

    private static ChatModifier a(Optional<ChatHexColor> color, Optional<Integer> shadowColor, Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underlined, Optional<Boolean> strikethrough, Optional<Boolean> obfuscated, Optional<ChatClickable> clickEvent, Optional<ChatHoverable> hoverEvent, Optional<String> insertion, Optional<FontDescription> font) {
        ChatModifier style = new ChatModifier(color.orElse(null), shadowColor.orElse(null), bold.orElse(null), italic.orElse(null), underlined.orElse(null), strikethrough.orElse(null), obfuscated.orElse(null), clickEvent.orElse(null), hoverEvent.orElse(null), insertion.orElse(null), font.orElse(null));
        return style.equals(a) ? a : style;
    }

    private ChatModifier(@Nullable ChatHexColor color, @Nullable Integer shadowColor, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ChatClickable clickEvent, @Nullable ChatHoverable hoverEvent, @Nullable String insertion, @Nullable FontDescription font) {
        this.b = color;
        this.c = shadowColor;
        this.d = bold;
        this.e = italic;
        this.f = underlined;
        this.g = strikethrough;
        this.h = obfuscated;
        this.i = clickEvent;
        this.j = hoverEvent;
        this.k = insertion;
        this.l = font;
    }

    @Nullable
    public ChatHexColor a() {
        return this.b;
    }

    @Nullable
    public Integer b() {
        return this.c;
    }

    public boolean c() {
        return this.d == Boolean.TRUE;
    }

    public boolean d() {
        return this.e == Boolean.TRUE;
    }

    public boolean e() {
        return this.g == Boolean.TRUE;
    }

    public boolean f() {
        return this.f == Boolean.TRUE;
    }

    public boolean g() {
        return this.h == Boolean.TRUE;
    }

    public boolean h() {
        return this == a;
    }

    @Nullable
    public ChatClickable i() {
        return this.i;
    }

    @Nullable
    public ChatHoverable j() {
        return this.j;
    }

    @Nullable
    public String k() {
        return this.k;
    }

    public FontDescription l() {
        return this.l != null ? this.l : FontDescription.b;
    }

    private static <T> ChatModifier a(ChatModifier style, @Nullable T oldValue, @Nullable T newValue) {
        return oldValue != null && newValue == null && style.equals(a) ? a : style;
    }

    public ChatModifier a(@Nullable ChatHexColor color) {
        return Objects.equals(this.b, color) ? this : ChatModifier.a(new ChatModifier(color, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.b, color);
    }

    public ChatModifier a(@Nullable EnumChatFormat formatting) {
        return this.a(formatting != null ? ChatHexColor.a(formatting) : null);
    }

    public ChatModifier a(int color) {
        return this.a(ChatHexColor.a(color));
    }

    public ChatModifier b(int color) {
        return Objects.equals(this.c, color) ? this : ChatModifier.a(new ChatModifier(this.b, color, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.c, color);
    }

    public ChatModifier a(@Nullable Boolean bold) {
        return Objects.equals(this.d, bold) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, bold, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.d, bold);
    }

    public ChatModifier b(@Nullable Boolean italic) {
        return Objects.equals(this.e, italic) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, italic, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.e, italic);
    }

    public ChatModifier c(@Nullable Boolean underlined) {
        return Objects.equals(this.f, underlined) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, underlined, this.g, this.h, this.i, this.j, this.k, this.l), this.f, underlined);
    }

    public ChatModifier d(@Nullable Boolean strikethrough) {
        return Objects.equals(this.g, strikethrough) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, strikethrough, this.h, this.i, this.j, this.k, this.l), this.g, strikethrough);
    }

    public ChatModifier e(@Nullable Boolean obfuscated) {
        return Objects.equals(this.h, obfuscated) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, this.g, obfuscated, this.i, this.j, this.k, this.l), this.h, obfuscated);
    }

    public ChatModifier a(@Nullable ChatClickable clickEvent) {
        return Objects.equals(this.i, clickEvent) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, this.g, this.h, clickEvent, this.j, this.k, this.l), this.i, clickEvent);
    }

    public ChatModifier a(@Nullable ChatHoverable hoverEvent) {
        return Objects.equals(this.j, hoverEvent) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, hoverEvent, this.k, this.l), this.j, hoverEvent);
    }

    public ChatModifier a(@Nullable String insertion) {
        return Objects.equals(this.k, insertion) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, insertion, this.l), this.k, insertion);
    }

    public ChatModifier a(@Nullable FontDescription font) {
        return Objects.equals(this.l, font) ? this : ChatModifier.a(new ChatModifier(this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, font), this.l, font);
    }

    public ChatModifier b(EnumChatFormat formatting) {
        ChatHexColor textColor = this.b;
        Boolean _boolean = this.d;
        Boolean _boolean1 = this.e;
        Boolean _boolean2 = this.g;
        Boolean _boolean3 = this.f;
        Boolean _boolean4 = this.h;
        switch (formatting) {
            case q: {
                _boolean4 = true;
                break;
            }
            case r: {
                _boolean = true;
                break;
            }
            case s: {
                _boolean2 = true;
                break;
            }
            case t: {
                _boolean3 = true;
                break;
            }
            case u: {
                _boolean1 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, this.c, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.i, this.j, this.k, this.l);
    }

    public ChatModifier c(EnumChatFormat formatting) {
        ChatHexColor textColor = this.b;
        Boolean _boolean = this.d;
        Boolean _boolean1 = this.e;
        Boolean _boolean2 = this.g;
        Boolean _boolean3 = this.f;
        Boolean _boolean4 = this.h;
        switch (formatting) {
            case q: {
                _boolean4 = true;
                break;
            }
            case r: {
                _boolean = true;
                break;
            }
            case s: {
                _boolean2 = true;
                break;
            }
            case t: {
                _boolean3 = true;
                break;
            }
            case u: {
                _boolean1 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                _boolean4 = false;
                _boolean = false;
                _boolean2 = false;
                _boolean3 = false;
                _boolean1 = false;
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, this.c, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(EnumChatFormat ... formats) {
        ChatHexColor textColor = this.b;
        Boolean _boolean = this.d;
        Boolean _boolean1 = this.e;
        Boolean _boolean2 = this.g;
        Boolean _boolean3 = this.f;
        Boolean _boolean4 = this.h;
        block8: for (EnumChatFormat chatFormatting : formats) {
            switch (chatFormatting) {
                case q: {
                    _boolean4 = true;
                    continue block8;
                }
                case r: {
                    _boolean = true;
                    continue block8;
                }
                case s: {
                    _boolean2 = true;
                    continue block8;
                }
                case t: {
                    _boolean3 = true;
                    continue block8;
                }
                case u: {
                    _boolean1 = true;
                    continue block8;
                }
                case v: {
                    return a;
                }
                default: {
                    textColor = ChatHexColor.a(chatFormatting);
                }
            }
        }
        return new ChatModifier(textColor, this.c, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(ChatModifier style) {
        if (this == a) {
            return style;
        }
        return style == a ? this : new ChatModifier(this.b != null ? this.b : style.b, this.c != null ? this.c : style.c, this.d != null ? this.d : style.d, this.e != null ? this.e : style.e, this.f != null ? this.f : style.f, this.g != null ? this.g : style.g, this.h != null ? this.h : style.h, this.i != null ? this.i : style.i, this.j != null ? this.j : style.j, this.k != null ? this.k : style.k, this.l != null ? this.l : style.l);
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        class A {
            private boolean b;

            A() {
            }

            private void a() {
                if (this.b) {
                    stringBuilder.append(',');
                }
                this.b = true;
            }

            void a(String key, @Nullable Boolean value) {
                if (value != null) {
                    this.a();
                    if (!value.booleanValue()) {
                        stringBuilder.append('!');
                    }
                    stringBuilder.append(key);
                }
            }

            void a(String key, @Nullable Object value) {
                if (value != null) {
                    this.a();
                    stringBuilder.append(key);
                    stringBuilder.append('=');
                    stringBuilder.append(value);
                }
            }
        }
        A collector = new A();
        collector.a("color", this.b);
        collector.a("shadowColor", this.c);
        collector.a("bold", this.d);
        collector.a("italic", this.e);
        collector.a("underlined", this.f);
        collector.a("strikethrough", this.g);
        collector.a("obfuscated", this.h);
        collector.a("clickEvent", this.i);
        collector.a("hoverEvent", this.j);
        collector.a("insertion", this.k);
        collector.a("font", this.l);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ChatModifier)) return false;
        ChatModifier style = (ChatModifier)other;
        if (this.d != style.d) return false;
        if (!Objects.equals(this.a(), style.a())) return false;
        if (!Objects.equals(this.b(), style.b())) return false;
        if (this.e != style.e) return false;
        if (this.h != style.h) return false;
        if (this.g != style.g) return false;
        if (this.f != style.f) return false;
        if (!Objects.equals(this.i, style.i)) return false;
        if (!Objects.equals(this.j, style.j)) return false;
        if (!Objects.equals(this.k, style.k)) return false;
        if (!Objects.equals(this.l, style.l)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
    }

    public static class ChatModifierSerializer {
        public static final MapCodec<ChatModifier> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChatHexColor.a.optionalFieldOf("color").forGetter(serializer -> Optional.ofNullable(serializer.b)), (App)ExtraCodecs.m.optionalFieldOf("shadow_color").forGetter(serializer -> Optional.ofNullable(serializer.c)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(serializer -> Optional.ofNullable(serializer.d)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(serializer -> Optional.ofNullable(serializer.e)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(serializer -> Optional.ofNullable(serializer.f)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(serializer -> Optional.ofNullable(serializer.g)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(serializer -> Optional.ofNullable(serializer.h)), (App)ChatClickable.a.optionalFieldOf("click_event").forGetter(serializer -> Optional.ofNullable(serializer.i)), (App)ChatHoverable.a.optionalFieldOf("hover_event").forGetter(serializer -> Optional.ofNullable(serializer.j)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(serializer -> Optional.ofNullable(serializer.k)), (App)FontDescription.a.optionalFieldOf("font").forGetter(serializer -> Optional.ofNullable(serializer.l))).apply((Applicative)instance, ChatModifier::a));
        public static final Codec<ChatModifier> b = a.codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, ChatModifier> c = ByteBufCodecs.c(b);
    }
}

