/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.chat.SignedMessage;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(byte[] c) {
    public static final Codec<MessageSignature> a = ExtraCodecs.u.xmap(MessageSignature::new, MessageSignature::c);
    public static final int b = 256;

    public MessageSignature {
        Preconditions.checkState((bytes.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
    }

    public SignedMessage.Signature adventure() {
        return () -> this.c;
    }

    public static MessageSignature a(PacketDataSerializer buffer) {
        byte[] bytes = new byte[256];
        buffer.b(bytes);
        return new MessageSignature(bytes);
    }

    public static void a(PacketDataSerializer buffer, MessageSignature signature) {
        buffer.c(signature.c);
    }

    public boolean a(SignatureValidator validator, SignatureUpdater updater) {
        return validator.validate(updater, this.c);
    }

    public ByteBuffer a() {
        return ByteBuffer.wrap(this.c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof MessageSignature)) return false;
        MessageSignature messageSignature = (MessageSignature)other;
        if (!Arrays.equals(this.c, messageSignature.c)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.c);
    }

    public static String a(@Nullable MessageSignature signature) {
        return signature == null ? "<no signature>" : signature.toString();
    }

    public a a(MessageSignatureCache signatureCache) {
        int i2 = signatureCache.a(this);
        return i2 != -1 ? new a(i2) : new a(this);
    }

    public int b() {
        return Arrays.hashCode(this.c);
    }

    public static final class a
    extends Record {
        private final int b;
        @Nullable
        private final MessageSignature c;
        public static final int a = -1;

        public a(MessageSignature fullSignature) {
            this(-1, fullSignature);
        }

        public a(int id) {
            this(id, null);
        }

        public a(int id, @Nullable MessageSignature fullSignature) {
            this.b = id;
            this.c = fullSignature;
        }

        public static a a(PacketDataSerializer buffer) {
            int i2 = buffer.l() - 1;
            return i2 == -1 ? new a(MessageSignature.a(buffer)) : new a(i2);
        }

        public static void a(PacketDataSerializer buffer, a packed) {
            buffer.c(packed.a() + 1);
            if (packed.b() != null) {
                MessageSignature.a(buffer, packed.b());
            }
        }

        public Optional<MessageSignature> a(MessageSignatureCache signatureCache) {
            return this.c != null ? Optional.of(this.c) : Optional.ofNullable(signatureCache.a(this.b));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        @Nullable
        public MessageSignature b() {
            return this.c;
        }
    }
}

