/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record PlayerChatMessage(SignedMessageLink d, @Nullable MessageSignature e, SignedMessageBody f, @Nullable IChatBaseComponent g, FilterMask h) {
    private final SignedMessageLink d;
    @Nullable
    private final MessageSignature e;
    private final SignedMessageBody f;
    @Nullable
    private final IChatBaseComponent g;
    private final FilterMask h;
    public static final MapCodec<PlayerChatMessage> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SignedMessageLink.a.fieldOf("link").forGetter(PlayerChatMessage::k), (App)MessageSignature.a.optionalFieldOf("signature").forGetter(chatMessage -> Optional.ofNullable(chatMessage.e)), (App)SignedMessageBody.a.forGetter(PlayerChatMessage::m), (App)ComponentSerialization.a.optionalFieldOf("unsigned_content").forGetter(chatMessage -> Optional.ofNullable(chatMessage.g)), (App)FilterMask.a.optionalFieldOf("filter_mask", (Object)FilterMask.c).forGetter(PlayerChatMessage::o)).apply((Applicative)instance, (messageLink, signature, signedBody, unsignedContent, filterMask) -> new PlayerChatMessage((SignedMessageLink)messageLink, signature.orElse(null), (SignedMessageBody)signedBody, unsignedContent.orElse(null), (FilterMask)filterMask)));
    private static final UUID i = SystemUtils.e;
    public static final Duration b = Duration.ofMinutes(5L);
    public static final Duration c = b.plus(Duration.ofMinutes(2L));

    public AdventureView adventureView() {
        return new AdventureView();
    }

    public static PlayerChatMessage a(String content) {
        return PlayerChatMessage.a(i, content);
    }

    public static PlayerChatMessage a(UUID sender, String content) {
        SignedMessageBody signedMessageBody = SignedMessageBody.a(content);
        SignedMessageLink signedMessageLink = SignedMessageLink.a(sender);
        return new PlayerChatMessage(signedMessageLink, null, signedMessageBody, null, FilterMask.c);
    }

    public PlayerChatMessage a(IChatBaseComponent message) {
        IChatBaseComponent component;
        if (message instanceof AdventureComponent) {
            AdventureComponent advComponent = (AdventureComponent)message;
            component = this.c().equals(AdventureCodecs.tryCollapseToString(advComponent.adventure$component())) ? null : message;
        } else {
            component = !message.equals(IChatBaseComponent.b(this.c())) ? message : null;
        }
        return new PlayerChatMessage(this.d, this.e, this.f, component, this.h);
    }

    public PlayerChatMessage a() {
        return this.g != null ? new PlayerChatMessage(this.d, this.e, this.f, null, this.h) : this;
    }

    public PlayerChatMessage a(FilterMask mask) {
        return this.h.equals(mask) ? this : new PlayerChatMessage(this.d, this.e, this.f, this.g, mask);
    }

    public PlayerChatMessage a(boolean shouldFilter) {
        return this.a(shouldFilter ? this.h : FilterMask.c);
    }

    public PlayerChatMessage b() {
        SignedMessageBody signedMessageBody = SignedMessageBody.a(this.c());
        SignedMessageLink signedMessageLink = SignedMessageLink.a(this.g());
        return new PlayerChatMessage(signedMessageLink, null, signedMessageBody, this.g, this.h);
    }

    public static void a(SignatureUpdater.a output, SignedMessageLink link, SignedMessageBody body) throws SignatureException {
        output.update(Ints.toByteArray((int)1));
        link.a(output);
        body.a(output);
    }

    public boolean a(SignatureValidator validator) {
        return this.e != null && this.e.a(validator, output -> PlayerChatMessage.a(output, this.d, this.f));
    }

    public String c() {
        return this.f.a();
    }

    public IChatBaseComponent d() {
        return Objects.requireNonNullElseGet(this.g, () -> IChatBaseComponent.b(this.c()));
    }

    public Instant e() {
        return this.f.b();
    }

    public long f() {
        return this.f.c();
    }

    public boolean a(Instant timestamp) {
        return timestamp.isAfter(this.e().plus(b));
    }

    public boolean b(Instant timestamp) {
        return timestamp.isAfter(this.e().plus(c));
    }

    public UUID g() {
        return this.d.c();
    }

    public boolean h() {
        return this.g().equals(i);
    }

    public boolean i() {
        return this.e != null;
    }

    public boolean a(UUID uuid) {
        return this.i() && this.d.c().equals(uuid);
    }

    public boolean j() {
        return this.h.b();
    }

    public static String a(PlayerChatMessage chatMessage) {
        return "'" + chatMessage.f.a() + "' @ " + String.valueOf(chatMessage.f.b()) + "\n - From: " + String.valueOf(chatMessage.d.c()) + "/" + String.valueOf(chatMessage.d.d()) + ", message #" + chatMessage.d.b() + "\n - Salt: " + chatMessage.f.c() + "\n - Signature: " + MessageSignature.a(chatMessage.e) + "\n - Last Seen: [\n" + chatMessage.f.d().b().stream().map(signature -> "     " + MessageSignature.a(signature) + "\n").collect(Collectors.joining()) + " ]\n";
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerChatMessage.class, "link;signature;signedBody;unsignedContent;filterMask", "d", "e", "f", "g", "h"}, this, o2);
    }

    public SignedMessageLink k() {
        return this.d;
    }

    @Nullable
    public MessageSignature l() {
        return this.e;
    }

    public SignedMessageBody m() {
        return this.f;
    }

    @Nullable
    public IChatBaseComponent n() {
        return this.g;
    }

    public FilterMask o() {
        return this.h;
    }

    public final class AdventureView
    implements SignedMessage {
        private AdventureView() {
        }

        public Instant timestamp() {
            return PlayerChatMessage.this.e();
        }

        public long salt() {
            return PlayerChatMessage.this.f();
        }

        @Nullable
        public SignedMessage.Signature signature() {
            return PlayerChatMessage.this.e == null ? null : PlayerChatMessage.this.e.adventure();
        }

        @Nullable
        public Component unsignedContent() {
            return PlayerChatMessage.this.n() == null ? null : PaperAdventure.asAdventure(PlayerChatMessage.this.n());
        }

        public String message() {
            return PlayerChatMessage.this.c();
        }

        public Identity identity() {
            return Identity.identity((UUID)PlayerChatMessage.this.g());
        }

        public PlayerChatMessage playerChatMessage() {
            return PlayerChatMessage.this;
        }
    }
}

