/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.bukkit.event.player.PlayerKickEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public class SignedMessageChain {
    static final Logger a = LogUtils.getLogger();
    @Nullable
    SignedMessageLink b;
    Instant c = Instant.EPOCH;

    public SignedMessageChain(UUID sender, UUID sessionId) {
        this.b = SignedMessageLink.a(sender, sessionId);
    }

    public c a(Signer signer) {
        return body -> {
            SignedMessageLink signedMessageLink = this.b;
            if (signedMessageLink == null) {
                return null;
            }
            this.b = signedMessageLink.a();
            return new MessageSignature(signer.sign(output -> PlayerChatMessage.a(output, signedMessageLink, body)));
        };
    }

    public b a(final ProfilePublicKey publicKey) {
        final SignatureValidator signatureValidator = publicKey.a();
        return new b(){

            @Override
            public PlayerChatMessage unpack(@Nullable MessageSignature signature, SignedMessageBody body) throws a {
                if (signature == null) {
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.a);
                }
                if (publicKey.b().a()) {
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.c, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
                }
                SignedMessageLink signedMessageLink = SignedMessageChain.this.b;
                if (signedMessageLink == null) {
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.b);
                }
                if (PurpurConfig.kickForOutOfOrderChat && body.b().isBefore(SignedMessageChain.this.c)) {
                    this.setChainBroken();
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.e, PlayerKickEvent.Cause.OUT_OF_ORDER_CHAT);
                }
                SignedMessageChain.this.c = body.b();
                PlayerChatMessage playerChatMessage = new PlayerChatMessage(signedMessageLink, signature, body, null, FilterMask.c);
                if (!playerChatMessage.a(signatureValidator)) {
                    this.setChainBroken();
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.d);
                }
                if (playerChatMessage.a(Instant.now())) {
                    a.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)body.a());
                }
                SignedMessageChain.this.b = signedMessageLink.a();
                return playerChatMessage;
            }

            @Override
            public void setChainBroken() {
                SignedMessageChain.this.b = null;
            }
        };
    }

    @FunctionalInterface
    public static interface c {
        public static final c a = body -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    @FunctionalInterface
    public static interface b {
        public static b unsigned(UUID id, BooleanSupplier shouldEnforceSecureProfile) {
            return (signature, body) -> {
                if (shouldEnforceSecureProfile.getAsBoolean()) {
                    throw new a(net.minecraft.network.chat.SignedMessageChain$a.a);
                }
                return PlayerChatMessage.a(id, body.a());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws a;

        default public void setChainBroken() {
        }
    }

    public static class a
    extends ThrowingComponent {
        static final IChatBaseComponent a = IChatBaseComponent.c("chat.disabled.missingProfileKey");
        static final IChatBaseComponent b = IChatBaseComponent.c("chat.disabled.chain_broken");
        static final IChatBaseComponent c = IChatBaseComponent.c("chat.disabled.expiredProfileKey");
        static final IChatBaseComponent d = IChatBaseComponent.c("chat.disabled.invalid_signature");
        static final IChatBaseComponent e = IChatBaseComponent.c("chat.disabled.out_of_order_chat");
        public final PlayerKickEvent.Cause kickCause;

        public a(IChatBaseComponent component, PlayerKickEvent.Cause event) {
            super(component);
            this.kickCause = event;
        }

        public a(IChatBaseComponent component) {
            this(component, PlayerKickEvent.Cause.UNKNOWN);
        }
    }
}

