/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.network.chat.contents.data.DataSources;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger c = LogUtils.getLogger();
    public static final MapCodec<NbtContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::b), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::c), (App)ComponentSerialization.a.lenientOptionalFieldOf("separator").forGetter(NbtContents::d), (App)DataSources.a.forGetter(NbtContents::e)).apply((Applicative)instance, NbtContents::new));
    private final boolean d;
    private final Optional<IChatBaseComponent> e;
    private final String f;
    private final DataSource g;
    @Nullable
    protected final ArgumentNBTKey.g b;

    public NbtContents(String nbtPathPattern, boolean interpreting, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this(nbtPathPattern, NbtContents.a(nbtPathPattern), interpreting, separator, dataSource);
    }

    private NbtContents(String nbtPathPattern, @Nullable ArgumentNBTKey.g compiledNbtPath, boolean interpreting, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this.f = nbtPathPattern;
        this.b = compiledNbtPath;
        this.d = interpreting;
        this.e = separator;
        this.g = dataSource;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String nbtPathPattern) {
        try {
            return new ArgumentNBTKey().a(new StringReader(nbtPathPattern));
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    public String b() {
        return this.f;
    }

    public boolean c() {
        return this.d;
    }

    public Optional<IChatBaseComponent> d() {
        return this.e;
    }

    public DataSource e() {
        return this.g;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof NbtContents)) return false;
        NbtContents nbtContents = (NbtContents)other;
        if (!this.g.equals(nbtContents.g)) return false;
        if (!this.e.equals(nbtContents.e)) return false;
        if (this.d != nbtContents.d) return false;
        if (!this.f.equals(nbtContents.f)) return false;
        return true;
    }

    public int hashCode() {
        int i2 = this.d ? 1 : 0;
        i2 = 31 * i2 + this.e.hashCode();
        i2 = 31 * i2 + this.f.hashCode();
        return 31 * i2 + this.g.hashCode();
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.g) + ", interpreting=" + this.d + ", separator=" + String.valueOf(this.e) + "}";
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (source != null && this.b != null) {
            Stream<String> stream = this.g.a(source).flatMap(tag -> {
                try {
                    return this.b.a((NBTBase)tag).stream();
                }
                catch (CommandSyntaxException var3x) {
                    return Stream.empty();
                }
            });
            if (this.d) {
                RegistryOps<NBTBase> registryOps = source.u().a(DynamicOpsNBT.a);
                IChatBaseComponent component = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.updateSeparatorForEntity(source, this.e, entity, recursionDepth), (Object)ChatComponentUtils.c);
                return stream.flatMap(tag -> {
                    try {
                        IChatBaseComponent component1 = (IChatBaseComponent)ComponentSerialization.a.parse((DynamicOps)registryOps, tag).getOrThrow();
                        return Stream.of(ChatComponentUtils.a(source, component1, entity, recursionDepth));
                    }
                    catch (Exception var6x) {
                        c.warn("Failed to parse component: {}", tag, (Object)var6x);
                        return Stream.of(new IChatMutableComponent[0]);
                    }
                }).reduce((mutableComponent, component1) -> mutableComponent.b(component).b((IChatBaseComponent)component1)).orElseGet(IChatBaseComponent::i);
            }
            Stream<String> stream1 = stream.map(NbtContents::a);
            return ChatComponentUtils.updateSeparatorForEntity(source, this.e, entity, recursionDepth).map(mutableComponent -> stream1.map(IChatBaseComponent::b).reduce((mutableComponent1, otherMutableComponent) -> mutableComponent1.b((IChatBaseComponent)mutableComponent).b((IChatBaseComponent)otherMutableComponent)).orElseGet(IChatBaseComponent::i)).orElseGet(() -> IChatBaseComponent.b(stream1.collect(Collectors.joining(", "))));
        }
        return IChatBaseComponent.i();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(NBTBase tag) {
        String string;
        if (!(tag instanceof NBTTagString)) {
            string = tag.toString();
            return string;
        }
        NBTTagString nBTTagString = (NBTTagString)tag;
        try {
            String string2;
            String var5;
            string = var5 = (string2 = nBTTagString.k());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public MapCodec<NbtContents> a() {
        return a;
    }
}

