/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TileEntity;

public record BlockDataSource(String b, @Nullable IVectorPosition c) implements DataSource
{
    public static final MapCodec<BlockDataSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(BlockDataSource::b)).apply((Applicative)instance, BlockDataSource::new));

    public BlockDataSource(String posPattern) {
        this(posPattern, BlockDataSource.a(posPattern));
    }

    @Nullable
    private static IVectorPosition a(String posPattern) {
        try {
            return ArgumentPosition.a().a(new StringReader(posPattern));
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    @Override
    public Stream<NBTTagCompound> a(CommandListenerWrapper source) {
        TileEntity blockEntity;
        BlockPosition blockPos;
        WorldServer level;
        if (this.c != null && (level = source.e()).p(blockPos = this.c.c(source)) && (blockEntity = level.c_(blockPos)) != null) {
            return Stream.of(blockEntity.b(source.u()));
        }
        return Stream.empty();
    }

    public MapCodec<BlockDataSource> a() {
        return a;
    }

    @Override
    public String toString() {
        return "block=" + this.b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof BlockDataSource)) return false;
        BlockDataSource blockDataSource = (BlockDataSource)other;
        if (!this.b.equals(blockDataSource.b)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }
}

