/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.world.entity.Entity;

public record EntityDataSource(String b, @Nullable EntitySelector c) implements DataSource
{
    public static final MapCodec<EntityDataSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(EntityDataSource::b)).apply((Applicative)instance, EntityDataSource::new));

    public EntityDataSource(String selectorPattern) {
        this(selectorPattern, EntityDataSource.a(selectorPattern));
    }

    @Nullable
    private static EntitySelector a(String selectorPattern) {
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(selectorPattern), true);
            return entitySelectorParser.t();
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    @Override
    public Stream<NBTTagCompound> a(CommandListenerWrapper source) throws CommandSyntaxException {
        if (this.c != null) {
            List<? extends Entity> list = this.c.b(source);
            return list.stream().map(CriterionConditionNBT::b);
        }
        return Stream.empty();
    }

    public MapCodec<EntityDataSource> a() {
        return a;
    }

    @Override
    public String toString() {
        return "entity=" + this.b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof EntityDataSource)) return false;
        EntityDataSource entityDataSource = (EntityDataSource)other;
        if (!this.b.equals(entityDataSource.b)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }
}

