/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutSpawnEntity> a = Packet.a(PacketPlayOutSpawnEntity::a, PacketPlayOutSpawnEntity::new);
    private final int b;
    private final UUID c;
    private final EntityTypes<?> d;
    private final double e;
    private final double f;
    private final double g;
    private final Vec3D h;
    private final byte i;
    private final byte j;
    private final byte k;
    private final int l;

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry serverEntity) {
        this(entity, serverEntity, 0);
    }

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry serverEntity, int data) {
        this(entity.az(), entity.cT(), entity.dE().a(), entity.dE().b(), entity.dE().c(), serverEntity.d(), serverEntity.e(), entity.ax(), data, serverEntity.c(), serverEntity.f());
    }

    public PacketPlayOutSpawnEntity(Entity entity, int data, BlockPosition pos) {
        this(entity.az(), entity.cT(), pos.u(), pos.v(), pos.w(), entity.dZ(), entity.dX(), entity.ax(), data, entity.dI(), entity.cN());
    }

    public PacketPlayOutSpawnEntity(int id, UUID uuid, double x2, double y2, double z2, float xRot, float yRot, EntityTypes<?> type, int data, Vec3D deltaMovement, double yHeadRot) {
        this.b = id;
        this.c = uuid;
        this.e = x2;
        this.f = y2;
        this.g = z2;
        this.h = deltaMovement;
        this.i = MathHelper.g(xRot);
        this.j = MathHelper.g(yRot);
        this.k = MathHelper.g((float)yHeadRot);
        this.d = type;
        this.l = data;
    }

    private PacketPlayOutSpawnEntity(RegistryFriendlyByteBuf buffer) {
        this.b = buffer.l();
        this.c = buffer.n();
        this.d = (EntityTypes)ByteBufCodecs.a(Registries.E).decode(buffer);
        this.e = buffer.readDouble();
        this.f = buffer.readDouble();
        this.g = buffer.readDouble();
        this.h = buffer.k();
        this.i = buffer.readByte();
        this.j = buffer.readByte();
        this.k = buffer.readByte();
        this.l = buffer.l();
    }

    @Override
    private void a(RegistryFriendlyByteBuf buffer) {
        buffer.c(this.b);
        buffer.a(this.c);
        ByteBufCodecs.a(Registries.E).encode(buffer, this.d);
        buffer.a(this.e);
        buffer.a(this.f);
        buffer.a(this.g);
        buffer.b(this.h);
        buffer.l(this.i);
        buffer.l(this.j);
        buffer.l(this.k);
        buffer.c(this.l);
    }

    @Override
    public PacketType<PacketPlayOutSpawnEntity> a() {
        return GamePacketTypes.c;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public int b() {
        return this.b;
    }

    public UUID e() {
        return this.c;
    }

    public EntityTypes<?> f() {
        return this.d;
    }

    public double g() {
        return this.e;
    }

    public double h() {
        return this.f;
    }

    public double i() {
        return this.g;
    }

    public Vec3D j() {
        return this.h;
    }

    public float k() {
        return MathHelper.a(this.i);
    }

    public float l() {
        return MathHelper.a(this.j);
    }

    public float m() {
        return MathHelper.a(this.k);
    }

    public int n() {
        return this.l;
    }
}

