/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.NameAndId;

public final class ServerPing
extends Record {
    private final IChatBaseComponent b;
    private final Optional<ServerPingPlayerSample> c;
    private final Optional<ServerData> d;
    private final Optional<a> e;
    private final boolean f;
    public static final Codec<ServerPing> a = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.a.lenientOptionalFieldOf("description", (Object)CommonComponents.a).forGetter(ServerPing::a), (App)ServerPingPlayerSample.a.lenientOptionalFieldOf("players").forGetter(ServerPing::b), (App)ServerData.a.lenientOptionalFieldOf("version").forGetter(ServerPing::c), (App)net.minecraft.network.protocol.status.ServerPing$a.a.lenientOptionalFieldOf("favicon").forGetter(ServerPing::d), (App)Codec.BOOL.lenientOptionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerPing::e)).apply((Applicative)instance, ServerPing::new));

    public ServerPing(IChatBaseComponent description, Optional<ServerPingPlayerSample> players, Optional<ServerData> version, Optional<a> favicon, boolean enforcesSecureChat) {
        this.b = description;
        this.c = players;
        this.d = version;
        this.e = favicon;
        this.f = enforcesSecureChat;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this, o2);
    }

    public IChatBaseComponent a() {
        return this.b;
    }

    public Optional<ServerPingPlayerSample> b() {
        return this.c;
    }

    public Optional<ServerData> c() {
        return this.d;
    }

    public Optional<a> d() {
        return this.e;
    }

    public boolean e() {
        return this.f;
    }

    public static final class ServerPingPlayerSample
    extends Record {
        private final int b;
        private final int c;
        private final List<NameAndId> d;
        public static final Codec<ServerPingPlayerSample> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max").forGetter(ServerPingPlayerSample::a), (App)Codec.INT.fieldOf("online").forGetter(ServerPingPlayerSample::b), (App)NameAndId.a.listOf().lenientOptionalFieldOf("sample", List.of()).forGetter(ServerPingPlayerSample::c)).apply((Applicative)instance, ServerPingPlayerSample::new));

        public ServerPingPlayerSample(int max, int online, List<NameAndId> sample) {
            this.b = max;
            this.c = online;
            this.d = sample;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public List<NameAndId> c() {
            return this.d;
        }
    }

    public record ServerData(String b, int c) {
        public static final Codec<ServerData> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ServerData::b), (App)Codec.INT.fieldOf("protocol").forGetter(ServerData::c)).apply((Applicative)instance, ServerData::new));

        public static ServerData a() {
            WorldVersion currentVersion = SharedConstants.b();
            return new ServerData(currentVersion.c(), currentVersion.d());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this, o2);
        }
    }

    public static final class a
    extends Record {
        private final byte[] b;
        private static final String c = "data:image/png;base64,";
        public static final Codec<a> a = Codec.STRING.comapFlatMap(string -> {
            if (!string.startsWith(c)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String string1 = string.substring(c.length()).replaceAll("\n", "");
                byte[] bytes = Base64.getDecoder().decode(string1.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new a(bytes));
            }
            catch (IllegalArgumentException var3) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, favicon -> c + new String(Base64.getEncoder().encode(favicon.b), StandardCharsets.UTF_8));

        public a(byte[] iconBytes) {
            this.b = iconBytes;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "iconBytes", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "iconBytes", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "iconBytes", "b"}, this, o2);
        }

        public byte[] a() {
            return this.b;
        }
    }
}

