/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.FileUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataPlayer {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = new GsonBuilder().create();
    private final PlayerList c;
    private final Path d;
    private AdvancementTree e;
    private final Map<AdvancementHolder, AdvancementProgress> f = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> g = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> h = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> i = new HashSet<AdvancementNode>();
    private EntityPlayer j;
    @Nullable
    private AdvancementHolder k;
    private boolean l = true;
    private final Codec<a> m;
    public final Map<CriterionTriggerAbstract<?>, Set<CriterionTrigger.a<?>>> criterionData = new IdentityHashMap();

    public AdvancementDataPlayer(DataFixer dataFixer, PlayerList playerList, AdvancementDataWorld manager, Path playerSavePath, EntityPlayer player) {
        this.c = playerList;
        this.d = playerSavePath;
        this.j = player;
        this.e = manager.a();
        int i2 = 1343;
        this.m = DataFixTypes.r.a(net.minecraft.server.AdvancementDataPlayer$a.a, dataFixer, 1343);
        this.d(manager);
    }

    public void a(EntityPlayer player) {
        this.j = player;
    }

    public void a() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.al) {
            criterionTrigger.a(this);
        }
    }

    public void a(AdvancementDataWorld manager) {
        this.a();
        this.f.clear();
        this.g.clear();
        this.i.clear();
        this.h.clear();
        this.l = true;
        this.k = null;
        this.e = manager.a();
        this.d(manager);
    }

    private void b(AdvancementDataWorld manager) {
        for (AdvancementHolder advancementHolder : manager.b()) {
            this.d(advancementHolder);
        }
    }

    private void c(AdvancementDataWorld manager) {
        for (AdvancementHolder advancementHolder : manager.b()) {
            Advancement advancement = advancementHolder.b();
            if (!advancement.e().isEmpty()) continue;
            this.a(advancementHolder, "");
            advancement.d().a(this.j);
        }
    }

    private void d(AdvancementDataWorld manager) {
        if (Files.isRegularFile(this.d, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.d, StandardCharsets.UTF_8);){
                JsonElement jsonElement = StrictJsonParser.a(bufferedReader);
                a data = (a)this.m.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
                this.a(manager, data);
            }
            catch (JsonIOException | IOException var7) {
                a.error("Couldn't access player advancements in {}", (Object)this.d, (Object)var7);
            }
            catch (JsonParseException var8) {
                a.error("Couldn't parse player advancements in {}", (Object)this.d, (Object)var8);
            }
        }
        this.c(manager);
        this.b(manager);
    }

    public void b() {
        if (SpigotConfig.disableAdvancementSaving) {
            return;
        }
        JsonElement jsonElement = (JsonElement)this.m.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.c()).getOrThrow();
        try {
            FileUtils.c(this.d.getParent());
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.d, StandardCharsets.UTF_8, new OpenOption[0]);){
                b.toJson(jsonElement, b.newJsonWriter((Writer)bufferedWriter));
            }
        }
        catch (JsonIOException | IOException var7) {
            a.error("Couldn't save player advancements to {}", (Object)this.d, (Object)var7);
        }
    }

    private void a(AdvancementDataWorld advancementManager, a data) {
        data.a((MinecraftKey path, AdvancementProgress progress) -> {
            AdvancementHolder advancementHolder = advancementManager.a((MinecraftKey)path);
            if (advancementHolder == null) {
                if (!path.b().equals("minecraft")) {
                    return;
                }
                if (!PurpurConfig.loggerSuppressIgnoredAdvancementWarnings) {
                    a.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", path, (Object)this.d);
                }
            } else {
                this.a(advancementHolder, (AdvancementProgress)progress);
                this.h.add(advancementHolder);
                this.c(advancementHolder);
            }
        });
    }

    private a c() {
        LinkedHashMap<MinecraftKey, AdvancementProgress> map = new LinkedHashMap<MinecraftKey, AdvancementProgress>();
        this.f.forEach((advancementHolder, progress) -> {
            if (progress.b()) {
                map.put(advancementHolder.a(), (AdvancementProgress)progress);
            }
        });
        return new a(map);
    }

    public boolean a(AdvancementHolder advancement, String criterionKey) {
        boolean flag = false;
        AdvancementProgress orStartProgress = this.b(advancement);
        boolean isDone = orStartProgress.a();
        if (orStartProgress.a(criterionKey)) {
            if (!new PlayerAdvancementCriterionGrantEvent((Player)this.j.getBukkitEntity(), advancement.toBukkit(), criterionKey).callEvent()) {
                orStartProgress.b(criterionKey);
                return false;
            }
            this.e(advancement);
            this.h.add(advancement);
            flag = true;
            if (!isDone && orStartProgress.a()) {
                Component message = advancement.b().c().flatMap(info -> Optional.ofNullable(info.i() ? PaperAdventure.asAdventure(info.e().a(advancement, this.j)) : null)).orElse(null);
                PlayerAdvancementDoneEvent event = new PlayerAdvancementDoneEvent((Player)this.j.getBukkitEntity(), advancement.toBukkit(), message);
                this.j.A().getCraftServer().getPluginManager().callEvent((Event)event);
                advancement.b().d().a(this.j);
                advancement.b().c().ifPresent(displayInfo -> {
                    if (event.message() != null && this.j.A().S().c(GameRules.C)) {
                        if (PurpurConfig.advancementOnlyBroadcastToAffectedPlayer) {
                            this.j.sendMessage(message);
                        } else {
                            this.c.a(PaperAdventure.asVanilla(event.message()), false);
                        }
                    }
                });
            }
        }
        if (!isDone && orStartProgress.a()) {
            this.c(advancement);
        }
        return flag;
    }

    public boolean b(AdvancementHolder advancement, String criterionKey) {
        boolean flag = false;
        AdvancementProgress orStartProgress = this.b(advancement);
        boolean isDone = orStartProgress.a();
        if (orStartProgress.b(criterionKey)) {
            this.d(advancement);
            this.h.add(advancement);
            flag = true;
        }
        if (isDone && !orStartProgress.a()) {
            this.c(advancement);
        }
        return flag;
    }

    private void c(AdvancementHolder advancement) {
        AdvancementNode advancementNode = this.e.a(advancement);
        if (advancementNode != null) {
            this.i.add(advancementNode.d());
        }
    }

    private void d(AdvancementHolder advancement) {
        AdvancementProgress orStartProgress = this.b(advancement);
        if (!orStartProgress.a()) {
            for (Map.Entry<String, Criterion<?>> entry : advancement.b().e().entrySet()) {
                CriterionProgress criterion = orStartProgress.c(entry.getKey());
                if (criterion == null || criterion.a()) continue;
                this.a(advancement, entry.getKey(), entry.getValue());
            }
        }
    }

    private <T extends CriterionInstance> void a(AdvancementHolder advancement, String criterionKey, Criterion<T> criterion) {
        criterion.a().a(this, new CriterionTrigger.a<T>(criterion.b(), advancement, criterionKey));
    }

    private void e(AdvancementHolder advancement) {
        AdvancementProgress orStartProgress = this.b(advancement);
        for (Map.Entry<String, Criterion<?>> entry : advancement.b().e().entrySet()) {
            CriterionProgress criterion = orStartProgress.c(entry.getKey());
            if (criterion == null || !criterion.a() && !orStartProgress.a()) continue;
            this.b(advancement, entry.getKey(), entry.getValue());
        }
    }

    private <T extends CriterionInstance> void b(AdvancementHolder advancement, String criterionKey, Criterion<T> criterion) {
        criterion.a().b(this, new CriterionTrigger.a<T>(criterion.b(), advancement, criterionKey));
    }

    public void a(EntityPlayer player, boolean showAdvancements) {
        if (this.l || !this.i.isEmpty() || !this.h.isEmpty()) {
            HashMap<MinecraftKey, AdvancementProgress> map = new HashMap<MinecraftKey, AdvancementProgress>();
            TreeSet<AdvancementHolder> set = new TreeSet<AdvancementHolder>(Comparator.comparing(adv -> adv.a().toString()));
            HashSet<MinecraftKey> set1 = new HashSet<MinecraftKey>();
            for (AdvancementNode advancementNode : this.i) {
                this.a(advancementNode, set, set1);
            }
            this.i.clear();
            for (AdvancementHolder advancementHolder : this.h) {
                if (!this.g.contains(advancementHolder)) continue;
                map.put(advancementHolder.a(), this.f.get(advancementHolder));
            }
            this.h.clear();
            if (!(map.isEmpty() && set.isEmpty() && set1.isEmpty())) {
                player.g.b(new PacketPlayOutAdvancements(this.l, set, set1, map, showAdvancements));
            }
        }
        this.l = false;
    }

    public void a(@Nullable AdvancementHolder advancement) {
        AdvancementHolder advancementHolder = this.k;
        this.k = advancement != null && advancement.b().a() && advancement.b().c().isPresent() ? advancement : null;
        if (advancementHolder != this.k) {
            this.j.g.b(new PacketPlayOutSelectAdvancementTab(this.k == null ? null : this.k.a()));
        }
    }

    public AdvancementProgress b(AdvancementHolder advancement) {
        AdvancementProgress advancementProgress = this.f.get(advancement);
        if (advancementProgress == null) {
            advancementProgress = new AdvancementProgress();
            this.a(advancement, advancementProgress);
        }
        return advancementProgress;
    }

    private void a(AdvancementHolder advancement, AdvancementProgress advancementProgress) {
        advancementProgress.a(advancement.b().f());
        this.f.put(advancement, advancementProgress);
    }

    private void a(AdvancementNode root, Set<AdvancementHolder> advancementOutput, Set<MinecraftKey> idOutput) {
        AdvancementVisibilityEvaluator.a(root, (AdvancementNode advancementNode) -> this.b(advancementNode.b()).a(), (AdvancementNode node, boolean visible) -> {
            AdvancementHolder advancementHolder = node.b();
            if (visible) {
                if (this.g.add(advancementHolder)) {
                    advancementOutput.add(advancementHolder);
                    if (this.f.containsKey(advancementHolder)) {
                        this.h.add(advancementHolder);
                    }
                }
            } else if (this.g.remove(advancementHolder)) {
                idOutput.add(advancementHolder.a());
            }
        });
    }

    static final class a
    extends Record {
        private final Map<MinecraftKey, AdvancementProgress> b;
        public static final Codec<a> a = Codec.unboundedMap(MinecraftKey.a, AdvancementProgress.a).xmap(a::new, a::a);

        a(Map<MinecraftKey, AdvancementProgress> map) {
            this.b = map;
        }

        public void a(BiConsumer<MinecraftKey, AdvancementProgress> action) {
            this.b.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> action.accept((MinecraftKey)entry.getKey(), (AdvancementProgress)entry.getValue()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "map", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "map", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "map", "b"}, this, o2);
        }

        public Map<MinecraftKey, AdvancementProgress> a() {
            return this.b;
        }
    }
}

