/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.profile.PaperAuthenticationService;
import com.google.common.io.FileWriteMode;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.ServerEnvironment;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(OptionSet optionSet) {
        LogManagerShutdownThread.hook();
        SharedConstants.a();
        try {
            WorldStem worldStem;
            Dynamic<?> dataTag;
            File file;
            Path path = (Path)optionSet.valueOf("pidFile");
            if (path != null) {
                Main.a(path);
            }
            CrashReport.g();
            if (optionSet.has("jfrProfile")) {
                JvmProfiler.f.a(Environment.b);
            }
            YamlConfiguration purpurConfiguration = PaperConfigurations.loadLegacyConfigFile((File)optionSet.valueOf("purpur-settings"));
            PurpurConfig.clampEnchantLevels = purpurConfiguration.getBoolean("settings.enchantment.clamp-levels", true);
            PurpurConfig.registerMinecraftDebugCommands = purpurConfiguration.getBoolean("settings.register-minecraft-debug-commands");
            PurpurConfig.registerMinecraftDisabledCommands = purpurConfiguration.getBoolean("settings.register-minecraft-disabled-commands");
            PluginInitializerManager.load(optionSet);
            DispenserRegistry.a();
            DispenserRegistry.c();
            SystemUtils.p();
            Path path1 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedServerSettings = new DedicatedServerSettings(optionSet);
            dedicatedServerSettings.b();
            RegionFileCompression.a(dedicatedServerSettings.a().T);
            Path path2 = Paths.get("eula.txt", new String[0]);
            EULA eula = new EULA(path2);
            YamlConfiguration bukkitConfiguration = PaperConfigurations.loadLegacyConfigFile((File)optionSet.valueOf("bukkit-settings"));
            YamlConfiguration spigotConfiguration = PaperConfigurations.loadLegacyConfigFile((File)optionSet.valueOf("spigot-settings"));
            if (optionSet.has("initSettings")) {
                File configFile = (File)optionSet.valueOf("bukkit-settings");
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml"), StandardCharsets.UTF_8)));
                configuration.save(configFile);
                File commandFile = (File)optionSet.valueOf("commands-settings");
                YamlConfiguration commandsConfiguration = YamlConfiguration.loadConfiguration((File)commandFile);
                commandsConfiguration.options().copyDefaults(true);
                commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/commands.yml"), StandardCharsets.UTF_8)));
                commandsConfiguration.save(commandFile);
                a.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                a.error("You have used the Spigot command line EULA agreement flag.");
                a.error("By using this setting you are indicating your agreement to Mojang's EULA (https://aka.ms/MinecraftEULA).");
                a.error("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.a() && !eulaAgreed) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            String awtException = ServerEnvironment.awtDependencyCheck();
            if (awtException != null) {
                a.error("You are using a headless JRE distribution.");
                a.error("This distribution is missing certain graphic libraries that the Minecraft server needs to function.");
                a.error("For instructions on how to install the non-headless JRE, see https://docs.papermc.io/misc/java-install");
                a.error("");
                a.error(awtException);
                return;
            }
            SpigotConfig.disabledAdvancements = spigotConfiguration.getStringList("advancements.disabled");
            File userCacheFile = new File("usercache.json");
            if (optionSet.has("universe")) {
                file = (File)optionSet.valueOf("universe");
                userCacheFile = new File(file, "usercache.json");
            } else {
                file = new File(bukkitConfiguration.getString("settings.world-container", "."));
            }
            Services services = Services.create(new PaperAuthenticationService(Proxy.NO_PROXY), file, userCacheFile, optionSet);
            String string = Optional.ofNullable((String)optionSet.valueOf("world")).orElse(dedicatedServerSettings.a().o);
            Convertable levelStorageSource = Convertable.b(file.toPath());
            Convertable.ConversionSession levelStorageAccess = levelStorageSource.validateAndCreateAccess(string, WorldDimension.b);
            if (levelStorageAccess.m()) {
                WorldInfo summary;
                try {
                    dataTag = levelStorageAccess.h();
                    summary = levelStorageAccess.a(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException var41) {
                    Convertable.b levelDirectory = levelStorageAccess.e();
                    a.warn("Failed to load world data from {}", (Object)levelDirectory.b(), (Object)var41);
                    a.info("Attempting to use fallback");
                    try {
                        dataTag = levelStorageAccess.i();
                        summary = levelStorageAccess.a(dataTag);
                    }
                    catch (IOException | NbtException | ReportedNbtException var40) {
                        a.error("Failed to load world data from {}", (Object)levelDirectory.c(), (Object)var40);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.b(), (Object)levelDirectory.c());
                        return;
                    }
                    levelStorageAccess.n();
                }
                if (summary.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!summary.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dataTag = null;
            }
            Dynamic<?> dynamic = dataTag;
            boolean hasOptionSpec = optionSet.has("safeMode");
            if (hasOptionSpec) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository packRepository = ResourcePackSourceVanilla.a(levelStorageAccess);
            File bukkitDataPackFolder = new File(levelStorageAccess.a(SavedFile.j).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                int major = SharedConstants.b().a(EnumResourcePackType.b).b();
                int minor = SharedConstants.b().a(EnumResourcePackType.b).c();
                com.google.common.io.Files.asCharSink((File)mcMeta, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"min_format\": [%d, %d],\n        \"max_format\": [%d, %d]\n    }\n}\n".formatted(major, minor, major, minor));
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex);
            }
            AtomicReference worldLoader = new AtomicReference();
            try {
                WorldLoader.c initConfig = Main.a(dedicatedServerSettings.a(), dynamic, hasOptionSpec, packRepository);
                worldStem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(initConfig, (WorldLoader.a context) -> {
                    worldLoader.set(context);
                    IRegistry<WorldDimension> registry = context.d().f(Registries.by);
                    if (dynamic != null) {
                        LevelDataAndDimensions levelDataAndDimensions = Convertable.a(dynamic, context.b(), registry, context.c());
                        return new WorldLoader.b<SaveData>(levelDataAndDimensions.a(), levelDataAndDimensions.b().b());
                    }
                    a.info("No existing world data, creating new world");
                    return Main.a(dedicatedServerSettings, context, registry, optionSet.has("demo"), optionSet.has("bonusChest"));
                }, WorldStem::new, SystemUtils.h(), executor)).get();
            }
            catch (Exception var39) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var39);
                return;
            }
            Class.forName(VillagerTrades.class.getName());
            DedicatedServer dedicatedServer = MinecraftServer.a((Thread thread1) -> {
                int port;
                boolean flag;
                DedicatedServer dedicatedServer1 = new DedicatedServer(optionSet, (WorldLoader.a)worldLoader.get(), (Thread)thread1, levelStorageAccess, packRepository, worldStem, dedicatedServerSettings, DataConverterRegistry.a(), services);
                if (optionSet.has("serverId")) {
                    dedicatedServer1.b((String)optionSet.valueOf("serverId"));
                }
                dedicatedServer1.c(optionSet.has("demo"));
                boolean bl = flag = !optionSet.has("nogui") && !optionSet.nonOptionArguments().contains("nogui");
                if (flag && !GraphicsEnvironment.isHeadless()) {
                    dedicatedServer1.bF();
                }
                if (optionSet.has("port") && (port = ((Integer)optionSet.valueOf("port")).intValue()) > 0) {
                    dedicatedServer1.b(port);
                }
                return dedicatedServer1;
            });
        }
        catch (Exception var42) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var42);
        }
    }

    public static WorldLoader.b<SaveData> a(DedicatedServerSettings settings, WorldLoader.a context, IRegistry<WorldDimension> stemRegistry, boolean demo, boolean generateBonusChest) {
        WorldDimensions worldDimensions;
        WorldOptions worldOptions;
        WorldSettings levelSettings;
        if (demo) {
            levelSettings = MinecraftServer.e;
            worldOptions = WorldOptions.b;
            worldDimensions = WorldPresets.a(context.c());
        } else {
            DedicatedServerProperties properties = settings.a();
            levelSettings = new WorldSettings(properties.o, properties.n.get(), properties.D, properties.m.get(), false, new GameRules(context.b().b()), context.b());
            worldOptions = generateBonusChest ? properties.ai.a(true) : properties.ai;
            worldDimensions = properties.a(context.c());
        }
        WorldDimensions.b complete = worldDimensions.a(stemRegistry);
        Lifecycle lifecycle = complete.a().add(context.c().d());
        return new WorldLoader.b<SaveData>(new WorldDataServer(levelSettings, worldOptions, complete.d(), lifecycle), complete.b());
    }

    private static void a(Path path) {
        try {
            long l2 = ProcessHandle.current().pid();
            Files.writeString(path, (CharSequence)Long.toString(l2), new OpenOption[0]);
        }
        catch (IOException var3) {
            throw new UncheckedIOException(var3);
        }
    }

    private static WorldLoader.c a(DedicatedServerProperties dedicatedServerProperties, @Nullable Dynamic<?> dynamic, boolean safeMode, ResourcePackRepository packRepository) {
        WorldDataConfiguration worldDataConfiguration;
        boolean flag;
        if (dynamic != null) {
            WorldDataConfiguration dataConfig = Convertable.a(dynamic);
            flag = false;
            worldDataConfiguration = dataConfig;
        } else {
            flag = true;
            worldDataConfiguration = new WorldDataConfiguration(dedicatedServerProperties.ab, FeatureFlags.h);
        }
        WorldLoader.d packConfig = new WorldLoader.d(packRepository, worldDataConfiguration, safeMode, flag);
        return new WorldLoader.c(packConfig, CommandDispatcher.ServerType.b, dedicatedServerProperties.H);
    }

    public static void a(Convertable.ConversionSession levelStorage, SaveData worldData, DataFixer dataFixer, boolean eraseCache, BooleanSupplier running, IRegistryCustom registryAccess, boolean recreateRegionFiles) {
        a.info("Forcing world upgrade! {}", (Object)levelStorage.f());
        try (WorldUpgrader worldUpgrader = new WorldUpgrader(levelStorage, dataFixer, worldData, registryAccess, eraseCache, recreateRegionFiles);){
            IChatBaseComponent component = null;
            while (!worldUpgrader.b()) {
                int totalChunks;
                IChatBaseComponent status = worldUpgrader.h();
                if (component != status) {
                    component = status;
                    a.info(worldUpgrader.h().getString());
                }
                if ((totalChunks = worldUpgrader.e()) > 0) {
                    int i2 = worldUpgrader.f() + worldUpgrader.g();
                    a.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.d((float)i2 / (float)totalChunks * 100.0f), i2, totalChunks});
                }
                if (!running.getAsBoolean()) {
                    worldUpgrader.a();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

