/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.time.Schedule;
import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import dev.omega24.upnp4j.UPnP4J;
import dev.omega24.upnp4j.util.Protocol;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.event.world.WorldDifficultyChangeEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.EntityScheduler;
import io.papermc.paper.threadedregions.RegionizedServerInitEvent;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import io.papermc.paper.world.PaperWorldLoader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.ChunkLoadStatusView;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R6.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftDifficulty;
import org.bukkit.craftbukkit.v1_21_R6.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.entity.RidableMoveEvent;
import org.purpurmc.purpur.task.BeehiveTask;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ICommandListener,
ChunkIOErrorReporter,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger m;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float n = 0.8f;
    private static final int o = 100;
    private static final long p;
    private static final int q = 20;
    private static final long r;
    private static final int s = 100;
    private static final long t;
    private static final long u;
    private static final int v = 12;
    public static final int c = 5;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int d = 29999984;
    public static final WorldSettings e;
    public static final NameAndId f;
    public Convertable.ConversionSession g;
    public final WorldNBTStorage h;
    private final List<Runnable> z = Lists.newArrayList();
    private MetricsRecorder A = InactiveMetricsRecorder.a;
    private Consumer<MethodProfilerResults> B = results -> this.ba();
    private Consumer<Path> C = path -> {};
    private boolean D;
    @Nullable
    private TimeProfiler E;
    private boolean F;
    private ServerConnection G;
    @Nullable
    private ServerPing I;
    @Nullable
    private ServerPing.a J;
    private final RandomSource K = RandomSource.a();
    public final DataFixer L;
    private String M;
    private int N = -1;
    private final LayeredRegistryAccess<RegistryLayer> O;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> P = Maps.newLinkedHashMap();
    private PlayerList Q;
    private volatile boolean R = true;
    private volatile boolean isRestarting = false;
    private boolean S;
    private int T;
    private int U = 6000;
    protected final Proxy i;
    private boolean V;
    private boolean W;
    private Component motd;
    private int Y;
    private final long[] Z = new long[100];
    private long aa = 0L;
    @Nullable
    private KeyPair ab;
    @Nullable
    private GameProfile ac;
    private boolean ad;
    private volatile boolean ae;
    private long af;
    protected final Services j;
    private final NotificationManager ag;
    private long ah;
    public final Thread ai;
    private long aj = SystemUtils.d();
    private long ak = SystemUtils.d();
    private long al;
    private long am = SystemUtils.d();
    private boolean an = false;
    private long ao;
    private boolean ap;
    private final ResourcePackRepository aq;
    private final ScoreboardServer ar = new ScoreboardServer(this);
    @Nullable
    private PersistentCommandStorage as;
    private final BossBattleCustomData at = new BossBattleCustomData();
    private final CustomFunctionData au;
    private boolean av;
    private boolean aw;
    private float ax;
    public final Executor ay;
    @Nullable
    private String az;
    public ReloadableResources aA;
    private final StructureTemplateManager aB;
    private final ServerTickRateManager aC;
    private final ServerDebugSubscribers aD = new ServerDebugSubscribers(this);
    protected SaveData k;
    private WorldData.a aE = WorldData.a.a;
    public PotionBrewer aF;
    private FuelValues aG;
    private int aH;
    private volatile boolean aI;
    private static final AtomicReference<RuntimeException> aJ;
    private final SuppressedExceptionCollector aK = new SuppressedExceptionCollector();
    private final DiscontinuousFrame aL;
    private final PacketProcessor aM;
    public final WorldLoader.a worldLoaderContext;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public static final long startTimeMillis;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    public volatile boolean hasFullyShutdown;
    public volatile boolean abnormalExit;
    public volatile Thread shutdownThread;
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    public static final long SERVER_INIT;
    public boolean lagging = false;
    protected boolean upnp = false;
    public final TickData tickTimes1s = new TickData(TimeUnit.SECONDS.toNanos(1L));
    public final TickData tickTimes5s = new TickData(TimeUnit.SECONDS.toNanos(5L));
    public final TickData tickTimes10s = new TickData(TimeUnit.SECONDS.toNanos(10L));
    public final TickData tickTimes15s = new TickData(TimeUnit.SECONDS.toNanos(15L));
    public final TickData tickTimes1m = new TickData(TimeUnit.MINUTES.toNanos(1L));
    public final TickData tickTimes5m = new TickData(TimeUnit.MINUTES.toNanos(5L));
    public final TickData tickTimes15m = new TickData(TimeUnit.MINUTES.toNanos(15L));
    private final Schedule tickSchedule = new Schedule(0L);
    private long lastTickStart;
    private long currentTickStart;
    private long scheduledTickStart;
    private long taskExecutionTime;
    private final Object statsLock = new Object();
    @Nullable
    private double[] tps;
    @Nullable
    private TickData.MSPTData msptData5s;
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    private final Object stopLock = new Object();
    public final EntityScheduler.EntitySchedulerTickList entitySchedulerTickList = new EntityScheduler.EntitySchedulerTickList();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(m)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTickTime(TickTime time) {
        Object object = this.statsLock;
        synchronized (object) {
            this.tickTimes1s.addDataFrom(time);
            this.tickTimes5s.addDataFrom(time);
            this.tickTimes10s.addDataFrom(time);
            this.tickTimes15s.addDataFrom(time);
            this.tickTimes1m.addDataFrom(time);
            this.tickTimes5m.addDataFrom(time);
            this.tickTimes15m.addDataFrom(time);
            this.clearTickTimeStatistics();
        }
    }

    private void clearTickTimeStatistics() {
        this.msptData5s = null;
        this.tps = null;
    }

    private static double getTPS(TickData tickData, long tickInterval) {
        Double avg = tickData.getTPSAverage(null, tickInterval);
        if (avg == null) {
            return 1.0E9 / (double)tickInterval;
        }
        return avg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getTPS() {
        Object object = this.statsLock;
        synchronized (object) {
            double[] tps = this.tps;
            if (tps == null) {
                this.tps = tps = this.computeTPS();
            }
            return (double[])tps.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TickData.MSPTData getMSPTData5s() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.msptData5s == null) {
                this.msptData5s = this.tickTimes5s.getMSPTData(null, this.aV().h());
            }
            return this.msptData5s;
        }
    }

    public double[] computeTPS() {
        long interval = this.aV().h();
        return new double[]{MinecraftServer.getTPS(this.tickTimes5s, interval), MinecraftServer.getTPS(this.tickTimes1m, interval), MinecraftServer.getTPS(this.tickTimes5m, interval), MinecraftServer.getTPS(this.tickTimes15m, interval)};
    }

    public static <S extends MinecraftServer> S a(Function<Thread, S> threadFunction) {
        MCTypeRegistry.init();
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicReference.get()).C(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, exception) -> m.error("Uncaught exception in server thread", exception));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer minecraftServer = (MinecraftServer)threadFunction.apply(thread);
        atomicReference.set(minecraftServer);
        thread.start();
        return (S)minecraftServer;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.Q()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.n().c()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        m.warn("Performing emergency save...");
        m.info("Saving all players...");
        this.am().h();
        m.info("Saved all players");
        m.info("Saving all worlds...");
        for (WorldServer world : this.Q()) {
            m.info("Saving chunks in world '" + WorldUtil.getWorldName(world) + "'...");
            world.moonrise$issueEmergencySave();
            m.info("Saved chunks in world '" + WorldUtil.getWorldName(world) + "'...");
        }
        m.info("Saved all worlds");
        m.warn("Performed emergency save");
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoaderContext, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer fixerUpper, Services services, LevelLoadListener levelLoadListener) {
        super("Server");
        SERVER = this;
        this.O = worldStem.c();
        this.k = worldStem.d();
        this.i = proxy;
        this.aq = packRepository;
        this.aA = new ReloadableResources(worldStem.a(), worldStem.b());
        this.j = services;
        this.aC = new ServerTickRateManager(this);
        this.g = storageSource;
        this.h = storageSource.g();
        this.L = fixerUpper;
        this.au = new CustomFunctionData(this, this.aA.b.a());
        HolderLookup.b holderGetter = this.O.a().f(Registries.i).a(this.k.J());
        this.aB = new StructureTemplateManager(worldStem.a(), storageSource, fixerUpper, holderGetter);
        this.ai = serverThread;
        this.ay = SystemUtils.h();
        this.aF = PotionBrewer.a(this.k.J());
        this.aA.b.c().a(this.k.J());
        this.aG = FuelValues.a(this.O.a(), this.k.J());
        this.aL = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.ag = new NotificationManager();
        this.aM = new PacketProcessor(serverThread);
        this.options = options;
        this.worldLoaderContext = worldLoaderContext;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paper().configurations();
    }

    private void a(WorldPersistentData dataStorage) {
        dataStorage.a(ScoreboardServer.a);
    }

    protected abstract boolean e() throws IOException;

    public ChunkLoadStatusView a(final int radius) {
        return new ChunkLoadStatusView(){
            @Nullable
            private PlayerChunkMap c;
            private int d;
            private int e;

            @Override
            public void a(ResourceKey<net.minecraft.world.level.World> dimension, ChunkCoordIntPair chunkPos) {
                WorldServer level = MinecraftServer.this.a(dimension);
                this.c = level != null ? level.n().a : null;
                this.d = chunkPos.h;
                this.e = chunkPos.i;
            }

            @Override
            @Nullable
            public ChunkStatus a(int x2, int z2) {
                return this.c == null ? null : this.c.c(ChunkCoordIntPair.c(x2 + this.d - radius, z2 + this.e - radius));
            }

            @Override
            public int a() {
                return radius;
            }
        };
    }

    protected void loadLevel(String levelId) {
        boolean flag = !JvmProfiler.f.c() && SharedConstants.aB && JvmProfiler.f.a(Environment.a(this));
        ProfiledDuration profiledDuration = JvmProfiler.f.e();
        PaperWorldLoader loader = PaperWorldLoader.create(this, levelId);
        loader.loadInitialWorlds();
        if (profiledDuration != null) {
            profiledDuration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable var4) {
                m.warn("Failed to stop JFR profiling", var4);
            }
        }
    }

    protected void initPostWorld() {
        ScoreboardServer scoreboard = this.aO();
        Collection toRemove = scoreboard.f().stream().filter(team -> team.c().startsWith("collideRule_")).map(ScoreboardTeam::c).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.am().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.am().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        this.server.getCommandMap().registerServerAliases();
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    protected void v() {
    }

    public void createLevel(WorldDimension levelStem, PaperWorldLoader.WorldLoadingInfo loadingInfo, Convertable.ConversionSession levelStorageAccess, WorldDataServer serverLevelData) {
        WorldServer serverLevel;
        WorldOptions worldOptions = serverLevelData.x();
        long seed = worldOptions.c();
        long l2 = BiomeManager.a(seed);
        ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(serverLevelData));
        ChunkGenerator chunkGenerator = this.server.getGenerator(loadingInfo.name());
        BiomeProvider biomeProvider = this.server.getBiomeProvider(loadingInfo.name());
        CraftWorldInfo worldInfo = new CraftWorldInfo(serverLevelData, levelStorageAccess, World.Environment.getEnvironment((int)loadingInfo.dimension()), levelStem.a().a(), levelStem.b(), this.bg());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey<net.minecraft.world.level.World> dimensionKey = ResourceKey.a(Registries.bx, loadingInfo.stemKey().a());
        if (loadingInfo.stemKey() == WorldDimension.b) {
            serverLevel = new WorldServer(this, this.ay, levelStorageAccess, serverLevelData, dimensionKey, levelStem, serverLevelData.z(), l2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
            this.k = serverLevelData;
            this.k.a(((DedicatedServer)this).a().n.get());
            WorldPersistentData dataStorage = serverLevel.y();
            this.a(dataStorage);
            this.as = new PersistentCommandStorage(dataStorage);
            this.server.scoreboardManager = new CraftScoreboardManager(this, serverLevel.g());
        } else {
            ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && levelStem.a().a(BuiltinDimensionTypes.a) ? list : Collections.emptyList();
            serverLevel = new WorldServer(this, this.ay, levelStorageAccess, serverLevelData, dimensionKey, levelStem, this.k.z(), l2, (List<MobSpawner>)spawners, true, this.O().R(), World.Environment.getEnvironment((int)loadingInfo.dimension()), chunkGenerator, biomeProvider);
        }
        this.addLevel(serverLevel);
        this.initWorld(serverLevel, serverLevelData, worldOptions);
    }

    public void initWorld(WorldServer serverLevel, WorldDataServer serverLevelData, WorldOptions worldOptions) {
        boolean isDebugWorld = this.k.z();
        if (serverLevel.generator != null) {
            serverLevel.getWorld().getPopulators().addAll(serverLevel.generator.getDefaultPopulators((World)serverLevel.getWorld()));
        }
        this.initWorldBorder(serverLevelData, serverLevel);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)serverLevel.getWorld()));
        if (!serverLevelData.m()) {
            try {
                MinecraftServer.a(serverLevel, serverLevelData, worldOptions.e(), isDebugWorld, serverLevel.levelLoadListener);
                serverLevelData.c(true);
                if (isDebugWorld) {
                    this.a(this.k);
                }
            }
            catch (Throwable var27) {
                CrashReport crashReport = CrashReport.a(var27, "Exception initializing level");
                try {
                    serverLevel.a(crashReport);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            serverLevelData.c(true);
        }
        GlobalPos globalPos = this.x();
        serverLevel.levelLoadListener.a(globalPos.a(), new ChunkCoordIntPair(globalPos.b()));
        if (serverLevelData.D() != null) {
            this.aR().a(serverLevelData.D(), this.bg());
        }
    }

    private void initWorldBorder(WorldDataServer serverLevelData, WorldServer serverLevel) {
        WorldServer serverLevel1 = serverLevel;
        Optional<WorldBorder.c> legacyWorldBorderSettings = serverLevelData.o();
        if (legacyWorldBorderSettings.isPresent()) {
            WorldBorder.c settings = legacyWorldBorderSettings.get();
            WorldPersistentData dataStorage1 = serverLevel1.y();
            if (dataStorage1.b(WorldBorder.d) == null) {
                double coordinateScale = serverLevel1.H_().k();
                WorldBorder.c settings1 = new WorldBorder.c(settings.b() / coordinateScale, settings.c() / coordinateScale, settings.d(), settings.e(), settings.f(), settings.g(), settings.h(), settings.i(), settings.j());
                dataStorage1.a(WorldBorder.d, settings1.a());
            }
            serverLevelData.a(Optional.empty());
        }
        serverLevel.u().world = serverLevel;
        serverLevel.u().a(this.ay());
        this.am().a(serverLevel);
    }

    private static void a(WorldServer level, IWorldDataServer levelData, boolean generateBonusChest, boolean debug, LevelLoadListener levelLoadListener) {
        if (SharedConstants.aE && SharedConstants.aU) {
            levelData.a(WorldData.a.a(level.al(), new BlockPosition(0, 64, -100), 0.0f, 0.0f));
        } else if (debug) {
            levelData.a(WorldData.a.a(level.al(), BlockPosition.c.b(80), 0.0f, 0.0f));
        } else {
            ChunkProviderServer chunkSource = level.n();
            if (level.generator != null) {
                Random rand = new Random(level.H());
                Location spawn = level.generator.getFixedSpawnLocation((World)level.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != level.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + levelData.d() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    levelData.a(new WorldData.a(GlobalPos.a(level.al(), new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ())), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkSource.i().b().a());
            levelLoadListener.a(LevelLoadListener.a.b, 0);
            levelLoadListener.a(level.al(), chunkPos);
            int spawnHeight = chunkSource.g().a(level);
            if (spawnHeight < level.M_()) {
                BlockPosition worldPosition = chunkPos.l();
                spawnHeight = level.a(HeightMap.Type.b, worldPosition.u() + 8, worldPosition.w() + 8);
            }
            levelData.a(WorldData.a.a(level.al(), chunkPos.l().b(8, spawnHeight, 8), 0.0f, 0.0f));
            int i2 = 0;
            int i1 = 0;
            int i22 = 0;
            int i3 = -1;
            for (int i4 = 0; i4 < MathHelper.i(11); ++i4) {
                BlockPosition spawnPosInChunk;
                if (i2 >= -5 && i2 <= 5 && i1 >= -5 && i1 <= 5 && (spawnPosInChunk = PlayerSpawnFinder.a(level, new ChunkCoordIntPair(chunkPos.h + i2, chunkPos.i + i1))) != null) {
                    levelData.a(WorldData.a.a(level.al(), spawnPosInChunk, 0.0f, 0.0f));
                    break;
                }
                if (i2 == i1 || i2 < 0 && i2 == -i1 || i2 > 0 && i2 == 1 - i1) {
                    int i5 = i22;
                    i22 = -i3;
                    i3 = i5;
                }
                i2 += i22;
                i1 += i3;
            }
            if (generateBonusChest) {
                level.L_().a(Registries.aS).flatMap(registry -> registry.a(MiscOverworldFeatures.m)).ifPresent(holder -> ((WorldGenFeatureConfigured)holder.a()).a(level, chunkSource.g(), level.z, levelData.a().b()));
            }
            levelLoadListener.a(LevelLoadListener.a.b);
        }
    }

    private void a(SaveData worldData) {
        worldData.a(EnumDifficulty.a);
        worldData.d(true);
        IWorldDataServer serverLevelData = worldData.H();
        serverLevelData.b(false);
        serverLevelData.a(false);
        serverLevelData.a(1000000000);
        serverLevelData.b(6000L);
        serverLevelData.a(EnumGamemode.d);
    }

    public void prepareLevel(WorldServer serverLevel) {
        this.forceTicks = true;
        ChunkLoadCounter chunkLoadCounter = new ChunkLoadCounter();
        chunkLoadCounter.a(serverLevel, () -> {
            TicketStorage ticketStorage = serverLevel.y().b(TicketStorage.b);
            if (ticketStorage != null) {
                ticketStorage.a();
            }
        });
        serverLevel.levelLoadListener.a(LevelLoadListener.a.c, chunkLoadCounter.c());
        do {
            serverLevel.levelLoadListener.a(LevelLoadListener.a.c, chunkLoadCounter.a(), chunkLoadCounter.c());
            this.executeModerately();
        } while (chunkLoadCounter.b() > 0);
        serverLevel.levelLoadListener.a(LevelLoadListener.a.c);
        serverLevel.b(serverLevel.J.p() != EnumDifficulty.a && serverLevel.S().c(GameRules.ag));
        this.bM();
        this.forceTicks = false;
        new WorldLoadEvent((World)serverLevel.getWorld()).callEvent();
    }

    protected GlobalPos x() {
        return this.k.H().a().c();
    }

    public EnumGamemode y() {
        return this.k.j();
    }

    public boolean w_() {
        return this.k.k();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag = false;
        for (WorldServer serverLevel : this.Q()) {
            if (!suppressLogs) {
                m.info("Saving chunks for level '{}'/{}", (Object)serverLevel, (Object)serverLevel.al().a());
            }
            serverLevel.save(null, flush, SharedConstants.af || serverLevel.e && !force, close);
            flag = true;
        }
        if (flush) {
            for (WorldServer serverLevel : this.Q()) {
                m.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)serverLevel.n().a.l());
            }
            m.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean var4;
        try {
            this.aI = true;
            this.am().h();
            var4 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aI = false;
        }
        return var4;
    }

    @Override
    public void close() {
        this.z();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void z() {
        Iterator<WorldServer> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        this.aM.close();
        if (this.A.e()) {
            this.bc();
        }
        m.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        if (this.upnp) {
            if (UPnP4J.close((int)this.W(), (Protocol)Protocol.TCP)) {
                m.info("[UPnP] Port {} closed", (Object)this.W());
            } else {
                m.error("[UPnP] Failed to close port {}", (Object)this.W());
            }
        }
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.an().b();
        this.aI = true;
        if (this.Q != null) {
            m.info("Saving players");
            this.Q.h();
            this.Q.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m.info("Saving worlds");
        for (WorldServer serverLevel : this.Q()) {
            if (serverLevel == null) continue;
            serverLevel.e = false;
        }
        for (WorldServer world : this.Q()) {
            world.n().q();
        }
        this.saveAllChunks(false, true, false, true);
        this.aI = false;
        this.aA.close();
        try {
            this.g.close();
        }
        catch (IOException var4) {
            m.error("Failed to unlock level {}", (Object)this.g.f(), (Object)var4);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            m.info("Saving usercache.json");
            this.av().f().save(false);
        }
        m.info("Waiting for all RegionFile I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        m.info("All RegionFile I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        SystemUtils.k();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.i();
    }

    public String A() {
        return this.M;
    }

    @Override
    public void a_(String localIp) {
        this.M = localIp;
    }

    public boolean B() {
        return this.R;
    }

    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        BossBarTask.stopAll();
        BeehiveTask.instance().unregister();
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.R = false;
        if (waitForShutdown) {
            try {
                this.ai.join();
            }
            catch (InterruptedException var3) {
                m.error("Error while shutting down", (Throwable)var3);
            }
        }
    }

    private void initTickSchedule() {
        long interval = this.J() || !this.aC.a() ? this.aC.h() : 0L;
        this.tickSchedule.setNextPeriod(this.am, interval);
        this.lastTickStart = Long.MIN_VALUE;
        this.scheduledTickStart = this.tickSchedule.getDeadline(interval);
    }

    private void recordEndOfTick() {
        long prevStart = this.lastTickStart;
        long currStart = this.currentTickStart;
        this.lastTickStart = this.currentTickStart;
        long scheduledStart = this.scheduledTickStart;
        this.scheduledTickStart = this.am;
        long now = SystemUtils.d();
        TickTime time = new TickTime(prevStart, scheduledStart, currStart, 0L, now, 0L, this.taskExecutionTime, 0L, false);
        this.taskExecutionTime = 0L;
        this.addTickTime(time);
    }

    private void runAllTasksAtTickStart() {
        this.bD();
        GameProfilerFiller profiler = Profiler.a();
        profiler.a("moonrise:run_all_tasks");
        profiler.a("moonrise:run_all_server");
        while (super.G()) {
            this.moonrise$executeMidTickTasks();
            this.aM.executeSinglePacket();
        }
        profiler.b("moonrise:run_all_packets");
        while (this.aM.executeSinglePacket()) {
            this.moonrise$executeMidTickTasks();
        }
        profiler.b("moonrise:run_all_chunk");
        for (WorldServer world : this.Q()) {
            profiler.a(world.toString() + " " + String.valueOf(world.al().a()));
            profiler.a("moonrise:distance_manager_update");
            world.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
            profiler.b("moonrise:legacy_chunk_tasks");
            world.n().g.executeAllRecentInternalTasks();
            profiler.b("moonrise:chunk_system_tasks");
            world.moonrise$getChunkTaskScheduler().executeAllRecentlyQueuedMainThreadTasks();
            profiler.c();
            profiler.c();
        }
        profiler.c();
        profiler.c();
        this.bE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTaskExecutionTimeWhileWaiting() {
        GameProfilerFiller profiler = Profiler.a();
        profiler.a("moonrise:execute_tasks_until_tick");
        this.an = true;
        boolean isLoggingEnabled = this.g();
        try {
            long deadline = this.am;
            while (true) {
                long start;
                if ((start = SystemUtils.d()) - deadline >= 0L) {
                } else {
                    while (this.G() && SystemUtils.d() - deadline < 0L) {
                    }
                    long now = SystemUtils.d();
                    this.taskExecutionTime += now - start;
                    long toWait = deadline - now;
                    if (toWait > 0L) {
                        LockSupport.parkNanos("waiting for tick or tasks", toWait);
                        if (!isLoggingEnabled) continue;
                        this.al += SystemUtils.d() - now;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.an = false;
        }
        profiler.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void C() {
        try {
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.am = SystemUtils.d();
            this.initTickSchedule();
            this.J = this.bH().orElse(null);
            this.I = this.bK();
            this.server.spark.enableBeforePlugins();
            m.info("Running delayed init tasks");
            new RegionizedServerInitEvent().callEvent();
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - Main.BOOT_TIME.toEpochMilli();
            m.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            if (GlobalConfiguration.isFirstStart) {
                m.info("*************************************************************************************");
                m.info("This is the first time you're starting this server.");
                m.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                m.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                m.info("*************************************************************************************");
            }
            if (!Boolean.getBoolean("Purpur.IReallyDontWantStartupCommands") && !PurpurConfig.startupCommands.isEmpty()) {
                m.info("Purpur: Running startup commands specified in purpur.yml.");
                for (String startupCommand : PurpurConfig.startupCommands) {
                    m.info("Purpur: Running the following command: \"{}\"", (Object)startupCommand);
                    ((DedicatedServer)this).a(startupCommand, this.aK());
                }
            }
            while (this.R) {
                boolean flag;
                long l2;
                long tickStart = System.nanoTime();
                if (!this.J() && this.aC.a() && this.aC.d()) {
                    l2 = 0L;
                    this.tickSchedule.setNextPeriod(tickStart, l2);
                } else {
                    l2 = this.aC.h();
                    long ticksBehind = Math.max(1L, this.tickSchedule.getPeriodsAhead(l2, tickStart));
                    long catchup = Math.max(1, PurpurConfig.tpsCatchup ? 5 : 1);
                    boolean bl = this.lagging = this.getTPS()[0] < PurpurConfig.laggingThreshold;
                    if (ticksBehind > catchup) {
                        long difference = ticksBehind - catchup;
                        this.tickSchedule.advanceBy(difference, l2);
                    }
                    this.tickSchedule.advanceBy(1L, l2);
                }
                this.af = this.am = this.tickSchedule.getDeadline(l2);
                this.currentTickStart = tickStart;
                ++currentTick;
                boolean bl = flag = l2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new TimeProfiler(SystemUtils.d(), this.T);
                }
                try (Profiler.a scope = Profiler.a(this.bU());){
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("tick");
                    this.aL.start();
                    this.runAllTasksAtTickStart();
                    this.a(flag ? () -> false : this::bF);
                    Throwable crash = this.chunkSystemCrash;
                    if (crash != null) {
                        this.chunkSystemCrash = null;
                        throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                    }
                    this.aL.end();
                    this.recordEndOfTick();
                    profilerFiller.b("nextTickWait");
                    this.ap = true;
                    this.ao = Math.max(SystemUtils.d() + l2, this.am);
                    this.bD();
                    this.recordTaskExecutionTimeWhileWaiting();
                    this.bE();
                    if (flag) {
                        this.aC.e();
                    }
                    profilerFiller.c();
                    this.bC();
                }
                finally {
                    this.aY();
                }
                this.ae = true;
                JvmProfiler.f.a(this.ax);
            }
        }
        catch (Throwable var69) {
            m.error("Encountered an unexpected exception", var69);
            CrashReport crashReport = MinecraftServer.b(var69);
            this.b(crashReport.f());
            Path path = this.I().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashReport.a(path, ReportType.a)) {
                m.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                m.error("We were unable to save this crash report to disk.");
            }
            this.a(crashReport);
        }
        finally {
            try {
                this.S = true;
                this.z();
            }
            catch (Throwable var64) {
                m.error("Exception stopping the server", var64);
            }
        }
    }

    private void bC() {
        long nanos = SystemUtils.d();
        if (this.g()) {
            this.f().a(nanos - this.aj);
        }
        this.aj = nanos;
    }

    private void bD() {
        if (this.g()) {
            this.ak = SystemUtils.d();
            this.al = 0L;
        }
    }

    private void bE() {
        if (this.g()) {
            SampleLogger tickTimeLogger = this.f();
            tickTimeLogger.a(SystemUtils.d() - this.ak - this.al, TpsDebugDimensions.c.ordinal());
            tickTimeLogger.a(this.al, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport b(Throwable cause) {
        CrashReport report;
        ReportedException reportedException = null;
        for (Throwable throwable = cause; throwable != null; throwable = throwable.getCause()) {
            ReportedException reportedException1;
            if (!(throwable instanceof ReportedException)) continue;
            reportedException = reportedException1 = (ReportedException)throwable;
        }
        if (reportedException != null) {
            report = reportedException.a();
            if (reportedException != cause) {
                report.a("Wrapped in").a("Wrapping exception", cause);
            }
        } else {
            report = new CrashReport("Exception in server tick loop", cause);
        }
        return report;
    }

    private boolean bF() {
        return this.forceTicks || this.bT() || SystemUtils.d() < (this.ap ? this.ao : this.am);
    }

    private void executeModerately() {
        this.bR();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean D() {
        RuntimeException runtimeException = aJ.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return true;
    }

    public static void a(RuntimeException fatalException) {
        aJ.compareAndSet(null, fatalException);
    }

    @Override
    public void b(BooleanSupplier isDone) {
        super.b(() -> MinecraftServer.D() && isDone.getAsBoolean());
    }

    public NotificationManager E() {
        return this.ag;
    }

    protected void x_() {
        GameProfilerFiller profilerFiller = Profiler.a();
        this.an = true;
        try {
            this.b(() -> SystemUtils.d() - this.am >= 0L);
        }
        finally {
            this.an = false;
        }
    }

    @Override
    public void F() {
        boolean isTickTimeLoggingEnabled = this.g();
        long l2 = isTickTimeLoggingEnabled ? SystemUtils.d() : 0L;
        long l1 = this.an ? this.am - SystemUtils.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", l1);
        if (isTickTimeLoggingEnabled) {
            this.al += SystemUtils.d() - l2;
        }
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.T, runnable);
    }

    protected boolean a(TickTask runnable) {
        return runnable.a() + 1 < this.T || this.bF();
    }

    @Override
    public boolean G() {
        boolean flag;
        this.ap = flag = this.aM.executeSinglePacket() | this.bG();
        return flag;
    }

    private boolean bG() {
        if (super.G()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.aC.a() || this.bS() || this.bF()) {
            for (WorldServer serverLevel : this.Q()) {
                if (!serverLevel.n().c()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask task) {
        Profiler.a().f("runTask");
        super.d(task);
    }

    private Optional<ServerPing.a> bH() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.j().filter(path -> Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new ServerPing.a(byteArrayOutputStream.toByteArray()));
            }
            catch (Exception var3) {
                m.error("Couldn't load server icon", (Throwable)var3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> H() {
        return this.g.j();
    }

    public Path I() {
        return Path.of("", new String[0]);
    }

    public void a(CrashReport report) {
    }

    public void i() {
    }

    public boolean J() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BooleanSupplier hasTimeLeft) {
        WatchdogThread.tick();
        long nanos = SystemUtils.d();
        int i2 = this.by() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (i2 > 0) {
            this.aH = this.Q.m() == 0 && !this.aC.a() && this.pluginsBlockingSleep.isEmpty() ? ++this.aH : 0;
            if (this.aH >= i2) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.aH == i2) {
                    m.info("Server empty for {} seconds, pausing", (Object)this.by());
                    this.bI();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (WorldServer level : this.P.values()) {
                    level.n().a(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.L();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.currentTickStart) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.T + 1).callEvent();
        ++this.T;
        this.aC.m();
        this.c(hasTimeLeft);
        if (nanos - this.ah >= t) {
            this.ah = nanos;
            this.I = this.bK();
        }
        --this.U;
        GameProfilerFiller profiler = Profiler.a();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.T % this.autosavePeriod == 0;
        try {
            this.aI = true;
            if (playerSaveInterval > 0) {
                this.Q.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.Q()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aI = false;
        }
        profiler.c();
        GameProfilerFiller profilerFiller = Profiler.a();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = this.am - endTime;
        new ServerTickEndEvent(this.T, (double)(endTime - this.currentTickStart) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.currentTickStart) / 1000000.0);
        profilerFiller.a("tallying");
        long l2 = SystemUtils.d() - nanos;
        int i1 = this.T % 100;
        this.aa -= this.Z[i1];
        this.aa += l2;
        this.Z[i1] = l2;
        this.ax = this.ax * 0.8f + (float)l2 / (float)TimeRange.b * 0.19999999f;
        this.a(nanos);
        profilerFiller.c();
    }

    private void bI() {
        this.U = this.autosavePeriod;
        m.debug("Autosave started");
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("save");
        this.b(true, false, false);
        profilerFiller.c();
        m.debug("Autosave finished");
    }

    private void a(long startTime) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - startTime, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bJ() {
        float f2;
        if (this.aC.a()) {
            long l2 = this.aW() + 1L;
            f2 = (float)TimeRange.a / (float)l2;
        } else {
            f2 = this.aC.f();
        }
        int i2 = 300;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void K() {
        int i2 = this.bJ();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bK() {
        ServerPing.ServerPingPlayerSample players = this.bL();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(players), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.J), this.aC());
    }

    private ServerPing.ServerPingPlayerSample bL() {
        List<EntityPlayer> players = this.Q.t();
        int maxPlayers = this.t();
        if (this.as()) {
            return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), List.of());
        }
        int min = Math.min(players.size(), SpigotConfig.playerSample);
        ObjectArrayList list = new ObjectArrayList(min);
        int randomInt = MathHelper.a(this.K, 0, players.size() - min);
        for (int i2 = 0; i2 < min; ++i2) {
            EntityPlayer serverPlayer = players.get(randomInt + i2);
            list.add((Object)(serverPlayer.aa() ? serverPlayer.gA() : f));
        }
        SystemUtils.c(list, this.K);
        return new ServerPing.ServerPingPlayerSample(maxPlayers, players.size(), (List<NameAndId>)list);
    }

    protected void c(BooleanSupplier hasTimeLeft) {
        GameProfilerFiller profilerFiller = Profiler.a();
        this.am().t().forEach(serverPlayer1 -> serverPlayer1.g.f());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        for (EntityScheduler scheduler : this.entitySchedulerTickList.getAllSchedulers()) {
            if (scheduler.isRetired()) continue;
            scheduler.executeTick();
        }
        ClickCallbackProviderImpl.ADVENTURE_CLICK_MANAGER.handleQueue(this.T);
        ClickCallbackProviderImpl.DIALOG_CLICK_MANAGER.handleQueue(this.T);
        profilerFiller.a("commandFunctions");
        this.aG().b();
        profilerFiller.b("levels");
        this.bM();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (WorldServer level : this.Q()) {
            boolean doDaylight = level.S().c(GameRules.m);
            long dayTime = level.ah();
            long worldTime = level.ag();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level.C()) {
                if (!(entityHuman instanceof EntityPlayer) || !level.isForceTime() && (this.T + entityHuman.az()) % 20 != 0) continue;
                EntityPlayer entityplayer = (EntityPlayer)entityHuman;
                long playerTime = entityplayer.getPlayerTime();
                boolean relativeTime = entityplayer.relativeTime;
                PacketPlayOutUpdateTime packet = (relativeTime || !doDaylight) && playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, relativeTime && doDaylight);
                entityplayer.g.b(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (WorldServer serverLevel : this.Q()) {
            serverLevel.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            serverLevel.updateLagCompensationTick();
            TileEntityHopper.skipHopperEvents = serverLevel.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            serverLevel.hasRidableMoveEvent = RidableMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            profilerFiller.a(() -> String.valueOf(serverLevel) + " " + String.valueOf(serverLevel.al().a()));
            profilerFiller.a("tick");
            try {
                serverLevel.a(hasTimeLeft);
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.a(var7, "Exception ticking world");
                serverLevel.a(crashReport);
                throw new ReportedException(crashReport);
            }
            profilerFiller.c();
            profilerFiller.c();
            serverLevel.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        profilerFiller.b("connection");
        this.L();
        profilerFiller.b("players");
        this.Q.d();
        profilerFiller.b("debugSubscribers");
        this.aD.a();
        if (this.aC.i()) {
            profilerFiller.b("gameTests");
            GameTestHarnessTicker.a.b();
        }
        profilerFiller.b("server gui refresh");
        for (int i2 = 0; i2 < this.z.size(); ++i2) {
            this.z.get(i2).run();
        }
        profilerFiller.b("send chunks");
        for (EntityPlayer serverPlayer : this.Q.t()) {
            serverPlayer.g.g.a(serverPlayer);
            serverPlayer.g.g();
        }
        profilerFiller.c();
    }

    public void bM() {
        WorldServer serverLevel = this.aL();
        WorldData.a respawnData = serverLevel.J.a();
        respawnData = respawnData.withLevel(serverLevel.al());
        this.aE = serverLevel.b(respawnData);
    }

    public void L() {
        this.an().c();
    }

    private void a(WorldServer level) {
        this.Q.a(new PacketPlayOutUpdateTime(level.ag(), level.ah(), level.S().c(GameRules.m)), level.al());
    }

    public void M() {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("timeSync");
        for (WorldServer serverLevel : this.Q()) {
            this.a(serverLevel);
        }
        profilerFiller.c();
    }

    public boolean a(net.minecraft.world.level.World level) {
        return level.al() != net.minecraft.world.level.World.i || this.aQ().c(GameRules.af);
    }

    public void b(Runnable tickable) {
        this.z.add(tickable);
    }

    protected void b(String serverId) {
        this.az = serverId;
    }

    public boolean N() {
        return !this.ai.isAlive();
    }

    public Path c(String path) {
        return this.I().resolve(path);
    }

    public final WorldServer O() {
        return this.P.get(net.minecraft.world.level.World.h);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> dimension) {
        return this.P.get(dimension);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.al(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.al());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> P() {
        return this.P.keySet();
    }

    public Iterable<WorldServer> Q() {
        return this.P.values();
    }

    @Override
    public String R() {
        return SharedConstants.b().c();
    }

    @Override
    public int S() {
        return this.Q.m();
    }

    public String[] T() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return PurpurConfig.serverModName;
    }

    public SystemReport b(SystemReport systemReport) {
        systemReport.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            systemReport.a("Player Count", () -> this.Q.m() + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t()));
        }
        systemReport.a("Active Data Packs", () -> ResourcePackRepository.a(this.aq.g()));
        systemReport.a("Available Data Packs", () -> ResourcePackRepository.a(this.aq.d()));
        systemReport.a("Enabled Feature Flags", () -> FeatureFlags.e.b(this.k.J()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        systemReport.a("World Generation", () -> this.k.A().toString());
        systemReport.a("World Seed", () -> String.valueOf(this.k.x().c()));
        systemReport.a("Suppressed Exceptions", this.aK::a);
        if (this.az != null) {
            systemReport.a("Server Id", () -> this.az);
        }
        return this.a(systemReport);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck U() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        m.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair V() {
        return this.ab;
    }

    public int W() {
        return this.N;
    }

    public void b(int port) {
        this.N = port;
    }

    @Nullable
    public GameProfile X() {
        return this.ac;
    }

    public void a(@Nullable GameProfile singleplayerProfile) {
        this.ac = singleplayerProfile;
    }

    public boolean Y() {
        return this.ac != null;
    }

    protected void Z() {
        m.info("Generating keypair");
        try {
            this.ab = MinecraftEncryption.b();
        }
        catch (CryptographyException var2) {
            throw new IllegalStateException("Failed to generate key pair", var2);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, @Nullable CommandListenerWrapper source, boolean forced) {
        WorldDataServer worldData = level.J;
        if (forced || !worldData.q()) {
            new WorldDifficultyChangeEvent((World)level.getWorld(), (CommandSourceStack)source, CraftDifficulty.toBukkit(difficulty)).callEvent();
            worldData.a(worldData.k() ? EnumDifficulty.d : difficulty);
            level.b(worldData.p() != EnumDifficulty.a && level.S().c(GameRules.ag));
        }
    }

    public int c(int trackingDistance) {
        return trackingDistance;
    }

    public void aa() {
        for (WorldServer serverLevel : this.Q()) {
            serverLevel.b(this.ab());
        }
    }

    public void b(boolean locked) {
        this.k.d(locked);
        this.am().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData levelData = player.A().F_();
        player.g.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
    }

    public boolean ab() {
        return this.k.p() != EnumDifficulty.a && this.aQ().c(GameRules.f) && this.aQ().c(GameRules.ag);
    }

    public boolean ac() {
        return this.ad;
    }

    public void c(boolean demo) {
        this.ad = demo;
    }

    public Map<String, String> ad() {
        return Map.of();
    }

    public Optional<ServerResourcePackInfo> ae() {
        return Optional.empty();
    }

    public boolean af() {
        return this.ae().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean ag() {
        return this.V;
    }

    @Override
    public void d(boolean online) {
        this.V = online;
    }

    public boolean ah() {
        return this.W;
    }

    public void e(boolean preventProxyConnections) {
        this.W = preventProxyConnections;
    }

    public abstract boolean p();

    @DoNotUse
    @Deprecated(forRemoval=true)
    public boolean ai() {
        return this.aQ().c(GameRules.ae);
    }

    public boolean aj() {
        return true;
    }

    public boolean y_() {
        return this.aQ().c(GameRules.ah);
    }

    public boolean r() {
        return this.aQ().c(GameRules.ai);
    }

    @Override
    public String ak() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean al() {
        return this.S;
    }

    public PlayerList am() {
        return this.Q;
    }

    public void a(PlayerList list) {
        this.Q = list;
    }

    public abstract boolean s();

    public void a(EnumGamemode gameMode) {
        this.k.a(gameMode);
    }

    public int b(@Nullable EnumGamemode gameMode) {
        if (gameMode == null) {
            return 0;
        }
        int i2 = 0;
        for (EntityPlayer serverPlayer : this.am().t()) {
            PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null);
            if (event == null || event.isCancelled()) continue;
            ++i2;
        }
        return i2;
    }

    public ServerConnection an() {
        return this.G == null ? (this.G = new ServerConnection(this)) : this.G;
    }

    public boolean ao() {
        return this.ae;
    }

    public boolean ap() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean commands, int port) {
        return false;
    }

    public int aq() {
        return this.T;
    }

    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean ar() {
        return true;
    }

    public boolean as() {
        return false;
    }

    public Proxy at() {
        return this.i;
    }

    public int au() {
        return this.Y;
    }

    @Override
    public void d(int idleTimeout) {
        this.Y = idleTimeout;
    }

    public Services av() {
        return this.j;
    }

    @Nullable
    public ServerPing aw() {
        return this.I;
    }

    public void ax() {
        this.ah = 0L;
    }

    public int ay() {
        return 29999984;
    }

    @Override
    public boolean az() {
        return super.az() && !this.al();
    }

    @Override
    public void c(Runnable task) {
        if (this.al()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(task);
    }

    @Override
    public Thread aA() {
        return this.ai;
    }

    public int aB() {
        return 256;
    }

    public boolean aC() {
        return false;
    }

    public long aD() {
        return this.am;
    }

    public DataFixer aE() {
        return this.L;
    }

    public AdvancementDataWorld aF() {
        return this.aA.b.e();
    }

    public CustomFunctionData aG() {
        return this.au;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> selectedIds) {
        return this.reloadResources(selectedIds, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> selectedIds, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)selectedIds.stream().map(this.aq::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList()), this).thenCompose(list -> {
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)list);
            List<IRegistry.a<?>> list1 = TagDataPack.loadTagsForExistingRegistries(closeableResourceManager, this.O.a(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, this.O, list1, this.k.J(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.ay, this).whenComplete((reloadableServerResources, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApply(reloadableServerResources -> new ReloadableResources(closeableResourceManager, (DataPackResources)reloadableServerResources));
        })).thenAcceptAsync(reloadableResources -> {
            PaperBrigadier.moveBukkitCommands(this.aA.b().d(), reloadableResources.b().d);
            this.aA.close();
            this.aA = reloadableResources;
            this.aq.setSelected(selectedIds, false);
            WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(MinecraftServer.a(this.aq, true), this.k.J());
            this.k.a(worldDataConfiguration);
            this.aA.b.g();
            this.aA.b.c().a(this.k.J());
            this.aF = this.aF.reload(this.k.J());
            if (Thread.currentThread() != this.ai) {
                return;
            }
            for (EntityPlayer player : this.am().t()) {
                player.U().b();
            }
            this.am().u();
            this.au.a(this.aA.b.a());
            this.aB.a(this.aA.a);
            this.aG = FuelValues.a(this.O.a(), this.k.J());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bO()) {
            this.b(((CompletableFuture)completableFuture)::isDone);
        }
        return completableFuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean initMode, boolean safeMode) {
        DataPackConfiguration dataPackConfig = initialDataConfig.a();
        FeatureFlagSet featureFlagSet = initMode ? FeatureFlagSet.a() : initialDataConfig.b();
        FeatureFlagSet featureFlagSet1 = initMode ? FeatureFlags.e.a() : initialDataConfig.b();
        packRepository.reload(true);
        if (safeMode) {
            return MinecraftServer.a(packRepository, List.of(b), featureFlagSet, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String string : dataPackConfig.a()) {
            if (packRepository.d(string)) {
                set.add(string);
                continue;
            }
            m.warn("Missing data pack {}", (Object)string);
        }
        for (ResourcePackLoader pack : packRepository.d()) {
            String id = pack.g();
            if (dataPackConfig.b().contains(id)) continue;
            FeatureFlagSet requestedFeatures = pack.e();
            boolean flag = set.contains(id);
            if (!flag && pack.l().a()) {
                if (requestedFeatures.a(featureFlagSet1)) {
                    m.info("Found new data pack {}, loading it automatically", (Object)id);
                    set.add(id);
                } else {
                    m.info("Found new data pack {}, but can't load it due to missing features {}", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
                }
            }
            if (!flag || requestedFeatures.a(featureFlagSet1)) continue;
            m.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)id, (Object)FeatureFlags.a(featureFlagSet1, requestedFeatures));
            set.remove(id);
        }
        if (set.isEmpty()) {
            m.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(packRepository, set, featureFlagSet, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository packRepository, Collection<String> selectedPacks, FeatureFlagSet enabledFeatures, boolean safeMode) {
        packRepository.setSelected(selectedPacks, true);
        MinecraftServer.a(packRepository, enabledFeatures);
        DataPackConfiguration selectedPacks1 = MinecraftServer.a(packRepository, safeMode);
        FeatureFlagSet featureFlagSet = packRepository.f().c(enabledFeatures);
        return new WorldDataConfiguration(selectedPacks1, featureFlagSet);
    }

    private static void a(ResourcePackRepository packRepository, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet requestedFeatureFlags = packRepository.f();
        FeatureFlagSet featureFlagSet = enabledFeatures.d(requestedFeatureFlags);
        if (!featureFlagSet.b()) {
            ObjectArraySet set = new ObjectArraySet(packRepository.e());
            for (ResourcePackLoader pack : packRepository.d()) {
                if (featureFlagSet.b()) break;
                if (pack.l() != PackSource.d) continue;
                String id = pack.g();
                FeatureFlagSet requestedFeatures = pack.e();
                if (requestedFeatures.b() || !requestedFeatures.b(featureFlagSet) || !requestedFeatures.a(enabledFeatures)) continue;
                if (!set.add(id)) {
                    throw new IllegalStateException("Tried to force '" + id + "', but it was already enabled");
                }
                m.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)id);
                featureFlagSet = featureFlagSet.d(requestedFeatures);
            }
            packRepository.setSelected((Collection<String>)set, true);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository packRepository, boolean safeMode) {
        Collection<String> selectedIds = packRepository.e();
        ImmutableList list = ImmutableList.copyOf(selectedIds);
        List<String> list1 = safeMode ? packRepository.c().stream().filter(packId -> !selectedIds.contains(packId)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    public void aH() {
        if (this.aS() && this.aT()) {
            PlayerList playerList = this.am();
            WhiteList whiteList = playerList.i();
            for (EntityPlayer serverPlayer : Lists.newArrayList(playerList.t())) {
                if (whiteList.a(serverPlayer.gA()) || this.am().f(serverPlayer.gA())) continue;
                serverPlayer.g.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aI() {
        return this.aq;
    }

    public CommandDispatcher aJ() {
        return this.aA.b.d();
    }

    public CommandListenerWrapper aK() {
        WorldServer serverLevel = this.aL();
        return new CommandListenerWrapper(this, serverLevel == null ? Vec3D.c : Vec3D.a(this.aM().b()), Vec2F.a, serverLevel, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    public WorldServer aL() {
        ResourceKey<net.minecraft.world.level.World> resourceKey = ((WorldDataServer)this.bf().H()).respawnDimension;
        WorldServer level = this.a(resourceKey);
        return level != null ? level : this.O();
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public void a(WorldData.a respawnData) {
        IWorldDataServer serverLevelData = this.k.H();
        WorldData.a respawnData1 = serverLevelData.a();
        if (!respawnData1.equals(respawnData)) {
            serverLevelData.a(respawnData);
            this.am().a(new PacketPlayOutSpawnPosition(respawnData));
            this.bM();
        }
    }

    public WorldData.a aM() {
        return this.aE;
    }

    @Override
    public boolean z_() {
        return true;
    }

    @Override
    public boolean A_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public CraftingManager aN() {
        return this.aA.b.c();
    }

    public ScoreboardServer aO() {
        return this.ar;
    }

    public PersistentCommandStorage aP() {
        if (this.as == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.as;
    }

    public GameRules aQ() {
        return this.O().S();
    }

    public BossBattleCustomData aR() {
        return this.at;
    }

    public boolean aS() {
        return this.av;
    }

    public void f(boolean enforceWhitelist) {
        this.av = enforceWhitelist;
    }

    public boolean aT() {
        return this.aw;
    }

    public void g(boolean usingWhitelist) {
        this.aw = usingWhitelist;
    }

    public float aU() {
        return this.ax;
    }

    public ServerTickRateManager aV() {
        return this.aC;
    }

    public long aW() {
        return this.aa / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aX() {
        return this.Z;
    }

    public int b(NameAndId nameAndId) {
        if (this.am().f(nameAndId)) {
            OpListEntry serverOpListEntry = (OpListEntry)this.am().k().c(nameAndId);
            if (serverOpListEntry != null) {
                return serverOpListEntry.a();
            }
            if (this.a(nameAndId)) {
                return 4;
            }
            if (this.Y()) {
                return this.am().v() ? 4 : 0;
            }
            return this.k();
        }
        return 0;
    }

    public abstract boolean a(NameAndId var1);

    public void a(Path path) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.P.entrySet()) {
                MinecraftKey resourceLocation = entry.getKey().a();
                Path path2 = path1.resolve(resourceLocation.b()).resolve(resourceLocation.a());
                Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException var7) {
            m.warn("Failed to save debug report", (Throwable)var7);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.bP()));
            bufferedWriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aU())));
            bufferedWriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.Z)));
            bufferedWriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.h()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gameRules = this.aQ();
            gameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gameRules.b(key)));
                }
            });
            for (String string : list) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String property = System.getProperty("java.class.path");
            String property1 = System.getProperty("path.separator");
            for (String string : Splitter.on((String)property1).split((CharSequence)property)) {
                bufferedWriter.write(string);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        Arrays.sort(threadInfos, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : threadInfos) {
                bufferedWriter.write(threadInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.a());
            }
            catch (Throwable var7) {
                m.warn("Failed to list native modules", var7);
                if (bufferedWriter != null) {
                    ((Writer)bufferedWriter).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativeModuleInfo1 -> nativeModuleInfo1.a));
            for (NativeModuleLister.a nativeModuleInfo : list) {
                bufferedWriter.write(nativeModuleInfo.toString());
                ((Writer)bufferedWriter).write(10);
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean bO() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    private GameProfilerFiller bU() {
        if (this.D) {
            this.A = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.i(), new MetricsPersister("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A.c();
        return GameProfilerTick.a(this.A.f(), GameProfilerTick.a("Server"));
    }

    public void aY() {
        this.A.d();
    }

    public boolean aZ() {
        return this.A.e();
    }

    public void a(Consumer<MethodProfilerResults> output, Consumer<Path> onMetricsRecordingFinished) {
        this.B = profileResults -> {
            this.ba();
            output.accept((MethodProfilerResults)profileResults);
        };
        this.C = onMetricsRecordingFinished;
        this.D = true;
    }

    public void ba() {
        this.A = InactiveMetricsRecorder.a;
    }

    public void bb() {
        this.A.a();
    }

    public void bc() {
        this.A.b();
    }

    public Path a(SavedFile levelResource) {
        return this.g.a(levelResource);
    }

    public boolean bd() {
        return true;
    }

    public StructureTemplateManager be() {
        return this.aB;
    }

    public SaveData bf() {
        return this.k;
    }

    public IRegistryCustom.Dimension bg() {
        return this.O.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bh() {
        return this.O;
    }

    public ReloadableServerRegistries.a bi() {
        return this.aA.b.b();
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.e;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.ac() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode bj() {
        return null;
    }

    public IResourceManager bk() {
        return this.aA.a;
    }

    public boolean bl() {
        return this.aI;
    }

    public boolean bm() {
        return this.F || this.E != null;
    }

    public void bn() {
        this.F = true;
    }

    public MethodProfilerResults bo() {
        if (this.E == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults profileResults = this.E.a(SystemUtils.d(), this.T);
        this.E = null;
        return profileResults;
    }

    public int bp() {
        return 1000000;
    }

    public void a(IChatBaseComponent content, ChatMessageType.a boundChatType, @Nullable String header) {
        Component string = PaperAdventure.asAdventure(boundChatType.a(content));
        if (header != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)header, (Object)string);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)string);
        }
    }

    public ChatDecorator bq() {
        return this.improvedChatDecorator;
    }

    public boolean br() {
        return true;
    }

    public void a(MinecraftKey id, Optional<NBTBase> payload) {
        m.debug("Received custom click action {} with payload {}", (Object)id, payload.orElse(null));
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public LevelLoadListener bs() {
        throw new UnsupportedOperationException();
    }

    public boolean h(boolean autoSave) {
        boolean flag = false;
        for (WorldServer serverLevel : this.Q()) {
            if (serverLevel == null || serverLevel.e != autoSave) continue;
            serverLevel.e = !autoSave;
            flag = true;
        }
        return flag;
    }

    public boolean bt() {
        for (WorldServer serverLevel : this.Q()) {
            if (serverLevel == null || serverLevel.e) continue;
            return true;
        }
        return false;
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public void a(String key, GameRules.GameRuleValue<?> value) {
        throw new UnsupportedOperationException();
    }

    public boolean bu() {
        return false;
    }

    private void a(CrashReport crashReport, ChunkCoordIntPair chunkPos, RegionStorageInfo regionStorageInfo) {
        SystemUtils.i().execute(() -> {
            try {
                Path file = this.c("debug");
                FileUtils.c(file);
                String string = FileUtils.a(regionStorageInfo.a());
                Path path = file.resolve("chunk-" + string + "-" + SystemUtils.f() + "-server.txt");
                FileStore fileStore = Files.getFileStore(file);
                long usableSpace = fileStore.getUsableSpace();
                if (usableSpace < 8192L) {
                    m.warn("Not storing chunk IO report due to low space on drive {}", (Object)fileStore.name());
                    return;
                }
                CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk Info");
                crashReportCategory.a("Level", regionStorageInfo::a);
                crashReportCategory.a("Dimension", () -> regionStorageInfo.b().a().toString());
                crashReportCategory.a("Storage", regionStorageInfo::c);
                crashReportCategory.a("Position", chunkPos::toString);
                crashReport.a(path, ReportType.e);
                m.info("Saved details to {}", (Object)crashReport.e());
            }
            catch (Exception var11) {
                m.warn("Failed to store chunk IO exception", (Throwable)var11);
            }
        });
    }

    @Override
    public void a(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        m.error("Failed to load chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aK.a("chunk/load", throwable);
        this.a(CrashReport.a(throwable, "Chunk load failure"), chunkPos, regionStorageInfo);
    }

    @Override
    public void b(Throwable throwable, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair chunkPos) {
        m.error("Failed to save chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, throwable});
        this.aK.a("chunk/save", throwable);
        this.a(CrashReport.a(throwable, "Chunk save failure"), chunkPos, regionStorageInfo);
    }

    public void a(Throwable throwable, PacketType<?> packetType) {
        this.aK.a("packet/" + packetType.toString(), throwable);
    }

    public PotionBrewer bv() {
        return this.aF;
    }

    public FuelValues bw() {
        return this.aG;
    }

    public ServerLinks bx() {
        return ServerLinks.a;
    }

    protected int by() {
        return 0;
    }

    public PacketProcessor bz() {
        return this.aM;
    }

    public ServerDebugSubscribers bA() {
        return this.aD;
    }

    public boolean isTickPaused() {
        return this.aH > 0 && this.aH >= this.by() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(WorldServer level) {
        return level.n().a.e();
    }

    static {
        m = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)m.getName());
        p = 30L * TimeRange.a / 20L;
        r = 10L * TimeRange.a;
        t = 5L * TimeRange.a;
        u = 10L * TimeRange.b;
        e = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(FeatureFlags.h), WorldDataConfiguration.d);
        f = new NameAndId(SystemUtils.e, "Anonymous Player");
        aJ = new AtomicReference();
        startTimeMillis = System.currentTimeMillis();
        SERVER_INIT = System.nanoTime();
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long startNanos, int startTick) {
            this.a = startNanos;
            this.b = startTick;
        }

        MethodProfilerResults a(final long endTimeNano, final int endTimeTicks) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String sectionPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTimeNano;
                }

                @Override
                public int d() {
                    return endTimeTicks;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

