/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.profile.PaperFilledProfileCache;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.server.players.CachedUserNameToIdResolver;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.SignatureValidator;

public record Services(MinecraftSessionService a, ServicesKeySet b, GameProfileRepository c, UserNameToIdResolver d, ProfileResolver e, @Nullable PaperServices paper) {
    private final MinecraftSessionService a;
    private final ServicesKeySet b;
    private final GameProfileRepository c;
    private final UserNameToIdResolver d;
    private final ProfileResolver e;
    @Nullable
    private final PaperServices paper;
    public static final String f = "usercache.json";

    public Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, UserNameToIdResolver nameToIdCache, ProfileResolver profileResolver) {
        this(sessionService, servicesKeySet, profileRepository, nameToIdCache, profileResolver, null);
    }

    public PaperServices paper() {
        return Objects.requireNonNull(this.paper);
    }

    public static Services create(YggdrasilAuthenticationService authenticationService, File profileRepository, File userCacheFile, OptionSet optionSet) throws Exception {
        MinecraftSessionService minecraftSessionService = authenticationService.createMinecraftSessionService();
        GameProfileRepository gameProfileRepository = authenticationService.createProfileRepository();
        CachedUserNameToIdResolver userNameToIdResolver = new CachedUserNameToIdResolver(gameProfileRepository, userCacheFile);
        Path legacyConfigPath = ((File)optionSet.valueOf("paper-settings")).toPath();
        Path configDirPath = ((File)optionSet.valueOf("paper-settings-directory")).toPath();
        PaperConfigurations paperConfigurations = PaperConfigurations.setup(legacyConfigPath, configDirPath, profileRepository.toPath(), (File)optionSet.valueOf("spigot-settings"));
        PaperServices paperServices = new PaperServices(paperConfigurations, new PaperFilledProfileCache());
        ProfileResolver.a profileResolver = new ProfileResolver.a(minecraftSessionService, userNameToIdResolver, paperServices.filledProfileCache());
        return new Services(minecraftSessionService, authenticationService.getServicesKeySet(), gameProfileRepository, userNameToIdResolver, profileResolver, paperServices);
    }

    @Nullable
    public SignatureValidator a() {
        return SignatureValidator.a(this.b, ServicesKeyType.PROFILE_KEY);
    }

    public boolean b() {
        return !this.b.keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;nameToIdCache;profileResolver;paper", "a", "b", "c", "d", "e", "paper"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;nameToIdCache;profileResolver;paper", "a", "b", "c", "d", "e", "paper"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;nameToIdCache;profileResolver;paper", "a", "b", "c", "d", "e", "paper"}, this, o2);
    }

    public MinecraftSessionService c() {
        return this.a;
    }

    public ServicesKeySet d() {
        return this.b;
    }

    public GameProfileRepository e() {
        return this.c;
    }

    public UserNameToIdResolver f() {
        return this.d;
    }

    public ProfileResolver g() {
        return this.e;
    }

    public record PaperServices(PaperConfigurations configurations, PaperFilledProfileCache filledProfileCache) {
    }
}

