/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.google.common.base.Charsets;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ChaseClient {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 5;
    private final String c;
    private final int d;
    private final MinecraftServer e;
    private volatile boolean f;
    @Nullable
    private Socket g;
    @Nullable
    private Thread h;

    public ChaseClient(String serverHost, int serverPort, MinecraftServer server) {
        this.c = serverHost;
        this.d = serverPort;
        this.e = server;
    }

    public void a() {
        if (this.h != null && this.h.isAlive()) {
            a.warn("Remote control client was asked to start, but it is already running. Will ignore.");
        }
        this.f = true;
        this.h = new Thread(this::c, "chase-client");
        this.h.setDaemon(true);
        this.h.start();
    }

    public void b() {
        this.f = false;
        IOUtils.closeQuietly((Socket)this.g);
        this.g = null;
        this.h = null;
    }

    public void c() {
        String string = this.c + ":" + this.d;
        while (this.f) {
            try {
                a.info("Connecting to remote control server {}", (Object)string);
                this.g = new Socket(this.c, this.d);
                a.info("Connected to remote control server! Will continuously execute the command broadcasted by that server.");
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.g.getInputStream(), Charsets.US_ASCII));){
                    while (this.f) {
                        String line = bufferedReader.readLine();
                        if (line == null) {
                            a.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
                            break;
                        }
                        this.a(line);
                    }
                }
                catch (IOException var8) {
                    a.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
                }
            }
            catch (IOException var9) {
                a.warn("Failed to connect to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
            }
            if (!this.f) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void a(String message) {
        try (Scanner scanner = new Scanner(new StringReader(message));){
            scanner.useLocale(Locale.ROOT);
            String string = scanner.next();
            if ("t".equals(string)) {
                this.a(scanner);
            } else {
                a.warn("Unknown message type '{}'", (Object)string);
            }
        }
        catch (NoSuchElementException var7) {
            a.warn("Could not parse message '{}', ignoring", (Object)message);
        }
    }

    private void a(Scanner scanner) {
        this.b(scanner).ifPresent(teleportTarget -> this.b(String.format(Locale.ROOT, "execute in %s run tp @s %.3f %.3f %.3f %.3f %.3f", teleportTarget.a.a(), teleportTarget.b.g, teleportTarget.b.h, teleportTarget.b.i, Float.valueOf(teleportTarget.c.k), Float.valueOf(teleportTarget.c.j))));
    }

    private Optional<a> b(Scanner scanner) {
        ResourceKey resourceKey = (ResourceKey)ChaseCommand.a.get((Object)scanner.next());
        if (resourceKey == null) {
            return Optional.empty();
        }
        float f2 = scanner.nextFloat();
        float f1 = scanner.nextFloat();
        float f22 = scanner.nextFloat();
        float f3 = scanner.nextFloat();
        float f4 = scanner.nextFloat();
        return Optional.of(new a(resourceKey, new Vec3D(f2, f1, f22), new Vec2F(f4, f3)));
    }

    private void b(String command) {
        this.e.execute(() -> {
            List<EntityPlayer> players = this.e.am().t();
            if (!players.isEmpty()) {
                EntityPlayer serverPlayer = players.get(0);
                WorldServer serverLevel = this.e.O();
                CommandListenerWrapper commandSourceStack = new CommandListenerWrapper(serverPlayer.B(), Vec3D.a(serverLevel.A().b()), Vec2F.a, serverLevel, 4, "", CommonComponents.a, this.e, serverPlayer);
                CommandDispatcher commands = this.e.aJ();
                commands.a(commandSourceStack, command);
            }
        });
    }

    record a(ResourceKey<World> a, Vec3D b, Vec2F c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this, o2);
        }
    }
}

