/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class CommandClone {
    private static final Logger b = LogUtils.getLogger();
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.clone.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> a = blockInWorld -> !blockInWorld.a().l();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("clone").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> input) -> ((CommandListenerWrapper)input.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.b("from").then(net.minecraft.commands.CommandDispatcher.a("sourceDimension", ArgumentDimension.a()).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> context1) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context1, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> levelGetter) {
        return net.minecraft.commands.CommandDispatcher.a("begin", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> input) -> ((CommandListenerWrapper)input.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.b("to").then(net.minecraft.commands.CommandDispatcher.a("targetDimension", ArgumentDimension.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "targetDimension"))))));
    }

    private static c a(CommandContext<CommandListenerWrapper> context, WorldServer level, String name) throws CommandSyntaxException {
        BlockPosition loadedBlockPos = ArgumentPosition.a(context, level, name);
        return new c(level, loadedBlockPos);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> sourceLevelGetter, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> destinationLevelGetter) {
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction = input -> CommandClone.a((CommandContext<CommandListenerWrapper>)input, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)input), "begin");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction1 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "end");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction2 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)destinationLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "destination");
        return CommandClone.a(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, false, net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a())).then(CommandClone.a(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, true, net.minecraft.commands.CommandDispatcher.b("strict")));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, c> begin, InCommandFunction<CommandContext<CommandListenerWrapper>, c> end, InCommandFunction<CommandContext<CommandListenerWrapper>, c> destination, boolean strict, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)commandContext -> CommandClone.a((CommandListenerWrapper)commandContext.getSource(), (c)begin.apply(commandContext), (c)end.apply(commandContext), (c)destination.apply(commandContext), blockInWorld -> true, Mode.c, strict)))).then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> input) -> blockInWorld -> true, strict, net.minecraft.commands.CommandDispatcher.b("replace")))).then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> context) -> a, strict, net.minecraft.commands.CommandDispatcher.b("masked")))).then(net.minecraft.commands.CommandDispatcher.b("filtered").then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), strict, net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(buildContext)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(InCommandFunction<CommandContext<CommandListenerWrapper>, c> begin, InCommandFunction<CommandContext<CommandListenerWrapper>, c> end, InCommandFunction<CommandContext<CommandListenerWrapper>, c> destination, InCommandFunction<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filter, boolean strict, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)commandContext -> CommandClone.a((CommandListenerWrapper)commandContext.getSource(), (c)begin.apply(commandContext), (c)end.apply(commandContext), (c)destination.apply(commandContext), (Predicate)filter.apply(commandContext), Mode.c, strict)))).then(net.minecraft.commands.CommandDispatcher.b("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.a, strict)))).then(net.minecraft.commands.CommandDispatcher.b("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.b, strict)))).then(net.minecraft.commands.CommandDispatcher.b("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.c, strict)));
    }

    private static int a(CommandListenerWrapper source, c begin, c end, c destination, Predicate<ShapeDetectorBlock> filter, Mode mode, boolean strict) throws CommandSyntaxException {
        int _int;
        BlockPosition blockPos = begin.b();
        BlockPosition blockPos1 = end.b();
        StructureBoundingBox boundingBox = StructureBoundingBox.a((BaseBlockPosition)blockPos, (BaseBlockPosition)blockPos1);
        BlockPosition blockPos2 = destination.b();
        BlockPosition blockPos3 = blockPos2.a(boundingBox.c());
        StructureBoundingBox boundingBox1 = StructureBoundingBox.a((BaseBlockPosition)blockPos2, (BaseBlockPosition)blockPos3);
        WorldServer serverLevel = begin.a();
        WorldServer serverLevel1 = destination.a();
        if (!mode.a() && serverLevel == serverLevel1 && boundingBox1.a(boundingBox)) {
            throw c.create();
        }
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > (_int = source.e().S().d(GameRules.B))) {
            throw d.create((Object)_int, (Object)i2);
        }
        if (!serverLevel.a(blockPos, blockPos1) || !serverLevel1.a(blockPos2, blockPos3)) {
            throw ArgumentPosition.a.create();
        }
        if (serverLevel1.am()) {
            throw e.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        LinkedList list3 = Lists.newLinkedList();
        int i1 = 0;
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(b);){
            int y2;
            int z2;
            BlockPosition blockPos4 = new BlockPosition(boundingBox1.h() - boundingBox.h(), boundingBox1.i() - boundingBox.i(), boundingBox1.j() - boundingBox.j());
            for (z2 = boundingBox.j(); z2 <= boundingBox.m(); ++z2) {
                for (y2 = boundingBox.i(); y2 <= boundingBox.l(); ++y2) {
                    for (int x2 = boundingBox.h(); x2 <= boundingBox.k(); ++x2) {
                        BlockPosition blockPos5 = new BlockPosition(x2, y2, z2);
                        BlockPosition blockPos6 = blockPos5.a(blockPos4);
                        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(serverLevel, blockPos5, false);
                        IBlockData state = blockInWorld.a();
                        if (!filter.test(blockInWorld)) continue;
                        TileEntity blockEntity = serverLevel.c_(blockPos5);
                        if (blockEntity != null) {
                            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector.a(blockEntity.v()), source.u());
                            blockEntity.f(tagValueOutput);
                            a cloneBlockEntityInfo = new a(tagValueOutput.b(), blockEntity.u());
                            list1.add(new CommandCloneStoredTileEntity(blockPos6, state, cloneBlockEntityInfo, serverLevel1.a_(blockPos6)));
                            list3.addLast(blockPos5);
                            continue;
                        }
                        if (!state.s() && !state.m(serverLevel, blockPos5)) {
                            list2.add(new CommandCloneStoredTileEntity(blockPos6, state, null, serverLevel1.a_(blockPos6)));
                            list3.addFirst(blockPos5);
                            continue;
                        }
                        list.add(new CommandCloneStoredTileEntity(blockPos6, state, null, serverLevel1.a_(blockPos6)));
                        list3.addLast(blockPos5);
                    }
                }
            }
            z2 = 2 | (strict ? 816 : 0);
            if (mode == Mode.b) {
                for (BlockPosition blockPos7 : list3) {
                    serverLevel.a(blockPos7, Blocks.iO.m(), z2 | 0x330);
                }
                y2 = strict ? z2 : 3;
                for (BlockPosition blockPos5 : list3) {
                    serverLevel.a(blockPos5, Blocks.a.m(), y2);
                }
            }
            ArrayList list4 = Lists.newArrayList();
            list4.addAll(list);
            list4.addAll(list1);
            list4.addAll(list2);
            List list5 = Lists.reverse((List)list4);
            for (CommandCloneStoredTileEntity cloneBlockInfo : list5) {
                serverLevel1.a(cloneBlockInfo.a, Blocks.iO.m(), z2 | 0x330);
            }
            for (CommandCloneStoredTileEntity cloneBlockInfo : list4) {
                if (!serverLevel1.a(cloneBlockInfo.a, cloneBlockInfo.b, z2)) continue;
                ++i1;
            }
            for (CommandCloneStoredTileEntity cloneBlockInfox : list1) {
                TileEntity blockEntity1 = serverLevel1.c_(cloneBlockInfox.a);
                if (cloneBlockInfox.c != null && blockEntity1 != null) {
                    blockEntity1.c(TagValueInput.a(scopedCollector.a(blockEntity1.v()), (HolderLookup.a)serverLevel1.L_(), cloneBlockInfox.c.a));
                    blockEntity1.a(cloneBlockInfox.c.b);
                    blockEntity1.e();
                }
                serverLevel1.a(cloneBlockInfox.a, cloneBlockInfox.b, z2);
            }
            if (!strict) {
                for (CommandCloneStoredTileEntity cloneBlockInfox : list5) {
                    serverLevel1.a(cloneBlockInfox.a, cloneBlockInfox.d);
                }
            }
            serverLevel1.o().a(serverLevel.o(), boundingBox, blockPos4);
        }
        if (i1 == 0) {
            throw e.create();
        }
        int i22 = i1;
        source.a(() -> IChatBaseComponent.a("commands.clone.success", i22), true);
        return i1;
    }

    record c(WorldServer a, BlockPosition b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this, o2);
        }
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(true);
        public static final /* enum */ Mode b = new Mode(true);
        public static final /* enum */ Mode c = new Mode(false);
        private final boolean d;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(boolean canOverlap) {
            this.d = canOverlap;
        }

        public boolean a() {
            return this.d;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{a, b, c};
        }

        static {
            e = Mode.b();
        }
    }

    record a(NBTTagCompound a, DataComponentMap b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this, o2);
        }
    }

    record CommandCloneStoredTileEntity(BlockPosition a, IBlockData b, @Nullable a c, IBlockData d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo;previousStateAtDestination", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo;previousStateAtDestination", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo;previousStateAtDestination", "a", "b", "c", "d"}, this, o2);
        }
    }
}

