/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.commons.io.IOUtils;
import org.bukkit.command.CommandSender;
import org.slf4j.Logger;

public class CommandDebug {
    static final Logger a = LogUtils.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.alreadyRunning"));
    static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.function.noRecursion"));
    static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.function.noReturnRun"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("debug").requires(net.minecraft.commands.CommandDispatcher.a(3))).then(net.minecraft.commands.CommandDispatcher.b("start").executes(commandContext -> CommandDebug.a((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("stop").executes(context -> CommandDebug.b((CommandListenerWrapper)context.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("function").requires(net.minecraft.commands.CommandDispatcher.a(3))).then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.b).executes((Command)new a())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer server = source.l();
        if (server.bm()) {
            throw c.create();
        }
        server.bn();
        source.a(() -> IChatBaseComponent.c("commands.debug.started"), true);
        return 0;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer server = source.l();
        if (!server.bm()) {
            throw b.create();
        }
        MethodProfilerResults profileResults = server.bo();
        double d2 = (double)profileResults.g() / (double)TimeRange.a;
        double d1 = (double)profileResults.f() / d2;
        source.a(() -> IChatBaseComponent.a("commands.debug.stopped", new Object[]{String.format(Locale.ROOT, "%.2f", d2), profileResults.f(), String.format(Locale.ROOT, "%.2f", d1)}), true);
        return (int)d1;
    }

    static class a
    extends CustomCommandExecutor.b<CommandListenerWrapper>
    implements CustomCommandExecutor.a<CommandListenerWrapper> {
        a() {
        }

        @Override
        public void a(CommandListenerWrapper source, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandListenerWrapper> executionControl) throws CommandSyntaxException {
            if (chainModifiers.c()) {
                throw e.create();
            }
            if (executionControl.a() != null) {
                throw d.create();
            }
            CommandContext topContext = contextChain.getTopContext();
            Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>> functions = ArgumentTag.a((CommandContext<CommandListenerWrapper>)topContext, "name");
            MinecraftServer server = source.l();
            String string = "debug-trace-" + SystemUtils.f() + ".txt";
            CommandDispatcher<CommandListenerWrapper> dispatcher = source.l().aG().a();
            int i2 = 0;
            try {
                Path file = server.c("debug");
                Files.createDirectories(file, new FileAttribute[0]);
                final PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(file.resolve(string), StandardCharsets.UTF_8, new OpenOption[0]));
                b tracer = new b(printWriter);
                executionControl.a(tracer);
                for (final net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper> commandFunction : functions) {
                    try {
                        CommandListenerWrapper commandSourceStack = source.a(tracer).b(2);
                        InstantiatedFunction<CommandListenerWrapper> instantiatedFunction = commandFunction.a(null, dispatcher);
                        executionControl.a(new CallFunction<CommandListenerWrapper>(this, instantiatedFunction, CommandResultCallback.a, false){

                            @Override
                            public void a(CommandListenerWrapper source1, ExecutionContext<CommandListenerWrapper> executionContext, Frame frame) {
                                printWriter.println(commandFunction.a());
                                super.a(source1, executionContext, frame);
                            }
                        }.bind(commandSourceStack));
                        i2 += instantiatedFunction.b().size();
                    }
                    catch (FunctionInstantiationException var18) {
                        source.b(var18.a());
                    }
                }
            }
            catch (IOException | UncheckedIOException var19) {
                a.warn("Tracing failed", (Throwable)var19);
                source.b(IChatBaseComponent.c("commands.debug.function.traceFailed"));
            }
            int i1 = i2;
            executionControl.a((executionContext, frame) -> {
                if (functions.size() == 1) {
                    source.a(() -> IChatBaseComponent.a("commands.debug.function.success.single", i1, IChatBaseComponent.a(((net.minecraft.commands.functions.CommandFunction)functions.iterator().next()).a()), string), true);
                } else {
                    source.a(() -> IChatBaseComponent.a("commands.debug.function.success.multiple", i1, functions.size(), string), true);
                }
            });
        }
    }

    static class b
    implements ICommandListener,
    TraceCallbacks {
        public static final int b = 1;
        private final PrintWriter c;
        private int d;
        private boolean e;

        b(PrintWriter output) {
            this.c = output;
        }

        private void a(int indent) {
            this.b(indent);
            this.d = indent;
        }

        private void b(int indent) {
            for (int i2 = 0; i2 < indent + 1; ++i2) {
                this.c.write("    ");
            }
        }

        private void e() {
            if (this.e) {
                this.c.println();
                this.e = false;
            }
        }

        @Override
        public void a(int depth, String command) {
            this.e();
            this.a(depth);
            this.c.print("[C] ");
            this.c.print(command);
            this.e = true;
        }

        @Override
        public void a(int depth, String command, int returnValue) {
            if (this.e) {
                this.c.print(" -> ");
                this.c.println(returnValue);
                this.e = false;
            } else {
                this.a(depth);
                this.c.print("[R = ");
                this.c.print(returnValue);
                this.c.print("] ");
                this.c.println(command);
            }
        }

        @Override
        public void a(int depth, MinecraftKey function, int commands) {
            this.e();
            this.a(depth);
            this.c.print("[F] ");
            this.c.print(function);
            this.c.print(" size=");
            this.c.println(commands);
        }

        @Override
        public void a(String errorMessage) {
            this.e();
            this.a(this.d + 1);
            this.c.print("[E] ");
            this.c.print(errorMessage);
        }

        @Override
        public void a(IChatBaseComponent message) {
            this.e();
            this.b(this.d + 1);
            this.c.print("[M] ");
            this.c.println(message.getString());
        }

        @Override
        public boolean z_() {
            return true;
        }

        @Override
        public boolean A_() {
            return true;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public boolean q_() {
            return true;
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((Writer)this.c);
        }
    }
}

