/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CommandEffect {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.effect.clear.specific.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("effect").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("clear").executes(commandContext -> CommandEffect.a((CommandListenerWrapper)commandContext.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandListenerWrapper)commandContext.getSource()).g())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets")))).then(net.minecraft.commands.CommandDispatcher.a("effect", ResourceArgument.a(context, Registries.aa)).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"))))))).then(net.minecraft.commands.CommandDispatcher.b("give").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("effect", ResourceArgument.a(context, Registries.aa)).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.a("hideParticles", BoolArgumentType.bool()).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("infinite").executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.a("hideParticles", BoolArgumentType.bool()).executes(context1 -> CommandEffect.a((CommandListenerWrapper)context1.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context1, "targets"), ResourceArgument.f((CommandContext<CommandListenerWrapper>)context1, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles")))))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Holder<MobEffectList> effect, @Nullable Integer seconds, int amplifier, boolean showParticles) throws CommandSyntaxException {
        MobEffectList mobEffect = effect.a();
        int i2 = 0;
        int i1 = seconds != null ? (mobEffect.a() ? seconds : (seconds == -1 ? -1 : seconds * 20)) : (mobEffect.a() ? 1 : 600);
        for (Entity entity : targets) {
            MobEffect mobEffectInstance;
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).addEffect(mobEffectInstance = new MobEffect(effect, i1, amplifier, false, showParticles), source.f(), EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.effect.give.success.single", mobEffect.g(), ((Entity)targets.iterator().next()).S_(), i1 / 20), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.effect.give.success.multiple", mobEffect.g(), targets.size(), i1 / 20), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeAllEffects(EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw b.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.effect.clear.everything.success.single", ((Entity)targets.iterator().next()).S_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.effect.clear.everything.success.multiple", targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Holder<MobEffectList> effect) throws CommandSyntaxException {
        MobEffectList mobEffect = effect.a();
        int i2 = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeEffect(effect, EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw c.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.effect.clear.specific.success.single", mobEffect.g(), ((Entity)targets.iterator().next()).S_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.effect.clear.specific.success.multiple", mobEffect.g(), targets.size()), true);
        }
        return i2;
    }
}

