/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.purpurmc.purpur.PurpurConfig;

public class CommandGamemode {
    public static final int a = 2;

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("gamemode").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("gamemode", GameModeArgument.a()).executes(commandContext -> CommandGamemode.a((CommandContext<CommandListenerWrapper>)commandContext, Collections.singleton(((CommandListenerWrapper)commandContext.getSource()).h()), GameModeArgument.a((CommandContext<CommandListenerWrapper>)commandContext, "gamemode")))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.d()).executes(context -> CommandGamemode.a((CommandContext<CommandListenerWrapper>)context, ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "target"), GameModeArgument.a((CommandContext<CommandListenerWrapper>)context, "gamemode")))))));
    }

    private static void a(CommandListenerWrapper source, EntityPlayer player, EnumGamemode gameType) {
        IChatMutableComponent component = IChatBaseComponent.c("gameMode." + gameType.b());
        if (source.f() == player) {
            source.a(() -> IChatBaseComponent.a("commands.gamemode.success.self", component), true);
        } else {
            if (source.e().S().c(GameRules.q)) {
                player.a(IChatBaseComponent.a("gameMode.changed", component));
            }
            source.a(() -> IChatBaseComponent.a("commands.gamemode.success.other", player.S_(), component), true);
        }
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Collection<EntityPlayer> players, EnumGamemode gameType) {
        if (PurpurConfig.commandGamemodeRequiresPermission) {
            String gamemode = gameType.b();
            CommandListenerWrapper sender = (CommandListenerWrapper)context.getSource();
            if (!sender.testPermission(2, "minecraft.command.gamemode." + gamemode)) {
                return 0;
            }
            Entity entity = sender.f();
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!(players.size() <= 1 && players.contains(player) || sender.testPermission(2, "minecraft.command.gamemode." + gamemode + ".other"))) {
                    return 0;
                }
            }
        }
        int i2 = 0;
        for (EntityPlayer serverPlayer : players) {
            if (!CommandGamemode.b((CommandListenerWrapper)context.getSource(), serverPlayer, gameType)) continue;
            ++i2;
        }
        return i2;
    }

    public static void a(EntityPlayer player, EnumGamemode gameMode) {
        CommandGamemode.b(player.C(), player, gameMode);
    }

    private static boolean b(CommandListenerWrapper source, EntityPlayer player, EnumGamemode gameMode) {
        return CommandGamemode.setGameMode(source, player, gameMode, PlayerGameModeChangeEvent.Cause.COMMAND);
    }

    public static boolean setGameMode(CommandListenerWrapper source, EntityPlayer player, EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause) {
        PlayerGameModeChangeEvent event = player.setGameMode(gameMode, cause, null);
        if (event != null && !event.isCancelled()) {
            CommandGamemode.a(source, player, gameMode);
            return true;
        }
        if (event != null && event.cancelMessage() != null) {
            source.a(() -> PaperAdventure.asVanilla(event.cancelMessage()), true);
            return false;
        }
        return false;
    }
}

