/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2F;

public class CommandSpawnpoint {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("spawnpoint").requires(net.minecraft.commands.CommandDispatcher.a(2))).executes(context -> CommandSpawnpoint.a((CommandListenerWrapper)context.getSource(), Collections.singleton(((CommandListenerWrapper)context.getSource()).h()), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d()), VectorPosition.a))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).executes(context -> CommandSpawnpoint.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d()), VectorPosition.a))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> CommandSpawnpoint.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentPosition.c((CommandContext<CommandListenerWrapper>)context, "pos"), VectorPosition.a))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(context -> CommandSpawnpoint.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentPosition.c((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rotation"))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, BlockPosition pos, IVectorPosition rotationSupplier) {
        ResourceKey<World> resourceKey = source.e().al();
        Vec2F rotation = rotationSupplier.b(source);
        float f2 = rotation.k;
        float f1 = rotation.j;
        ArrayList<EntityPlayer> actualTargets = new ArrayList<EntityPlayer>();
        for (EntityPlayer serverPlayer : targets) {
            if (!serverPlayer.setRespawnPosition(new EntityPlayer.RespawnConfig(WorldData.a.a(resourceKey, pos, f2, f1), true), false, PlayerSetSpawnEvent.Cause.COMMAND)) continue;
            actualTargets.add(serverPlayer);
        }
        if (actualTargets.isEmpty()) {
            return 0;
        }
        String string = resourceKey.a().toString();
        if (actualTargets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.spawnpoint.success.single", pos.u(), pos.v(), pos.w(), Float.valueOf(f2), Float.valueOf(f1), string, ((EntityPlayer)actualTargets.iterator().next()).S_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.spawnpoint.success.multiple", pos.u(), pos.v(), pos.w(), Float.valueOf(f2), Float.valueOf(f1), string, actualTargets.size()), true);
        }
        return actualTargets.size();
    }
}

