/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandWhitelist {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.remove.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("whitelist").requires(net.minecraft.commands.CommandDispatcher.a(3))).then(net.minecraft.commands.CommandDispatcher.b("on").executes(commandContext -> CommandWhitelist.b((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("off").executes(context -> CommandWhitelist.c((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("list").executes(context -> CommandWhitelist.d((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("add").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentProfile.a()).suggests((commandContext, suggestionsBuilder) -> {
            PlayerList playerList = ((CommandListenerWrapper)commandContext.getSource()).l().am();
            return ICompletionProvider.b(playerList.t().stream().map(EntityHuman::gA).filter(nameAndId -> !playerList.i().a((NameAndId)nameAndId)).map(NameAndId::b), suggestionsBuilder);
        }).executes(commandContext -> CommandWhitelist.a((CommandListenerWrapper)commandContext.getSource(), ArgumentProfile.a((CommandContext<CommandListenerWrapper>)commandContext, "targets")))))).then(net.minecraft.commands.CommandDispatcher.b("remove").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentProfile.a()).suggests((commandContext, suggestionsBuilder) -> ICompletionProvider.a(((CommandListenerWrapper)commandContext.getSource()).l().am().j(), suggestionsBuilder)).executes(commandContext -> CommandWhitelist.b((CommandListenerWrapper)commandContext.getSource(), ArgumentProfile.a((CommandContext<CommandListenerWrapper>)commandContext, "targets")))))).then(net.minecraft.commands.CommandDispatcher.b("reload").executes(context -> CommandWhitelist.a((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) {
        source.l().am().a();
        source.a(() -> IChatBaseComponent.c("commands.whitelist.reloaded"), true);
        source.l().aH();
        return 1;
    }

    private static int a(CommandListenerWrapper source, Collection<NameAndId> players) throws CommandSyntaxException {
        WhiteList whiteList = source.l().am().i();
        int i2 = 0;
        for (NameAndId nameAndId : players) {
            if (whiteList.a(nameAndId)) continue;
            WhiteListEntry userWhiteListEntry = new WhiteListEntry(nameAndId);
            whiteList.a(userWhiteListEntry);
            source.a(() -> IChatBaseComponent.a("commands.whitelist.add.success", IChatBaseComponent.b(nameAndId.b())), true);
            ++i2;
        }
        if (i2 == 0) {
            throw c.create();
        }
        return i2;
    }

    private static int b(CommandListenerWrapper source, Collection<NameAndId> players) throws CommandSyntaxException {
        WhiteList whiteList = source.l().am().i();
        int i2 = 0;
        for (NameAndId nameAndId : players) {
            if (!whiteList.a(nameAndId)) continue;
            WhiteListEntry userWhiteListEntry = new WhiteListEntry(nameAndId);
            whiteList.b(userWhiteListEntry);
            source.a(() -> IChatBaseComponent.a("commands.whitelist.remove.success", IChatBaseComponent.b(nameAndId.b())), true);
            ++i2;
        }
        if (i2 == 0) {
            throw d.create();
        }
        source.l().aH();
        return i2;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        if (source.l().aT()) {
            throw a.create();
        }
        source.l().g(true);
        source.a(() -> IChatBaseComponent.c("commands.whitelist.enabled"), true);
        source.l().aH();
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        if (!source.l().aT()) {
            throw b.create();
        }
        source.l().g(false);
        source.a(() -> IChatBaseComponent.c("commands.whitelist.disabled"), true);
        return 1;
    }

    private static int d(CommandListenerWrapper source) {
        String[] whiteListNames = source.l().am().j();
        if (whiteListNames.length == 0) {
            source.a(() -> IChatBaseComponent.c("commands.whitelist.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.whitelist.list", whiteListNames.length, String.join((CharSequence)", ", whiteListNames)), false);
        }
        return whiteListNames.length;
    }
}

