/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;

public class RaidCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("raid").requires(net.minecraft.commands.CommandDispatcher.a(3))).then(net.minecraft.commands.CommandDispatcher.b("start").then(net.minecraft.commands.CommandDispatcher.a("omenlvl", IntegerArgumentType.integer((int)0)).executes(commandContext -> RaidCommand.b((CommandListenerWrapper)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"omenlvl")))))).then(net.minecraft.commands.CommandDispatcher.b("stop").executes(context1 -> RaidCommand.c((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("check").executes(context1 -> RaidCommand.d((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("sound").then(net.minecraft.commands.CommandDispatcher.a("type", ArgumentChatComponent.a(context)).executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource(), ArgumentChatComponent.b((CommandContext<CommandListenerWrapper>)context1, "type")))))).then(net.minecraft.commands.CommandDispatcher.b("spawnleader").executes(context1 -> RaidCommand.b((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("setomen").then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource(), IntegerArgumentType.getInteger((CommandContext)context1, (String)"level")))))).then(net.minecraft.commands.CommandDispatcher.b("glow").executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            for (EntityRaider raider : raid.h()) {
                raider.a(new MobEffect(MobEffects.x, 1000, 1));
            }
        }
        return 1;
    }

    private static int a(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            int maxRaidOmenLevel = raid.k();
            if (level > maxRaidOmenLevel) {
                source.b(IChatBaseComponent.b("Sorry, the max raid omen level you can set is " + maxRaidOmenLevel));
            } else {
                int raidOmenLevel = raid.l();
                raid.a(level);
                source.a(() -> IChatBaseComponent.b("Changed village's raid omen level from " + raidOmenLevel + " to " + level), false);
            }
        } else {
            source.b(IChatBaseComponent.b("No raid found here"));
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        source.a(() -> IChatBaseComponent.b("Spawned a raid captain"), false);
        EntityRaider raider = EntityTypes.aY.a(source.e(), EntitySpawnReason.n);
        if (raider == null) {
            source.b(IChatBaseComponent.b("Pillager failed to spawn"));
            return 0;
        }
        raider.x(true);
        raider.a(EnumItemSlot.f, Raid.a(source.u().f(Registries.aM)));
        raider.a_(source.d().g, source.d().h, source.d().i);
        raider.a((WorldAccess)source.e(), source.e().d_(BlockPosition.a(source.d())), EntitySpawnReason.n, null);
        source.e().a_(raider);
        return 1;
    }

    private static int a(CommandListenerWrapper source, @Nullable IChatBaseComponent type) {
        if (type != null && type.getString().equals("local")) {
            WorldServer level = source.e();
            Vec3D vec3 = source.d().b(5.0, 0.0, 0.0);
            level.a(null, vec3.g, vec3.h, vec3.i, SoundEffects.wU, SoundCategory.g, 2.0f, 1.0f, level.z.g());
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source, int badOmenLevel) throws CommandSyntaxException {
        EntityPlayer playerOrException = source.h();
        BlockPosition blockPos = playerOrException.dF();
        if (playerOrException.A().e(blockPos)) {
            source.b(IChatBaseComponent.b("Raid already started close by"));
            return -1;
        }
        PersistentRaid raids = playerOrException.A().E();
        Raid raid = raids.a(playerOrException, playerOrException.dF());
        if (raid != null) {
            raid.a(badOmenLevel);
            raids.t();
            source.a(() -> IChatBaseComponent.b("Created a raid in your local village"), false);
        } else {
            source.b(IChatBaseComponent.b("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        EntityPlayer playerOrException = source.h();
        BlockPosition blockPos = playerOrException.dF();
        Raid raidAt = playerOrException.A().d(blockPos);
        if (raidAt != null) {
            raidAt.m();
            source.a(() -> IChatBaseComponent.b("Stopped raid"), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("No raid here"));
        return -1;
    }

    private static int d(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found a started raid! ");
            source.a(() -> IChatBaseComponent.b(stringBuilder.toString()), false);
            StringBuilder stringBuilder1 = new StringBuilder();
            stringBuilder1.append("Num groups spawned: ");
            stringBuilder1.append(raid.j());
            stringBuilder1.append(" Raid omen level: ");
            stringBuilder1.append(raid.l());
            stringBuilder1.append(" Num mobs: ");
            stringBuilder1.append(raid.p());
            stringBuilder1.append(" Raid health: ");
            stringBuilder1.append(raid.o());
            stringBuilder1.append(" / ");
            stringBuilder1.append(raid.g());
            source.a(() -> IChatBaseComponent.b(stringBuilder1.toString()), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("Found no started raids"));
        return 0;
    }

    @Nullable
    private static Raid a(EntityPlayer player) {
        return player.A().d(player.dF());
    }
}

