/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;

public class SpawnArmorTrimsCommand {
    private static final List<ResourceKey<TrimPattern>> a = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p, TrimPatterns.q, TrimPatterns.r);
    private static final List<ResourceKey<TrimMaterial>> b = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j, TrimMaterials.k);
    private static final ToIntFunction<ResourceKey<TrimPattern>> c = SystemUtils.g(a);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> d = SystemUtils.g(b);
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("Invalid pattern", object));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("spawn_armor_trims").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(net.minecraft.commands.CommandDispatcher.b("*_lag_my_game").executes(commandContext -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)commandContext.getSource(), ((CommandListenerWrapper)commandContext.getSource()).h())))).then(net.minecraft.commands.CommandDispatcher.a("pattern", ResourceKeyArgument.a(Registries.bt)).executes(context -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)context.getSource(), (EntityHuman)((CommandListenerWrapper)context.getSource()).h(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "pattern", Registries.bt, e))))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        return SpawnArmorTrimsCommand.a(source, player, source.l().bg().f(Registries.bt).c());
    }

    private static int a(CommandListenerWrapper source, EntityHuman player, ResourceKey<TrimPattern> pattern) {
        return SpawnArmorTrimsCommand.a(source, player, Stream.of((Holder.c)source.l().bg().f(Registries.bt).a(pattern).orElseThrow()));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player, Stream<Holder.c<TrimPattern>> patterns) {
        WorldServer level = source.e();
        List<Holder.c> list = patterns.sorted(Comparator.comparing(reference3 -> c.applyAsInt(reference3.h()))).toList();
        List<Holder.c> list1 = level.L_().f(Registries.bs).c().sorted(Comparator.comparing(reference3 -> d.applyAsInt(reference3.h()))).toList();
        List<Holder.c<Item>> list2 = SpawnArmorTrimsCommand.a(level.L_().f(Registries.O));
        BlockPosition blockPos = player.dF().a(player.db(), 5);
        double d2 = 3.0;
        for (int i2 = 0; i2 < list1.size(); ++i2) {
            Holder.c reference = list1.get(i2);
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Holder.c reference1 = list.get(i1);
                ArmorTrim armorTrim = new ArmorTrim(reference, reference1);
                for (int i22 = 0; i22 < list2.size(); ++i22) {
                    Holder.c<Item> reference2 = list2.get(i22);
                    double d1 = (double)blockPos.u() + 0.5 - (double)i22 * 3.0;
                    double d22 = (double)blockPos.v() + 0.5 + (double)i2 * 3.0;
                    double d3 = (double)blockPos.w() + 0.5 + (double)(i1 * 10);
                    EntityArmorStand armorStand = new EntityArmorStand(level, d1, d22, d3);
                    armorStand.v(180.0f);
                    armorStand.g(true);
                    ItemStack itemStack = new ItemStack(reference2);
                    Equippable equippable = Objects.requireNonNull(itemStack.a(DataComponents.D));
                    itemStack.b(DataComponents.W, armorTrim);
                    armorStand.a(equippable.b(), itemStack);
                    if (i22 == 0) {
                        armorStand.b(armorTrim.b().a().a(armorTrim.a()).f().f(" & ").b(armorTrim.a().a().b()));
                        armorStand.p(true);
                    } else {
                        armorStand.l(true);
                    }
                    level.b(armorStand);
                }
            }
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }

    private static List<Holder.c<Item>> a(HolderLookup<Item> itemRegistry) {
        ArrayList<Holder.c<Item>> list = new ArrayList<Holder.c<Item>>();
        itemRegistry.c().forEach(reference -> {
            Equippable equippable = ((Item)reference.a()).f().a(DataComponents.D);
            if (equippable != null && equippable.b().a() == EnumItemSlot.Function.b && equippable.d().isPresent()) {
                list.add((Holder.c<Item>)reference);
            }
        });
        return list;
    }
}

