/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.HexColorArgument;
import net.minecraft.commands.arguments.WaypointArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointStyleAsset;
import net.minecraft.world.waypoints.WaypointStyleAssets;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class WaypointCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("waypoint").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(net.minecraft.commands.CommandDispatcher.b("list").executes(commandContext -> WaypointCommand.a((CommandListenerWrapper)commandContext.getSource())))).then(net.minecraft.commands.CommandDispatcher.b("modify").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("waypoint", ArgumentEntity.a()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("color").then(net.minecraft.commands.CommandDispatcher.a("color", ArgumentChatFormat.a()).executes(context -> WaypointCommand.a((CommandListenerWrapper)context.getSource(), WaypointArgument.a((CommandContext<CommandListenerWrapper>)context, "waypoint"), ArgumentChatFormat.a((CommandContext<CommandListenerWrapper>)context, "color"))))).then(net.minecraft.commands.CommandDispatcher.b("hex").then(net.minecraft.commands.CommandDispatcher.a("color", HexColorArgument.a()).executes(context -> WaypointCommand.a((CommandListenerWrapper)context.getSource(), WaypointArgument.a((CommandContext<CommandListenerWrapper>)context, "waypoint"), HexColorArgument.a((CommandContext<CommandListenerWrapper>)context, "color")))))).then(net.minecraft.commands.CommandDispatcher.b("reset").executes(context -> WaypointCommand.a((CommandListenerWrapper)context.getSource(), WaypointArgument.a((CommandContext<CommandListenerWrapper>)context, "waypoint")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("style").then(net.minecraft.commands.CommandDispatcher.b("reset").executes(context -> WaypointCommand.a((CommandListenerWrapper)context.getSource(), WaypointArgument.a((CommandContext<CommandListenerWrapper>)context, "waypoint"), WaypointStyleAssets.b)))).then(net.minecraft.commands.CommandDispatcher.b("set").then(net.minecraft.commands.CommandDispatcher.a("style", ArgumentMinecraftKeyRegistered.a()).executes(context -> WaypointCommand.a((CommandListenerWrapper)context.getSource(), WaypointArgument.a((CommandContext<CommandListenerWrapper>)context, "waypoint"), ResourceKey.a(WaypointStyleAssets.a, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "style")))))))))));
    }

    private static int a(CommandListenerWrapper source, WaypointTransmitter waypoint, ResourceKey<WaypointStyleAsset> style) {
        WaypointCommand.a(source, waypoint, (Waypoint.a icon) -> {
            icon.d = style;
        });
        source.a(() -> IChatBaseComponent.c("commands.waypoint.modify.style"), false);
        return 0;
    }

    private static int a(CommandListenerWrapper source, WaypointTransmitter waypoint, EnumChatFormat color) {
        WaypointCommand.a(source, waypoint, (Waypoint.a icon) -> {
            icon.e = Optional.of(color.f());
        });
        source.a(() -> IChatBaseComponent.a("commands.waypoint.modify.color", IChatBaseComponent.b(color.g()).a(color)), false);
        return 0;
    }

    private static int a(CommandListenerWrapper source, WaypointTransmitter waypoint, Integer color) {
        WaypointCommand.a(source, waypoint, (Waypoint.a icon) -> {
            icon.e = Optional.of(color);
        });
        source.a(() -> IChatBaseComponent.a("commands.waypoint.modify.color", IChatBaseComponent.b(String.format("%06X", ARGB.c(0, color))).b(color)), false);
        return 0;
    }

    private static int a(CommandListenerWrapper source, WaypointTransmitter waypoint) {
        WaypointCommand.a(source, waypoint, (Waypoint.a icon) -> {
            icon.e = Optional.empty();
        });
        source.a(() -> IChatBaseComponent.c("commands.waypoint.modify.color.reset"), false);
        return 0;
    }

    private static int a(CommandListenerWrapper source) {
        WorldServer level = source.e();
        Set<WaypointTransmitter> set = level.h().b();
        String string = level.al().a().toString();
        if (set.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.waypoint.list.empty", new Object[]{string}), false);
            return 0;
        }
        IChatBaseComponent component = ChatComponentUtils.b(set.stream().map(waypointTransmitter -> {
            if (waypointTransmitter instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)waypointTransmitter;
                BlockPosition blockPos = livingEntity.dF();
                return livingEntity.hu().f().a(style -> style.a(new ChatClickable.SuggestCommand("/execute in " + string + " run tp @s " + blockPos.u() + " " + blockPos.v() + " " + blockPos.w())).a(new ChatHoverable.e(IChatBaseComponent.c("chat.coordinates.tooltip"))).a(waypointTransmitter.gn().e.orElse(-1)));
            }
            return IChatBaseComponent.b(waypointTransmitter.toString());
        }).toList(), Function.identity());
        source.a(() -> IChatBaseComponent.a("commands.waypoint.list.success", set.size(), string, component), false);
        return set.size();
    }

    private static void a(CommandListenerWrapper source, WaypointTransmitter waypoint, Consumer<Waypoint.a> mutator) {
        WorldServer worldServer;
        if (waypoint instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)waypoint;
            worldServer = (WorldServer)livingEntity.an();
        } else {
            worldServer = source.e();
        }
        WorldServer level = worldServer;
        level.h().c(waypoint);
        mutator.accept(waypoint.gn());
        level.h().a(waypoint);
    }
}

