/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonElement;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import dev.omega24.upnp4j.UPnP4J;
import dev.omega24.upnp4j.util.Protocol;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.jsonrpc.JsonRpcNotificationService;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.security.JsonRpcSslContextProvider;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.UtilColor;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R6.util.ForwardLogHandler;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.task.BeehiveTask;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger m = LogUtils.getLogger();
    private static final int n = 5000;
    private static final int o = 2;
    private final Queue<ServerCommand> serverCommandQueue = new ConcurrentLinkedQueue<ServerCommand>();
    @Nullable
    private RemoteStatusListener q;
    @Nullable
    private RemoteControlListener s;
    public DedicatedServerSettings t;
    @Nullable
    private ServerGUI u;
    @Nullable
    private final ServerTextFilter v;
    @Nullable
    private RemoteSampleLogger w;
    private boolean x;
    public ServerLinks y;
    private final Map<String, String> z;
    @Nullable
    private ManagementServer A;
    private long B;
    private static final AtomicInteger ASYNC_DEBUG_CHUNKS_COUNT = new AtomicInteger();

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, DedicatedServerSettings settings, DataFixer fixerUpper, Services services) {
        super(options, worldLoader, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, fixerUpper, services, LoggingLevelLoadListener.a());
        this.t = settings;
        this.d(settings.a().h.get());
        this.v = ServerTextFilter.a(settings.a());
        this.y = DedicatedServer.a(settings);
        this.z = settings.a().i ? DedicatedServer.bU() : Map.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> bU() {
        Path path = Path.of("codeofconduct", new String[0]);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Code of Conduct folder does not exist: " + String.valueOf(path));
        }
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try (Stream<Path> stream = Files.list(path);){
                for (Path path1 : stream.toList()) {
                    String string = path1.getFileName().toString();
                    if (!string.endsWith(".txt")) continue;
                    String string1 = string.substring(0, string.length() - 4).toLowerCase(Locale.ROOT);
                    if (!path1.toRealPath(new LinkOption[0]).getParent().equals(path.toAbsolutePath())) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file \"" + string + "\" because it links to a file outside the allowed directory");
                    }
                    try {
                        String string2 = String.join((CharSequence)"\n", Files.readAllLines(path1, StandardCharsets.UTF_8));
                        builder.put((Object)string1, (Object)UtilColor.a(string2));
                    }
                    catch (IOException var9) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file " + string, var9);
                        return builder.build();
                    }
                }
            }
        }
        catch (IOException var11) {
            throw new IllegalArgumentException("Failed to read Code of Conduct folder", var11);
        }
    }

    private SslContext bV() {
        try {
            return JsonRpcSslContextProvider.a(this.a().v, this.a().w);
        }
        catch (Exception var2) {
            JsonRpcSslContextProvider.a();
            throw new IllegalStateException("Failed to configure TLS for the server management protocol", var2);
        }
    }

    @Override
    public boolean e() throws IOException {
        String proxyLink;
        Object bindAddress;
        int i2 = this.a().s;
        if (this.a().q) {
            String string = this.t.a().t;
            if (!SecurityConfig.a(string)) {
                throw new IllegalStateException("Invalid management server secret, must be 40 alphanumeric characters");
            }
            String string1 = this.a().r;
            HostAndPort hostAndPort = HostAndPort.fromParts((String)string1, (int)i2);
            SecurityConfig securityConfig = new SecurityConfig(string);
            AuthenticationHandler authenticationHandler = new AuthenticationHandler(securityConfig);
            m.info("Starting json RPC server on {}", (Object)hostAndPort);
            this.A = new ManagementServer(hostAndPort, authenticationHandler);
            MinecraftApi minecraftApi = MinecraftApi.a(this);
            minecraftApi.h().a(new JsonRpcNotificationService(minecraftApi, this.A));
            if (this.a().u) {
                SslContext sslContext = this.bV();
                this.A.a(minecraftApi, sslContext);
            } else {
                this.A.a(minecraftApi);
            }
        }
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                if (DedicatedServer.this.u == null || System.console() != null) {
                    new PaperConsole(DedicatedServer.this).start();
                }
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (HostAndPort handler : global.getHandlers()) {
            global.removeHandler((Handler)handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(m));
        m.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            m.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            m.warn("****************************");
            m.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            m.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            m.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            m.warn("****************************");
        }
        m.info("Loading properties");
        DedicatedServerProperties properties = this.t.a();
        if (this.Y()) {
            this.a_("127.0.0.1");
        } else {
            this.d(properties.d);
            this.e(properties.e);
            this.a_(properties.f);
        }
        this.a(new DedicatedPlayerList(this, this.bh(), this.h));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        this.paperConfigurations.initializeGlobalConfiguration(this.bg());
        this.paperConfigurations.initializeWorldDefaultsConfiguration(this.bg());
        this.server.spark.enableEarlyIfRequested();
        if (this.bI()) {
            this.av().f().save(false);
        }
        this.bE().loadAndSaveFiles();
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
        thread.start();
        PaperCommands.registerCommands(this);
        this.server.spark.registerCommandBeforePlugins(this.server);
        Metrics.PaperMetrics.startMetrics();
        try {
            PurpurConfig.init((File)this.options.valueOf("purpur-settings"));
        }
        catch (Exception e2) {
            m.error("Unable to load server configuration", (Throwable)e2);
            return false;
        }
        PurpurConfig.registerCommands();
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        m.info("Default game type: {}", (Object)properties.n.get());
        if (this.A().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                m.error("**** INVALID CONFIGURATION!");
                m.error("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!GlobalConfiguration.get().proxies.velocity.enabled && !SpigotConfig.bungee) {
                m.error("**** INVALID CONFIGURATION!");
                m.error("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.A().substring("unix:".length()));
        } else {
            InetAddress inetAddress = null;
            if (!this.A().isEmpty()) {
                inetAddress = InetAddress.getByName(this.A());
            }
            if (this.W() < 0) {
                this.b(properties.p);
            }
            bindAddress = new InetSocketAddress(inetAddress, this.W());
        }
        this.Z();
        m.info("Starting Minecraft server on {}:{}", (Object)(this.A().isEmpty() ? "*" : this.A()), (Object)this.W());
        try {
            this.an().startTcpServerListener((SocketAddress)bindAddress);
        }
        catch (IOException var11) {
            m.warn("**** FAILED TO BIND TO PORT!");
            m.warn("The exception was: {}", (Object)var11.toString());
            m.warn("Perhaps a server is already running on that port?");
            throw new IllegalStateException("Failed to bind to port", var11);
        }
        if (PurpurConfig.useUPnP) {
            m.info("[UPnP] Attempting to start UPnP port forwarding service...");
            if (UPnP4J.isUPnPAvailable()) {
                if (UPnP4J.isOpen((int)this.W(), (Protocol)Protocol.TCP)) {
                    this.upnp = false;
                    m.info("[UPnP] Port {} is already open", (Object)this.W());
                } else if (UPnP4J.open((int)this.W(), (Protocol)Protocol.TCP)) {
                    this.upnp = true;
                    m.info("[UPnP] Successfully opened port {}", (Object)this.W());
                } else {
                    this.upnp = false;
                    m.info("[UPnP] Failed to open port {}", (Object)this.W());
                }
                if (this.upnp) {
                    m.info("[UPnP] {}:{}", (Object)UPnP4J.getExternalIP(), (Object)this.W());
                }
            } else {
                this.upnp = false;
                m.error("[UPnP] Service is unavailable");
            }
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        boolean usingProxy = SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled;
        String proxyFlavor = GlobalConfiguration.get().proxies.velocity.enabled ? "Velocity" : "BungeeCord";
        String string = proxyLink = GlobalConfiguration.get().proxies.velocity.enabled ? "https://docs.papermc.io/velocity/security" : "http://www.spigotmc.org/wiki/firewall-guide/";
        if (!this.ag()) {
            m.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            m.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (usingProxy) {
                m.warn("Whilst this makes it possible to use {}, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.", (Object)proxyFlavor);
                m.warn("Please see {} for further information.", (Object)proxyLink);
            } else {
                m.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            m.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        this.w = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.bA(), RemoteDebugSampleType.a);
        long nanos = SystemUtils.d();
        this.j.f().a(!this.ag());
        m.info("Preparing level \"{}\"", (Object)this.j());
        this.loadLevel(this.g.f());
        long l2 = SystemUtils.d() - nanos;
        String string2 = String.format(Locale.ROOT, "%.3fs", (double)l2 / 1.0E9);
        m.info("Done preparing level \"{}\" ({})", (Object)this.j(), (Object)string2);
        this.initPostWorld();
        if (properties.x != null) {
            this.aQ().b(GameRules.C).set(properties.x, this.O());
        }
        if (properties.y) {
            m.info("Starting GS4 status listener");
            this.q = RemoteStatusListener.a(this);
        }
        if (properties.A) {
            m.info("Starting remote control listener");
            this.s = RemoteControlListener.a(this);
        }
        if (properties.U) {
            MinecraftServerBeans.a(this);
            m.info("JMX monitoring enabled");
        }
        BossBarTask.startAll();
        if (PurpurConfig.beeCountPayload) {
            BeehiveTask.instance().register();
        }
        this.E().a();
        return true;
    }

    public File getPluginsFolder() {
        return (File)this.options.valueOf("plugins");
    }

    @Override
    public boolean aS() {
        return this.t.a().l.get();
    }

    @Override
    public void f(boolean enforceWhitelist) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.l.a(this.bg(), enforceWhitelist));
    }

    @Override
    public boolean aT() {
        return this.t.a().ae.get();
    }

    @Override
    public void g(boolean usingWhitelist) {
        new WhitelistToggleEvent(usingWhitelist).callEvent();
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ae.a(this.bg(), usingWhitelist));
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft) {
        long l2;
        super.a(hasTimeLeft);
        if (this.A != null) {
            this.A.a();
        }
        long millis = SystemUtils.c();
        int i2 = this.bH();
        if (i2 > 0 && millis - this.B >= (l2 = (long)i2 * TimeRange.c)) {
            this.B = millis;
            this.E().e();
        }
    }

    @Override
    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        this.E().c();
        boolean flag = super.a(suppressLogs, flush, force);
        this.E().d();
        return flag;
    }

    @Override
    public boolean aj() {
        return this.t.a().g.get();
    }

    public void i(boolean allowFlight) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.g.a(this.bg(), allowFlight));
    }

    @Override
    public DedicatedServerProperties a() {
        return this.t.a();
    }

    public void a(EnumDifficulty difficulty) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.m.a(this.bg(), difficulty));
        this.v();
    }

    @Override
    public void v() {
    }

    public int bB() {
        return this.t.a().L.get();
    }

    public void e(int viewDistance) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.L.a(this.bg(), viewDistance));
        this.bE().a(viewDistance);
    }

    public int bC() {
        return this.t.a().M.get();
    }

    public void f(int simulationDistance) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.M.a(this.bg(), simulationDistance));
        this.bE().b(simulationDistance);
    }

    @Override
    public SystemReport a(SystemReport report) {
        report.a("Is Modded", () -> this.U().b());
        report.a("Type", () -> "Dedicated Server (map_server.txt)");
        return report;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties properties = this.a();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", properties.S));
            bufferedWriter.write(String.format(Locale.ROOT, "gamemode=%s%n", properties.n.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", properties.X.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", properties.R));
            bufferedWriter.write(String.format(Locale.ROOT, "view-distance=%d%n", properties.L.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", properties.M.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", properties.ai.d()));
            bufferedWriter.write(String.format(Locale.ROOT, "use-native=%s%n", properties.E));
            bufferedWriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", properties.K));
        }
    }

    @Override
    public void i() {
        if (this.v != null) {
            this.v.close();
        }
        if (this.u != null) {
            this.u.b();
        }
        if (this.s != null) {
            this.s.stopNonBlocking();
        }
        if (this.q != null) {
            // empty if block
        }
        if (this.A != null) {
            try {
                this.A.a(true);
            }
            catch (InterruptedException var2) {
                m.error("Interrupted while stopping the management server", (Throwable)var2);
            }
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void L() {
        super.L();
        this.bD();
    }

    public void a(String msg, CommandListenerWrapper source) {
        if (msg.equalsIgnoreCase("paper debug chunks --async")) {
            m.info("Scheduling async debug chunks");
            Runnable run = () -> {
                m.info("Async debug chunks executing");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(this, false);
                ConsoleCommandSender sender = MinecraftServer.getServer().console;
                File file = ChunkTaskScheduler.getChunkDebugFile();
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
                try {
                    JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(this), file);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.m.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
            };
            Thread t2 = new Thread(run);
            t2.setName("Async debug thread #" + ASYNC_DEBUG_CHUNKS_COUNT.getAndIncrement());
            t2.setDaemon(true);
            t2.start();
            return;
        }
        this.serverCommandQueue.add(new ServerCommand(msg, source));
    }

    public void bD() {
        ServerCommand consoleInput;
        while ((consoleInput = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, consoleInput.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            consoleInput = new ServerCommand(event.getCommand(), consoleInput.b);
            this.aJ().a(consoleInput.b, consoleInput.a);
        }
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public int o() {
        return this.a().K;
    }

    @Override
    public boolean p() {
        return this.a().E;
    }

    public DedicatedPlayerList bE() {
        return (DedicatedPlayerList)super.am();
    }

    @Override
    public int t() {
        return this.t.a().N.get();
    }

    public void g(int maxPlayers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.N.a(this.bg(), maxPlayers));
    }

    @Override
    public boolean s() {
        return true;
    }

    @Override
    public String b() {
        return this.A();
    }

    @Override
    public int d() {
        return this.W();
    }

    @Override
    public String h() {
        return this.ak();
    }

    public void bF() {
        if (this.u == null) {
            this.u = ServerGUI.a(this);
        }
    }

    @Override
    public boolean ap() {
        return this.u != null;
    }

    public int bG() {
        return this.a().F.get();
    }

    public void h(int radius) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.F.a(this.bg(), radius));
    }

    @Override
    public boolean a(WorldServer level, BlockPosition pos, EntityHuman player) {
        int abs1;
        WorldData.a respawnData = level.A();
        if (level.al() != respawnData.a()) {
            return false;
        }
        if (this.bE().k().d()) {
            return false;
        }
        if (this.bE().f(player.gA())) {
            return false;
        }
        if (this.bG() <= 0) {
            return false;
        }
        BlockPosition blockPos = respawnData.b();
        int abs = MathHelper.a(pos.u() - blockPos.u());
        int max = Math.max(abs, abs1 = MathHelper.a(pos.w() - blockPos.w()));
        return max <= this.bG();
    }

    @Override
    public boolean ar() {
        return this.a().V.get();
    }

    public void j(boolean repliesToStatus) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.V.a(this.bg(), repliesToStatus));
    }

    @Override
    public boolean as() {
        return this.a().W.get();
    }

    public void k(boolean hidesOnlinePlayers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.W.a(this.bg(), hidesOnlinePlayers));
    }

    @Override
    public int k() {
        return this.a().G.get();
    }

    public void i(int operatorUserPermissionLevel) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.G.a(this.bg(), operatorUserPermissionLevel));
    }

    @Override
    public int l() {
        return this.a().H;
    }

    @Override
    public int au() {
        return this.t.a().ac.get();
    }

    @Override
    public void d(int idleTimeout) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ac.a(this.bg(), idleTimeout));
    }

    public int bH() {
        return this.t.a().ad.get();
    }

    public void j(int heartbeatInterval) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ad.a(this.bg(), heartbeatInterval));
    }

    @Override
    public String ak() {
        return super.ak();
    }

    @Override
    public void d(String motd) {
        super.d(motd);
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.h.a(this.bg(), this.ak()));
    }

    @Override
    public boolean m() {
        return this.a().P;
    }

    @Override
    public boolean c() {
        return this.a().Q;
    }

    @Override
    public int ay() {
        return this.a().R;
    }

    @Override
    public int aB() {
        return this.a().O;
    }

    @Override
    public boolean aC() {
        DedicatedServerProperties properties = this.a();
        return properties.af && GlobalConfiguration.get().proxies.isProxyOnlineMode() && this.j.b();
    }

    @Override
    public boolean br() {
        return this.a().ag;
    }

    protected boolean bI() {
        boolean flag = false;
        for (int i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                m.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bW();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int var7 = 0; !flag1 && var7 <= 2; ++var7) {
            if (var7 > 0) {
                m.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bW();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (int var8 = 0; !flag2 && var8 <= 2; ++var8) {
            if (var8 > 0) {
                m.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bW();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (int var9 = 0; !flag3 && var9 <= 2; ++var9) {
            if (var9 > 0) {
                m.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bW();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (int var10 = 0; !flag4 && var10 <= 2; ++var10) {
            if (var10 > 0) {
                m.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bW();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bW() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bJ() {
        return this.a().I;
    }

    @Override
    public int bp() {
        return this.a().J;
    }

    @Override
    public String q() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String command) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        if (s2.isBlank()) {
            return "";
        }
        rconConsoleSource.e();
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.aJ().a(wrapper, event.getCommand());
        });
        return rconConsoleSource.f();
    }

    @Override
    public void z() {
        this.E().b();
        super.z();
    }

    @Override
    public boolean a(NameAndId nameAndId) {
        return false;
    }

    @Override
    public int c(int trackingDistance) {
        return this.bK() * trackingDistance / 100;
    }

    public int bK() {
        return this.a().X.get();
    }

    public void k(int entityBroadcastRangePercentage) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.X.a(this.bg(), entityBroadcastRangePercentage));
    }

    @Override
    public String j() {
        return this.g.f();
    }

    @Override
    public boolean bd() {
        return this.t.a().S;
    }

    @Override
    public ITextFilter a(EntityPlayer player) {
        return this.v != null ? this.v.a(player.gz()) : ITextFilter.e;
    }

    @Override
    @Nullable
    public EnumGamemode bj() {
        return this.bL() ? this.k.j() : null;
    }

    public boolean bL() {
        return this.t.a().k.get();
    }

    public void l(boolean forceGameMode) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.k.a(this.bg(), forceGameMode));
        this.b(this.bj());
    }

    public EnumGamemode bM() {
        return this.a().n.get();
    }

    public void c(EnumGamemode gameMode) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.n.a(this.bg(), gameMode));
        this.k.a(this.bM());
        this.b(this.bj());
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> ae() {
        return this.t.a().aa;
    }

    @Override
    public void aY() {
        super.aY();
        this.x = this.bA().a(DebugSubscriptions.a);
    }

    @Override
    public SampleLogger f() {
        return this.w;
    }

    @Override
    public boolean g() {
        return this.x;
    }

    @Override
    public boolean bu() {
        return this.t.a().aj.get();
    }

    public void m(boolean acceptsTransfers) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.aj.a(this.bg(), acceptsTransfers));
    }

    @Override
    public ServerLinks bx() {
        return this.y;
    }

    @Override
    public int by() {
        return this.t.a().ah.get();
    }

    public void l(int pauseWhenEmptySeconds) {
        this.t.a(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.ah.a(this.bg(), pauseWhenEmptySeconds));
    }

    private static ServerLinks a(DedicatedServerSettings settings) {
        Optional<URI> optional = DedicatedServer.a(settings.a());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.a.a((URI)uri)))).orElse(ServerLinks.a);
    }

    private static Optional<URI> a(DedicatedServerProperties properties) {
        String string = properties.j;
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.a(string));
        }
        catch (Exception var3) {
            m.warn("Failed to parse bug link {}", (Object)string, (Object)var3);
            return Optional.empty();
        }
    }

    @Override
    public Map<String, String> ad() {
        return this.z;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

