/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;

public interface IncomingRpcMethod {
    public MethodInfo a();

    public a b();

    public JsonElement a(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> c<e<Result>> a(f<Result> supplier, Codec<Result> resultCodec) {
        return new c<e<Result>>((info, attributes) -> {
            if (info.b().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.c().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new e(info, attributes, resultCodec, supplier);
        });
    }

    public static <Params, Result> c<d<Params, Result>> a(g<Params, Result> function, Codec<Params> paramsCodec, Codec<Result> resultCodec) {
        return new c<d<Params, Result>>((info, attributes) -> {
            if (info.b().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (info.c().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new d(info, attributes, paramsCodec, resultCodec, function);
        });
    }

    public static <Result> c<e<Result>> a(Function<MinecraftApi, Result> callback, Codec<Result> resultCodec) {
        return new c<e<Result>>((info, attributes) -> {
            if (info.b().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (info.c().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new e<Object>(info, attributes, resultCodec, (api, client) -> callback.apply(api));
        });
    }

    public static class c<T extends IncomingRpcMethod> {
        private final b<T> a;
        private String b = "";
        @Nullable
        private ParamInfo c;
        @Nullable
        private ResultInfo d;
        private boolean e = true;
        private boolean f = true;

        public c(b<T> method) {
            this.a = method;
        }

        public c<T> a(String description) {
            this.b = description;
            return this;
        }

        public c<T> a(ResultInfo resultInfo) {
            this.d = resultInfo;
            return this;
        }

        public c<T> a(ParamInfo paramInfo) {
            this.c = paramInfo;
            return this;
        }

        public c<T> a() {
            this.e = false;
            return this;
        }

        public c<T> b() {
            this.f = false;
            return this;
        }

        public T c() {
            MethodInfo methodInfo = new MethodInfo(this.b, this.c, this.d);
            return this.a.create(methodInfo, new a(this.f, this.e));
        }

        public T a(IRegistry<IncomingRpcMethod> registry, String namespace) {
            return this.a(registry, MinecraftKey.b(namespace));
        }

        private T a(IRegistry<IncomingRpcMethod> registry, MinecraftKey id) {
            return (T)((IncomingRpcMethod)IRegistry.a(registry, id, this.c()));
        }
    }

    @FunctionalInterface
    public static interface f<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface b<T extends IncomingRpcMethod> {
        public T create(MethodInfo var1, a var2);
    }

    @FunctionalInterface
    public static interface g<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record e<Result>(MethodInfo a, a b, Codec<Result> c, f<Result> d) implements IncomingRpcMethod
    {
        @Override
        public JsonElement a(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params == null || params.isJsonArray() && params.getAsJsonArray().isEmpty()) {
                if (this.a.b().isPresent()) {
                    throw new IllegalArgumentException("Method defined as not having parameters but is describing them");
                }
                Result object = this.d.apply(api, client);
                return (JsonElement)this.c.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(InvalidParameterJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "info;attributes;resultCodec;supplier", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "info;attributes;resultCodec;supplier", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "info;attributes;resultCodec;supplier", "a", "b", "c", "d"}, this, o2);
        }
    }

    public record a(boolean a, boolean b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this, o2);
        }
    }

    public record d<Params, Result>(MethodInfo a, a b, Codec<Params> c, Codec<Result> d, g<Params, Result> e) implements IncomingRpcMethod
    {
        @Override
        public JsonElement a(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params != null && (params.isJsonArray() || params.isJsonObject())) {
                JsonElement jsonElement1;
                if (this.a.b().isEmpty()) {
                    throw new IllegalArgumentException("Method defined as having parameters without describing them");
                }
                if (params.isJsonObject()) {
                    String string = this.a.b().get().a();
                    JsonElement jsonElement = params.getAsJsonObject().get(string);
                    if (jsonElement == null) {
                        throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", string));
                    }
                    jsonElement1 = jsonElement;
                } else {
                    JsonArray asJsonArray = params.getAsJsonArray();
                    if (asJsonArray.isEmpty() || asJsonArray.size() > 1) {
                        throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                    }
                    jsonElement1 = asJsonArray.get(0);
                }
                Object orThrow = this.c.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement1).getOrThrow(InvalidParameterJsonRpcException::new);
                Result object = this.e.apply(api, orThrow, client);
                return (JsonElement)this.d.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(EncodeJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected params as array or named");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "info;attributes;paramsCodec;resultCodec;function", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "info;attributes;paramsCodec;resultCodec;function", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "info;attributes;paramsCodec;resultCodec;function", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

