/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer a;
    private final JsonRpcLogger b;

    public MinecraftGameRuleServiceImpl(DedicatedServer server, JsonRpcLogger jsonrpcLogger) {
        this.a = server;
        this.b = jsonrpcLogger;
    }

    @Override
    public GameRulesService.b a(GameRulesService.c rule, ClientInfo client) {
        GameRules.GameRuleValue<?> ruleValue = this.b(rule.a());
        String string = ruleValue.b();
        if (ruleValue instanceof GameRules.GameRuleBoolean) {
            GameRules.GameRuleBoolean booleanValue = (GameRules.GameRuleBoolean)ruleValue;
            booleanValue.set(Boolean.parseBoolean(rule.b()), this.a.O());
        } else {
            if (!(ruleValue instanceof GameRules.GameRuleInt)) {
                throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + rule.a());
            }
            GameRules.GameRuleInt integerValue = (GameRules.GameRuleInt)ruleValue;
            integerValue.set(Integer.parseInt(rule.b()), this.a.O());
        }
        GameRulesService.b typedRule = this.a(rule.a(), ruleValue);
        this.b.a(client, "Game rule '{}' updated from '{}' to '{}'", typedRule.a(), string, typedRule.b());
        this.a.E().onGameRuleChanged(this.a.O(), rule.a(), ruleValue);
        return typedRule;
    }

    @Override
    public <T extends GameRules.GameRuleValue<T>> T a(GameRules.GameRuleKey<T> key) {
        return this.a.aQ().b(key);
    }

    @Override
    public GameRulesService.b a(String key, GameRules.GameRuleValue<?> value) {
        GameRules.GameRuleValue<?> gameRuleValue = value;
        Objects.requireNonNull(gameRuleValue);
        GameRules.GameRuleValue<?> gameRuleValue2 = gameRuleValue;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.GameRuleBoolean.class, GameRules.GameRuleInt.class}, gameRuleValue2, n2)) {
            case 0 -> {
                GameRules.GameRuleBoolean booleanValue = (GameRules.GameRuleBoolean)gameRuleValue2;
                yield new GameRulesService.b(key, String.valueOf(booleanValue.a()), GameRulesService.a.b);
            }
            case 1 -> {
                GameRules.GameRuleInt integerValue = (GameRules.GameRuleInt)gameRuleValue2;
                yield new GameRulesService.b(key, String.valueOf(integerValue.a()), GameRulesService.a.a);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> a() {
        FeatureFlagSet featureFlagSet = this.a.bf().I().g().b();
        return GameRules.a(featureFlagSet);
    }

    private Optional<GameRules.GameRuleKey<?>> a(String id) {
        Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> availableGameRules = this.a();
        return availableGameRules.filter(entry -> ((GameRules.GameRuleKey)entry.getKey()).a().equals(id)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.GameRuleValue<?> b(String id) {
        GameRules.GameRuleKey<?> key = this.a(id).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + id + "' does not exist"));
        return this.a.aQ().b(key);
    }
}

