/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Logger c = LogUtils.getLogger();
    private static final AttributeKey<Boolean> d = AttributeKey.valueOf((String)"authenticated");
    public static final String a = "Authorization";
    public static final String b = "Bearer ";
    private final SecurityConfig e;

    public AuthenticationHandler(SecurityConfig securityConfig) {
        this.e = securityConfig;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Boolean _boolean;
        String clientIp = this.a(ctx);
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            a securityCheckResult = this.a(httpRequest);
            if (!securityCheckResult.b()) {
                this.c.debug("Authentication rejected for connection with ip {}: {}", (Object)clientIp, (Object)securityCheckResult.c());
                ctx.channel().attr(d).set((Object)false);
                this.a(ctx, securityCheckResult.c());
                return;
            }
            ctx.channel().attr(d).set((Object)true);
        }
        if (Boolean.TRUE.equals(_boolean = (Boolean)ctx.channel().attr(d).get())) {
            super.channelRead(ctx, msg);
        } else {
            this.c.debug("Dropping unauthenticated connection with ip {}", (Object)clientIp);
            ctx.close();
        }
    }

    private a a(HttpRequest request) {
        return !this.b(request) ? net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Invalid or missing API key") : net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a();
    }

    private boolean b(HttpRequest request) {
        String string = request.headers().get(a);
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (string.startsWith(b)) {
            String trimmed = string.substring(b.length()).trim();
            return this.a(trimmed);
        }
        return false;
    }

    public boolean a(String key) {
        if (key != null && !key.isEmpty()) {
            byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
            byte[] bytes1 = this.e.b().getBytes(StandardCharsets.UTF_8);
            return MessageDigest.isEqual(bytes, bytes1);
        }
        return false;
    }

    private String a(ChannelHandlerContext ctx) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetSocketAddress.getAddress().getHostAddress();
    }

    private void a(ChannelHandlerContext ctx, String message) {
        String string = "{\"error\":\"Unauthorized\",\"message\":\"" + message + "\"}";
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])bytes));
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)defaultFullHttpResponse).addListener(future -> ctx.close());
    }

    static class a {
        private final boolean a;
        private final String b;

        private a(boolean allowed, String reason) {
            this.a = allowed;
            this.b = reason;
        }

        public static a a() {
            return new a(true, null);
        }

        public static a a(String reason) {
            return new a(false, reason);
        }

        public boolean b() {
            return this.a;
        }

        public String c() {
            return this.b;
        }
    }
}

