/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.PlayerAFKEvent;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cA = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cB = 32;
    private static final int cC = 10;
    private static final int cD = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    public static final String f = "Dimension";
    private static final AttributeModifier cE = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cG = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final AttributeModifier cH = new AttributeModifier(MinecraftKey.b("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.c);
    private static final boolean cI = false;
    private static final boolean cJ = false;
    public PlayerConnection g;
    private final MinecraftServer cK;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cL;
    private final ServerStatisticManager cM;
    private float cN = Float.MIN_VALUE;
    private int cO = Integer.MIN_VALUE;
    private int cP = Integer.MIN_VALUE;
    private int cS = Integer.MIN_VALUE;
    private int cT = Integer.MIN_VALUE;
    private int cU = Integer.MIN_VALUE;
    private float cV = -1.0E8f;
    private int cW = -99999999;
    private boolean cX = true;
    public int cY = -99999999;
    private EnumChatVisibility cZ = EnumChatVisibility.a;
    public ParticleStatus da = ParticleStatus.a;
    private boolean db = true;
    private long dc = SystemUtils.c();
    @Nullable
    private net.minecraft.world.entity.Entity dd;
    public boolean de;
    public boolean i = false;
    private final RecipeBookServer df;
    @Nullable
    private Vec3D dg;
    private int dh;
    private boolean di;
    private int dj = 2;
    public String dk = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D dl;
    @Nullable
    private Vec3D dm;
    @Nullable
    private Vec3D dn;
    private SectionPosition do = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dp = ChunkTrackingView.a;
    @Nullable
    private RespawnConfig dq;
    private final ITextFilter dr;
    private boolean ds;
    private boolean dt;
    private boolean du = false;
    public WardenSpawnTracker dv = new WardenSpawnTracker();
    @Nullable
    private BlockPosition dw;
    private Vec3D dx = Vec3D.c;
    private Input dy = Input.b;
    private final Set<EntityEnderPearl> dz = new HashSet<EntityEnderPearl>();
    private long dA;
    private NBTTagCompound dB = new NBTTagCompound();
    private NBTTagCompound dC = new NBTTagCompound();
    public final ContainerSynchronizer dD = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.ej().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> component) {
                return ((HashCode)component.a(this.b).getOrThrow(string -> new IllegalArgumentException("Failed to hash " + String.valueOf(component) + ": " + string))).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> items, ItemStack carried, int[] remoteDataSlots) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowItems(container.l, container.k(), items, carried));
            for (int i2 = 0; i2 < remoteDataSlots.length; ++i2) {
                this.b(container, i2, remoteDataSlots[i2]);
            }
        }

        @Override
        public void sendOffHandSlotChange() {
            this.a((Container)EntityPlayer.this.ck, 45, EntityPlayer.this.ck.b(45).g().v());
        }

        @Override
        public void a(Container container, int slot, ItemStack stack) {
            EntityPlayer.this.g.b(new PacketPlayOutSetSlot(container.l, container.k(), slot, stack));
        }

        @Override
        public void a(Container containerMenu, ItemStack stack) {
            EntityPlayer.this.g.b(new ClientboundSetCursorItemPacket(stack));
        }

        @Override
        public void a(Container container, int id, int value) {
            this.b(container, id, value);
        }

        private void b(Container container, int id, int value) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowData(container.l, id, value));
        }

        @Override
        public RemoteSlot a() {
            return new RemoteSlot.a(arg_0 -> this.b.getUnchecked(arg_0));
        }
    };
    private final ICrafting dE = new ICrafting(){

        @Override
        public void a(Container containerToSend, int dataSlotIndex, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gB()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gB(), stack);
            }
        }

        @Override
        public void slotChanged(Container containerToSend, int dataSlotIndex, ItemStack oldStack, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gB()) {
                if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gB(), stack);
                    return;
                }
                PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), dataSlotIndex, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                event.callEvent();
                if (event.shouldTriggerAdvancements()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gB(), stack);
                }
            }
        }

        @Override
        public void a(Container containerMenu, int dataSlotIndex, int value) {
        }
    };
    @Nullable
    private RemoteChatSession dF;
    @Nullable
    public final Object j;
    private final ICommandListener dG = new ICommandListener(){

        @Override
        public boolean z_() {
            return EntityPlayer.this.A().S().c(GameRules.q);
        }

        @Override
        public boolean A_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent message) {
            EntityPlayer.this.a(message);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private Set<DebugSubscription<?>> dH = Set.of();
    private int dI;
    public boolean k;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    @Nullable
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    @Nullable
    public String lastKnownName;
    public String displayName;
    public Component adventure$displayName;
    @Nullable
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean suppressTrackerForLogin = false;
    public boolean isRealPlayer;
    @Nullable
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public PlayerQuitEvent.QuitReason quitReason = null;
    private boolean tpsBar = false;
    private boolean compassBar = false;
    private boolean ramBar = false;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private boolean isAfk = false;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    @Nullable
    public WeatherType weatherType = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer level, GameProfile gameProfile, ClientInformation clientInformation) {
        super(level, gameProfile);
        this.cK = server;
        this.dr = server.a(this);
        this.h = server.b(this);
        this.h.a(this.b((EnumGamemode)null), null);
        this.df = new RecipeBookServer((recipe, output) -> server.aN().a(recipe, output));
        this.cM = server.am().getPlayerStats(this);
        this.cL = server.am().f(this);
        this.updateOptionsNoEvents(clientInformation);
        this.j = null;
        this.displayName = this.cV();
        this.adventure$displayName = Component.text((String)this.cV());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.fj();
    }

    @Override
    public BlockPosition a(WorldServer level, BlockPosition pos) {
        CompletableFuture<Vec3D> completableFuture = PlayerSpawnFinder.a(level, pos);
        level.H.g.b(completableFuture::isDone);
        return BlockPosition.a(completableFuture.join());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.dv = input.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.dm = input.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = input.a("seenCredits", false);
        input.a("recipeBook", RecipeBookServer.b.a).ifPresent(packed -> this.df.a((RecipeBookServer.b)packed, (ResourceKey<IRecipe<?>> key) -> this.cK.aN().b((ResourceKey<IRecipe<?>>)key).isPresent()));
        this.getBukkitEntity().readExtraData(input);
        if (this.gg()) {
            this.gh();
        }
        this.dq = input.a("respawn", RespawnConfig.a).orElse(null);
        this.du = input.a("spawn_extra_particles_on_fall", false);
        this.dw = input.a("raid_omen_position", BlockPosition.a).orElse(null);
        this.tpsBar = input.a("Purpur.TPSBar", false);
        this.compassBar = input.a("Purpur.CompassBar", false);
        this.ramBar = input.a("Purpur.RamBar", false);
        this.loadGameTypes(input);
    }

    private void loadGameTypes(ValueInput input) {
        if (this.cK.bj() != null && this.cK.bj() != EntityPlayer.a(input, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.cK.y().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.h.a(this.cK.bj(), EnumGamemode.e);
            } else {
                this.h.a(EntityPlayer.a(input, "playerGameType"), EntityPlayer.a(input, "previousPlayerGameType"));
            }
            return;
        }
        this.h.a(this.b(EntityPlayer.a(input, "playerGameType")), EntityPlayer.a(input, "previousPlayerGameType"));
        this.b(input.a("ShoulderEntityLeft", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.c(input.a("ShoulderEntityRight", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dv);
        this.g(output);
        output.a("seenCredits", this.i);
        output.b("entered_nether_pos", Vec3D.a, this.dm);
        this.e(output);
        output.a("recipeBook", RecipeBookServer.b.a, this.df.b());
        output.a(f, this.A().al().a().toString());
        output.b("respawn", RespawnConfig.a, this.dq);
        output.a("spawn_extra_particles_on_fall", this.du);
        output.b("raid_omen_position", BlockPosition.a, this.dw);
        this.f(output);
        if (!this.ak().j()) {
            output.a("ShoulderEntityLeft", NBTTagCompound.a, this.ak());
        }
        if (!this.al().j()) {
            output.a("ShoulderEntityRight", NBTTagCompound.a, this.al());
        }
        this.getBukkitEntity().setExtraData(output);
        output.a("Purpur.TPSBar", this.tpsBar);
        output.a("Purpur.CompassBar", this.compassBar);
        output.a("Purpur.RamBar", this.ramBar);
    }

    private void e(ValueOutput output) {
        net.minecraft.world.entity.Entity rootVehicle = this.dp();
        net.minecraft.world.entity.Entity vehicle = this.du();
        boolean persistVehicle = true;
        if (vehicle != null) {
            for (net.minecraft.world.entity.Entity topVehicle = vehicle; topVehicle != null; topVehicle = topVehicle.du()) {
                if (topVehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && vehicle != null && rootVehicle != this && rootVehicle.do() && !rootVehicle.ec()) {
            ValueOutput valueOutput = output.a("RootVehicle");
            valueOutput.a("Attach", UUIDUtil.a, vehicle.cT());
            rootVehicle.c(valueOutput.a("Entity"));
        }
    }

    public void b(ValueInput input) {
        Optional<ValueInput> optional = input.a("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer serverLevel = this.A();
            net.minecraft.world.entity.Entity entity = EntityTypes.a(optional.get().b("Entity"), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r, entity2 -> !serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity2, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity2);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cT().equals(uuid)) {
                    this.a(entity, true, false);
                } else {
                    for (net.minecraft.world.entity.Entity entity1 : entity.dm()) {
                        if (!entity1.cT().equals(uuid)) continue;
                        this.a(entity1, true, false);
                        break;
                    }
                }
                if (!this.cl()) {
                    cA.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (net.minecraft.world.entity.Entity entity1x : entity.dm()) {
                        entity1x.discard(null);
                    }
                }
            }
        }
    }

    private void f(ValueOutput output) {
        if (!this.dz.isEmpty()) {
            ValueOutput.b valueOutputList = output.b(d);
            for (EntityEnderPearl thrownEnderpearl : this.dz) {
                if (thrownEnderpearl.an().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (thrownEnderpearl.ec()) {
                    cA.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueOutput = valueOutputList.a();
                thrownEnderpearl.c(valueOutput);
                valueOutput.a(e, net.minecraft.world.level.World.g, thrownEnderpearl.an().al());
            }
        }
    }

    public void c(ValueInput input) {
        input.d(d).forEach(this::e);
    }

    private void e(ValueInput input) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = input.a(e, net.minecraft.world.level.World.g);
        if (!optional.isEmpty()) {
            WorldServer level = this.A().q().a(optional.get());
            if (level != null) {
                net.minecraft.world.entity.Entity entity = EntityTypes.a(input, (net.minecraft.world.level.World)level, EntitySpawnReason.r, entity1 -> !level.c((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(level, entity.dH());
                } else {
                    cA.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cA.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(WorldServer level) {
        if (level == null) {
            throw new IllegalArgumentException("level can't be null");
        }
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    public void a(int experiencePoints) {
        float f2 = this.gL();
        float f1 = (f2 - 1.0f) / f2;
        this.ct = MathHelper.a((float)experiencePoints / f2, 0.0f, f1);
        this.cY = -1;
    }

    public void b(int level) {
        this.cr = level;
        this.cY = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cY = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int cost) {
        super.a(enchantedItem, cost);
        this.cY = -1;
    }

    public void a(Container menu) {
        menu.a(this.dE);
        menu.a(this.dD);
    }

    public void c() {
        this.a(this.ck);
    }

    @Override
    public void i_() {
        super.i_();
        this.g.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void Q_() {
        super.Q_();
        this.g.b(new ClientboundPlayerCombatEndPacket(this.fh()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        MobEffect nightVision;
        net.minecraft.world.entity.Entity camera;
        if (this.joining) {
            this.joining = false;
        }
        this.hc();
        this.h.a();
        this.dv.a();
        if (this.ax > 0) {
            --this.ax;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.cl.d();
            if (this.cl != this.ck) {
                this.ck.broadcastNonContainerSlotChanges();
            }
            this.containerUpdateDelay = this.A().paperConfig().tickRates.containerUpdate;
        }
        if (this.cl != this.ck && (this.fv() || !this.cl.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cl = this.ck;
        }
        if ((camera = this.N()) != this) {
            if (camera.bX()) {
                this.a(camera.dK(), camera.dM(), camera.dQ(), camera.dX(), camera.dZ());
                this.A().n().a(this);
                if (this.gq()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.dg != null) {
            CriterionTriggers.v.a(this, this.dg, this.at - this.dh);
        }
        this.m();
        this.n();
        this.hk();
        this.cL.a(this, true);
        if (this.A().purpurConfig.useNightVisionWhenRiding && this.du() != null && this.du().getRider() == this && this.A().ag() % 100L == 0L && ((nightVision = this.e(MobEffects.p)) == null || nightVision.d() <= 300)) {
            this.a(new MobEffect(MobEffects.p, 400, 0));
        }
    }

    private void hk() {
        AttributeModifiable attribute2;
        AttributeModifiable attribute1;
        AttributeModifiable attribute = this.h(GenericAttributes.g);
        if (attribute != null) {
            if (this.gQ()) {
                attribute.a(cE);
            } else {
                attribute.e(cE);
            }
        }
        if ((attribute1 = this.h(GenericAttributes.k)) != null) {
            if (this.gQ()) {
                attribute1.a(cF);
            } else {
                attribute1.e(cF);
            }
        }
        if ((attribute2 = this.h(GenericAttributes.H)) != null) {
            if (this.cu()) {
                attribute2.a(cH);
            } else {
                attribute2.e(cH);
            }
        }
    }

    public void h() {
        try {
            if (this.valid && !this.at() || !this.dy()) {
                super.g();
                if (!this.cl.b(this)) {
                    this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
                    this.cl = this.ck;
                }
                this.cm.a(this);
                this.a(StatisticList.k);
                this.a(StatisticList.l);
                if (this.bX()) {
                    this.a(StatisticList.m);
                }
                if (this.cs()) {
                    this.a(StatisticList.o);
                }
                if (!this.gg()) {
                    this.a(StatisticList.n);
                }
            }
            for (int i2 = 0; i2 < this.gB().b(); ++i2) {
                ItemStack item = this.gB().a(i2);
                if (item.f()) continue;
                this.i(item);
            }
            if (this.eU() != this.cV || this.cW != this.cm.a() || this.cm.c() == 0.0f != this.cX) {
                this.g.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.cm.a(), this.cm.c()));
                this.cV = this.eU();
                this.cW = this.cm.a();
                boolean bl = this.cX = this.cm.c() == 0.0f;
            }
            if (this.eU() + this.fM() != this.cN) {
                this.cN = this.eU() + this.fM();
                this.a(IScoreboardCriteria.h, MathHelper.f(this.cN));
            }
            if (this.cm.a() != this.cO) {
                this.cO = this.cm.a();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cO));
            }
            if (this.cF() != this.cP) {
                this.cP = this.cF();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cP));
            }
            if (this.fg() != this.cS) {
                this.cS = this.fg();
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cS));
            }
            if (this.cs != this.cU) {
                this.cU = this.cs;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cU));
            }
            if (this.maxHealthCache != (double)this.fj()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cr != this.cT) {
                this.cT = this.cr;
                this.a(IScoreboardCriteria.m, MathHelper.f((float)this.cT));
            }
            if (this.cs != this.cY) {
                this.cY = this.cs;
                this.g.b(new PacketPlayOutExperience(this.ct, this.cs, this.cr));
            }
            if (this.at % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cr;
            }
            if (this.oldLevel != this.cr) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cr);
                this.oldLevel = this.cr;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable var4) {
            CrashReport crashReport = CrashReport.a(var4, "Ticking player");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Player being ticked");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    private void i(ItemStack stack) {
        Packet<?> updatePacket;
        MapId mapId = stack.a(DataComponents.M);
        WorldMap savedData = ItemWorldMap.a(mapId, (net.minecraft.world.level.World)this.A());
        if (savedData != null && (updatePacket = savedData.a(mapId, this)) != null) {
            this.g.b(updatePacket);
        }
    }

    @Override
    protected void i() {
        if (this.A().aq() == EnumDifficulty.a && this.A().S().c(GameRules.l)) {
            if (this.at % 20 == 0) {
                float saturationLevel;
                if (this.eU() < this.fj()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((saturationLevel = this.cm.c()) < 20.0f) {
                    this.cm.b(saturationLevel + 1.0f);
                }
            }
            if (this.at % 10 == 0 && this.cm.b()) {
                this.cm.a(this.cm.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        this.e(this.ak());
        this.e(this.al());
        if ((this.an > 0.5 || this.bu() || this.gC().b || this.gg() || this.aJ) && !this.A().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.k();
        }
    }

    private void e(NBTTagCompound tag) {
        EntityTypes entityType;
        if (!(tag.j() || tag.b("Silent", false) || this.as.a(200) != 0 || (entityType = (EntityTypes)tag.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aT || EntityParrot.a((net.minecraft.world.level.World)this.A(), (net.minecraft.world.entity.Entity)this))) {
            this.A().a(null, this.dK(), this.dM(), this.dQ(), EntityParrot.a((net.minecraft.world.level.World)this.A(), this.as), this.dw(), 1.0f, EntityParrot.a(this.as));
        }
    }

    public boolean a(NBTTagCompound tag) {
        if (this.cl() || !this.aS() || this.bu() || this.aJ) {
            return false;
        }
        if (this.ak().j()) {
            this.b(tag);
            this.dA = this.A().ag();
            return true;
        }
        if (this.al().j()) {
            this.c(tag);
            this.dA = this.A().ag();
            return true;
        }
        return false;
    }

    @Override
    public void k() {
        if (this.dA + 20L < this.A().ag()) {
            if (this.respawnEntityOnShoulder(this.ak())) {
                this.b(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.al())) {
                this.c(new NBTTagCompound());
            }
        }
    }

    public net.minecraft.world.entity.Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity = this.respawnEntityOnShoulder0(this.ak());
        if (entity != null) {
            this.b(new NBTTagCompound());
        }
        return entity;
    }

    public net.minecraft.world.entity.Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity = this.respawnEntityOnShoulder0(this.al());
        if (entity != null) {
            this.c(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound tag) {
        return this.respawnEntityOnShoulder0(tag) != null;
    }

    @Nullable
    private net.minecraft.world.entity.Entity respawnEntityOnShoulder0(NBTTagCompound tag) {
        WorldServer scopedCollector = this.A();
        if (scopedCollector instanceof WorldServer) {
            WorldServer serverLevel = scopedCollector;
            if (!tag.j()) {
                try (ProblemReporter.j scopedCollectorx = new ProblemReporter.j(this.en(), cA);){
                    net.minecraft.world.entity.Entity entity2 = EntityTypes.a(TagValueInput.a(scopedCollectorx.a(() -> ".shoulder"), (HolderLookup.a)serverLevel.L_(), tag), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r).map(entity -> {
                        if (entity instanceof EntityTameableAnimal) {
                            EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)entity;
                            tamableAnimal.i(this);
                        }
                        entity.a_(this.dK(), this.dM() + (double)0.7f, this.dQ());
                        return serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY) ? entity : null;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    @Override
    public void l() {
        if (this.eU() > 0.0f && this.dl != null) {
            CriterionTriggers.Y.a(this, this.dl);
        }
        this.dl = null;
        super.l();
    }

    public void m() {
        if (this.an > 0.0 && this.dl == null) {
            this.dl = this.dD();
            if (this.cy != null && this.cy.h <= this.dl.h) {
                CriterionTriggers.af.a(this, this.cy, this.cz);
            }
        }
    }

    public void n() {
        if (this.du() != null && this.du().bJ()) {
            if (this.dn == null) {
                this.dn = this.dD();
            } else {
                CriterionTriggers.Z.a(this, this.dn);
            }
        }
        if (!(this.dn == null || this.du() != null && this.du().bJ())) {
            this.dn = null;
        }
    }

    private void a(IScoreboardCriteria criteria, int points) {
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(criteria, this, scoreAccess -> scoreAccess.a(points));
    }

    private static boolean shouldKeepDeathEventItem(PlayerDeathEvent event, ItemStack item) {
        List itemsToKeep = event.getItemsToKeep();
        if (EnchantmentManager.a(item, EnchantmentEffectComponents.D) || itemsToKeep.isEmpty() || item.f()) {
            return false;
        }
        org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
        Iterator iterator = itemsToKeep.iterator();
        while (iterator.hasNext()) {
            org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
            if (!bukkitStack.equals((Object)itemStack)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void sendClientboundPlayerCombatKillPacket(boolean displayMessage, IChatBaseComponent deathMessage) {
        if (displayMessage && deathMessage != CommonComponents.a) {
            this.g.a(new ClientboundPlayerCombatKillPacket(this.az(), deathMessage), PacketSendListener.a(() -> {
                int i2 = 256;
                String string = deathMessage.a(256);
                IChatMutableComponent component = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(string).a(EnumChatFormat.o));
                IChatMutableComponent component1 = IChatBaseComponent.a("death.attack.even_more_magic", this.S_()).a(style -> style.a(new ChatHoverable.e(component)));
                return new ClientboundPlayerCombatKillPacket(this.az(), component1);
            }));
        } else {
            this.g.b(new ClientboundPlayerCombatKillPacket(this.az(), CommonComponents.a));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        boolean keepInventory;
        boolean _boolean;
        boolean showDeathMessage = _boolean = this.A().S().c(GameRules.o);
        if (this.ec()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.gB().b());
        boolean bl = keepInventory = this.A().S().c(GameRules.e) || this.at();
        if (!keepInventory) {
            for (ItemStack item : this.gB().getContents()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false, null)));
            }
        }
        if (!this.at() && this.e(this.A())) {
            this.b(this.A(), damageSource, this.bH > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.fh().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damageSource, loot, PaperAdventure.asAdventure(defaultMessage), showDeathMessage, keepInventory);
        if (event.isCancelled()) {
            if (this.eU() <= 0.0f) {
                this.x((float)event.getReviveHealth());
            }
            return;
        }
        this.c(GameEvent.p);
        if (this.cl != this.ck) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        TextComponent apiDeathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        IChatBaseComponent deathScreenMessage = PaperAdventure.asVanilla((Component)(event.deathScreenMessageOverride() != null ? event.deathScreenMessageOverride() : apiDeathMessage));
        if (apiDeathMessage != null && apiDeathMessage != Component.empty() && event.getShowDeathMessages()) {
            IChatBaseComponent deathMessage = PaperAdventure.asVanilla((Component)apiDeathMessage);
            this.sendClientboundPlayerCombatKillPacket(event.getShowDeathMessages(), deathScreenMessage);
            ScoreboardTeam team = this.cD();
            if (PurpurConfig.deathMessageOnlyBroadcastToAffectedPlayer) {
                this.a(deathMessage);
            } else if (team == null || ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.a) {
                this.cK.am().a(deathMessage, false);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                this.cK.am().a((EntityHuman)this, deathMessage);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                this.cK.am().b(this, deathMessage);
            }
        } else {
            this.sendClientboundPlayerCombatKillPacket(event.getShowDeathMessages(), deathScreenMessage);
        }
        this.k();
        if (this.A().S().c(GameRules.P)) {
            this.hl();
        }
        if (event.shouldDropExperience()) {
            this.b(this.A(), damageSource.d());
        }
        if (!event.getKeepInventory()) {
            for (int i2 = 0; i2 < this.gB().j().size(); ++i2) {
                if (EntityPlayer.shouldKeepDeathEventItem(event, this.gB().j().get(i2))) continue;
                this.gB().j().set(i2, ItemStack.l);
            }
            for (EnumItemSlot value : EnumItemSlot.j) {
                if (!this.gB().n.has(value) || EntityPlayer.shouldKeepDeathEventItem(event, this.gB().n.a(value))) continue;
                this.gB().n.a(value, ItemStack.l);
            }
            if (!event.getItemsToKeep().isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : event.getItemsToKeep()) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving killCredit = this.fi();
        if (killCredit != null) {
            this.b(StatisticList.h.b(killCredit.ax()));
            killCredit.a((net.minecraft.world.entity.Entity)this, damageSource);
            this.e(killCredit);
        }
        this.A().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aQ();
        this.k(0);
        this.d(false);
        this.fh().c();
        this.d(Optional.of(GlobalPos.a(this.A().al(), this.dF())));
        this.w(false);
    }

    private void hl() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.dF()).c(32.0, 10.0, 32.0);
        this.A().a(EntityInsentient.class, aabb, IEntitySelector.f).stream().filter(mob -> mob instanceof IEntityAngerable).forEach(mob -> ((IEntityAngerable)((Object)mob)).a_(this.A(), this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        if (entity != this) {
            super.a(entity, damageSource);
            ScoreboardServer scoreboard = this.A().g();
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.R);
                this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.P);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damageSource);
        }
    }

    private void a(ScoreHolder scoreHolder, ScoreHolder teamMember, IScoreboardCriteria[] criteria) {
        int id;
        ScoreboardTeam playersTeam = this.getBukkitEntity().getScoreboard().getHandle().e(teamMember.cV());
        if (playersTeam != null && (id = playersTeam.o().b()) >= 0 && id < criteria.length) {
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(criteria[id], scoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityHuman player1;
        EntityArrow abstractArrow;
        net.minecraft.world.entity.Entity entity;
        EntityHuman player;
        net.minecraft.world.entity.Entity entity2;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.m)) {
            if (this.dp() instanceof EntityMinecartAbstract && this.A().purpurConfig.minecartControllable && !this.A().purpurConfig.minecartControllableFallDamage) {
                return false;
            }
            if (this.dp() instanceof EntityBoat && !this.A().purpurConfig.boatsDoFallDamage) {
                return false;
            }
        }
        if ((entity2 = damageSource.d()) instanceof EntityHuman && !this.a(player = (EntityHuman)entity2) || entity2 instanceof EntityArrow && (entity = (abstractArrow = (EntityArrow)entity2).ai_()) instanceof EntityHuman && !this.a(player1 = (EntityHuman)entity)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(level, damageSource, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.g.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman other) {
        return this.hm() && super.a(other);
    }

    private boolean hm() {
        return this.A().getWorld().getPVP();
    }

    @Nullable
    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean useCharge, TeleportTransition.a postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        RespawnResult result = this.findRespawnPositionAndUseSpawnBlock0(useCharge, postTeleportTransition, respawnReason);
        return result == null ? null : result.transition();
    }

    @Nullable
    public RespawnResult findRespawnPositionAndUseSpawnBlock0(boolean useCharge, TeleportTransition.a postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        Runnable consumeAnchorCharge = null;
        RespawnConfig respawnConfig = this.V();
        WorldServer level = this.cK.a(RespawnConfig.b(respawnConfig));
        if (level != null && respawnConfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(level, respawnConfig, useCharge);
            if (optional.isPresent()) {
                RespawnPosAngle respawnPosAngle = optional.get();
                isBedSpawn = respawnPosAngle.isBedSpawn();
                isAnchorSpawn = respawnPosAngle.isAnchorSpawn();
                consumeAnchorCharge = respawnPosAngle.consumeAnchorCharge();
                teleportTransition = new TeleportTransition(level, respawnPosAngle.a(), Vec3D.c, respawnPosAngle.b(), respawnPosAngle.c(), postTeleportTransition);
            } else {
                teleportTransition = TeleportTransition.b(this, postTeleportTransition);
            }
        } else {
            teleportTransition = TeleportTransition.a(this, postTeleportTransition);
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (net.minecraft.world.level.World)teleportTransition.b(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, teleportTransition.g(), respawnReason);
        this.A().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.g.isDisconnected()) {
            return null;
        }
        if (location.equals((Object)respawnEvent.getRespawnLocation()) && consumeAnchorCharge != null) {
            consumeAnchorCharge.run();
        }
        location = respawnEvent.getRespawnLocation();
        return new RespawnResult(new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause()), isBedSpawn, isAnchorSpawn);
    }

    public boolean o() {
        return this.i(GenericAttributes.I) > 0.0;
    }

    @Override
    protected void a(Holder<AttributeBase> attribute) {
        if (attribute.a(GenericAttributes.I)) {
            ServerWaypointManager waypointManager = this.A().h();
            if (this.fp().c(attribute) > 0.0) {
                waypointManager.a(this);
            } else {
                waypointManager.c(this);
            }
        }
        super.a(attribute);
    }

    public static Optional<RespawnPosAngle> a(WorldServer level, RespawnConfig respawnConfig, boolean useCharge) {
        WorldData.a respawnData = respawnConfig.b;
        BlockPosition blockPos = respawnData.b();
        float yaw = respawnData.d();
        float pitch = respawnData.e();
        boolean flag = respawnConfig.c;
        IBlockData blockState = level.a_(blockPos);
        Block block = blockState.b();
        if (block instanceof BlockRespawnAnchor && (flag || blockState.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(level)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bX, level, blockPos);
            Runnable consumeAnchorCharge = null;
            if (!flag && useCharge && optional.isPresent()) {
                consumeAnchorCharge = () -> level.a(blockPos, (IBlockData)blockState.b(BlockRespawnAnchor.d, blockState.c(BlockRespawnAnchor.d) - 1), 3);
            }
            Runnable finalConsumeAnchorCharge = consumeAnchorCharge;
            return optional.map(pos -> RespawnPosAngle.of(pos, blockPos, 0.0f, false, true, finalConsumeAnchorCharge));
        }
        if (block instanceof BlockBed && BlockBed.a(level)) {
            return BlockBed.a(EntityTypes.bX, (ICollisionAccess)level, blockPos, blockState.c(BlockFacingHorizontal.f), yaw).map(pos -> RespawnPosAngle.of(pos, blockPos, 0.0f, true, false, null));
        }
        if (!flag) {
            return Optional.empty();
        }
        boolean isPossibleToRespawnInThis = block.a(blockState);
        IBlockData blockState1 = level.a_(blockPos.d());
        boolean isPossibleToRespawnInThis1 = blockState1.b().a(blockState1);
        return isPossibleToRespawnInThis && isPossibleToRespawnInThis1 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.1, (double)blockPos.w() + 0.5), yaw, pitch, false, false, null)) : Optional.empty();
    }

    public void p() {
        this.av();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleportTransition) {
        PlayerTeleportEvent tpEvent;
        TileEntity tileEntity;
        if (this.gg()) {
            return null;
        }
        if (this.ec()) {
            return null;
        }
        if (teleportTransition.g()) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer level = teleportTransition.b();
        WorldServer serverLevel = this.A();
        ResourceKey<WorldDimension> resourceKey = serverLevel.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        Location exit = CraftLocation.toBukkit(absolutePosition.a(), (net.minecraft.world.level.World)level, absolutePosition.c(), absolutePosition.d());
        if (this.aG != null && this.aG.a((BlockEndGateway)Blocks.lB) && (tileEntity = this.A().c_(this.aG.c())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), enter, exit.clone(), (EndGateway)new CraftEndGateway((World)this.A().getWorld(), theEndGatewayBlockEntity));
        } else {
            tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit.clone(), teleportTransition.cause());
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled()) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            level = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTransition = new TeleportTransition(level, CraftLocation.toVec3(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
        }
        if (!teleportTransition.h()) {
            this.ad();
        }
        if (level.al() == serverLevel.al()) {
            this.g.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
            this.g.l();
            teleportTransition.j().onTransition(this);
            return this;
        }
        this.de = true;
        WorldData levelData = level.F_();
        this.g.b(new PacketPlayOutRespawn(this.b(level), 3));
        this.g.b(new PacketPlayOutServerDifficulty(levelData.p(), levelData.q()));
        PlayerList playerList = this.cK.am();
        playerList.d(this);
        this.aG = null;
        serverLevel.a(this, Entity.RemovalReason.e);
        this.ee();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("moving");
        if (resourceKey == WorldDimension.b && level.getTypeKey() == WorldDimension.c) {
            this.dm = this.dD();
        }
        profilerFiller.c();
        profilerFiller.a("placing");
        this.portalPos = CraftLocation.toBlockPosition(exit);
        this.a(level);
        this.g.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        this.g.l();
        level.d(this);
        profilerFiller.c();
        this.h(serverLevel);
        this.fU();
        this.g.b(new PacketPlayOutAbilities(this.gC()));
        playerList.a(this, level);
        playerList.e(this);
        playerList.c(this);
        teleportTransition.j().onTransition(this);
        this.cY = -1;
        this.cV = -1.0f;
        this.cW = -1;
        this.a(teleportTransition, serverLevel);
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)serverLevel.getWorld());
        this.A().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fV()) {
            this.fU();
        }
        return this;
    }

    @Override
    public void a(float yRot, boolean yRelative, float xRot, boolean xRelative) {
        super.a(yRot, yRelative, xRot, xRelative);
        this.g.b(new ClientboundPlayerRotationPacket(yRot, yRelative, xRot, xRelative));
    }

    public void h(WorldServer level) {
        ResourceKey<net.minecraft.world.level.World> resourceKey = level.al();
        ResourceKey<net.minecraft.world.level.World> resourceKey1 = this.A().al();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(level);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.A());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourceKey;
            maindimensionkey1 = resourceKey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourceKey || maindimensionkey1 != resourceKey1) {
            CriterionTriggers.w.a(this, resourceKey, resourceKey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.dm != null) {
            CriterionTriggers.D.a(this, this.dm);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.dm = null;
        }
    }

    @Override
    public boolean a(EntityPlayer player) {
        return player.at() ? this.N() == this : !this.at() && super.a(player);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int quantity) {
        super.a(entity, quantity);
        this.cl.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition bedPos, EnumDirection direction) {
        if (this.gg() || !this.bX()) {
            return Either.left(EntityHuman.EnumBedResult.e);
        }
        if (!this.A().H_().j() && !this.A().H_().l()) {
            return Either.left(EntityHuman.EnumBedResult.a);
        }
        if (!this.a(bedPos, direction)) {
            return Either.left(EntityHuman.EnumBedResult.c);
        }
        if (this.b(bedPos, direction)) {
            return Either.left(EntityHuman.EnumBedResult.d);
        }
        this.setRespawnPosition(new RespawnConfig(WorldData.a.a(this.A().al(), bedPos, this.dX(), this.dZ()), false), true, PlayerSetSpawnEvent.Cause.BED);
        if (this.A().aa()) {
            return Either.left(EntityHuman.EnumBedResult.b);
        }
        if (!this.gQ()) {
            double d2 = 8.0;
            double d1 = 5.0;
            Vec3D vec3 = Vec3D.c(bedPos);
            List<EntityMonster> entitiesOfClass = this.A().a(EntityMonster.class, new AxisAlignedBB(vec3.a() - 8.0, vec3.b() - 5.0, vec3.c() - 8.0, vec3.a() + 8.0, vec3.b() + 5.0, vec3.c() + 8.0), (? super T monster) -> monster.a(this.A(), this));
            if (!this.A().purpurConfig.playerSleepNearMonsters && !entitiesOfClass.isEmpty()) {
                return Either.left(EntityHuman.EnumBedResult.f);
            }
        }
        return Either.right(Unit.a);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        IChatBaseComponent clientMessage;
        EnumDirection direction = this.A().a_(bedPos).c(BlockFacingHorizontal.f);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(bedPos, direction);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, bedPos, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(bedPos, force).ifRight(unit -> {
            this.a(StatisticList.aq);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().e() && (clientMessage = PurpurConfig.sleepNotPossible.isBlank() ? null : (!PurpurConfig.sleepNotPossible.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.sleepNotPossible)) : IChatBaseComponent.c("sleep.not_possible"))) != null) {
            this.a(clientMessage, true);
        }
        this.A().f();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3 = Vec3D.c(pos);
        return Math.abs(this.dK() - vec3.a()) <= 3.0 && Math.abs(this.dM() - vec3.b()) <= 2.0 && Math.abs(this.dQ() - vec3.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.d();
        return !this.h(blockPos) || !this.h(blockPos.a(direction.g()));
    }

    @Override
    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        if (!this.gg()) {
            return;
        }
        CraftBlock bed = CraftBlock.at(this.A(), this.ge().orElse(this.dF()));
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)this.getBukkitEntity(), (org.bukkit.block.Block)bed, true);
        if (!event.callEvent()) {
            return;
        }
        if (this.gg()) {
            this.A().n().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(wakeImmediately, updateLevelForSleepingPlayers);
        if (this.g != null) {
            this.g.teleport(this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return super.a(level, damageSource) || this.S() && !damageSource.a(DamageTypes.m) || !this.hb() || !this.A().paperConfig().collisions.allowPlayerCrammingDamage && damageSource.a(DamageTypes.h);
    }

    @Override
    protected void b(WorldServer level, BlockPosition pos) {
        if (!this.at()) {
            super.b(level, pos);
        }
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.du && onGround && this.an > 0.0) {
            Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.an, 0.0, 200.0);
            this.A().a(new ParticleParamBlock(Particles.b, state), vec3.g, vec3.h, vec3.i, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.du = false;
        }
        super.a(y2, onGround, state, pos);
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        super.a(entity);
        this.cy = this.dD();
        this.cz = entity;
        this.x(entity != null && entity.ax() == EntityTypes.bM);
    }

    @Override
    protected void q() {
        if (this.A().w().i()) {
            super.q();
        }
    }

    @Override
    public void a(TileEntitySign signEntity, boolean isFrontText) {
        if (this.A().purpurConfig.signAllowColors) {
            this.g.b(signEntity.getTranslatedUpdatePacket(this.ds, isFrontText));
        }
        this.g.b(new PacketPlayOutBlockChange(this.A(), signEntity.aD_()));
        this.g.b(new PacketPlayOutOpenSignEditor(signEntity.aD_(), isFrontText));
    }

    @Override
    public void b(Holder<Dialog> dialog) {
        this.g.b(new ClientboundShowDialogPacket(dialog));
    }

    public int nextContainerCounter() {
        this.dI = this.dI % 100 + 1;
        return this.dI;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory menu) {
        if (menu == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container abstractContainerMenu = menu.createMenu(this.dI, this.gB(), this);
        IChatBaseComponent title = null;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.setTitle(menu.S_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, abstractContainerMenu, cancelled);
            abstractContainerMenu = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (abstractContainerMenu == null && !cancelled) {
                if (menu instanceof IInventory) {
                    IInventory container = (IInventory)((Object)menu);
                    container.b(this);
                } else if (menu instanceof BlockChest.DoubleInventory) {
                    BlockChest.DoubleInventory doubleInventory = (BlockChest.DoubleInventory)menu;
                    doubleInventory.container.b(this);
                } else if (!this.cj.b((TileEntityEnderChest)null)) {
                    this.cj.b(this);
                }
                return OptionalInt.empty();
            }
        }
        if (abstractContainerMenu == null) {
            if (this.at()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cl = abstractContainerMenu;
        if (!this.fv()) {
            this.g.b(new PacketPlayOutOpenWindow(abstractContainerMenu.l, abstractContainerMenu.a(), Objects.requireNonNullElseGet(title, abstractContainerMenu::getTitle)));
        }
        this.a(abstractContainerMenu);
        return OptionalInt.of(this.dI);
    }

    @Override
    public void a(int containerId, MerchantRecipeList offers, int level, int xp, boolean showProgress, boolean canRestock) {
        this.g.b(new PacketPlayOutOpenWindowMerchant(containerId, offers, level, xp, showProgress, canRestock));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dI, this.gB(), inventory, horse, horse.ad_());
        container.setTitle(horse.S_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.b(this);
            return;
        }
        if (this.cl != this.ck) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int inventoryColumns = horse.ad_();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dI, inventoryColumns, horse.az()));
        this.cl = container;
        this.a(this.cl);
    }

    @Override
    public void a(ItemStack stack, EnumHand hand) {
        if (stack.c(DataComponents.V)) {
            if (WrittenBookContent.a(stack, this.C(), this)) {
                this.cl.d();
            }
            this.g.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.g.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::d));
    }

    @Override
    public void r() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.g.b(new PacketPlayOutCloseWindow(this.cl.l));
        this.s();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.g.b(new PacketPlayOutCloseWindow(this.cl.l));
        this.cl = this.ck;
    }

    @Override
    public void s() {
        this.cl.a(this);
        this.ck.a(this.cl);
        this.cl = this.ck;
    }

    @Override
    public void t() {
        double x2 = this.dK();
        double y2 = this.dM();
        double z2 = this.dQ();
        super.t();
        this.p(this.dK() - x2, this.dM() - y2, this.dQ() - z2);
    }

    public void a(double dx, double dy, double dz) {
        if (!this.cl() && !EntityPlayer.q(dx, dy, dz)) {
            if (this.cw()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.D, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.w, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bu()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.s, rounded);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.fe()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.aS()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    if (this.cv()) {
                        this.a(StatisticList.r, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.sprintMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cu()) {
                        this.a(StatisticList.q, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, rounded);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fY()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.C, rounded);
            } else {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 25) {
                    this.a(StatisticList.v, rounded);
                }
            }
        }
    }

    private void p(double dx, double dy, double dz) {
        if (this.cl() && !EntityPlayer.q(dx, dy, dz)) {
            int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
            net.minecraft.world.entity.Entity vehicle = this.du();
            if (vehicle instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, rounded);
            } else if (vehicle instanceof AbstractBoat) {
                this.a(StatisticList.y, rounded);
            } else if (vehicle instanceof EntityPig) {
                this.a(StatisticList.z, rounded);
            } else if (vehicle instanceof EntityHorseAbstract) {
                this.a(StatisticList.B, rounded);
            } else if (vehicle instanceof EntityStrider) {
                this.a(StatisticList.E, rounded);
            } else if (vehicle instanceof HappyGhast) {
                this.a(StatisticList.A, rounded);
            }
        }
    }

    private static boolean q(double dx, double dy, double dz) {
        return dx == 0.0 && dy == 0.0 && dz == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cM.b(this, stat, amount);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreAccess -> scoreAccess.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cM.a(this, stat, 0);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.df.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> items) {
        CriterionTriggers.ad.a(this, recipe.a(), items);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
        List<RecipeHolder<?>> list = recipes.stream().flatMap(key -> this.cK.aN().b((ResourceKey<IRecipe<?>>)key).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.df.b(recipes, this);
    }

    @Override
    public void u() {
        super.u();
        this.a(StatisticList.F);
        if (this.cv()) {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int xpPoints) {
        super.d(xpPoints);
        this.cY = -1;
    }

    public void v() {
        this.di = true;
        this.ca();
        if (this.cl() && this.du() instanceof EntityPlayer) {
            this.cb();
        }
        if (this.gg()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.di;
    }

    public void x() {
        this.cV = -1.0E8f;
        this.cY = -1;
    }

    public void sendActionBarMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendActionBarMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendActionBarMessage(@Nullable Component message) {
        if (message != null) {
            this.sendActionBarMessage(PaperAdventure.asVanilla(message));
        }
    }

    public void sendActionBarMessage(@Nullable IChatBaseComponent message) {
        if (message != null) {
            this.a(message, true);
        }
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    public void R_() {
        if (!this.bS.f() && this.fO()) {
            this.g.b(new PacketPlayOutEntityStatus(this, 9));
            super.R_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.g.b(new PacketPlayOutLookAt(anchor, target.g, target.h, target.i));
    }

    public void a(ArgumentAnchor.Anchor fromAnchor, net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor toAnchor) {
        Vec3D vec3 = toAnchor.a(entity);
        super.a(fromAnchor, vec3);
        this.g.b(new PacketPlayOutLookAt(fromAnchor, entity, toAnchor));
    }

    public void a(EntityPlayer that, boolean keepEverything) {
        this.dv = that.dv;
        this.dF = that.dF;
        this.h.a(that.h.b(), that.h.c());
        this.z();
        if (keepEverything) {
            this.fp().b(that.fp());
            this.x(that.eU());
            this.cm = that.cm;
            for (MobEffect mobEffect : that.eR()) {
            }
            this.gB().a(that.gB());
            this.cr = that.cr;
            this.cs = that.cs;
            this.ct = that.ct;
            this.q(that.gu());
            this.aG = that.aG;
        } else {
            this.fp().b(that.fp());
            if (this.A().S().c(GameRules.e) || that.at()) {
                this.gB().a(that.gB());
                this.cr = that.cr;
                this.cs = that.cs;
                this.ct = that.ct;
                this.q(that.gu());
            }
        }
        this.cu = that.cu;
        this.cj = that.cj;
        this.aC().a(Avatar.t, that.aC().a(Avatar.t));
        this.cY = -1;
        this.cV = -1.0f;
        this.cW = -1;
        this.i = that.i;
        this.dm = that.dm;
        this.dp = that.dp;
        this.dH = that.dH;
        this.b(that.ak());
        this.c(that.al());
        this.d(that.gZ());
    }

    @Override
    protected void a(MobEffect effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.az(), effectInstance, true));
        if (effectInstance.a(MobEffects.y)) {
            this.dh = this.at;
            this.dg = this.dD();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect effectInstance, boolean forced, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, forced, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.az(), effectInstance, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> effects) {
        super.c(effects);
        for (MobEffect mobEffectInstance : effects) {
            this.g.b(new PacketPlayOutRemoveEntityEffect(this.az(), mobEffectInstance.c()));
            if (!mobEffectInstance.a(MobEffects.y)) continue;
            this.dg = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.teleportTo(x2, y2, z2, PlayerTeleportEvent.TeleportCause.DISMOUNT);
    }

    @Override
    public void b(double x2, double y2, double z2) {
        this.teleportTo(x2, y2, z2, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(double x2, double y2, double z2, PlayerTeleportEvent.TeleportCause cause) {
        this.g.teleport(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k), cause);
    }

    @Override
    public void c(double dx, double dy, double dz) {
        this.g.a(new PositionMoveRotation(new Vec3D(dx, dy, dz), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag;
        if (this.gg()) {
            this.a(true, true);
        }
        if (setCamera) {
            this.d((net.minecraft.world.entity.Entity)this);
        }
        if (flag = super.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, cause)) {
            this.r(relativeMovements.contains((Object)Relative.d) ? this.cN() + yaw : yaw);
        }
        return flag;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        super.d(x2, y2, z2);
        this.g.l();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.A().n().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity target) {
        this.A().n().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void z() {
        if (this.g != null) {
            this.g.b(new PacketPlayOutAbilities(this.gC()));
            this.M();
        }
    }

    public WorldServer A() {
        return (WorldServer)super.an();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && !event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean isSpectator = this.at();
        PlayerGameModeChangeEvent event = this.h.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null) {
            return null;
        }
        if (event.isCancelled()) {
            return event;
        }
        this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.k();
            this.cb();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (isSpectator) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fN();
        return event;
    }

    @Override
    @Nonnull
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener B() {
        return this.dG;
    }

    public CommandListenerWrapper C() {
        return new CommandListenerWrapper(this.B(), this.dD(), this.cg(), this.A(), this.I(), this.ap(), this.S_(), this.cK, this);
    }

    public void sendMiniMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendMessage(@Nullable Component message) {
        if (message != null) {
            this.a(PaperAdventure.asVanilla(message));
        }
    }

    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.y(overlay)) {
            this.g.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.y(false)) {
                    int i2 = 256;
                    String string = message.a(256);
                    IChatMutableComponent component = IChatBaseComponent.b(string).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", component).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundChatType) {
        this.sendChatMessage(message, filtered, boundChatType, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundChatType, @Nullable IChatBaseComponent unsigned) {
        if (this.ho()) {
            message.sendToPlayer(this, filtered, boundChatType, unsigned);
        }
    }

    public String D() {
        String string;
        SocketAddress socketAddress = this.g.m();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = InetAddresses.toAddrString((InetAddress)inetSocketAddress.getAddress());
        } else {
            string = "<unknown>";
        }
        return string;
    }

    public void a(ClientInformation clientInformation) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), (Map)SystemUtils.a(new IdentityHashMap(), (? super T map) -> {
            map.put(ClientOption.LOCALE, clientInformation.b());
            map.put(ClientOption.VIEW_DISTANCE, clientInformation.c());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientInformation.d().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientInformation.e());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientInformation.f()));
            map.put(ClientOption.MAIN_HAND, clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientInformation.h());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientInformation.i());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientInformation.j().name()));
        })).callEvent();
        if (this.as() != clientInformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.cK.server.getPluginManager().callEvent((Event)event);
        }
        if (this.dk == null || !this.dk.equals(clientInformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientInformation.b());
            this.cK.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientInformation);
    }

    public void updateOptionsNoEvents(ClientInformation clientInformation) {
        this.dk = clientInformation.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.dk), Locale.US);
        this.dj = clientInformation.c();
        this.cZ = clientInformation.d();
        this.db = clientInformation.e();
        this.ds = clientInformation.h();
        this.dt = clientInformation.i();
        this.da = clientInformation.j();
        this.aC().a(Avatar.t, (byte)clientInformation.f());
        this.aC().a(Avatar.s, (byte)clientInformation.g().b());
    }

    public ClientInformation E() {
        byte i2 = this.aC().a(Avatar.t);
        EnumMainHand humanoidArm = EnumMainHand.d.apply(this.aC().a(Avatar.s).byteValue());
        return new ClientInformation(this.dk, this.dj, this.cZ, this.db, i2, humanoidArm, this.ds, this.dt, this.da);
    }

    public boolean F() {
        return this.db;
    }

    public EnumChatVisibility G() {
        return this.cZ;
    }

    private boolean y(boolean overlay) {
        return this.cZ != EnumChatVisibility.c || overlay;
    }

    private boolean ho() {
        return this.cZ == EnumChatVisibility.a;
    }

    public int H() {
        return this.dj;
    }

    public void a(ServerPing serverStatus) {
        this.g.b(new ClientboundServerDataPacket(serverStatus.a(), serverStatus.d().map(ServerPing.a::a)));
    }

    @Override
    public int I() {
        return this.cK.b(this.gA());
    }

    @Override
    public void J() {
        this.dc = SystemUtils.c();
        this.setAfk(false);
    }

    @Override
    public void setAfk(boolean afk) {
        if (this.isAfk == afk) {
            return;
        }
        String msg = afk ? PurpurConfig.afkBroadcastAway : PurpurConfig.afkBroadcastBack;
        PlayerAFKEvent event = new PlayerAFKEvent((Player)this.getBukkitEntity(), afk, this.A().purpurConfig.idleTimeoutKick, msg, !Bukkit.isPrimaryThread());
        if (!event.callEvent() || event.shouldKick()) {
            return;
        }
        this.isAfk = afk;
        if (!afk) {
            this.J();
        }
        if ((msg = event.getBroadcastMsg()) != null && !msg.isEmpty()) {
            String playerName = this.gz().name();
            if (PurpurConfig.afkBroadcastUseDisplayName) {
                TextComponent playerDisplayNameComponent = LegacyComponentSerializer.legacySection().deserialize(this.getBukkitEntity().getDisplayName());
                playerName = PlainTextComponentSerializer.plainText().serialize((Component)playerDisplayNameComponent);
            }
            this.cK.am().broadcastMiniMessage(String.format(msg, playerName), false);
        }
        if (this.A().purpurConfig.idleTimeoutUpdateTabList) {
            String scoreboardName = this.cV();
            String playerListName = (String)MiniMessage.miniMessage().serialize(this.getBukkitEntity().playerListName());
            String[] split = playerListName.split(scoreboardName);
            String prefix = (split.length > 0 ? split[0] : "").replace(PurpurConfig.afkTabListPrefix, "");
            String suffix = (split.length > 1 ? split[1] : "").replace(PurpurConfig.afkTabListSuffix, "");
            if (afk) {
                this.getBukkitEntity().setPlayerListName(PurpurConfig.afkTabListPrefix + prefix + scoreboardName + suffix + PurpurConfig.afkTabListSuffix, true);
            } else {
                this.getBukkitEntity().setPlayerListName(prefix + scoreboardName + suffix, true);
            }
        }
        this.A().f();
    }

    @Override
    public boolean isAfk() {
        return this.isAfk;
    }

    @Override
    public boolean j(net.minecraft.world.entity.Entity entity) {
        return !this.isAfk() && super.j(entity);
    }

    public ServerStatisticManager K() {
        return this.cM;
    }

    public RecipeBookServer L() {
        return this.df;
    }

    @Override
    protected void M() {
        if (this.at()) {
            this.eP();
            this.l(true);
        } else {
            super.M();
        }
    }

    public net.minecraft.world.entity.Entity N() {
        return this.dd == null ? this : this.dd;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entityToSpectate) {
        net.minecraft.world.entity.Entity camera = this.N();
        net.minecraft.world.entity.Entity entity = this.dd = entityToSpectate == null ? this : entityToSpectate;
        if (camera != this.dd) {
            net.minecraft.world.level.World world;
            if (this.dd == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.dd = camera;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity(), (Entity)entityToSpectate.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.dd = camera;
                    return;
                }
            }
            if ((world = this.dd.an()) instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                this.teleportTo(serverLevel, this.dd.dK(), this.dd.dM(), this.dd.dQ(), Set.of(), this.dX(), this.dZ(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entityToSpectate != null) {
                this.A().n().a(this);
            }
            this.g.b(new PacketPlayOutCamera(this.dd));
            this.g.l();
        }
    }

    @Override
    protected void O() {
        if (!this.de) {
            super.O();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity target) {
        if (this.at()) {
            this.d(target);
        } else {
            super.e(target);
        }
    }

    public long P() {
        return this.dc;
    }

    @Nullable
    public IChatBaseComponent Q() {
        return this.listName;
    }

    public int R() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gV();
    }

    public boolean S() {
        return this.de;
    }

    public void T() {
        this.de = false;
    }

    public AdvancementDataPlayer U() {
        return this.cL;
    }

    @Nullable
    public RespawnConfig V() {
        return this.dq;
    }

    public void b(EntityPlayer player) {
        this.a(player.dq, false);
    }

    public void a(@Nullable RespawnConfig respawnConfig, boolean displayInChat) {
        this.setRespawnPosition(respawnConfig, displayInChat, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    public boolean setRespawnPosition(@Nullable RespawnConfig respawnConfig, boolean displayInChat, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean actuallyDisplayInChat = false;
        if (respawnConfig != null) {
            actuallyDisplayInChat = displayInChat && !respawnConfig.a(this.dq);
            spawnLoc = CraftLocation.toBukkit((BaseBlockPosition)respawnConfig.a().b(), (net.minecraft.world.level.World)this.cK.a(respawnConfig.a().a()));
            spawnLoc.setYaw(respawnConfig.a().d());
            spawnLoc.setPitch(respawnConfig.a().e());
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, respawnConfig != null && respawnConfig.b(), cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), actuallyDisplayInChat, actuallyDisplayInChat ? PaperAdventure.asAdventure(cG) : null);
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            respawnConfig = new RespawnConfig(new WorldData.a(GlobalPos.a(((CraftWorld)event.getLocation().getWorld()).getHandle().al(), CraftLocation.toBlockPosition(event.getLocation())), event.getLocation().getYaw(), event.getLocation().getPitch()), event.isForced());
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
        }
        this.dq = respawnConfig;
        return true;
    }

    public SectionPosition W() {
        return this.do;
    }

    public void a(SectionPosition sectionPos) {
        this.do = sectionPos;
    }

    public ChunkTrackingView X() {
        return this.dp;
    }

    public void a(ChunkTrackingView chunkTrackingView) {
        this.dp = chunkTrackingView;
    }

    @Override
    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
        this.g.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(sound), source, this.dK(), this.dM(), this.dQ(), volume, pitch, this.as.g()));
    }

    @Override
    public EntityItem drop(ItemStack droppedItem, boolean dropAround, boolean traceItem, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        WorldMap mapData;
        ItemStack itemStack;
        EntityItem itemEntity = super.drop(droppedItem, dropAround, traceItem, callEvent, entityOperation);
        ItemStack itemStack2 = itemStack = itemEntity != null ? itemEntity.e() : ItemStack.l;
        if (traceItem && !itemStack.f()) {
            this.a(StatisticList.f.b(itemStack.h()), itemStack.M());
            this.a(StatisticList.G);
        }
        if (itemStack.a(Items.tY) && (mapData = ItemWorldMap.b(itemStack, (net.minecraft.world.level.World)this.A())) != null) {
            mapData.a(this, itemStack);
        }
        return itemEntity;
    }

    public ITextFilter Y() {
        return this.dr;
    }

    public void a(WorldServer level) {
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    @Nullable
    private static EnumGamemode a(ValueInput input, String key) {
        return input.a(key, EnumGamemode.h).orElse(null);
    }

    private EnumGamemode b(@Nullable EnumGamemode gameType) {
        EnumGamemode forcedGameType = this.cK.bj();
        if (forcedGameType != null) {
            return forcedGameType;
        }
        return gameType != null ? gameType : this.cK.y();
    }

    private void g(ValueOutput output) {
        output.a("playerGameType", EnumGamemode.h, this.h.b());
        EnumGamemode previousGameModeForPlayer = this.h.c();
        output.b("previousPlayerGameType", EnumGamemode.h, previousGameModeForPlayer);
    }

    @Override
    public boolean Z() {
        return this.ds;
    }

    public boolean c(EntityPlayer player) {
        return player != this && (this.ds || player.ds);
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        return super.c(level, pos) && level.a((net.minecraft.world.entity.Entity)this, pos);
    }

    @Override
    protected void a(ItemStack usingItem) {
        CriterionTriggers.X.a(this, usingItem);
        super.a(usingItem);
    }

    public boolean a(boolean dropStack) {
        PlayerInventory inventory = this.gB();
        ItemStack itemStack = inventory.a(dropStack);
        this.cl.b(inventory, inventory.g()).ifPresent(slot -> this.cl.a(slot, inventory.h()));
        return this.a(itemStack, false, true) != null;
    }

    @Override
    public void b(ItemStack stack) {
        if (!this.gB().g(stack)) {
            this.a(stack, false);
        }
    }

    public boolean aa() {
        return this.dt;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dv);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.du = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem itemEntity) {
        super.a(itemEntity);
        net.minecraft.world.entity.Entity owner = itemEntity.ai_();
        if (owner != null) {
            CriterionTriggers.S.a(this, itemEntity.e(), owner);
        }
    }

    public void a(RemoteChatSession chatSession) {
        this.dF = chatSession;
    }

    @Nullable
    public RemoteChatSession ac() {
        return this.dF != null && this.dF.b() ? null : this.dF;
    }

    @Override
    public void a(double xDistance, double zDistance) {
        this.cx = (float)(MathHelper.d(zDistance, xDistance) * 180.0 / 3.1415927410125732 - (double)this.dX());
        this.g.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force, boolean triggerEvents) {
        if (super.a(entity, force, triggerEvents)) {
            entity.k(this);
            this.g.a(new PositionMoveRotation(this.dD(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                this.cK.am().a(livingEntity, this.g);
            }
            this.g.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity vehicle = this.du();
        super.removeVehicle(suppressCancellation);
        if (vehicle instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)vehicle;
            for (MobEffect mobEffectInstance : livingEntity.eR()) {
                this.g.b(new PacketPlayOutRemoveEntityEffect(vehicle.az(), mobEffectInstance.c()));
            }
        }
        if (vehicle != null) {
            this.g.b(new PacketPlayOutMount(vehicle));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer level) {
        return new CommonPlayerSpawnInfo(level.ak(), level.al(), BiomeManager.a(level.H()), this.h.b(), this.h.c(), level.am(), level.G(), this.gZ(), this.aK(), level.T());
    }

    public void c(BlockPosition raidOmenPosition) {
        this.dw = raidOmenPosition;
    }

    public void ae() {
        this.dw = null;
    }

    @Nullable
    public BlockPosition af() {
        return this.dw;
    }

    @Override
    public Vec3D ag() {
        net.minecraft.world.entity.Entity vehicle = this.du();
        return vehicle != null && vehicle.dg() != this ? vehicle.ag() : this.dx;
    }

    public void a(Vec3D knownMovement) {
        this.dx = knownMovement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity entity, float damage, DamageSource damageSource) {
        return EnchantmentManager.a(this.A(), this.el(), entity, damageSource, damage);
    }

    @Override
    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public Input ah() {
        return this.dy;
    }

    public void a(Input lastClientInput) {
        this.dy = lastClientInput;
    }

    public Vec3D ai() {
        float f2;
        float f3 = this.dy.c() == this.dy.d() ? 0.0f : (f2 = this.dy.c() ? 1.0f : -1.0f);
        float f1 = this.dy.a() == this.dy.b() ? 0.0f : (this.dy.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dX());
    }

    public void a(EntityEnderPearl enderPearl) {
        this.dz.add(enderPearl);
    }

    public void b(EntityEnderPearl enderPearl) {
        this.dz.remove(enderPearl);
    }

    public Set<EntityEnderPearl> aj() {
        return this.dz;
    }

    public NBTTagCompound ak() {
        return this.dB;
    }

    public void b(NBTTagCompound tag) {
        this.dB = tag;
        this.b(EntityPlayer.d(tag));
    }

    public NBTTagCompound al() {
        return this.dC;
    }

    public void c(NBTTagCompound tag) {
        this.dC = tag;
        this.c(EntityPlayer.d(tag));
    }

    public long c(EntityEnderPearl enderPearl) {
        net.minecraft.world.level.World world = enderPearl.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ChunkCoordIntPair chunkPos = enderPearl.dH();
            this.a(enderPearl);
            serverLevel.j();
            return EntityPlayer.a(serverLevel, chunkPos) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer level, ChunkCoordIntPair pos) {
        if (!level.paperConfig().misc.legacyEnderPearlBehavior) {
            level.n().b(TicketType.n, pos, 2);
        }
        return TicketType.n.g();
    }

    public void a(Set<DebugSubscription<?>> subscriptions) {
        this.dH = Set.copyOf(subscriptions);
    }

    public Set<DebugSubscription<?>> am() {
        return !this.cK.bA().a(this) ? Set.of() : this.dH;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.A().ah() + this.timeOffset;
        }
        return this.A().ah() - this.A().ah() % 24000L + this.timeOffset;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weatherType != null) {
            return;
        }
        if (plugin) {
            this.weatherType = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weatherType == null) {
            if (oldRain != newRain) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weatherType == WeatherType.DOWNFALL || this.weatherType == null) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weatherType == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weatherType == WeatherType.DOWNFALL ? (this.pluginRainPosition += 0.01f) : (this.pluginRainPosition -= 0.01f);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weatherType = null;
        this.setPlayerWeather(this.A().F_().h() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cV() + " at " + this.dK() + "," + this.dM() + "," + this.dQ() + ")";
    }

    @Override
    public boolean fv() {
        return super.fv() || this.g != null && this.g.isDisconnected();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.ct;
            this.newTotalExp = this.cs;
            this.newLevel = this.cr;
        }
        this.x(this.fj());
        this.fU();
        this.j(this.cE());
        this.h(0);
        this.an = 0.0;
        this.cm = new FoodMetaData();
        this.cr = this.newLevel;
        this.cs = this.newTotalExp;
        this.ct = 0.0f;
        this.bv = 0;
        this.p(0);
        this.bs = 0;
        this.setArrowCount(0, true);
        this.br = 0;
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).co = true;
        this.cl = this.ck;
        this.bG = null;
        ((EntityLiving)this).cp = null;
        ((EntityLiving)this).ck = new CombatTracker(this);
        this.cY = -1;
        if (this.keepLevel) {
            this.ct = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.m(0.0, 0.0, 0.0);
        ((EntityLiving)this).cC = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public void teleport(Location to) {
        this.ca();
        this.stopRiding(true);
        if (this.gg()) {
            this.a(true, false);
        }
        if (this.cl != this.ck) {
            this.closeContainer(InventoryCloseEvent.Reason.TELEPORT);
        }
        WorldServer toLevel = ((CraftWorld)to.getWorld()).getHandle();
        if (this.A() == toLevel) {
            this.g.internalTeleport(to);
        } else {
            this.a(new TeleportTransition(toLevel, CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch(), Relative.j, TeleportTransition.a, PlayerTeleportEvent.TeleportCause.UNKNOWN));
        }
    }

    public boolean tpsBar() {
        return this.tpsBar;
    }

    public void tpsBar(boolean tpsBar) {
        this.tpsBar = tpsBar;
    }

    public boolean compassBar() {
        return this.compassBar;
    }

    public void compassBar(boolean compassBar) {
        this.compassBar = compassBar;
    }

    public boolean ramBar() {
        return this.ramBar;
    }

    public void ramBar(boolean ramBar) {
        this.ramBar = ramBar;
    }

    public static final class RespawnConfig
    extends Record {
        private final WorldData.a b;
        private final boolean c;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldData.a.b.forGetter(RespawnConfig::a), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::b)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(WorldData.a respawnData, boolean forced) {
            this.b = respawnData;
            this.c = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null ? respawnConfig.a().a() : net.minecraft.world.level.World.h;
        }

        public boolean a(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null && this.b.c().equals(respawnConfig.b.c());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this, o2);
        }

        public WorldData.a a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }

    public record RespawnResult(TeleportTransition transition, boolean isBedSpawn, boolean isAnchorSpawn) {
    }

    public record RespawnPosAngle(Vec3D a, float b, float c, boolean isBedSpawn, boolean isAnchorSpawn, @Nullable Runnable consumeAnchorCharge) {
        public static RespawnPosAngle of(Vec3D position, BlockPosition towardsPos, float pitch, boolean isBedSpawn, boolean isAnchorSpawn, @Nullable Runnable consumeAnchorCharge) {
            return new RespawnPosAngle(position, RespawnPosAngle.a(position, towardsPos), pitch, isBedSpawn, isAnchorSpawn, consumeAnchorCharge);
        }

        private static float a(Vec3D position, BlockPosition towardsPos) {
            Vec3D vec3 = Vec3D.c(towardsPos).d(position).d();
            return (float)MathHelper.e(MathHelper.d(vec3.i, vec3.g) * 180.0 / 3.1415927410125732 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn;consumeAnchorCharge", "a", "b", "c", "isBedSpawn", "isAnchorSpawn", "consumeAnchorCharge"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final Optional<ResourceKey<net.minecraft.world.level.World>> c;
        private final Optional<Vec3D> d;
        private final Optional<Vec2F> e;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.level.World.g.optionalFieldOf(EntityPlayer.f).forGetter(c::a), (App)Vec3D.a.optionalFieldOf("Pos").forGetter(c::b), (App)Vec2F.i.optionalFieldOf("Rotation").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final c b = new c(Optional.empty(), Optional.empty(), Optional.empty());

        public c(Optional<ResourceKey<net.minecraft.world.level.World>> dimension, Optional<Vec3D> position, Optional<Vec2F> rotation) {
            this.c = dimension;
            this.d = position;
            this.e = rotation;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this, o2);
        }

        public Optional<ResourceKey<net.minecraft.world.level.World>> a() {
            return this.c;
        }

        public Optional<Vec3D> b() {
            return this.d;
        }

        public Optional<Vec2F> c() {
            return this.e;
        }
    }
}

