/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.util.Priority;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class PlayerSpawnFinder {
    private static final EntitySize a = EntityTypes.bX.n();
    private static final int b = 1024;
    private final WorldServer c;
    private final BlockPosition d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private int i;
    private final CompletableFuture<Vec3D> j = new CompletableFuture();

    private PlayerSpawnFinder(WorldServer level, BlockPosition spawnSuggestion, int radius) {
        this.c = level;
        this.d = spawnSuggestion;
        this.e = radius;
        long l2 = (long)radius * 2L + 1L;
        this.f = (int)Math.min(1024L, l2 * l2);
        this.g = PlayerSpawnFinder.a(this.f);
        this.h = RandomSource.a().a(this.f);
    }

    public static CompletableFuture<Vec3D> a(WorldServer level, BlockPosition pos) {
        if (level.H_().g() && level.J.j() != EnumGamemode.c) {
            int max = Math.max(0, level.S().d(GameRules.t));
            int floor = MathHelper.a(level.u().b(pos.u(), pos.w()));
            if (floor < max) {
                max = floor;
            }
            if (floor <= 1) {
                max = 1;
            }
            PlayerSpawnFinder playerSpawnFinder = new PlayerSpawnFinder(level, pos, max);
            playerSpawnFinder.a();
            return playerSpawnFinder.j;
        }
        return CompletableFuture.completedFuture(PlayerSpawnFinder.a((ICollisionAccess)level, pos));
    }

    private void a() {
        int i2;
        if ((i2 = this.i++) < this.f) {
            int i1 = (this.h + this.g * i2) % this.f;
            int i22 = i1 % (this.e * 2 + 1);
            int i3 = i1 / (this.e * 2 + 1);
            int i4 = this.d.u() + i22 - this.e;
            int i5 = this.d.w() + i3 - this.e;
            this.a(i4, i5, i2, () -> {
                BlockPosition overworldRespawnPos = PlayerSpawnFinder.a(this.c, i4, i5);
                return overworldRespawnPos != null && PlayerSpawnFinder.b(this.c, overworldRespawnPos) ? Optional.of(Vec3D.c(overworldRespawnPos)) : Optional.empty();
            });
        } else {
            this.a(this.d.u(), this.d.w(), i2, () -> Optional.of(PlayerSpawnFinder.a((ICollisionAccess)this.c, this.d)));
        }
    }

    private static Vec3D a(ICollisionAccess level, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        while (!PlayerSpawnFinder.b(level, mutableBlockPos) && mutableBlockPos.v() < level.ar()) {
            mutableBlockPos.c(EnumDirection.b);
        }
        mutableBlockPos.c(EnumDirection.a);
        while (PlayerSpawnFinder.b(level, mutableBlockPos) && mutableBlockPos.v() > level.M_()) {
            mutableBlockPos.c(EnumDirection.a);
        }
        mutableBlockPos.c(EnumDirection.b);
        return Vec3D.c(mutableBlockPos);
    }

    private static boolean b(ICollisionAccess level, BlockPosition pos) {
        return level.a(null, a.a(pos.c()), true);
    }

    private static int a(int candidateCount) {
        return candidateCount <= 16 ? candidateCount - 1 : 17;
    }

    private void a(int x2, int z2, int index, Supplier<Optional<Vec3D>> calculator) {
        if (!this.j.isDone()) {
            int sectionPosX = SectionPosition.a(x2);
            int sectionPosZ = SectionPosition.a(z2);
            this.c.moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAndLoadWithRadius(TicketType.h, new ChunkCoordIntPair(sectionPosX, sectionPosZ), 0, ChunkStatus.n, Priority.HIGH).whenCompleteAsync((object, throwable) -> {
                if (throwable == null) {
                    try {
                        Optional optional = (Optional)calculator.get();
                        if (optional.isPresent()) {
                            this.j.complete((Vec3D)optional.get());
                        } else {
                            this.a();
                        }
                    }
                    catch (Exception var9) {
                        throwable = var9;
                    }
                }
                if (throwable != null) {
                    CrashReport crashReport = CrashReport.a(throwable, "Searching for spawn");
                    CrashReportSystemDetails crashReportCategory = crashReport.a("Spawn Lookup");
                    crashReportCategory.a("Origin", this.d::toString);
                    crashReportCategory.a("Radius", () -> Integer.toString(this.e));
                    crashReportCategory.a("Candidate", () -> "[" + x2 + "," + z2 + "]");
                    crashReportCategory.a("Progress", () -> index + " out of " + this.f);
                    this.j.completeExceptionally(new ReportedException(crashReport));
                }
            }, (Executor)this.c.q());
        }
    }

    @Nullable
    protected static BlockPosition a(WorldServer level, int x2, int z2) {
        int i2;
        boolean hasCeiling = level.H_().h();
        Chunk chunk = level.d(SectionPosition.a(x2), SectionPosition.a(z2));
        int n2 = i2 = hasCeiling ? level.n().g().a(level) : chunk.a(HeightMap.Type.e, x2 & 0xF, z2 & 0xF);
        if (i2 < level.M_()) {
            return null;
        }
        int height = chunk.a(HeightMap.Type.b, x2 & 0xF, z2 & 0xF);
        if (height <= i2 && height > chunk.a(HeightMap.Type.d, x2 & 0xF, z2 & 0xF)) {
            return null;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i1 = i2 + 1; i1 >= level.M_(); --i1) {
            mutableBlockPos.d(x2, i1, z2);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (!blockState.y().c()) break;
            if (!Block.a(blockState.g(level, mutableBlockPos), EnumDirection.b)) continue;
            return mutableBlockPos.d().j();
        }
        return null;
    }

    @Nullable
    public static BlockPosition a(WorldServer level, ChunkCoordIntPair pos) {
        if (SharedConstants.a(pos)) {
            return null;
        }
        for (int blockX = pos.d(); blockX <= pos.f(); ++blockX) {
            for (int blockZ = pos.e(); blockZ <= pos.g(); ++blockZ) {
                BlockPosition overworldRespawnPos = PlayerSpawnFinder.a(level, blockX, blockZ);
                if (overworldRespawnPos == null) continue;
                return overworldRespawnPos;
            }
        }
        return null;
    }
}

