/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.LevelDebugSynchronizers;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R6.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider C = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger D = LogUtils.getLogger();
    private static final int E = 300;
    private static final int F = 65536;
    final List<EntityPlayer> G = Lists.newArrayList();
    public final ChunkProviderServer H;
    private final MinecraftServer I;
    public final WorldDataServer J;
    final EntityTickList K = new EntityTickList();
    private final ServerWaypointManager L;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R = new TickListServer(this::d);
    private final TickListServer<FluidType> S = new TickListServer(this::d);
    private final PathTypeCache T = new PathTypeCache();
    final Set<EntityInsentient> U = new ObjectOpenHashSet();
    volatile boolean V;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> W = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> X = new ArrayList<BlockActionData>(64);
    private boolean Y;
    private final List<MobSpawner> Z;
    @Nullable
    private EnderDragonBattle aa;
    final Int2ObjectMap<EntityComplexPart> ab = new Int2ObjectOpenHashMap();
    private final StructureManager ac;
    private final StructureCheck ad;
    private final boolean ae;
    private double preciseTime;
    private boolean forceTime;
    private final RandomSequences af;
    final LevelDebugSynchronizers ag = new LevelDebugSynchronizers(this);
    public final Convertable.ConversionSession levelStorageAccess;
    public final UUID uuid;
    public final LevelLoadListener levelLoadListener;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    public boolean hasRidableMoveEvent = false;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final Chunk[] EMPTY_LEVEL_CHUNKS = new Chunk[0];
    private final ReferenceList<Chunk> loadedChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> tickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> entityTickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final ReferenceList<Chunk> playerTickingChunks = new ReferenceList<Chunk>(EMPTY_LEVEL_CHUNKS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.a());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;

    @Override
    @Nullable
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.H.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.levelStorageAccess.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB box) {
        int minBlockX = MathHelper.a(box.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(box.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(box.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(box.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.n();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB box, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(box.a - 1.0E-7) - 3;
        int minBlockZ = MathHelper.a(box.c - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(box.d + 1.0E-7) + 3;
        int maxBlockZ = MathHelper.a(box.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public EntityHuman c(UUID uuid) {
        EntityPlayer player = this.q().am().b(uuid);
        return player != null && ((net.minecraft.world.entity.Entity)player).an() == this ? player : null;
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.H.a(chunkX, chunkZ);
    }

    @Override
    public final IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.I.moonrise$executeMidTickTasks();
    }

    @Override
    public final IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, chunkStatus, priority, onLoad, null);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad, Consumer<IChunkAccess> onEachLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (onEachLoad != null) {
                onEachLoad.accept((IChunkAccess)chunk);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    if (onLoad != null) {
                        onLoad.accept(Collections.unmodifiableList(ret));
                    }
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                PlatformHooks.get().scheduleChunkLoad(this, cx, cz, ChunkStatus.n, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkProviderServer chunkSource = this.H;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void moonrise$issueEmergencySave() {
        this.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(true, true, true, true);
    }

    @Override
    public final ReferenceList<Chunk> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk);
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(Chunk chunk) {
        this.playerTickingChunks.remove(chunk);
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add((Chunk)chunkHolder.getCurrentChunk());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove((Chunk)chunkHolder.getCurrentChunk());
    }

    public WorldServer(MinecraftServer server, Executor dispatcher, Convertable.ConversionSession levelStorageAccess, WorldDataServer serverLevelData, ResourceKey<net.minecraft.world.level.World> dimension, WorldDimension levelStem, boolean isDebug, long biomeZoomSeed, List<MobSpawner> customSpawners, boolean tickTime, @Nullable RandomSequences randomSequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(serverLevelData, dimension, server.bg(), levelStem.a(), false, isDebug, biomeZoomSeed, server.bp(), gen, biomeProvider, env, spigotConfig -> server.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(levelStorageAccess.c.f(), serverLevelData.d(), dimension.a(), spigotConfig, server.bg(), serverLevelData.n())), dispatcher);
        this.levelStorageAccess = levelStorageAccess;
        this.uuid = WorldUUID.getOrCreate(levelStorageAccess.c.f().toFile());
        this.levelLoadListener = new LoggingLevelLoadListener(false, this);
        this.ae = tickTime;
        this.I = server;
        this.Z = new ArrayList<MobSpawner>();
        this.J = serverLevelData;
        if (this.purpurConfig.phantomSpawning) {
            this.Z.add(new MobSpawnerPhantom());
        }
        if (this.purpurConfig.patrolSpawning) {
            this.Z.add(new MobSpawnerPatrol());
        }
        if (this.purpurConfig.catSpawning) {
            this.Z.add(new MobSpawnerCat());
        }
        if (this.purpurConfig.villageSiegeSpawning) {
            this.Z.add(new VillageSiege());
        }
        if (this.purpurConfig.villagerTraderSpawning) {
            this.Z.add(new MobSpawnerTrader(serverLevelData));
        }
        ChunkGenerator chunkGenerator = levelStem.b();
        this.J.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager biomeSource = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.I.bg().f(Registries.aN), chunkGenerator.d());
            if (chunkGenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract noiseBased = (ChunkGeneratorAbstract)chunkGenerator;
                chunkGenerator = new ChunkGeneratorAbstract((WorldChunkManager)biomeSource, noiseBased.e);
            } else if (chunkGenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat flatLevel = (ChunkProviderFlat)chunkGenerator;
                chunkGenerator = new ChunkProviderFlat(flatLevel.h(), biomeSource);
            }
        }
        if (gen != null) {
            chunkGenerator = new CustomChunkGenerator(this, chunkGenerator, gen);
        }
        boolean flag = server.bd();
        DataFixer fixerUpper = server.aE();
        this.H = new ChunkProviderServer(this, levelStorageAccess, fixerUpper, server.be(), dispatcher, chunkGenerator, this.spigotConfig.viewDistance, this.spigotConfig.simulationDistance, flag, null, () -> server.O().y());
        this.H.h().b();
        this.Q = new PortalTravelAgent(this);
        this.ae();
        this.af();
        this.f = this.y().a(PersistentRaid.a(this.ak()));
        if (!server.Y()) {
            serverLevelData.a(server.y());
        }
        long seed = server.bf().x().c();
        this.ad = new StructureCheck(this.H.o(), this.L_(), server.be(), this.getTypeKey(), chunkGenerator, this.H.i(), this, chunkGenerator.d(), seed, fixerUpper);
        this.ac = new StructureManager(this, this.J.x(), this.ad);
        this.aa = this.al() == net.minecraft.world.level.World.j && this.ak().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.J.x().c(), this.J.B()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.af = Objects.requireNonNullElseGet(randomSequences, () -> this.y().a(RandomSequences.a));
        this.L = new ServerWaypointManager();
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new a()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(levelStorageAccess.f(), dimension, "entities"), levelStorageAccess.a(dimension).resolve("entities"), server.bd()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
        this.preciseTime = this.J.c();
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.n().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle dragonFight) {
        this.aa = dragonFight;
    }

    public void a(int clearTime, int weatherTime, boolean isRaining, boolean isThundering) {
        this.J.a(clearTime);
        this.J.c(weatherTime);
        this.J.b(weatherTime);
        this.J.setRaining(isRaining, WeatherChangeEvent.Cause.COMMAND);
        this.J.setThundering(isThundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int x2, int y2, int z2) {
        return this.n().g().d().getNoiseBiome(x2, y2, z2, this.n().i().b());
    }

    public StructureManager b() {
        return this.ac;
    }

    public void a(BooleanSupplier hasTimeLeft) {
        boolean hasActiveTickets;
        GameProfilerFiller profilerFiller = Profiler.a();
        this.Y = true;
        TickRateManager tickRateManager = this.w();
        boolean runsNormally = tickRateManager.i();
        if (runsNormally) {
            profilerFiller.a("world border");
            this.u().s();
            profilerFiller.b("weather");
            this.az();
            profilerFiller.c();
        }
        int _int = this.S().d(GameRules.R);
        if (this.purpurConfig.playersSkipNight && this.O.a(_int) && this.O.a(_int, this.G)) {
            long newDayTime = this.A.c() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, newDayTime - newDayTime % 24000L - this.ah());
            if (this.S().c(GameRules.m) && event.callEvent()) {
                this.b(this.ah() + event.getSkipAmount());
            }
            if (!event.isCancelled()) {
                this.ax();
            }
            if (this.S().c(GameRules.x) && this.aj()) {
                this.i();
            }
        }
        this.ae();
        if (runsNormally) {
            this.c();
        }
        profilerFiller.a("tickPending");
        if (!this.am() && runsNormally) {
            long l2 = this.ag();
            profilerFiller.a("blockTicks");
            this.R.a(l2, this.paperConfig().environment.maxBlockTicks, this::c);
            profilerFiller.b("fluidTicks");
            this.S.a(l2, this.paperConfig().environment.maxFluidTicks, this::a);
            profilerFiller.c();
        }
        profilerFiller.b("raid");
        if (runsNormally) {
            this.f.a(this);
        }
        profilerFiller.b("chunkSource");
        this.n().a(hasTimeLeft, true);
        profilerFiller.b("blockEvents");
        if (runsNormally) {
            this.aA();
        }
        this.Y = false;
        profilerFiller.c();
        boolean bl = hasActiveTickets = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || this.H.k();
        if (hasActiveTickets) {
            this.j();
        }
        if (runsNormally) {
            ++this.P;
        }
        if (this.P < 300) {
            profilerFiller.a("entities");
            if (this.aa != null && runsNormally) {
                profilerFiller.a("dragonFight");
                this.aa.c();
                profilerFiller.c();
            }
            ActivationRange.activateEntities(this);
            this.K.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.ec() && !tickRateManager.a((net.minecraft.world.entity.Entity)entity)) {
                    profilerFiller.a("checkDespawn");
                    entity.dR();
                    profilerFiller.c();
                    net.minecraft.world.entity.Entity vehicle = entity.du();
                    if (vehicle != null) {
                        if (!vehicle.ec() && vehicle.z((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.cb();
                    }
                    profilerFiller.a("tick");
                    this.a(this::a, entity);
                    profilerFiller.c();
                }
            });
            profilerFiller.b("blockEntities");
            this.ad();
            profilerFiller.c();
        }
        profilerFiller.a("entityManagement");
        profilerFiller.c();
        profilerFiller.a("debugSynchronizers");
        if (this.ag.a(DebugSubscriptions.o)) {
            this.s.a((BlockPosition blockPos) -> this.ag.b((BlockPosition)blockPos, DebugSubscriptions.o, blockPos));
        } else {
            this.s.a(null);
        }
        this.ag.a(this.I.bA());
        profilerFiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void c() {
        if (this.ae) {
            long l2 = this.A.b() + 1L;
            this.J.a(l2);
            Profiler.a().a("scheduledFunctions");
            this.J.r().a(this.I, l2);
            Profiler.a().c();
            if (this.J.n().c(GameRules.m)) {
                int incrementTicks;
                int n2 = incrementTicks = this.aa() ? this.purpurConfig.daytimeTicks : this.purpurConfig.nighttimeTicks;
                if (incrementTicks != 12000) {
                    this.preciseTime += 12000.0 / (double)incrementTicks;
                    this.setDayTime(this.preciseTime);
                } else {
                    this.b(this.A.c() + 1L);
                }
            }
        }
    }

    public void b(long time) {
        this.J.b(time);
        this.preciseTime = time;
        this.forceTime = false;
    }

    public void setDayTime(double i2) {
        this.J.b((long)i2);
        this.forceTime = true;
    }

    public boolean isForceTime() {
        return this.forceTime;
    }

    public void a(boolean spawnEnemies) {
        for (MobSpawner customSpawner : this.Z) {
            customSpawner.a(this, spawnEnemies);
        }
    }

    private void ax() {
        this.O.a();
        this.G.stream().filter(EntityLiving::gg).collect(Collectors.toList()).forEach(player -> player.a(false, false));
    }

    private void optimiseRandomTick(Chunk chunk, int tickSpeed) {
        ChunkSection[] sections = chunk.d();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkCoordIntPair cpos = chunk.f();
        int offsetX = cpos.h << 4;
        int offsetZ = cpos.i << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            ChunkSection section = sections[sectionIndex];
            DataPaletteBlock<IBlockData> states = section.h;
            if (!section.e()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i2 = 0; i2 < tickSpeed; ++i2) {
                Fluid fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.f() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                IBlockData state = states.a(location);
                BlockPosition pos = new BlockPosition(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.b(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.y()).f()) continue;
                fluidState.a(this, pos, (RandomSource)simpleRandom);
            }
        }
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkCoordIntPair pos = chunk.f();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int i2 = 0; i2 < randomTickSpeed; ++i2) {
                if (simpleRandom.a(48) != 0) continue;
                this.a(this.a(minBlockX, 0, minBlockZ, 15));
            }
        }
        profilerFiller.b("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        profilerFiller.c();
    }

    public void a(Chunk chunk) {
        BlockPosition blockPos;
        ChunkCoordIntPair pos = chunk.f();
        boolean isRaining = this.aj();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("thunder");
        if (!this.paperConfig().environment.disableThunder && isRaining && this.ai() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0 && this.r(blockPos = this.b(this.a(minBlockX, 0, minBlockZ, 15)))) {
            EntityLightning lightningBolt;
            boolean flag;
            DifficultyDamageScaler currentDifficultyAt = this.d_(blockPos);
            boolean bl = flag = this.S().c(GameRules.f) && this.z.j() < (double)currentDifficultyAt.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockPos.e()).a(TagsBlock.aj);
            if (flag) {
                EntityHorseAbstract skeletonHorse;
                if (this.purpurConfig.zombieHorseSpawnChance > 0.0 && this.z.j() <= this.purpurConfig.zombieHorseSpawnChance) {
                    skeletonHorse = EntityTypes.bU.a(this, EntitySpawnReason.h);
                } else {
                    skeletonHorse = EntityTypes.bl.a(this, EntitySpawnReason.h);
                    if (skeletonHorse != null) {
                        ((EntityHorseSkeleton)skeletonHorse).x(true);
                    }
                }
                if (skeletonHorse != null) {
                    skeletonHorse.c_(0);
                    skeletonHorse.a_(blockPos.u(), blockPos.v(), blockPos.w());
                    this.addFreshEntity(skeletonHorse, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
            }
            if ((lightningBolt = EntityTypes.aA.a(this, EntitySpawnReason.h)) != null) {
                lightningBolt.f(Vec3D.c(blockPos));
                lightningBolt.a(flag);
                this.strikeLightning(lightningBolt, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        profilerFiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition pos) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, pos);
        BlockPosition blockPos = heightmapPos.e();
        BiomeBase biome = this.v(heightmapPos).a();
        if (biome.a(this, blockPos)) {
            CraftEventFactory.handleBlockFormEvent(this, blockPos, Blocks.eq.m(), 3, null);
        }
        if (this.aj()) {
            BiomeBase.Precipitation precipitationAt;
            int _int = this.S().d(GameRules.V);
            if (_int > 0 && biome.b(this, heightmapPos)) {
                IBlockData blockState = this.a_(heightmapPos);
                if (blockState.a(Blocks.ep)) {
                    int layersValue = blockState.c(BlockSnow.c);
                    if (layersValue < Math.min(_int, 8)) {
                        boolean canSnow = true;
                        if (PurpurConfig.smoothSnowAccumulationStep > 0 && layersValue >= PurpurConfig.smoothSnowAccumulationStep) {
                            int layersValueMin = layersValue - PurpurConfig.smoothSnowAccumulationStep;
                            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                                BlockPosition blockPosNeighbor = heightmapPos.a(direction);
                                IBlockData blockStateNeighbor = this.a_(blockPosNeighbor);
                                if (blockStateNeighbor.a(Blocks.ep)) {
                                    int layersValueNeighbor = blockStateNeighbor.c(BlockSnow.c);
                                    if (layersValueNeighbor > layersValueMin) continue;
                                    canSnow = false;
                                    break;
                                }
                                if (Block.a(blockStateNeighbor.g(this, blockPosNeighbor), direction.g())) continue;
                                canSnow = false;
                                break;
                            }
                        }
                        if (canSnow) {
                            IBlockData blockState1 = (IBlockData)blockState.b(BlockSnow.c, layersValue + 1);
                            Block.a(blockState, blockState1, this, heightmapPos);
                            CraftEventFactory.handleBlockFormEvent(this, heightmapPos, blockState1, 3, null);
                        }
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent(this, heightmapPos, Blocks.ep.m(), 3, null);
                }
            }
            if ((precipitationAt = biome.a(blockPos, this.T())) != BiomeBase.Precipitation.a) {
                IBlockData blockState2 = this.a_(blockPos);
                blockState2.b().a(blockState2, (net.minecraft.world.level.World)this, blockPos, precipitationAt);
            }
        }
    }

    public Optional<BlockPosition> G(BlockPosition pos) {
        Optional<BlockPosition> optional = this.D().e(poiType -> poiType.a(PoiTypes.t), pos1 -> pos1.v() == this.a(HeightMap.Type.b, pos1.u(), pos1.w()) - 1, pos, PurpurConfig.lightningRodRange, VillagePlace.Occupancy.c);
        return optional.map(pos1 -> pos1.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition heightmapPos = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.G(heightmapPos);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB aabb = AxisAlignedBB.a(heightmapPos, heightmapPos.h(this.ar() + 1)).g(3.0);
        List<EntityLiving> entitiesOfClass = this.a(EntityLiving.class, aabb, (? super T entity) -> entity != null && entity.bX() && this.h(entity.dF()) && !entity.at());
        if (!entitiesOfClass.isEmpty()) {
            return entitiesOfClass.get(this.z.a(entitiesOfClass.size())).dF();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (heightmapPos.v() == this.M_() - 1) {
            heightmapPos = heightmapPos.b(2);
        }
        return heightmapPos;
    }

    public boolean d() {
        return this.Y;
    }

    public boolean e() {
        return this.S().d(GameRules.R) <= 100;
    }

    private void ay() {
        if (this.e() && (!this.q().Y() || this.q().s())) {
            IChatBaseComponent component;
            int _int = this.S().d(GameRules.R);
            if (this.O.a(_int)) {
                if (PurpurConfig.sleepSkippingNight.isBlank()) {
                    return;
                }
                component = !PurpurConfig.sleepSkippingNight.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.sleepSkippingNight)) : IChatBaseComponent.c("sleep.skipping_night");
            } else {
                if (PurpurConfig.sleepingPlayersPercent.isBlank()) {
                    return;
                }
                component = !PurpurConfig.sleepingPlayersPercent.equalsIgnoreCase("default") ? PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize(PurpurConfig.sleepingPlayersPercent, new TagResolver[]{Placeholder.parsed((String)"count", (String)Integer.toString(this.O.b())), Placeholder.parsed((String)"total", (String)Integer.toString(this.O.b(_int)))})) : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(_int));
            }
            for (EntityPlayer serverPlayer : this.G) {
                serverPlayer.a(component, true);
            }
        }
    }

    public void f() {
        if (!this.G.isEmpty() && this.O.a(this.G)) {
            this.ay();
        }
    }

    public ScoreboardServer g() {
        return this.I.aO();
    }

    public ServerWaypointManager h() {
        return this.L;
    }

    private void az() {
        boolean isRaining = this.aj();
        if (this.H_().g()) {
            if (this.S().c(GameRules.x)) {
                int clearWeatherTime = this.J.e();
                int thunderTime = this.J.g();
                int rainTime = this.J.i();
                boolean isThundering = this.A.f();
                boolean isRaining1 = this.A.h();
                if (clearWeatherTime > 0) {
                    --clearWeatherTime;
                    thunderTime = isThundering ? 0 : 1;
                    rainTime = isRaining1 ? 0 : 1;
                    isThundering = false;
                    isRaining1 = false;
                } else {
                    if (thunderTime > 0) {
                        if (--thunderTime == 0) {
                            isThundering = !isThundering;
                        }
                    } else {
                        thunderTime = isThundering ? d.a(this.z) : C.a(this.z);
                    }
                    if (rainTime > 0) {
                        if (--rainTime == 0) {
                            isRaining1 = !isRaining1;
                        }
                    } else {
                        rainTime = isRaining1 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.J.b(thunderTime);
                this.J.c(rainTime);
                this.J.a(clearWeatherTime);
                this.J.setThundering(isThundering, ThunderChangeEvent.Cause.NATURAL);
                this.J.setRaining(isRaining1, WeatherChangeEvent.Cause.NATURAL);
            }
            this.x = this.y;
            this.y = this.A.f() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.h() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (EntityPlayer player : this.G) {
            if (player.A() != this) continue;
            player.tickWeather();
        }
        if (isRaining != this.aj()) {
            for (EntityPlayer player : this.G) {
                if (player.A() != this) continue;
                player.setPlayerWeather(!isRaining ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (EntityPlayer player : this.G) {
            if (player.A() != this) continue;
            player.updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    @VisibleForTesting
    public void i() {
        if (this.purpurConfig.rainStopsAfterSleep) {
            this.J.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        }
        if (!this.J.h()) {
            this.J.c(0);
        }
        if (this.purpurConfig.thunderStopsAfterSleep) {
            this.J.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        }
        if (!this.J.f()) {
            this.J.b(0);
        }
    }

    public void j() {
        this.P = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        IBlockData blockState = this.a_(pos);
        Fluid fluidState = blockState.y();
        if (fluidState.b(fluid)) {
            fluidState.a(this, pos, blockState);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.I.moonrise$executeMidTickTasks();
        }
    }

    private void c(BlockPosition pos, Block block) {
        IBlockData blockState = this.a_(pos);
        if (blockState.a(block)) {
            blockState.a(this, pos, this.z);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.I.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.bL();
            GameProfilerFiller profilerFiller = Profiler.a();
            ++entity.at;
            ++entity.totalEntityAge;
            profilerFiller.a(() -> BuiltInRegistries.g.b(entity.ax()).toString());
            profilerFiller.f("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.g();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity1 : entity.di()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity ridingEntity, net.minecraft.world.entity.Entity passengerEntity, boolean isActive) {
        if (passengerEntity.ec() || passengerEntity.du() != ridingEntity) {
            passengerEntity.cb();
        } else if (passengerEntity instanceof EntityHuman || this.K.c(passengerEntity)) {
            passengerEntity.bL();
            ++passengerEntity.at;
            ++passengerEntity.totalEntityAge;
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(() -> BuiltInRegistries.g.b(passengerEntity.ax()).toString());
            profilerFiller.f("tickPassenger");
            if (isActive) {
                passengerEntity.t();
                passengerEntity.postTick();
            } else {
                passengerEntity.k(Vec3D.c);
                passengerEntity.inactiveTick();
                ridingEntity.k(passengerEntity);
            }
            profilerFiller.c();
            for (net.minecraft.world.entity.Entity entity : passengerEntity.di()) {
                this.tickPassenger(passengerEntity, entity, isActive);
            }
        }
    }

    public void a(BlockPosition pos, IBlockData state) {
        boolean flag;
        IBlockData blockState = this.a_(pos);
        Block block = blockState.b();
        boolean bl = flag = !state.a(block);
        if (flag) {
            state.a(this, pos, false);
        }
        this.a(pos, blockState.b());
        if (blockState.q()) {
            this.b(pos, block);
        }
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        EntityHuman player;
        return !(entity instanceof EntityHuman && (this.I.a(this, pos, player = (EntityHuman)entity) || !this.u().a(pos)));
    }

    public void saveIncrementally(boolean doFull) {
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.c(false);
        }
        if (doFull) {
            this.J.a(this.I.aR().a(this.L_()));
            this.levelStorageAccess.a(this.I.bg(), this.J, this.I.am().r());
        }
    }

    public void a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        this.save(progress, flush, skipSave, false);
    }

    public void save(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave, boolean close) {
        ChunkProviderServer chunkSource = this.n();
        if (!skipSave) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progress != null) {
                progress.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.c(flush);
            if (progress != null) {
                progress.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            if (!close) {
                chunkSource.a(flush);
            }
        }
        if (close) {
            try {
                chunkSource.close(!skipSave);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        WorldServer serverLevel1 = this;
        this.J.a(this.I.aR().a(this.L_()));
        this.levelStorageAccess.a(this.I.bg(), this.J, this.I.am().r());
    }

    private void c(boolean join) {
        if (this.aa != null) {
            this.J.a(this.aa.b());
        }
        WorldPersistentData dataStorage = this.n().m();
        if (join) {
            dataStorage.b();
        } else {
            dataStorage.a();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(typeTest, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output) {
        this.a(typeTest, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> typeTest, Predicate<? super T> predicate, List<? super T> output, int maxResults) {
        this.K().a(typeTest, (U entity) -> {
            if (predicate.test(entity)) {
                output.add((Object)entity);
                if (output.size() >= maxResults) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> k() {
        return this.a(EntityTypes.S, EntityLiving::bX);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int maxResults) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer serverPlayer : this.G) {
            if (!predicate.test(serverPlayer)) continue;
            list.add(serverPlayer);
            if (list.size() < maxResults) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer l() {
        List<EntityPlayer> players = this.a(EntityLiving::bX);
        return players.isEmpty() ? null : players.get(this.z.a(players.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            this.c(serverPlayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer player) {
        this.c(player);
    }

    public void b(EntityPlayer player) {
        this.c(player);
    }

    private void c(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.d(player.cT());
        if (entity != null) {
            D.warn("Force-added player with duplicate UUID {}", (Object)player.cT());
            entity.av();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, @Nullable CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.m.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.ec()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).e().f()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.dk().map(net.minecraft.world.entity.Entity::cT).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void b(Chunk chunk) {
        for (TileEntity blockEntity : chunk.J().values()) {
            if (!(blockEntity instanceof IInventory)) continue;
            for (HumanEntity human : Lists.newArrayList(((IInventory)((Object)blockEntity)).getViewers())) {
                ((CraftHumanEntity)human).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.K();
        chunk.c(this);
        this.ag.a(chunk.f());
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int breakerId, BlockPosition pos, int progress) {
        EntityHuman breakerPlayer = null;
        net.minecraft.world.entity.Entity entity = this.a(breakerId);
        if (entity instanceof EntityHuman) {
            breakerPlayer = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        for (EntityPlayer serverPlayer : this.I.am().t()) {
            if (serverPlayer == null || serverPlayer.A() != this || serverPlayer.az() == breakerId) continue;
            double d2 = (double)pos.u() - serverPlayer.dK();
            double d1 = (double)pos.v() - serverPlayer.dM();
            double d22 = (double)pos.w() - serverPlayer.dQ();
            if (breakerPlayer != null && !serverPlayer.getBukkitEntity().canSee(breakerPlayer.getBukkitEntity()) || !(d2 * d2 + d1 * d1 + d22 * d22 < 1024.0)) continue;
            serverPlayer.g.b(new PacketPlayOutBlockBreakAnimation(breakerId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory source, float volume, float pitch, long seed) {
        EntityHuman player;
        this.I.am().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, x2, y2, z2, sound.a().a(volume), this.al(), new PacketPlayOutNamedSoundEffect(sound, source, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity sourceEntity, Holder<SoundEffect> sound, SoundCategory source, float volume, float pitch, long seed) {
        EntityHuman player;
        this.I.am().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, sourceEntity.dK(), sourceEntity.dM(), sourceEntity.dQ(), sound.a().a(volume), this.al(), new PacketPlayOutEntitySound(sound, source, sourceEntity, volume, pitch, seed));
    }

    @Override
    public void b(int id, BlockPosition pos, int data) {
        if (this.S().c(GameRules.Y)) {
            this.I.am().t().forEach(player -> {
                Vec3D vec31;
                if (player.A() == this) {
                    Vec3D vec3 = Vec3D.b(pos);
                    if (player.g(vec3) < (double)MathHelper.i(32)) {
                        vec31 = vec3;
                    } else {
                        Vec3D vec32 = vec3.d(player.dD()).d();
                        vec31 = player.dD().e(vec32.c(32.0));
                    }
                } else {
                    vec31 = player.dD();
                }
                player.g.b(new PacketPlayOutWorldEvent(id, BlockPosition.a(vec31), data, true));
            });
        } else {
            this.a(null, id, pos, data);
        }
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, int type, BlockPosition pos, int data) {
        EntityHuman player;
        this.I.am().a(entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null, pos.u(), pos.v(), pos.w(), 64.0, this.al(), new PacketPlayOutWorldEvent(type, pos, data, false));
    }

    public int m() {
        return this.H_().p();
    }

    @Override
    public void a(Holder<GameEvent> gameEvent, Vec3D pos, GameEvent.a context) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(pos.g) >> 4, MathHelper.a(pos.i) >> 4) == null) {
            return;
        }
        this.N.a(gameEvent, pos, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape collisionShape1;
        VoxelShape collisionShape;
        if (this.V) {
            String string = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.n().a(pos);
        this.T.a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(collisionShape = oldState.g(this, pos), collisionShape1 = newState.g(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            try {
                for (EntityInsentient mob : this.U) {
                    NavigationAbstract navigation = mob.S();
                    if (!navigation.b(pos)) continue;
                    list.add(navigation);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.a(pos, oldState, newState, flags);
                return;
            }
            try {
                this.V = true;
                for (NavigationAbstract pathNavigation : list) {
                    pathNavigation.i();
                }
            }
            finally {
                this.V = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block block) {
        if (this.populating) {
            return;
        }
        if (this.captureBlockStates) {
            return;
        }
        this.a(pos, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.s.a(pos, block, null, orientation);
    }

    @Override
    public void a(BlockPosition pos, Block block, EnumDirection facing, @Nullable Orientation orientation) {
        this.s.a(pos, block, facing, orientation);
    }

    @Override
    public void b(BlockPosition pos, Block block, @Nullable Orientation orientation) {
        this.s.a(pos, block, orientation);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
        this.s.a(state, pos, block, orientation, movedByPiston);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte state) {
        this.n().a(entity, new PacketPlayOutEntityStatus(entity, state));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.n().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer n() {
        return this.H;
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound) {
        this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound) {
        return this.explode0(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, blockParticles, explosionSound, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, World.a explosionInteraction, ParticleParam smallExplosionParticles, ParticleParam largeExplosionParticles, WeightedList<ExplosionParticleInfo> blockParticles, Holder<SoundEffect> explosionSound, @Nullable Consumer<ServerExplosion> configurator) {
        Explosion.Effect blockInteraction = switch (explosionInteraction) {
            default -> throw new MatchException(null, null);
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.S);
            case World.a.c -> {
                if (source instanceof EntityLargeFireball && this.S().getBoolean(GameRules.d, this.purpurConfig.fireballsMobGriefingOverride) || this.S().c(GameRules.d)) {
                    yield this.a(GameRules.T);
                }
                yield Explosion.Effect.a;
            }
            case World.a.d -> this.a(GameRules.U);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
        };
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        ServerExplosion serverExplosion = new ServerExplosion(this, source, damageSource, damageCalculator, vec3, radius, fire, blockInteraction);
        if (configurator != null) {
            configurator.accept(serverExplosion);
        }
        int i2 = serverExplosion.i();
        if (serverExplosion.wasCanceled) {
            return serverExplosion;
        }
        ParticleParam particleOptions = serverExplosion.l() ? smallExplosionParticles : largeExplosionParticles;
        for (EntityPlayer serverPlayer : this.G) {
            if (!(serverPlayer.g(vec3) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverExplosion.j().get(serverPlayer));
            serverPlayer.g.b(new PacketPlayOutExplosion(vec3, radius, i2, optional, particleOptions, explosionSound, blockParticles));
        }
        return serverExplosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> decayGameRule) {
        return this.S().c(decayGameRule) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition pos, Block block, int eventId, int eventParam) {
        this.W.add((Object)new BlockActionData(pos, block, eventId, eventParam));
    }

    private void aA() {
        this.X.clear();
        while (!this.W.isEmpty()) {
            BlockActionData blockEventData = (BlockActionData)this.W.removeFirst();
            if (this.n(blockEventData.a())) {
                if (!this.a(blockEventData)) continue;
                this.I.am().a(null, blockEventData.a().u(), blockEventData.a().v(), blockEventData.a().w(), 64.0, this.al(), new PacketPlayOutBlockAction(blockEventData.a(), blockEventData.b(), blockEventData.c(), blockEventData.d()));
                continue;
            }
            this.X.add(blockEventData);
        }
        this.W.addAll(this.X);
    }

    private boolean a(BlockActionData event) {
        IBlockData blockState = this.a_(event.a());
        return blockState.a(event.b()) && blockState.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d());
    }

    public TickListServer<Block> o() {
        return this.R;
    }

    public TickListServer<FluidType> p() {
        return this.S;
    }

    @Override
    @Nonnull
    public MinecraftServer q() {
        return this.I;
    }

    public PortalTravelAgent r() {
        return this.Q;
    }

    public StructureTemplateManager s() {
        return this.I.be();
    }

    public <T extends ParticleParam> int a(T options, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, false, false, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int a(T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(null, options, overrideLimiter, alwaysShow, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(@Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        return this.sendParticlesSource(this.G, sender, options, overrideLimiter, alwaysShow, x2, y2, z2, count, xDist, yDist, zDist, speed);
    }

    public <T extends ParticleParam> int sendParticlesSource(List<EntityPlayer> receivers, @Nullable net.minecraft.world.entity.Entity sender, T options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, int count, double xDist, double yDist, double zDist, double speed) {
        PacketPlayOutWorldParticles clientboundLevelParticlesPacket = new PacketPlayOutWorldParticles(options, overrideLimiter, alwaysShow, x2, y2, z2, (float)xDist, (float)yDist, (float)zDist, (float)speed, count);
        int i2 = 0;
        for (int i1 = 0; i1 < receivers.size(); ++i1) {
            EntityPlayer serverPlayer = receivers.get(i1);
            if (sender != null && !serverPlayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(serverPlayer, overrideLimiter, x2, y2, z2, clientboundLevelParticlesPacket)) continue;
            ++i2;
        }
        return i2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer player, T particle, boolean overrideLimiter, boolean alwaysShow, double posX, double posY, double posZ, int count, double xDist, double yDist, double zDist, double maxSpeed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, overrideLimiter, alwaysShow, posX, posY, posZ, (float)xDist, (float)yDist, (float)zDist, (float)maxSpeed, count);
        return this.a(player, overrideLimiter, posX, posY, posZ, packet);
    }

    private boolean a(EntityPlayer player, boolean overrideLimiter, double x2, double y2, double z2, Packet<?> packet) {
        if (player.A() != this) {
            return false;
        }
        BlockPosition blockPos = player.dF();
        if (blockPos.a(new Vec3D(x2, y2, z2), overrideLimiter ? 512.0 : 32.0)) {
            player.g.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.K().a(id);
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(UUID id) {
        net.minecraft.world.entity.Entity entity = this.d(id);
        if (entity != null) {
            return entity;
        }
        for (WorldServer serverLevel : this.q().Q()) {
            net.minecraft.world.entity.Entity entity1;
            if (serverLevel == this || (entity1 = serverLevel.d(id)) == null) continue;
            return entity1;
        }
        return null;
    }

    @Override
    @Nullable
    public EntityHuman b(UUID id) {
        return this.q().am().b(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.K().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ab.get(id);
    }

    @Override
    public Collection<EntityComplexPart> t() {
        return this.ab.values();
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipKnownStructures) {
        if (!this.J.x().d()) {
            return null;
        }
        Optional optional = this.L_().f(Registries.bm).a(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.n().g().a(this, (HolderSet)optional.get(), pos, radius, skipKnownStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> biomePredicate, BlockPosition pos, int radius, int horizontalStep, int verticalStep) {
        return this.n().g().d().a(pos, radius, horizontalStep, verticalStep, biomePredicate, this.n().i().b(), this);
    }

    @Override
    public WorldBorder u() {
        return this.y().a(WorldBorder.d);
    }

    public CraftingManager v() {
        return this.I.aN();
    }

    @Override
    public TickRateManager w() {
        return this.I.aV();
    }

    @Override
    public boolean x() {
        return this.e;
    }

    public WorldPersistentData y() {
        return this.n().m();
    }

    @Override
    @Nullable
    public WorldMap a(MapId mapId) {
        WorldPersistentData storage = this.q().O().y();
        Optional<PersistentBase> cacheEntry = storage.c.get(WorldMap.a(mapId));
        if (cacheEntry == null) {
            WorldMap mapData = storage.b(WorldMap.a(mapId));
            if (mapData != null) {
                mapData.id = mapId;
                new MapInitializeEvent((MapView)mapData.mapView).callEvent();
                return mapData;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof WorldMap) {
            WorldMap mapItemSavedData = var5_6;
            mapItemSavedData.id = mapId;
            return mapItemSavedData;
        }
        return null;
    }

    public void a(MapId mapId, WorldMap data) {
        data.id = mapId;
        MapInitializeEvent event = new MapInitializeEvent((MapView)data.mapView);
        event.callEvent();
        this.q().O().y().a(WorldMap.a(mapId), data);
    }

    public MapId z() {
        return this.q().O().y().a(PersistentIdCounts.b).a();
    }

    @Override
    public void a(WorldData.a respawnData) {
        if (!this.J.a().positionEquals(respawnData)) {
            Location previousLocation = this.getWorld().getSpawnLocation();
            this.J.a(respawnData);
            this.I.am().a(new PacketPlayOutSpawnPosition(respawnData), this.al());
            this.I.bM();
            new SpawnChangeEvent((World)this.getWorld(), previousLocation).callEvent();
        }
        if (this.I.O().J.respawnDimension != this.al()) {
            this.I.O().J.respawnDimension = this.al();
            this.I.bM();
        }
    }

    @Override
    public WorldData.a A() {
        return this.q().aM();
    }

    public LongSet B() {
        return this.H.l();
    }

    public boolean a(int chunkX, int chunkZ, boolean add) {
        boolean flag = this.H.a(new ChunkCoordIntPair(chunkX, chunkZ), add);
        if (add && flag) {
            this.d(chunkX, chunkZ);
        }
        return flag;
    }

    public List<EntityPlayer> C() {
        return this.G;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldState);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newState))) {
            BlockPosition blockPos = pos.j();
            optional.ifPresent(holder -> this.q().execute(() -> {
                this.D().a(blockPos);
                this.ag.c(blockPos);
            }));
            optional1.ifPresent(holder -> this.q().execute(() -> {
                VillagePlaceRecord poiRecord;
                if (optional.isEmpty() && this.D().a(blockPos, (Holder<VillagePlaceType> ignored) -> true)) {
                    this.D().a(blockPos);
                }
                if ((poiRecord = this.D().a(blockPos, (Holder<VillagePlaceType>)holder)) != null) {
                    this.ag.a(poiRecord);
                }
            }));
        }
    }

    public VillagePlace D() {
        return this.n().n();
    }

    public boolean c(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition pos) {
        return this.c(pos.k());
    }

    public boolean a(BlockPosition pos, int sections) {
        return sections <= 6 && this.b(SectionPosition.a(pos)) <= sections;
    }

    public int b(SectionPosition pos) {
        return this.D().a(pos);
    }

    public PersistentRaid E() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean e(BlockPosition pos) {
        return this.d(pos) != null;
    }

    public void a(ReputationEvent type, net.minecraft.world.entity.Entity target, ReputationHandler host) {
        host.a(type, target);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedWriter3;
        PlayerChunkMap chunkMap = this.n().a;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", chunkMap.i().a()));
            SpawnerCreature.d lastSpawnState = this.n().p();
            if (lastSpawnState != null) {
                for (Object2IntMap.Entry entry : lastSpawnState.b().object2IntEntrySet()) {
                    bufferedWriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedWriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedWriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.o().a()));
            bufferedWriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.p().a()));
            bufferedWriter.write("distance_manager: " + chunkMap.i().c() + "\n");
            bufferedWriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.n().f()));
        }
        CrashReport crashReport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashReport);
        try (BufferedWriter bufferedWriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedWriter1.write(crashReport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedWriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedWriter2 != null) {
            ((Writer)bufferedWriter2).close();
        }
        if ((bufferedWriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            ((Writer)bufferedWriter3).close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedWriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedWriter4, this.K().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedWriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedWriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent customName = entity.ar();
            IChatBaseComponent displayName = entity.S_();
            csvOutput.a(entity.dK(), entity.dM(), entity.dQ(), entity.cT(), BuiltInRegistries.g.b(entity.ax()), entity.bX(), displayName.getString(), customName != null ? customName.getString() : null);
        }
    }

    private void a(Writer output) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("type").a(output);
        for (TickingBlockEntity tickingBlockEntity : this.r) {
            BlockPosition pos = tickingBlockEntity.c();
            csvOutput.a(pos.u(), pos.v(), pos.w(), tickingBlockEntity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox boundingBox) {
        this.W.removeIf(blockEventData -> boundingBox.b(blockEventData.a()));
    }

    @Override
    public float a(EnumDirection direction, boolean shade) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> F() {
        return this.K().a();
    }

    public String toString() {
        return "ServerLevel[" + this.J.d() + "]";
    }

    public boolean G() {
        return this.J.y();
    }

    @Override
    public long H() {
        return this.J.x().c();
    }

    @Nullable
    public EnderDragonBattle I() {
        return this.aa;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String J() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.G.size(), this.moonrise$getEntityLookup().getDebugInfo(), WorldServer.a(this.moonrise$getEntityLookup().a(), (T entity) -> BuiltInRegistries.g.b(entity.ax()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.o().a(), this.p().a(), this.N());
    }

    private static <T> String a(Iterable<T> objects, Function<T, String> typeGetter) {
        try {
            Object2IntOpenHashMap map = new Object2IntOpenHashMap();
            for (T object : objects) {
                String string = typeGetter.apply(object);
                map.addTo((Object)string, 1);
            }
            return map.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> (String)entry.getKey() + ":" + entry.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception var6) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> K() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void c(Chunk chunk) {
        chunk.d(this.F_().b());
    }

    public void a(IChunkAccess chunk) {
        this.I.execute(() -> this.ad.a(chunk.f(), chunk.g()));
    }

    public PathTypeCache L() {
        return this.T;
    }

    public void a(ChunkCoordIntPair chunkPos, int radius) {
        List<ChunkCoordIntPair> list = ChunkCoordIntPair.a(chunkPos, radius).toList();
        this.H.g.b(() -> {
            for (ChunkCoordIntPair chunkPos1 : list) {
                if (this.c(chunkPos1.a())) continue;
                return false;
            }
            return true;
        });
    }

    public boolean M() {
        return this.I.ab();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String N() {
        return "Chunks[S] W: " + this.H.e() + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    public boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean g(BlockPosition pos) {
        return this.b(new ChunkCoordIntPair(pos));
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        return this.H.a.b(chunkPos);
    }

    public boolean c(ChunkCoordIntPair chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkPos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady() && this.u().a(chunkPos);
    }

    @Override
    public FeatureFlagSet O() {
        return this.I.bf().J();
    }

    @Override
    public PotionBrewer P() {
        return this.I.bv();
    }

    @Override
    public FuelValues Q() {
        return this.I.bw();
    }

    public RandomSource a(MinecraftKey location) {
        return this.af.a(location);
    }

    public RandomSequences R() {
        return this.af;
    }

    public GameRules S() {
        return this.J.n();
    }

    public List<EntityPlayer> getPlayersForGlobalSoundGamerule() {
        return this.S().c(GameRules.Y) ? this.q().am().k : this.C();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    @Deprecated
    public void checkCapturedTreeStateForObserverNotify(BlockPosition pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().v() == pos.v() && this.a_(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlags(), 512);
        }
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashReportCategory = super.a(report);
        crashReportCategory.a("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashReportCategory;
    }

    @Override
    public int T() {
        return this.H.g().f();
    }

    @Override
    public void a(TileEntity entity) {
        super.a(entity);
        this.ag.a(entity);
    }

    public LevelDebugSynchronizers U() {
        return this.ag;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.I.am().b(uuid);
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).gm()) {
                WorldServer.this.h().a(waypointTransmitter);
            }
            entity.bL();
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof WaypointTransmitter) {
                WaypointTransmitter waypointTransmitter = (WaypointTransmitter)((Object)entity);
                WorldServer.this.h().c(waypointTransmitter);
            }
            WorldServer.this.g().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.K.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.K.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && WorldServer.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.c((net.minecraft.world.entity.Entity)null);
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            WaypointTransmitter waypointTransmitter;
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.G.add(serverPlayer);
                if (serverPlayer.o()) {
                    WorldServer.this.h().a(serverPlayer);
                }
                WorldServer.this.f();
            }
            if (entity instanceof WaypointTransmitter && (waypointTransmitter = (WaypointTransmitter)((Object)entity)).gm()) {
                WorldServer.this.h().a(waypointTransmitter);
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.U.add(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (EntityComplexPart enderDragonPart : enderDragon.s()) {
                    WorldServer.this.ab.put(enderDragonPart.az(), (Object)enderDragonPart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.n().b(entity);
            if (entity.origin == null) {
                entity.origin = entity.dD();
            }
            if (entity.originWorld == null) {
                entity.originWorld = WorldServer.this.getWorld().getUID();
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            Object object;
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                object = WorldServer.this.q().Q().iterator();
                while (object.hasNext()) {
                    WorldServer level = object.next();
                    for (Optional<PersistentBase> savedData : level.y().c.values()) {
                        PersistentBase persistentBase;
                        if (savedData.isEmpty() || !((persistentBase = savedData.get()) instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)persistentBase;
                        map.q.remove(player);
                        if (!map.p.removeIf(holdingPlayer -> holdingPlayer.a == player)) continue;
                        map.s.remove(player.ao().getString());
                    }
                }
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.ed() != Entity.RemovalReason.a)) {
                Merchant merchant;
                if (!entity.an().purpurConfig.playerVoidTrading && (object = entity.getBukkitEntity()) instanceof Merchant && (merchant = (Merchant)object).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.n().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                WorldServer.this.G.remove(serverPlayer);
                WorldServer.this.h().c(serverPlayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient mob = (EntityInsentient)entity;
                WorldServer.this.U.remove(mob);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                for (HumanEntity enderDragonPart : enderDragon.s()) {
                    WorldServer.this.ab.remove(enderDragonPart.az());
                }
            }
            entity.a(DynamicGameEventListener::b);
            WorldServer.this.ag.b(entity);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.I.am().k) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

