/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;

public class LegacyTextFilter
extends ServerTextFilter {
    private static final String b = "v1/chat";
    final URL c;
    final a d;
    final URL e;
    final a f;
    private final String g;

    private LegacyTextFilter(URL chatEndpoint, ServerTextFilter.b chatEncoder, URL joinEndpoint, a joinEncoder, URL leaveEndpoint, a leaveEncoder, String authKey, ServerTextFilter.a chatIgnoreStrategy, ExecutorService workerPool) {
        super(chatEndpoint, chatEncoder, chatIgnoreStrategy, workerPool);
        this.c = joinEndpoint;
        this.d = joinEncoder;
        this.e = leaveEndpoint;
        this.f = leaveEncoder;
        this.g = authKey;
    }

    @Nullable
    public static ServerTextFilter a(String config) {
        try {
            ServerTextFilter.b messageEncoder;
            JsonObject jsonObject = ChatDeserializer.a(config);
            URI uri = new URI(ChatDeserializer.i(jsonObject, "apiServer"));
            String asString = ChatDeserializer.i(jsonObject, "apiKey");
            if (asString.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int asInt = ChatDeserializer.a(jsonObject, "ruleId", 1);
            String asString1 = ChatDeserializer.a(jsonObject, "serverId", "");
            String asString2 = ChatDeserializer.a(jsonObject, "roomId", "Java:Chat");
            int asInt1 = ChatDeserializer.a(jsonObject, "hashesToDrop", -1);
            int asInt2 = ChatDeserializer.a(jsonObject, "maxConcurrentRequests", 7);
            JsonObject asJsonObject = ChatDeserializer.a(jsonObject, "endpoints", null);
            String endpointFromConfig = LegacyTextFilter.a(asJsonObject, "chat", b);
            boolean flag = endpointFromConfig.equals(b);
            URL url = uri.resolve("/" + endpointFromConfig).toURL();
            URL endpoint = LegacyTextFilter.a(uri, asJsonObject, "join", "v1/join");
            URL endpoint1 = LegacyTextFilter.a(uri, asJsonObject, "leave", "v1/leave");
            a joinOrLeaveEncoder = profile -> {
                JsonObject jsonObject1 = new JsonObject();
                jsonObject1.addProperty("server", asString1);
                jsonObject1.addProperty("room", asString2);
                jsonObject1.addProperty("user_id", profile.id().toString());
                jsonObject1.addProperty("user_display_name", profile.name());
                return jsonObject1;
            };
            if (flag) {
                messageEncoder = (profile, message) -> {
                    JsonObject jsonObject1 = new JsonObject();
                    jsonObject1.addProperty("rule", (Number)asInt);
                    jsonObject1.addProperty("server", asString1);
                    jsonObject1.addProperty("room", asString2);
                    jsonObject1.addProperty("player", profile.id().toString());
                    jsonObject1.addProperty("player_display_name", profile.name());
                    jsonObject1.addProperty("text", message);
                    jsonObject1.addProperty("language", "*");
                    return jsonObject1;
                };
            } else {
                String string = String.valueOf(asInt);
                messageEncoder = (profile, message) -> {
                    JsonObject jsonObject1 = new JsonObject();
                    jsonObject1.addProperty("rule_id", string);
                    jsonObject1.addProperty("category", asString1);
                    jsonObject1.addProperty("subcategory", asString2);
                    jsonObject1.addProperty("user_id", profile.id().toString());
                    jsonObject1.addProperty("user_display_name", profile.name());
                    jsonObject1.addProperty("text", message);
                    jsonObject1.addProperty("language", "*");
                    return jsonObject1;
                };
            }
            ServerTextFilter.a ignoreStrategy = ServerTextFilter.a.select(asInt1);
            ExecutorService executorService = LegacyTextFilter.a(asInt2);
            String string1 = Base64.getEncoder().encodeToString(asString.getBytes(StandardCharsets.US_ASCII));
            return new LegacyTextFilter(url, messageEncoder, endpoint, joinOrLeaveEncoder, endpoint1, joinOrLeaveEncoder, string1, ignoreStrategy, executorService);
        }
        catch (Exception var20) {
            ServerTextFilter.a.warn("Failed to parse chat filter config {}", (Object)config, (Object)var20);
            return null;
        }
    }

    @Override
    public ITextFilter a(GameProfile profile) {
        return new ServerTextFilter.c(profile){

            @Override
            public void a() {
                LegacyTextFilter.this.a(this.b, LegacyTextFilter.this.c, LegacyTextFilter.this.d, this.c);
            }

            @Override
            public void b() {
                LegacyTextFilter.this.a(this.b, LegacyTextFilter.this.e, LegacyTextFilter.this.f, this.c);
            }
        };
    }

    void a(GameProfile profile, URL endpoint, a encoder, Executor streamExecutor) {
        streamExecutor.execute(() -> {
            JsonObject jsonObject = encoder.encode(profile);
            try {
                this.b(jsonObject, endpoint);
            }
            catch (Exception var6) {
                ServerTextFilter.a.warn("Failed to send join/leave packet to {} for player {}", new Object[]{endpoint, profile, var6});
            }
        });
    }

    private void b(JsonObject request, URL endpoint) throws IOException {
        HttpURLConnection httpUrlConnection = this.a(request, endpoint);
        try (InputStream inputStream = httpUrlConnection.getInputStream();){
            this.a(inputStream);
        }
    }

    @Override
    protected void a(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", "Basic " + this.g);
    }

    @Override
    protected FilteredText a(String text, ServerTextFilter.a ignoreStrategy, JsonObject response) {
        boolean asBoolean = ChatDeserializer.a(response, "response", false);
        if (asBoolean) {
            return FilteredText.a(text);
        }
        String asString = ChatDeserializer.a(response, "hashed", null);
        if (asString == null) {
            return FilteredText.b(text);
        }
        JsonArray asJsonArray = ChatDeserializer.v(response, "hashes");
        FilterMask filterMask = this.a(text, asJsonArray, ignoreStrategy);
        return new FilteredText(text, filterMask);
    }

    @FunctionalInterface
    static interface a {
        public JsonObject encode(GameProfile var1);
    }
}

